/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.driver.blackbox;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import jeus.jdbc.driver.blackbox.BlackboxDataSource;
import jeus.jdbc.driver.blackbox.BlackboxPooledConnection;

public final class BlackboxConnectionPoolDataSource
extends BlackboxDataSource
implements ConnectionPoolDataSource,
Referenceable {
    public BlackboxConnectionPoolDataSource() {
    }

    public BlackboxConnectionPoolDataSource(Reference ref) throws SQLException {
        super(ref);
    }

    public PooledConnection getPooledConnection() throws SQLException {
        Connection conn = this.property == null ? DriverManager.getConnection(this.url, this.userName, this.password) : DriverManager.getConnection(this.url, this.property);
        if (this.implicitCahingEnabled) {
            this.setOracleCaching(conn);
        }
        if (this.sql != null) {
            this.executeQuery(conn);
        }
        if (!this.txIsolation.equals("")) {
            conn.setTransactionIsolation(this.convertInt(this.txIsolation));
        }
        return new BlackboxPooledConnection(conn);
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        Connection conn;
        if (this.property == null) {
            conn = DriverManager.getConnection(this.url, user, password);
        } else {
            this.property.put("user", user);
            this.property.put("password", password);
            conn = DriverManager.getConnection(this.url, this.property);
        }
        if (this.implicitCahingEnabled) {
            this.setOracleCaching(conn);
        }
        if (this.sql != null) {
            this.executeQuery(conn);
        }
        if (!this.txIsolation.equals("")) {
            conn.setTransactionIsolation(this.convertInt(this.txIsolation));
        }
        return new BlackboxPooledConnection(conn);
    }

    public Reference getReference() {
        Reference ref = new Reference("jeus.jdbc.driver.blackbox.BlackboxConnectionPoolDataSource", "jeus.jdbc.driver.blackbox.BlackboxDataSourceFactory", null);
        ref.add(0, new StringRefAddr("Type", "ConnectionPool"));
        ref.add(1, new StringRefAddr("URL", this.url));
        ref.add(2, new StringRefAddr("DriverClassName", this.driverClassName));
        ref.add(3, new StringRefAddr("Password", this.password));
        ref.add(4, new StringRefAddr("UserName", this.userName));
        ref.add(5, new StringRefAddr("Properties", this.properties));
        ref.add(6, new StringRefAddr("implicitCahingEnabled", new Boolean(this.implicitCahingEnabled).toString()));
        ref.add(7, new StringRefAddr("maxStatements", Integer.toString(this.maxStatements)));
        ref.add(8, new StringRefAddr("Sql", this.sql));
        ref.add(9, new StringRefAddr("Isolation", this.txIsolation));
        return ref;
    }
}

