/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.helper;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import jeus.jdbc.common.DBMSType;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.JeusSQLException;
import jeus.jdbc.helper.DBAHelperConstants;
import jeus.util.ErrorMsgManager;
import jeus.util.ScheduleTask;
import jeus.util.ScheduledExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public final class ConnectionPoolDBAHelper {
    private Map<JeusPooledConnection, String> sessionIds;
    private DBAHelperConstants dbConstants;
    private static final ScheduledExecutor executor = ScheduledExecutor.getInstance();
    private DataSource dbaDelegator;
    private String dbaDataSourceName;
    private int dbaTO;
    private ConcurrentHashMap connTimerList = new ConcurrentHashMap();
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");

    public ConnectionPoolDBAHelper(int max, DBMSType dbmsType, int dbaTO) {
        this.sessionIds = Collections.synchronizedMap(new IdentityHashMap(max));
        this.dbConstants = new DBAHelperConstants(dbmsType);
        this.dbaTO = dbaTO;
    }

    private String getSessionId(JeusPooledConnection key) {
        return this.sessionIds.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionId(JeusPooledConnection pcon, Connection con) throws SQLException {
        String sid = this.sessionIds.get(pcon);
        if (sid == null) {
            Statement stmt = con.createStatement();
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery(this.dbConstants.GET_SESSION_ID_SQL);
                if (rs.next()) {
                    sid = rs.getString(1);
                }
                if (logger.isLoggable(JeusMessage_JDBC._325_LEVEL)) {
                    logger.log(JeusMessage_JDBC._325_LEVEL, JeusMessage_JDBC._325, (Object)sid);
                }
                this.sessionIds.put(pcon, sid);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e1) {}
                }
                try {
                    stmt.close();
                }
                catch (SQLException e1) {}
            }
        }
        if (logger.isLoggable(JeusMessage_JDBC._326_LEVEL)) {
            logger.log(JeusMessage_JDBC._326_LEVEL, JeusMessage_JDBC._326, (Object)sid);
        }
    }

    public synchronized void removeSession(JeusPooledConnection pcon) {
        this.sessionIds.remove(pcon);
    }

    public void setDBADelegate(Hashtable env, int dbaTO, String exportName, String dbaDele) throws NamingException {
        this.dbaTO = dbaTO;
        if (dbaTO != -1) {
            if (!dbaDele.equals("") && !dbaDele.equals(exportName)) {
                this.dbaDelegator = (DataSource)new InitialContext(env).lookup(dbaDele);
                this.dbaDataSourceName = dbaDele;
            } else {
                throw new RuntimeException();
            }
        }
    }

    public synchronized void scheduleConnectionTimer(JeusPooledConnection pcon) {
        String sid = this.getSessionId(pcon);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Trying to schedule id = " + sid + ", connection = " + pcon);
        }
        if (this.dbaTO != -1 && sid != null) {
            ConnectionTimer connTimer = new ConnectionTimer(pcon, this);
            this.connTimerList.put(pcon, connTimer);
            executor.schedule(connTimer, this.dbaTO);
        }
    }

    public synchronized void removeConnectionTimer(PooledConnection con) {
        ConnectionTimer connT;
        if (this.dbaTO >= 0 && (connT = (ConnectionTimer)this.connTimerList.remove(con)) != null) {
            connT.cancel();
        }
    }

    public synchronized void forcedClose(JeusPooledConnection pcon) throws SQLException {
        if (pcon.abnormallyClosed()) {
            return;
        }
        ConnectionTimer timer = (ConnectionTimer)this.connTimerList.remove(pcon);
        if (timer != null) {
            timer.cancel();
        }
        String sessionID = this.sessionIds.remove(pcon);
        logger.log(JeusMessage_JDBC._221_LEVEL, "Trying to kill session id = " + sessionID + ", connection = " + pcon);
        if (sessionID != null) {
            pcon.setForcedClosed(true);
            DBAConnection dbaCon = new DBAConnection(this.dbConstants, sessionID, this.dbaDelegator);
            dbaCon.forcedClose();
            if (logger.isLoggable(JeusMessage_JDBC._221_LEVEL)) {
                logger.log(JeusMessage_JDBC._221_LEVEL, JeusMessage_JDBC._221, (Object)sessionID);
            }
        }
    }

    private class DBAConnection {
        protected DataSource ds;
        protected DBAHelperConstants dbConstants;
        private String sessionId;

        public DBAConnection(DBAHelperConstants dbConstants, String sessionId, DataSource dbaDataSource) {
            this.ds = dbaDataSource;
            this.sessionId = sessionId;
            this.dbConstants = dbConstants;
        }

        public synchronized void forcedClose() throws SQLException {
            switch (this.dbConstants.DB_KIND) {
                case 1: {
                    this.oracleForcedClose();
                    break;
                }
                case 2: {
                    this.sybaseForcedClose();
                    break;
                }
            }
        }

        private synchronized void oracleForcedClose() throws SQLException {
            Statement stmt = null;
            Connection dbaConn = null;
            String dbaOperationSql = null;
            try {
                ResultSet rs;
                dbaConn = this.ds.getConnection();
                stmt = dbaConn.createStatement();
                dbaOperationSql = this.dbConstants.GET_SERIAL_NO_SQL + this.sessionId;
                if (logger.isLoggable(JeusMessage_JDBC._327_LEVEL)) {
                    logger.log(JeusMessage_JDBC._327_LEVEL, JeusMessage_JDBC._327, (Object)dbaOperationSql);
                }
                if (!(rs = stmt.executeQuery(dbaOperationSql)).next()) {
                    if (logger.isLoggable(JeusMessage_JDBC._329_LEVEL)) {
                        logger.logp(JeusMessage_JDBC._329_LEVEL, "DBAConnection", "oracleForcedClose", JeusMessage_JDBC._329, (Object)this.sessionId);
                    }
                    throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._329, (Object)this.sessionId));
                }
                String sid = rs.getString(1);
                String serial = rs.getString(2);
                dbaOperationSql = this.dbConstants.KILL_SESSION_SQL + "'" + sid + "," + serial + "'";
                if (logger.isLoggable(JeusMessage_JDBC._328_LEVEL)) {
                    logger.log(JeusMessage_JDBC._328_LEVEL, JeusMessage_JDBC._328, (Object)dbaOperationSql);
                }
                stmt.executeQuery(dbaOperationSql);
            }
            catch (SQLException se) {
                throw new JeusSQLException(JeusMessage_JDBC._351, new Object[]{dbaOperationSql, ConnectionPoolDBAHelper.this.dbaDataSourceName}, (Throwable)se);
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
                if (dbaConn != null) {
                    dbaConn.close();
                }
            }
        }

        private synchronized void sybaseForcedClose() throws SQLException {
            Statement stmt = null;
            Connection dbaConn = null;
            String killSidSQL = null;
            try {
                dbaConn = this.ds.getConnection();
                stmt = dbaConn.createStatement();
                killSidSQL = this.dbConstants.KILL_SESSION_SQL + this.sessionId;
                if (logger.isLoggable(JeusMessage_JDBC._328_LEVEL)) {
                    logger.log(JeusMessage_JDBC._328_LEVEL, JeusMessage_JDBC._328, (Object)killSidSQL);
                }
                stmt.executeUpdate(killSidSQL);
            }
            catch (SQLException se) {
                throw new JeusSQLException(JeusMessage_JDBC._349, new Object[]{killSidSQL, ConnectionPoolDBAHelper.this.dbaDataSourceName}, (Throwable)se);
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
                if (dbaConn != null) {
                    dbaConn.close();
                }
            }
        }
    }

    private class ConnectionTimer
    extends ScheduleTask {
        private ConnectionPoolDBAHelper dbaHelper;
        private JeusPooledConnection pcon;

        public ConnectionTimer(JeusPooledConnection pcon, ConnectionPoolDBAHelper dbaHelper) {
            this.dbaHelper = dbaHelper;
            this.pcon = pcon;
        }

        public void run() {
            block2: {
                try {
                    this.dbaHelper.forcedClose(this.pcon);
                }
                catch (Throwable e) {
                    if (!logger.isLoggable(JeusMessage_JDBC._307_LEVEL)) break block2;
                    logger.logp(JeusMessage_JDBC._307_LEVEL, "ConnectionTimer", "run", JeusMessage_JDBC._307, e);
                }
            }
        }
    }
}

