/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.info;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import jeus.jdbc.info.CPInfo;
import jeus.jdbc.info.ConnectionPoolInfo;
import jeus.jdbc.info.PooledConnectionInfo;
import jeus.management.j2ee.statistics.BoundedRangeStatisticImpl;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.management.j2ee.statistics.RangeStatisticImpl;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.management.j2ee.statistics.TimeStatisticImpl;

public class DynamicPoolStatsAndInfo {
    private final BoundedRangeStatisticImpl minPoolSizeStat;
    private final BoundedRangeStatisticImpl maxPoolSizeStat;
    private final BoundedRangeStatisticImpl activeConnections;
    private final BoundedRangeStatisticImpl idleConnections;
    private final RangeStatisticImpl disposableConnections;
    private final CountStatisticImpl closeCount;
    private final CountStatisticImpl createCount;
    private final AtomicInteger currentPoolSize = new AtomicInteger(0);
    private final RangeStatisticImpl waitingThreadCount;
    private final TimeStatisticImpl waitTimeStat;
    private final TimeStatisticImpl connectionUseTime;
    private final List<PooledConnectionInfo> infoList = Collections.synchronizedList(new ArrayList());

    public DynamicPoolStatsAndInfo(ConnectionPoolInfo config) {
        this.minPoolSizeStat = new BoundedRangeStatisticImpl("MinPoolSize", "connection", "the size of min. connections in the pool", (long)config.getMinPoolSize(), (long)config.getMinPoolSize());
        this.maxPoolSizeStat = new BoundedRangeStatisticImpl("MaxPoolSize", "connection", "the size of the max. connection pool", (long)config.getMaxPoolSize(), (long)config.getMaxPoolSize());
        this.activeConnections = new BoundedRangeStatisticImpl("PoolSize", "connection", "the number of connections that are used by applications", (long)config.getMaxPoolSize(), 0L);
        this.disposableConnections = new RangeStatisticImpl("DisposableConnections", "connection", "the number of disposable connections");
        this.idleConnections = new BoundedRangeStatisticImpl("FreePoolSize", "connection", "the number of free connections in the pool", (long)config.getMaxPoolSize(), 0L);
        this.connectionUseTime = new TimeStatisticImpl("UseTime", "millisecond", "the time spent using a connection");
        this.closeCount = new CountStatisticImpl("CloseCount", "connection", "the number of connections closed");
        this.createCount = new CountStatisticImpl("CreateCount", "connection", "the number of connections created");
        this.waitingThreadCount = new RangeStatisticImpl("WaitingThreadCount", "thread", "the number of threads waiting for a connection");
        this.waitTimeStat = new TimeStatisticImpl("WaitTime", "millisecond", "the time spent waiting for a connection to be available");
    }

    public synchronized void addUseTimeStat(long startTime) {
        this.connectionUseTime.addData(System.currentTimeMillis() - startTime);
    }

    public TimeStatisticImpl getUseTimeStat() {
        return this.connectionUseTime;
    }

    public RangeStatisticImpl getDisposableConnections() {
        return this.disposableConnections;
    }

    public StatisticImpl getActiveConnections() {
        return this.activeConnections;
    }

    public int getCurrentPoolSize() {
        return this.currentPoolSize.intValue();
    }

    public StatisticImpl getMinSizeStat() {
        return this.minPoolSizeStat;
    }

    public StatisticImpl getMaxSizeStat() {
        return this.maxPoolSizeStat;
    }

    public StatisticImpl getIdleConnections() {
        return this.idleConnections;
    }

    public void addWaitTimeStat(long time) {
        this.waitTimeStat.addData(time);
    }

    public void incWaitThreadCount() {
        this.waitingThreadCount.increase();
    }

    public void decWaitThreadCount() {
        this.waitingThreadCount.decrease();
    }

    public void incCreateCount() {
        this.createCount.increase();
    }

    public void decCreateCount() {
        this.createCount.decrease();
    }

    public StatisticImpl getCreatCountStat() {
        return this.createCount;
    }

    public void incCloseCount() {
        this.closeCount.increase();
    }

    public StatisticImpl getCloseCountStat() {
        return this.closeCount;
    }

    public boolean removePooledConnectionInfo(PooledConnectionInfo info) {
        if (info.isDisposable()) {
            this.disposableConnections.decrease();
        } else {
            this.currentPoolSize.decrementAndGet();
        }
        return this.infoList.remove(info);
    }

    public void addPooledConnectionInfo(PooledConnectionInfo info) {
        if (info.isDisposable()) {
            this.disposableConnections.increase();
        } else {
            this.currentPoolSize.incrementAndGet();
        }
        this.infoList.add(info);
    }

    public StatisticImpl getWaitingThreadCountStat() {
        return this.waitingThreadCount;
    }

    public StatisticImpl getWaitTimeStat() {
        return this.waitTimeStat;
    }

    public PooledConnectionInfo[] getPooledConnectionInfoArray() {
        return this.infoList.toArray(new PooledConnectionInfo[this.infoList.size()]);
    }

    public void destroy() {
        this.idleConnections.set(0L);
        this.activeConnections.set(0L);
        this.disposableConnections.set(0L);
        this.closeCount.setValue(0L);
        this.createCount.setValue(0L);
        this.waitingThreadCount.set(0L);
        this.infoList.clear();
    }

    public void setCPInfo(CPInfo cpInfo) {
        int idleCount = (int)this.idleConnections.getCurrent();
        cpInfo.setActive(this.currentPoolSize.get() - idleCount);
        cpInfo.setIdle(idleCount);
        cpInfo.setDisposable((int)this.disposableConnections.getCurrent());
    }

    public void incActiveConnections() {
        this.activeConnections.increase();
    }

    public void decActiveConnections() {
        this.activeConnections.decrease();
    }

    public void incIdleConnections() {
        this.idleConnections.increase();
    }

    public void decIdleConnections() {
        this.idleConnections.decrease();
    }
}

