/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.pool;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public class Driver
implements java.sql.Driver {
    private static final int MAJOR_VERSION = 2;
    private static final int MINOR_VERSION = 0;
    private static final String JEUS_URL_PREFIX = "jdbc:jeus:pool";
    private static final String ID_PROPERTY_KEY = "jeus.jdbc.pool.ConnectionPoolID";
    private static final char URL_DELIM = ':';
    private Context context;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");

    public Connection connect(String url) throws SQLException {
        return this.connect(url, null);
    }

    public Connection connect(String url, Properties props) throws SQLException {
        String exportedPoolName = null;
        if (url != null) {
            int index = url.lastIndexOf(58);
            if (index > 0) {
                if (!url.startsWith(JEUS_URL_PREFIX)) {
                    throw new SQLException("URL should start with jdbc:jeus:pool");
                }
                exportedPoolName = url.substring(index + 1);
            } else {
                exportedPoolName = url;
            }
        } else if (props != null) {
            exportedPoolName = (String)props.get(ID_PROPERTY_KEY);
        }
        if (exportedPoolName == null || exportedPoolName.equals("")) {
            throw new SQLException("DB Connection Pool Name should be specified");
        }
        if (logger.isLoggable(JeusMessage_JDBC._346_LEVEL)) {
            logger.logp(JeusMessage_JDBC._346_LEVEL, "PoolForServlet", "connect", JeusMessage_JDBC._346, (Object)exportedPoolName);
        }
        try {
            if (this.context == null) {
                this.context = new InitialContext();
            }
            DataSource ds = (DataSource)this.context.lookup(exportedPoolName);
            if (logger.isLoggable(JeusMessage_JDBC._347_LEVEL)) {
                logger.logp(JeusMessage_JDBC._347_LEVEL, "PoolForServlet", "connect", JeusMessage_JDBC._347, (Object)exportedPoolName);
            }
            return ds.getConnection();
        }
        catch (NamingException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(JEUS_URL_PREFIX);
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties props) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException sqle) {
            sqle.printStackTrace(System.out);
        }
    }
}

