/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.util;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Set;
import jeus.jdbc.common.JeusPreparedStatement;
import jeus.jdbc.util.RepositoryEvent;
import jeus.jdbc.util.lru.LruCache;

public class CacheHashtable
extends HashMap
implements RepositoryEvent {
    private LruCache cache;

    public CacheHashtable(int max) {
        this.cache = new LruCache(max, this);
    }

    public synchronized Object put(Object key, Object value) {
        this.cache.addObject(key);
        return super.put(key, value);
    }

    public synchronized Object get(Object key) {
        Object obj = super.get(key);
        if (obj != null) {
            this.cache.getObject(key);
        }
        return obj;
    }

    public synchronized Object remove(Object key) {
        this.cache.delete(key);
        return super.remove(key);
    }

    public synchronized void removeFromRepository(Object key) {
        Object obj = super.remove(key);
        if (obj != null && obj instanceof JeusPreparedStatement) {
            JeusPreparedStatement pstmt = (JeusPreparedStatement)obj;
            try {
                pstmt.realClose();
            }
            catch (SQLException ignored) {
                // empty catch block
            }
        }
    }

    public synchronized Set keySet() {
        return super.keySet();
    }

    public synchronized void clear() {
        super.clear();
        this.cache.clear();
    }
}

