/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.ejb.EJBHome;
import javax.naming.LinkException;
import javax.naming.NamingException;
import javax.naming.Reference;
import jeus.ejb.bean.objectbase.JEUSClusterStub;
import jeus.ejb.client.BusinessHome;
import jeus.jndi.JEUSClusterContext;
import jeus.jndi.jns.common.ClusterManager;
import jeus.jndi.jns.local.DirService;
import jeus.jndi.jns.local.JNSLocal;
import jeus.jndi.jns.local.Service;
import jeus.security.util.LoginUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JNSCommon;

public class DynamicLinkRef
extends Reference {
    static final long serialVersionUID = -5362040020503199925L;
    private final Vector links = new Vector();
    private transient String localExportName;
    private static HashMap dynamicLinks = new HashMap();
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.cluster");

    public DynamicLinkRef(String s, String exportName) {
        super(s);
        this.links.add(exportName);
        this.localExportName = exportName;
    }

    public String getLinkName() throws NamingException {
        return (String)this.getLinkNameOrObject(true);
    }

    public Object getLinkObject() throws NamingException {
        return this.getLinkNameOrObject(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getLinkNameOrObject(boolean returnName) throws NamingException {
        block18: {
            if (this.localExportName != null) {
                try {
                    Object object = this.lookupLinkObject("localhost", this.localExportName);
                    if (object != null) {
                        if (returnName) {
                            return this.localExportName;
                        }
                        return this.setClusterInfo(this.localExportName, object);
                    }
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_JNSCommon._10_LEVEL)) break block18;
                    logger.log(JeusMessage_JNSCommon._10_LEVEL, JeusMessage_JNSCommon._10, t);
                }
            }
        }
        try {
            ArrayList<String> list = new ArrayList<String>();
            Vector vector = this.links;
            synchronized (vector) {
                if (this.links.isEmpty()) {
                    throw new LinkException("There is no available link. : " + this.links);
                }
                for (int i = 0; i < this.links.size(); ++i) {
                    String linkName = (String)this.links.get(i);
                    String hostName = Service.getClusterExportUrl(linkName);
                    if (ClusterManager.isInFailList(hostName)) continue;
                    list.add(linkName);
                }
            }
            while (list.size() > 0) {
                Object object;
                int currentIndex;
                Random i = JEUSClusterContext.random;
                synchronized (i) {
                    currentIndex = JEUSClusterContext.random.nextInt(list.size());
                }
                String linkName = (String)list.get(currentIndex);
                String exportURL = Service.getClusterExportUrl(linkName);
                if (!ClusterManager.isInFailList(exportURL) && (object = this.lookupLinkObject(linkName)) != null) {
                    if (returnName) {
                        return linkName;
                    }
                    return this.setClusterInfo(linkName, object);
                }
                list.remove(currentIndex);
            }
            return this.checkFailedLinks(returnName);
        }
        catch (Throwable t) {
            logger.log(JeusMessage_JNSCommon._11_LEVEL, JeusMessage_JNSCommon._11, t);
            throw Service.makeNamingException(t);
        }
    }

    private Object lookupLinkObject(String name) {
        String exportUrl = Service.getClusterExportUrl(name);
        return this.lookupLinkObject(exportUrl, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object lookupLinkObject(String exportUrl, String name) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
        env.put("java.naming.provider.url", exportUrl);
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            JNSLocal localServer = JNSLocal.getLocalServer(env);
            DirService dirService = localServer.getDirService();
            Object object = dirService.lookup(name, true);
            if (object != null) {
                try {
                    if (object instanceof EJBHome) {
                        ((EJBHome)object).getEJBMetaData();
                    } else if (object instanceof BusinessHome) {
                        ((BusinessHome)object).ping();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Object var8_10 = null;
                    LoginUtil.logoutWithRuntimeException();
                    return var8_10;
                }
            }
            Object object2 = object;
            return object2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (logger.isLoggable(JeusMessage_JNSCommon._12_LEVEL)) {
                logger.log(JeusMessage_JNSCommon._12_LEVEL, JeusMessage_JNSCommon._12, (Object)exportUrl, (Throwable)ex);
            }
            ClusterManager.addFailList(exportUrl);
            Object var6_7 = null;
            return var6_7;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object checkFailedLinks(boolean returnName) throws LinkException {
        String[] linkNames;
        if (logger.isLoggable(JeusMessage_JNSCommon._13_LEVEL)) {
            logger.log(JeusMessage_JNSCommon._13_LEVEL, JeusMessage_JNSCommon._13);
        }
        Vector vector = this.links;
        synchronized (vector) {
            linkNames = this.links.toArray(new String[this.links.size()]);
        }
        for (int i = 0; i < linkNames.length; ++i) {
            String linkName = linkNames[i];
            String exportURL = Service.getClusterExportUrl(linkName);
            ClusterManager.checkFailNode(exportURL);
            Object obj = this.lookupLinkObject(linkName);
            if (obj == null) continue;
            if (returnName) {
                return linkName;
            }
            return this.setClusterInfo(linkName, obj);
        }
        throw new LinkException("All link are failed to connect to JNDI Server");
    }

    public String getLocalExportName() {
        return this.localExportName;
    }

    public void setLocalExportName(String name) {
        this.localExportName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addList(DynamicLinkRef obj) {
        Vector targetLink = obj.links;
        if (logger.isLoggable(JeusMessage_JNSCommon._14_LEVEL)) {
            logger.log(JeusMessage_JNSCommon._14_LEVEL, JeusMessage_JNSCommon._14, (Object)targetLink);
        }
        Vector vector = this.links;
        synchronized (vector) {
            for (int j = 0; j < targetLink.size(); ++j) {
                String _exportName = (String)targetLink.elementAt(j);
                if (this.links.contains(_exportName)) continue;
                this.links.add(_exportName);
            }
        }
    }

    public boolean remove(String _exportName) {
        if (logger.isLoggable(JeusMessage_JNSCommon._15_LEVEL)) {
            logger.log(JeusMessage_JNSCommon._15_LEVEL, JeusMessage_JNSCommon._15, (Object)_exportName);
        }
        this.links.remove(_exportName);
        return this.links.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicate(String _exportName) {
        if (logger.isLoggable(JeusMessage_JNSCommon._16_LEVEL)) {
            logger.log(JeusMessage_JNSCommon._16_LEVEL, JeusMessage_JNSCommon._16, (Object)_exportName);
        }
        Vector vector = this.links;
        synchronized (vector) {
            if (!this.links.contains(_exportName)) {
                this.links.add(_exportName);
            }
        }
    }

    public void replicate(DynamicLinkRef obj) {
        if (obj == null) {
            return;
        }
        this.addList(obj);
    }

    public Object setClusterInfo(String exportName, Object obj) {
        if (obj instanceof JEUSClusterStub) {
            ((JEUSClusterStub)obj).__jeus_setCluster(exportName, this);
        }
        return obj;
    }

    public String toString() {
        return "DynamicLinkRef, localExportName : " + this.localExportName + ", links : " + this.links;
    }

    public static DynamicLinkRef getDynamicLink(String exportName) {
        return (DynamicLinkRef)dynamicLinks.get(exportName);
    }

    public static synchronized DynamicLinkRef addDynamicLink(String exportName, DynamicLinkRef obj) {
        DynamicLinkRef dlink = (DynamicLinkRef)dynamicLinks.get(exportName);
        if (dlink == null) {
            if (logger.isLoggable(JeusMessage_JNSCommon._17_LEVEL)) {
                logger.log(JeusMessage_JNSCommon._17_LEVEL, JeusMessage_JNSCommon._17, (Object)obj);
            }
            dynamicLinks.put(exportName, obj);
            return obj;
        }
        if (logger.isLoggable(JeusMessage_JNSCommon._18_LEVEL)) {
            logger.log(JeusMessage_JNSCommon._18_LEVEL, JeusMessage_JNSCommon._18, new Object[]{dlink, obj});
        }
        dlink.replicate(obj);
        return dlink;
    }

    public static synchronized void removeDynamicLink(String exportName) {
        dynamicLinks.remove(exportName);
    }

    public Vector getLinks() {
        return this.links;
    }
}

