/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.common;

import java.util.Hashtable;

public class Environment {
    public static final int ENV_REPLICATE = 1;
    public static final int ENV_CACHE = 2;
    public static final int ENV_MULTIPLEOBJECT = 8;
    public static final int ENV_DIRECTBIND = 16;
    public static final int ENV_LOCAL = 32;
    public static final int ENV_FORCED = 64;
    public static final int ENV_CLUSTER = 128;
    public static final int ENV_LOCAL_CONTEXT = 256;
    public static final int ENV_REPLICATE_CONTEXT = 512;
    private boolean replicate = true;
    private boolean cache = true;
    private boolean directbind;
    private boolean local;
    private boolean forced;
    private boolean cluster;
    private boolean localContext;
    private boolean replicateContext = true;
    public static final Environment defaultEnv = new Environment();
    public static final int defaultEnvValue = defaultEnv.toInt();

    public Environment() {
    }

    public Environment(int envValue) {
        this.replicate = (envValue & 1) > 0;
        this.cache = (envValue & 2) > 0;
        this.directbind = (envValue & 0x10) > 0;
        this.local = (envValue & 0x20) > 0;
        this.forced = (envValue & 0x40) > 0;
        this.cluster = (envValue & 0x80) > 0;
        this.localContext = (envValue & 0x100) > 0;
        this.replicateContext = (envValue & 0x200) > 0;
    }

    public Environment(Hashtable env) {
        String value = (String)env.get("jeus.jndi.jns.replicatebindings");
        if ("false".equals(value)) {
            this.replicate = false;
        }
        if ("false".equals(value = (String)env.get("jeus.jndi.jns.cachebindings"))) {
            this.cache = false;
        }
        if ("true".equals(value = (String)env.get("jeus.jndi.jns.localbindings"))) {
            this.local = true;
            this.replicate = false;
            this.cache = false;
            value = (String)env.get("jeus.jndi.jns.localcontextbindings");
            if (value == null) {
                this.localContext = true;
            }
            if ((value = (String)env.get("jeus.jndi.replicate.context")) == null) {
                this.replicateContext = false;
            }
        }
        if ("true".equals(value = (String)env.get("jeus.jndi.jns.localcontextbindings"))) {
            this.localContext = true;
            this.replicateContext = false;
        }
        if ("false".equals(value = (String)env.get("jeus.jndi.replicate.context"))) {
            this.replicateContext = false;
        }
        if ("true".equals(value = (String)env.get("jeus.jndi.jns.forcedbindings"))) {
            this.forced = true;
        }
        if ("true".equals(value = (String)env.get("jeus.jndi.jns.clusterbindings"))) {
            this.cluster = true;
        }
    }

    public int toInt() {
        int envValue = 0;
        if (this.replicate) {
            ++envValue;
        }
        if (this.cache) {
            envValue += 2;
        }
        if (this.directbind) {
            envValue += 16;
        }
        if (this.local) {
            envValue += 32;
        }
        if (this.forced) {
            envValue += 64;
        }
        if (this.cluster) {
            envValue += 128;
        }
        if (this.localContext) {
            envValue += 256;
        }
        if (this.replicateContext) {
            envValue += 512;
        }
        return envValue;
    }

    public void fromInt(int envValue) {
        this.replicate = (envValue & 1) > 0;
        this.cache = (envValue & 2) > 0;
        this.directbind = (envValue & 0x10) > 0;
        this.local = (envValue & 0x20) > 0;
        this.forced = (envValue & 0x40) > 0;
        this.cluster = (envValue & 0x80) > 0;
        this.localContext = (envValue & 0x100) > 0;
        this.replicateContext = (envValue & 0x200) > 0;
    }

    public boolean getReplicate() {
        return this.replicate;
    }

    public void setReplicate(boolean replicate) {
        this.replicate = replicate;
    }

    public boolean getCache() {
        return this.cache;
    }

    public boolean getDirectBind() {
        return this.directbind;
    }

    public void setDirectBind(boolean directbind) {
        this.directbind = directbind;
    }

    public boolean getLocal() {
        return this.local;
    }

    public boolean getForced() {
        return this.forced;
    }

    public void setForcedBind(boolean forced) {
        this.forced = forced;
    }

    public boolean getCluster() {
        return this.cluster;
    }

    public String toString() {
        return "/" + (this.replicate ? "R" : "r") + (this.cache ? "C" : "c") + (this.directbind ? "D" : "d") + (this.local ? "L" : "l") + (this.forced ? "F" : "f") + (this.cluster ? "CL" : "cl") + (this.localContext ? "LC" : "lc") + (this.replicateContext ? "RC" : "rc") + "/";
    }

    public boolean getLocalContextBinding() {
        return this.localContext;
    }

    public boolean getReplicateContext() {
        return this.replicateContext;
    }
}

