/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.delegate;

import java.rmi.Remote;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import jeus.jndi.jns.delegate.JEUSNamingManager;
import jeus.jndi.jns.delegate.NamingEnumerationWrapper;
import jeus.jndi.jns.delegate.RemoteContext;
import jeus.jndi.jns.delegate.RemoteNamingEnumeration;
import jeus.util.properties.JeusManagerPropertyValues;

public class ContextWrapper
implements RemoteContext {
    private static final Hashtable DEFAULT_ENV = new Hashtable();
    private transient Context delegate;
    private Hashtable env;

    public ContextWrapper(Context delegate) {
        this.env = DEFAULT_ENV;
        this.delegate = delegate;
    }

    public ContextWrapper(Context delegate, Hashtable env) {
        this.delegate = delegate;
        this.env = env;
    }

    public Object addToEnvironment(String s, Object obj) throws NamingException {
        return this.delegate.addToEnvironment(s, obj);
    }

    public void bind(String s, Object obj) throws NamingException {
        this.delegate.bind(s, obj);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.delegate.bind(name, obj);
    }

    public void close() throws NamingException {
        this.delegate.close();
    }

    public String composeName(String s, String s1) throws NamingException {
        return this.delegate.composeName(s, s1);
    }

    public Name composeName(Name name, Name name1) throws NamingException {
        return this.delegate.composeName(name, name1);
    }

    public RemoteContext createSubcontext(String s) throws NamingException {
        return this.createSubcontext(new CompositeName(s));
    }

    public RemoteContext createSubcontext(Name name) throws NamingException {
        return this.makeTransportable(this.delegate.createSubcontext(name));
    }

    public void destroySubcontext(String s) throws NamingException {
        this.delegate.destroySubcontext(s);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.delegate.destroySubcontext(name);
    }

    protected Hashtable env() {
        return this.env;
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.delegate.getEnvironment();
    }

    public String getNameInNamespace() throws NamingException {
        return this.delegate.getNameInNamespace();
    }

    public NameParser getNameParser(String s) throws NamingException {
        return this.delegate.getNameParser(s);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.delegate.getNameParser(name);
    }

    public RemoteNamingEnumeration list(String s) throws NamingException {
        NamingEnumerationWrapper obj = new NamingEnumerationWrapper(this.delegate.list(s), this.env);
        try {
            UnicastRemoteObject.exportObject((Remote)obj, JeusManagerPropertyValues.getDefaultRMIPort());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new NamingException(t.toString());
        }
        return obj;
    }

    public RemoteNamingEnumeration list(Name name) throws NamingException {
        NamingEnumerationWrapper obj = new NamingEnumerationWrapper(this.delegate.list(name), this.env);
        try {
            UnicastRemoteObject.exportObject((Remote)obj, JeusManagerPropertyValues.getDefaultRMIPort());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new NamingException(t.toString());
        }
        return obj;
    }

    public RemoteNamingEnumeration listBindings(String s) throws NamingException {
        NamingEnumerationWrapper obj = new NamingEnumerationWrapper(this.delegate.listBindings(s), this.env);
        try {
            UnicastRemoteObject.exportObject((Remote)obj, JeusManagerPropertyValues.getDefaultRMIPort());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new NamingException(t.toString());
        }
        return obj;
    }

    public RemoteNamingEnumeration listBindings(Name name) throws NamingException {
        NamingEnumerationWrapper obj = new NamingEnumerationWrapper(this.delegate.listBindings(name), this.env);
        try {
            UnicastRemoteObject.exportObject((Remote)obj, JeusManagerPropertyValues.getDefaultRMIPort());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new NamingException(t.toString());
        }
        return obj;
    }

    public Object lookup(String s) throws NamingException {
        return this.lookup(new CompositeName(s));
    }

    public Object lookup(Name name) throws NamingException {
        return this.makeTransportable(this.delegate.lookup(name));
    }

    public Object lookupLink(String s) throws NamingException {
        return this.lookupLink(new CompositeName(s));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.makeTransportable(this.delegate.lookupLink(name));
    }

    protected final Object makeTransportable(Object obj) throws NamingException {
        return JEUSNamingManager.getTransportableInstance(obj, null, null, this.env);
    }

    protected final RemoteContext makeTransportable(Context context) throws NamingException {
        try {
            return (RemoteContext)this.makeTransportable((Object)context);
        }
        catch (ClassCastException _ex) {
            throw new NamingException("A TransportableObjectFactory converted " + context.toString() + " into a object that does not implement Context");
        }
    }

    public void rebind(String s, Object obj) throws NamingException {
        this.delegate.rebind(s, obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.delegate.rebind(name, obj);
    }

    public Object removeFromEnvironment(String s) throws NamingException {
        return this.delegate.removeFromEnvironment(s);
    }

    public void rename(String s, String s1) throws NamingException {
        this.delegate.rename(s, s1);
    }

    public void rename(Name name, Name name1) throws NamingException {
        this.delegate.rename(name, name1);
    }

    public void unbind(String s) throws NamingException {
        this.delegate.unbind(s);
    }

    public void unbind(Name name) throws NamingException {
        this.delegate.unbind(name);
    }
}

