/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.delegate;

import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import jeus.jndi.jns.delegate.ContextWrapper;
import jeus.jndi.jns.delegate.DirContextWrapper;
import jeus.jndi.jns.delegate.JEUSNamingManager;
import jeus.jndi.jns.delegate.NamingEnumerationWrapper;
import jeus.jndi.jns.delegate.TransportableObjectFactory;
import jeus.util.properties.JeusManagerPropertyValues;

public class JNSTransportableObjectFactory
implements TransportableObjectFactory {
    public Object getObjectInstance(Object obj, Name name, Context context, Hashtable hashtable) throws Exception {
        Object obj1 = obj;
        if (!this.isAlreadyTransportable(obj)) {
            if (obj instanceof Context) {
                obj1 = this.makeTransportable((Context)obj, hashtable);
            } else if (obj instanceof Binding) {
                obj1 = this.makeTransportable((Binding)obj, hashtable);
            } else if (obj instanceof NamingEnumeration) {
                obj1 = this.makeTransportable((NamingEnumeration)obj, hashtable);
            } else if (!this.isSerializable(obj1)) {
                obj1 = null;
            }
        }
        return obj1;
    }

    public boolean isAlreadyTransportable(Object obj) {
        return obj instanceof Remote;
    }

    private Object makeTransportable(Binding binding, Hashtable env) throws NamingException {
        Object obj2;
        if (binding instanceof SearchResult) {
            SearchResult searchresult = (SearchResult)binding;
            Object original = searchresult.getObject();
            Object transport = JEUSNamingManager.getTransportableInstance(original, null, null, env);
            Attributes attr = searchresult.getAttributes();
            if (original != transport) {
                return new SearchResult(searchresult.getName(), transport, attr);
            }
            return binding;
        }
        Object obj = binding.getObject();
        if (obj != (obj2 = JEUSNamingManager.getTransportableInstance(obj, null, null, env))) {
            return new Binding(binding.getName(), obj2);
        }
        return binding;
    }

    private Object makeTransportable(Context context, Hashtable hashtable) throws NamingException {
        ContextWrapper obj = context instanceof DirContext ? new DirContextWrapper((DirContext)context, hashtable) : new ContextWrapper(context, hashtable);
        try {
            UnicastRemoteObject.exportObject((Remote)obj, JeusManagerPropertyValues.getDefaultRMIPort());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new NamingException(t.toString());
        }
        return obj;
    }

    private Object makeTransportable(NamingEnumeration namingenumeration, Hashtable hashtable) throws NamingException {
        NamingEnumerationWrapper obj = new NamingEnumerationWrapper(namingenumeration, hashtable);
        try {
            UnicastRemoteObject.exportObject((Remote)obj, JeusManagerPropertyValues.getDefaultRMIPort());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new NamingException(t.toString());
        }
        return obj;
    }

    public boolean isSerializable(Object obj) {
        return obj instanceof Serializable;
    }
}

