/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.local;

import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.naming.Binding;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.event.EventContext;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import javax.naming.spi.NamingManager;
import jeus.jndi.JNSContext;
import jeus.jndi.jns.common.ClusterManager;
import jeus.jndi.jns.common.DynamicLinkRef;
import jeus.jndi.jns.common.Environment;
import jeus.jndi.jns.common.JNS;
import jeus.jndi.jns.common.JeusNameClassPair;
import jeus.jndi.jns.common.Message;
import jeus.jndi.jns.common.NameEnumerationImpl;
import jeus.jndi.jns.common.PropertyLinkRef;
import jeus.jndi.jns.common.PropertyReference;
import jeus.jndi.jns.local.JNSLocal;
import jeus.jndi.jns.local.JNSServerAlreadyDownException;
import jeus.jndi.jns.local.Service;
import jeus.jndi.jns.util.RMIStubWrapper;
import jeus.jndi.objectfactory.CosNamingResourceFactory;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_JNSLocal;

public class DirService
extends Service {
    private boolean useCacheForLookupObject = true;

    public DirService(JNSLocal _jnsLocal, boolean enableCache) {
        super(_jnsLocal);
        this.useCacheForLookupObject = enableCache;
    }

    public String dereference(String linkname, boolean followLast, boolean dereferenceDynamicLinkRef) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSLocal._80_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._80_LEVEL, "DirService", "dereference", JeusMessage_JNSLocal._80, new Object[]{linkname, String.valueOf(followLast), String.valueOf(dereferenceDynamicLinkRef)});
        }
        String derefName = "";
        StringTokenizer atomicNames = new StringTokenizer(linkname, "/");
        while (atomicNames.hasMoreTokens()) {
            Object obj = this.lookup(derefName = derefName + atomicNames.nextToken(), false);
            if (obj instanceof LinkRef && (atomicNames.hasMoreTokens() || followLast)) {
                derefName = this.dereference(((LinkRef)obj).getLinkName(), true, dereferenceDynamicLinkRef);
            } else if (obj instanceof DynamicLinkRef && dereferenceDynamicLinkRef) {
                derefName = this.dereferenceDynamicLinkRef((DynamicLinkRef)obj);
            }
            if (!atomicNames.hasMoreTokens()) continue;
            derefName = derefName + "/";
        }
        if (logger.isLoggable(JeusMessage_JNSLocal._81_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._81_LEVEL, "DirService", "dereference", JeusMessage_JNSLocal._81, (Object)derefName);
        }
        return derefName;
    }

    public String dereferenceDynamicLinkRef(DynamicLinkRef obj) throws Exception {
        String selectedLinkName = obj.getLinkName();
        Object clusterObj = this.lookup(selectedLinkName, true);
        obj.setClusterInfo(selectedLinkName, clusterObj);
        if (logger.isLoggable(JeusMessage_JNSLocal._82_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._82_LEVEL, "DirService", "dereferenceDynamicLinkRef", JeusMessage_JNSLocal._82, (Object)selectedLinkName);
        }
        return selectedLinkName;
    }

    public void bind(String name, Object obj, Environment env) throws Exception {
        this.bind(name, obj, env, null);
    }

    public void bind(String name, Object obj, Environment env, Attributes attrs) throws Exception {
        Message res;
        if (logger.isLoggable(JeusMessage_JNSLocal._83_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._83_LEVEL, "DirService", "bind", JeusMessage_JNSLocal._83, new Object[]{obj, name});
        }
        name = this.getKey(name);
        if (!this.isDown() && this.bindingCache.containsKey(name) || localBindingRepository.containsKey(name)) {
            throw new NameAlreadyBoundException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JNSLocal._68, (Object)name));
        }
        if (this.isLocalBinding(obj, env)) {
            this.addRepository(name, obj, env);
            if (logger.isLoggable(JeusMessage_JNSLocal._84_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._84_LEVEL, "DirService", "bind", JeusMessage_JNSLocal._84, new Object[]{obj, name});
            }
            return;
        }
        Message req = new Message(201, env);
        Object tempObj = obj;
        if (obj instanceof Remote) {
            obj = new RMIStubWrapper(obj);
        }
        req.put(0, name);
        req.put(1, obj);
        if (attrs != null) {
            req.put(5, attrs);
        }
        if ((res = this.sendMessage(req)).getCode() == 401) {
            if (logger.isLoggable(JeusMessage_JNSLocal._85_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._85_LEVEL, "DirService", "bind", JeusMessage_JNSLocal._85);
            }
            if (env.getCache()) {
                this.addCache(name, tempObj, env);
            }
        } else {
            if (logger.isLoggable(JeusMessage_JNSLocal._86_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._86_LEVEL, "DirService", "bind", JeusMessage_JNSLocal._86);
            }
            throw DirService.wrapClientException(res);
        }
    }

    public void rebind(String name, Object obj, Environment env) throws Exception {
        this.rebind(name, obj, env, null);
    }

    public void rebind(String name, Object obj, Environment env, Attributes attrs) throws Exception {
        Message res;
        if (logger.isLoggable(JeusMessage_JNSLocal._87_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._87_LEVEL, "DirService", "rebind", JeusMessage_JNSLocal._87, new Object[]{obj, name});
        }
        name = this.getKey(name);
        if (this.isLocalBinding(obj, env)) {
            this.addRepository(name, obj, env);
            return;
        }
        boolean isDynamicLinkRef = obj instanceof DynamicLinkRef;
        String localExportName = null;
        if (isDynamicLinkRef) {
            localExportName = ((DynamicLinkRef)obj).getLocalExportName();
            DynamicLinkRef prevLinkRef = DynamicLinkRef.getDynamicLink(name);
            if (prevLinkRef != null) {
                if (prevLinkRef.getLocalExportName() != null) {
                    throw new NamingException("The dynamic link ref with name " + name + " is already exported for another EJB");
                }
                prevLinkRef.setLocalExportName(localExportName);
            }
        }
        Message req = new Message(202, env);
        Object tempObj = obj;
        if (obj instanceof Remote) {
            obj = new RMIStubWrapper(obj);
        }
        req.put(0, name);
        req.put(1, obj);
        if (attrs != null) {
            req.put(5, attrs);
        }
        if ((res = this.sendMessage(req)).getCode() == 401) {
            if (logger.isLoggable(JeusMessage_JNSLocal._90_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._90_LEVEL, "DirService", "rebind", JeusMessage_JNSLocal._90, new Object[]{name, obj});
            }
            if (env.getCache()) {
                if (isDynamicLinkRef) {
                    tempObj = res.get(1);
                    ((DynamicLinkRef)tempObj).setLocalExportName(localExportName);
                }
                this.addCache(name, tempObj, env);
            }
        } else {
            if (logger.isLoggable(JeusMessage_JNSLocal._91_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._91_LEVEL, "DirService", "rebind", JeusMessage_JNSLocal._91, new Object[]{name, obj});
            }
            throw DirService.wrapClientException(res);
        }
    }

    private boolean isLocalBinding(Object obj, Environment env) {
        boolean isLocalBinding = JNS.isJNSContext(obj) ? env.getLocalContextBinding() : env.getLocal();
        return isLocalBinding;
    }

    public void localDestroySubcontext(String name) throws Exception {
        String key;
        if (logger.isLoggable(JeusMessage_JNSLocal._138_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._138_LEVEL, "DirService", "localDestroySubcontext", JeusMessage_JNSLocal._138, (Object)name);
        }
        Enumeration e = this.bindingCache.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (!key.startsWith(name)) continue;
            this.removeCache(key);
        }
        e = localBindingRepository.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (!key.startsWith(name)) continue;
            this.removeRepository(key);
        }
    }

    public void unbind(String name, Environment env, boolean dereference) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSLocal._92_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._92_LEVEL, "DirService", "unbind", JeusMessage_JNSLocal._92, new Object[]{name, String.valueOf(dereference)});
        }
        name = this.getKey(name);
        Object obj = this.removeRepository(name = this.dereference(name, dereference, false));
        if (obj != null) {
            return;
        }
        this.removeCache(name);
        Message req = new Message(203, env);
        req.put(0, name);
        Message res = this.sendMessage(req);
        if (res.getCode() != 401) {
            if (logger.isLoggable(JeusMessage_JNSLocal._96_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._96_LEVEL, "DirService", "unbind", JeusMessage_JNSLocal._96, (Object)name);
            }
            throw DirService.wrapClientException(res);
        }
        if (logger.isLoggable(JeusMessage_JNSLocal._95_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._95_LEVEL, "DirService", "unbind", JeusMessage_JNSLocal._95, (Object)name);
        }
        this.drop(name);
    }

    public void rename(String oldName, String newName, Environment env) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSLocal._97_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._97_LEVEL, "DirService", "rename", JeusMessage_JNSLocal._97, new Object[]{oldName, newName});
        }
        oldName = this.getKey(oldName);
        newName = this.getKey(newName);
        if (!this.isDown() && this.bindingCache.containsKey(newName) || localBindingRepository.containsKey(newName)) {
            throw new NameAlreadyBoundException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JNSLocal._68, (Object)newName));
        }
        if (env.getLocal()) {
            Environment localEnv = (Environment)localEnvRepository.get(oldName);
            if (localEnv != null && localEnv.getLocal()) {
                if (logger.isLoggable(JeusMessage_JNSLocal._98_LEVEL)) {
                    logger.logp(JeusMessage_JNSLocal._98_LEVEL, "DirService", "rename", JeusMessage_JNSLocal._98, new Object[]{oldName, newName});
                }
                this.addRepository(newName, localBindingRepository.get(oldName), localEnvRepository.get(oldName));
                this.removeRepository(oldName);
                return;
            }
            if (localEnv == null) {
                throw new NameNotFoundException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JNSLocal._70, (Object)oldName));
            }
            if (logger.isLoggable(JeusMessage_JNSLocal._99_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._99_LEVEL, "DirService", "rename", JeusMessage_JNSLocal._99, new Object[]{oldName, newName});
            }
            throw new OperationNotSupportedException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JNSLocal._72, (Object)oldName));
        }
        Message req = new Message(206, env);
        req.put(0, oldName);
        req.put(1, newName);
        Message res = this.sendMessage(req);
        if (res.getCode() == 401) {
            if (logger.isLoggable(JeusMessage_JNSLocal._100_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._100_LEVEL, "DirService", "rename", JeusMessage_JNSLocal._100, new Object[]{oldName, newName});
            }
        } else {
            if (logger.isLoggable(JeusMessage_JNSLocal._101_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._101_LEVEL, "DirService", "rename", JeusMessage_JNSLocal._101, new Object[]{oldName, newName});
            }
            throw DirService.wrapClientException(res);
        }
        this.drop(oldName);
    }

    public NameEnumerationImpl list(String name, boolean dereferenceDynamicLinkRef) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSLocal._102_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._102_LEVEL, "DirService", "list", JeusMessage_JNSLocal._102, (Object)name);
        }
        name = this.getKey(name);
        int nameLength = (name = this.dereference(name, true, dereferenceDynamicLinkRef)).length();
        if (nameLength == 0) {
            nameLength = -1;
        }
        Message req = new Message(205, null);
        req.put(0, name);
        Message res = this.sendMessage(req);
        if (res.getCode() == 401) {
            Object obj;
            if (logger.isLoggable(JeusMessage_JNSLocal._103_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._103_LEVEL, "DirService", "list", JeusMessage_JNSLocal._103, (Object)name);
            }
            if ((obj = res.get(0)) instanceof NameEnumerationImpl) {
                NameEnumerationImpl enumeration = (NameEnumerationImpl)obj;
                List v = enumeration.getList();
                Enumeration e = this.envCache.keys();
                while (e.hasMoreElements()) {
                    Environment localEnv;
                    String localName;
                    String localLastName = localName = (String)e.nextElement();
                    int lastSlash = localName.lastIndexOf("/");
                    if (lastSlash >= 0) {
                        localLastName = localName.substring(lastSlash + 1);
                    }
                    if (!(localEnv = (Environment)this.envCache.get(localName)).getLocal() || v.contains(localLastName) || !localName.startsWith(name) || lastSlash != nameLength) continue;
                    Object bindingObj = this.bindingCache.get(localName);
                    v.add(new JeusNameClassPair(localLastName, bindingObj.getClass().getName(), bindingObj, true));
                }
                return enumeration;
            }
            return null;
        }
        if (logger.isLoggable(JeusMessage_JNSLocal._104_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._104_LEVEL, "DirService", "list", JeusMessage_JNSLocal._104, (Object)name);
        }
        throw DirService.wrapClientException(res);
    }

    public NameEnumerationImpl localList(String name, boolean dereferenceDynamicLinkRef) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSLocal._105_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._105_LEVEL, "DirService", "localList", JeusMessage_JNSLocal._105, (Object)name);
        }
        name = this.getKey(name);
        if ((name = this.dereference(name, true, dereferenceDynamicLinkRef)).equals("")) {
            return null;
        }
        ArrayList<JeusNameClassPair> v = new ArrayList<JeusNameClassPair>();
        Object bindingObj = localBindingRepository.get(name);
        if (bindingObj == null) {
            bindingObj = this.bindingCache.get(name);
        }
        if (bindingObj != null && !JNS.isJNSContext(bindingObj)) {
            v.add(new JeusNameClassPair(name, bindingObj.getClass().getName(), bindingObj, true));
            return new NameEnumerationImpl(v, false);
        }
        int nameLength = name.length();
        if (nameLength == 0) {
            nameLength = -1;
        }
        Enumeration e = localEnvRepository.keys();
        while (e.hasMoreElements()) {
            Environment localEnv;
            String localName;
            String localLastName = localName = (String)e.nextElement();
            int lastSlash = localName.lastIndexOf("/");
            if (lastSlash >= 0) {
                localLastName = localName.substring(lastSlash + 1);
            }
            if (!(localEnv = (Environment)localEnvRepository.get(localName)).getLocal() || v.contains(localLastName) || !localName.startsWith(name) || lastSlash != nameLength) continue;
            bindingObj = localBindingRepository.get(localName);
            v.add(new JeusNameClassPair(localLastName, bindingObj.getClass().getName(), bindingObj, true));
        }
        return new NameEnumerationImpl(v, true);
    }

    public Object lookup(String name, boolean dereference) throws Exception {
        Object obj;
        if (logger.isLoggable(JeusMessage_JNSLocal._106_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._106_LEVEL, "DirService", "lookup", JeusMessage_JNSLocal._106, new Object[]{name, String.valueOf(dereference)});
        }
        if ((obj = localBindingRepository.get(name = this.getKey(name))) == null) {
            if (this.bindingCache == null) {
                this.jnsLocal.cancel();
                throw new JNSServerAlreadyDownException("already server down");
            }
            obj = this.bindingCache.get(name);
        }
        if (obj != null) {
            return this.getDereferencedObject(dereference, obj, name);
        }
        if (dereference) {
            name = this.dereference(name, true, true);
            if (logger.isLoggable(JeusMessage_JNSLocal._111_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._111_LEVEL, "DirService", "lookup", JeusMessage_JNSLocal._111, new Object[]{name, String.valueOf(dereference)});
            }
            return this.lookup(name, false);
        }
        return this.lookupFromServer(name);
    }

    private Object lookupFromServer(String name) throws Exception {
        Message req = new Message(204, null);
        req.put(0, name);
        Message res = this.sendMessage(req);
        if (res.getCode() == 401) {
            boolean cacheObject;
            if (logger.isLoggable(JeusMessage_JNSLocal._112_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._112_LEVEL, "DirService", "lookup", JeusMessage_JNSLocal._112);
            }
            Object obj = res.get(0);
            Environment env1 = res.getEnvironment();
            boolean bl = cacheObject = this.useCacheForLookupObject && env1.getCache();
            if (cacheObject) {
                this.addCache(name, obj, env1);
            } else if (obj instanceof DynamicLinkRef) {
                obj = DynamicLinkRef.addDynamicLink(name, (DynamicLinkRef)obj);
            }
            if (obj instanceof LinkRef) {
                String url = ((LinkRef)obj).getLinkName();
                if (url.startsWith("corbaname:") || url.startsWith("corbaloc:")) {
                    InitialContext ctx = new InitialContext((Hashtable)JNSContext.currentContextEnvironment.get());
                    return ctx.lookup(url);
                }
                obj = res.get(1);
                if (cacheObject) {
                    this.addCache(url, obj, env1);
                }
            }
            return obj;
        }
        if (logger.isLoggable(JeusMessage_JNSLocal._113_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._113_LEVEL, "DirService", "lookup", JeusMessage_JNSLocal._113);
        }
        throw DirService.wrapClientException(res);
    }

    private Object getDereferencedObject(boolean dereference, Object obj, String name) throws Exception {
        if (dereference) {
            if (obj instanceof LinkRef) {
                Object lookupObject;
                String url = ((LinkRef)obj).getLinkName();
                if (logger.isLoggable(JeusMessage_JNSLocal._107_LEVEL)) {
                    logger.logp(JeusMessage_JNSLocal._107_LEVEL, "DirService", "lookup", JeusMessage_JNSLocal._107, new Object[]{name, url});
                }
                if (url.startsWith("corbaname:") || url.startsWith("corbaloc:")) {
                    if (logger.isLoggable(JeusMessage_JNSLocal._139_LEVEL)) {
                        logger.logp(JeusMessage_JNSLocal._139_LEVEL, "DirService", "lookup", JeusMessage_JNSLocal._139, (Object)url);
                    }
                    InitialContext ctx = CosNamingResourceFactory.getCNCtx();
                    return ctx.lookup(url);
                }
                if (url.startsWith("java:")) {
                    InitialContext ctx = new InitialContext();
                    lookupObject = ctx.lookup(url);
                } else {
                    lookupObject = this.lookup(url, true);
                }
                if (obj instanceof PropertyLinkRef && lookupObject instanceof PropertyReference) {
                    ((PropertyReference)lookupObject).setProperties(((PropertyLinkRef)obj).getProperties());
                }
                if (logger.isLoggable(JeusMessage_JNSLocal._108_LEVEL)) {
                    logger.logp(JeusMessage_JNSLocal._108_LEVEL, "DirService", "lookup", JeusMessage_JNSLocal._108, lookupObject);
                }
                return lookupObject;
            }
            if (obj instanceof DynamicLinkRef) {
                Object clusterObj = ((DynamicLinkRef)obj).getLinkObject();
                if (logger.isLoggable(JeusMessage_JNSLocal._109_LEVEL)) {
                    logger.logp(JeusMessage_JNSLocal._109_LEVEL, "DirService", "lookup", JeusMessage_JNSLocal._109, clusterObj);
                }
                return clusterObj;
            }
        }
        if (logger.isLoggable(JeusMessage_JNSLocal._110_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._110_LEVEL, "DirService", "lookup", JeusMessage_JNSLocal._110, obj);
        }
        return obj;
    }

    public Attributes getAttributes(String name, String[] attrIds) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSLocal._114_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._114_LEVEL, "DirService", "getAttributes", JeusMessage_JNSLocal._114, (Object)name);
        }
        name = this.getKey(name);
        Message req = new Message(208, null);
        req.put(0, name);
        req.put(6, attrIds);
        Message res = this.sendMessage(req);
        if (res.getCode() == 401) {
            Attributes ret;
            if (logger.isLoggable(JeusMessage_JNSLocal._115_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._115_LEVEL, "DirService", "getAttributes", JeusMessage_JNSLocal._115);
            }
            if ((ret = (Attributes)res.get(0)) == null) {
                ret = new BasicAttributes();
            }
            return ret;
        }
        if (logger.isLoggable(JeusMessage_JNSLocal._116_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._116_LEVEL, "DirService", "getAttributes", JeusMessage_JNSLocal._116);
        }
        throw DirService.wrapClientException(res);
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSLocal._117_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._117_LEVEL, "DirService", "modifyAttributes", JeusMessage_JNSLocal._117, (Object)name);
        }
        name = this.getKey(name);
        Message req = new Message(209, null);
        req.put(0, name);
        req.put(7, mods);
        Message res = this.sendMessage(req);
        if (res.getCode() != 401) {
            if (logger.isLoggable(JeusMessage_JNSLocal._118_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._118_LEVEL, "DirService", "modifyAttributes", JeusMessage_JNSLocal._118);
            }
            throw DirService.wrapClientException(res);
        }
        this.drop(name);
        if (logger.isLoggable(JeusMessage_JNSLocal._119_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._119_LEVEL, "DirService", "modifyAttributes", JeusMessage_JNSLocal._119);
        }
    }

    public List search(String name, Attributes attrs, String[] attrIds) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSLocal._120_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._120_LEVEL, "DirService", "search", JeusMessage_JNSLocal._120, new Object[]{attrs, name});
        }
        name = this.getKey(name);
        Message req = new Message(210, null);
        req.put(0, name);
        req.put(5, attrs);
        req.put(6, attrIds);
        Message res = this.sendMessage(req);
        if (res.getCode() == 401) {
            if (logger.isLoggable(JeusMessage_JNSLocal._121_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._121_LEVEL, "DirService", "search", JeusMessage_JNSLocal._121);
            }
            return (List)res.get(0);
        }
        if (logger.isLoggable(JeusMessage_JNSLocal._122_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._122_LEVEL, "DirService", "search", JeusMessage_JNSLocal._122);
        }
        throw DirService.wrapClientException(res);
    }

    public List search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSLocal._123_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._123_LEVEL, "DirService", "search", JeusMessage_JNSLocal._123, new Object[]{name, filterExpr, cons});
        }
        name = this.getKey(name);
        Message req = new Message(210, null);
        req.put(0, name);
        req.put(11, filterExpr);
        req.put(12, filterArgs);
        req.put(8, cons);
        Message res = this.sendMessage(req);
        if (res.getCode() == 401) {
            if (logger.isLoggable(JeusMessage_JNSLocal._124_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._124_LEVEL, "DirService", "search", JeusMessage_JNSLocal._124);
            }
            return (List)res.get(0);
        }
        if (logger.isLoggable(JeusMessage_JNSLocal._125_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._125_LEVEL, "DirService", "search", JeusMessage_JNSLocal._125);
        }
        throw DirService.wrapClientException(res);
    }

    public DirContext getSchema(String name) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSLocal._126_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._126_LEVEL, "DirService", "getSchema", JeusMessage_JNSLocal._126, (Object)name);
        }
        name = this.getKey(name);
        Message req = new Message(211, null);
        req.put(0, name);
        Message res = this.sendMessage(req);
        if (res.getCode() == 401) {
            if (logger.isLoggable(JeusMessage_JNSLocal._127_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._127_LEVEL, "DirService", "getSchema", JeusMessage_JNSLocal._127, (Object)name);
            }
            return (DirContext)res.get(0);
        }
        if (logger.isLoggable(JeusMessage_JNSLocal._128_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._128_LEVEL, "DirService", "getSchema", JeusMessage_JNSLocal._128, (Object)name);
        }
        throw DirService.wrapClientException(res);
    }

    public DirContext getSchemaClassDefinition(String name) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSLocal._129_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._129_LEVEL, "DirService", "getSchemaClassDefinition", JeusMessage_JNSLocal._129, (Object)name);
        }
        name = this.getKey(name);
        Message req = new Message(212, null);
        req.put(0, name);
        Message res = this.sendMessage(req);
        if (res.getCode() == 401) {
            if (logger.isLoggable(JeusMessage_JNSLocal._130_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._130_LEVEL, "DirService", "getSchemaClassDefinition", JeusMessage_JNSLocal._130);
            }
            return (DirContext)res.get(0);
        }
        if (logger.isLoggable(JeusMessage_JNSLocal._131_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._131_LEVEL, "DirService", "getSchemaClassDefinition", JeusMessage_JNSLocal._131);
        }
        throw DirService.wrapClientException(res);
    }

    public void dispatchEvent(Message msg) {
        if (logger.isLoggable(JeusMessage_JNSLocal._51_LEVEL)) {
            logger.log(JeusMessage_JNSLocal._51_LEVEL, JeusMessage_JNSLocal._51, (Object)msg);
        }
        Integer listenerID = (Integer)msg.get(9);
        Reference ctxRef = (Reference)msg.get(2);
        Integer type = (Integer)msg.get(10);
        Binding newBd = (Binding)msg.get(3);
        Binding oldBd = (Binding)msg.get(4);
        try {
            EventContext eventSource;
            if (ctxRef == null) {
                InitialDirContext initial = new InitialDirContext();
                eventSource = (EventDirContext)initial.lookup("");
            } else {
                eventSource = (EventContext)NamingManager.getObjectInstance(ctxRef, null, null, null);
            }
            NamingEvent event = new NamingEvent(eventSource, type, newBd, oldBd, null);
            NamingListener listener = (NamingListener)this.listenerTable.get(listenerID);
            if (listener == null) {
                return;
            }
            if (logger.isLoggable(JeusMessage_JNSLocal._133_LEVEL)) {
                logger.logp(JeusMessage_JNSLocal._133_LEVEL, "DirService", "dispatchEvent", JeusMessage_JNSLocal._133, new Object[]{event, listener});
            }
            switch (event.getType()) {
                case 0: {
                    if (!(listener instanceof NamespaceChangeListener)) break;
                    ((NamespaceChangeListener)listener).objectAdded(event);
                    break;
                }
                case 1: {
                    if (!(listener instanceof NamespaceChangeListener)) break;
                    ((NamespaceChangeListener)listener).objectRemoved(event);
                    break;
                }
                case 2: {
                    if (!(listener instanceof NamespaceChangeListener)) break;
                    ((NamespaceChangeListener)listener).objectRenamed(event);
                    break;
                }
                case 3: {
                    if (!(listener instanceof ObjectChangeListener)) break;
                    ((ObjectChangeListener)listener).objectChanged(event);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addNamingListener(String name, int scope, NamingListener listener) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSLocal._134_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._134_LEVEL, "DirService", "addNamingListener", JeusMessage_JNSLocal._134, new Object[]{listener, name, String.valueOf(scope)});
        }
        name = this.getKey(name);
        Integer type = listener instanceof ObjectChangeListener ? JNSContext.OBJECT_CHANGE_LISTENER : (listener instanceof NamespaceChangeListener ? JNSContext.NAMESPACE_CHANGE_LISTENER : JNSContext.ETC_LISTENER);
        Integer listenerID = this.getNextListenerID();
        Message req = new Message(213, null);
        req.put(9, listenerID);
        req.put(10, type);
        req.put(0, name);
        req.put(13, new Integer(scope));
        Message res = this.sendMessage(req);
        if (res.getCode() != 401) {
            throw DirService.wrapClientException(res);
        }
        this.listenerTable.put(listenerID, listener);
        this.listenerReverseTable.put(listener, listenerID);
    }

    public void removeNamingListener(NamingListener listener) throws Exception {
        Integer listenerID;
        if (logger.isLoggable(JeusMessage_JNSLocal._135_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._135_LEVEL, "DirService", "removeNamingListener", JeusMessage_JNSLocal._135, (Object)listener);
        }
        if ((listenerID = (Integer)this.listenerReverseTable.get(listener)) == null) {
            return;
        }
        this.listenerTable.remove(listenerID);
        this.listenerReverseTable.remove(listener);
        Message req = new Message(214, null);
        req.put(9, listenerID);
        Message res = this.sendMessage(req);
        if (res.getCode() != 401) {
            throw DirService.wrapClientException(res);
        }
    }

    public void addNamingListener(String name, String filterExpr, SearchControls cons, NamingListener listener) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSLocal._136_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._136_LEVEL, "DirService", "removeNamingListener", JeusMessage_JNSLocal._136, new Object[]{listener, name, filterExpr, cons});
        }
        name = this.getKey(name);
        Integer listenerID = this.getNextListenerID();
        Message req = new Message(213, null);
        req.put(9, listenerID);
        req.put(0, name);
        req.put(11, filterExpr);
        req.put(8, cons);
        Message res = this.sendMessage(req);
        if (res.getCode() != 401) {
            throw DirService.wrapClientException(res);
        }
        this.listenerTable.put(listenerID, listener);
        this.listenerReverseTable.put(listener, listenerID);
    }

    public void addNamingListener(String name, String filterExpr, Object[] filterArgs, SearchControls cons, NamingListener listener) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSLocal._137_LEVEL)) {
            logger.logp(JeusMessage_JNSLocal._137_LEVEL, "DirService", "removeNamingListener", JeusMessage_JNSLocal._137, new Object[]{listener, name, filterExpr, cons});
        }
        name = this.getKey(name);
        Integer listenerID = this.getNextListenerID();
        Message req = new Message(213, null);
        req.put(9, listenerID);
        req.put(0, name);
        req.put(11, filterExpr);
        req.put(12, filterArgs);
        req.put(8, cons);
        Message res = this.sendMessage(req);
        if (res.getCode() != 401) {
            throw DirService.wrapClientException(res);
        }
        this.listenerTable.put(listenerID, listener);
        this.listenerReverseTable.put(listener, listenerID);
    }

    public void drop(String name) throws Exception {
        DynamicLinkRef linkRef;
        String dynamicLinkName = DirService.getClusterExportName(name);
        if (dynamicLinkName != null) {
            ClusterManager.removeFailedLink(name);
            linkRef = DynamicLinkRef.getDynamicLink(dynamicLinkName);
            if (linkRef != null) {
                try {
                    boolean noMoreLinks = linkRef.remove(name);
                    String localExportName = linkRef.getLocalExportName();
                    if (localExportName != null && localExportName.equals(name)) {
                        linkRef.setLocalExportName(null);
                    }
                    if (noMoreLinks) {
                        DynamicLinkRef.removeDynamicLink(dynamicLinkName);
                        if (this.bindingCache != null) {
                            this.removeCache(dynamicLinkName);
                        }
                    }
                }
                catch (Throwable t) {
                    if (logger.isLoggable(JeusMessage_JNSLocal._65_LEVEL)) {
                        logger.logp(JeusMessage_JNSLocal._65_LEVEL, "Service", "drop", JeusMessage_JNSLocal._65, t);
                    }
                }
            }
        } else {
            dynamicLinkName = DirService.getDynamicLinkExportName(name);
            if (dynamicLinkName != null) {
                linkRef = DynamicLinkRef.getDynamicLink(dynamicLinkName);
                String item = DirService.getDynamicLinkItem(name);
                linkRef.remove(item);
            }
        }
        if (this.bindingCache == null) {
            return;
        }
        Object obj = this.bindingCache.get(name);
        if (!(obj instanceof DynamicLinkRef) && !JNS.isJNSContext(obj)) {
            this.removeCache(name);
        }
    }

    public void replicate(String name, Object updateDynamicLinkRef) throws Exception {
        DynamicLinkRef localDynamicLinkRef = DynamicLinkRef.getDynamicLink(name);
        if (localDynamicLinkRef instanceof DynamicLinkRef && updateDynamicLinkRef instanceof DynamicLinkRef) {
            try {
                DynamicLinkRef linkRef = localDynamicLinkRef;
                linkRef.replicate((DynamicLinkRef)updateDynamicLinkRef);
            }
            catch (Throwable t) {
                if (logger.isLoggable(JeusMessage_JNSLocal._65_LEVEL)) {
                    logger.logp(JeusMessage_JNSLocal._65_LEVEL, "Service", "drop", JeusMessage_JNSLocal._65, t);
                }
            }
        } else if (!JNS.isJNSContext(updateDynamicLinkRef)) {
            if (DirService.getClusterExportName(name) != null) {
                ClusterManager.removeFailedLink(name);
            }
            this.removeCache(name);
        }
    }

    public boolean isDown() {
        return this.bindingCache == null;
    }
}

