/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.local;

import java.io.IOException;
import java.security.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import jeus.jndi.JNSContext;
import jeus.jndi.jns.common.DynamicLinkRef;
import jeus.jndi.jns.common.Environment;
import jeus.jndi.jns.common.Message;
import jeus.jndi.jns.common.NamingServerException;
import jeus.jndi.jns.local.JNSLocal;
import jeus.net.ReplyListener;
import jeus.net.SocketStream;
import jeus.net.helper.MsgSync;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JNSLocal;
import jeus.util.properties.JeusJNDIProperties;

public class Service {
    protected JNSLocal jnsLocal;
    protected Hashtable syncTable;
    protected ConcurrentHashMap bindingCache;
    protected ConcurrentHashMap envCache;
    protected static ConcurrentHashMap localBindingRepository = new ConcurrentHashMap(100);
    protected static ConcurrentHashMap localEnvRepository = new ConcurrentHashMap(100);
    protected ConcurrentHashMap listenerTable = new ConcurrentHashMap(20);
    protected ConcurrentHashMap listenerReverseTable = new ConcurrentHashMap(20);
    protected int listenerID;
    protected static final JeusLogger logger = JNSLocal.getLogger();
    private static final String JEUS_CLUSTER_PREFIX = "__jeus_cl@";
    private static final String JEUS_LINK_PREFIX = "__jeus_link@";
    private static final String LINK_ITEM_PREFIX = "_$item$_";

    public Service(JNSLocal jnsLocal) {
        this.syncTable = new Hashtable(100);
        this.bindingCache = new ConcurrentHashMap(100);
        this.envCache = new ConcurrentHashMap(100);
        this.jnsLocal = jnsLocal;
    }

    public void destroy() {
        if (this.bindingCache != null) {
            this.bindingCache.clear();
        }
        if (this.envCache != null) {
            this.envCache.clear();
        }
        if (this.syncTable != null) {
            this.syncTable.clear();
        }
        if (this.listenerTable != null) {
            this.listenerTable.clear();
        }
        if (this.listenerReverseTable != null) {
            this.listenerReverseTable.clear();
        }
        this.bindingCache = null;
        this.envCache = null;
        this.syncTable = null;
        this.listenerTable = null;
        this.listenerReverseTable = null;
    }

    public static void clearLocalBindings() {
        localBindingRepository.clear();
        localEnvRepository.clear();
    }

    protected void addCache(String name, Object obj, Object env) {
        if (obj instanceof DynamicLinkRef) {
            obj = DynamicLinkRef.addDynamicLink(name, (DynamicLinkRef)obj);
        }
        if (this.bindingCache != null) {
            if (env == null) {
                env = Environment.defaultEnv;
            }
            if (name != null && obj != null) {
                this.bindingCache.put(name, obj);
                this.envCache.put(name, env);
            }
        }
    }

    public Object removeCache(String name) {
        if (this.bindingCache != null) {
            this.envCache.remove(name);
            return this.bindingCache.remove(name);
        }
        return null;
    }

    protected void addRepository(String name, Object obj, Object env) {
        if (env == null) {
            env = Environment.defaultEnv;
        }
        if (name != null && obj != null) {
            localBindingRepository.put(name, obj);
            localEnvRepository.put(name, env);
        }
    }

    protected Object removeRepository(String name) {
        localEnvRepository.remove(name);
        return localBindingRepository.remove(name);
    }

    protected Message sendMessage(Message req) throws Exception {
        int retryCount = 0;
        MsgSync sync = new MsgSync(JeusJNDIProperties.JNDI_WAIT_TIME_OUT);
        while (true) {
            try {
                SocketStream stream = this.jnsLocal.getSocketStream();
                if (stream == null) {
                    throw new IOException("try to reconnect");
                }
                stream.write((Object)req, (ReplyListener)sync);
                Object obj = null;
                try {
                    obj = sync.waitReply();
                    return (Message)obj;
                }
                catch (ClassCastException npe) {
                    if (obj != null) {
                        System.out.println("***** class cast exception occurred : " + obj + ", class : " + obj.getClass() + ", classloader : " + obj.getClass().getClassLoader());
                    } else {
                        System.out.println("***** class cast exception occurred, obj is null");
                    }
                    npe.printStackTrace();
                    throw npe;
                }
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
                throw new NamingException("service is alreay stopped");
            }
            catch (IOException e) {
                try {
                    this.jnsLocal = JNSLocal.getLocalServer(this.jnsLocal.localServerID, (Hashtable)JNSContext.currentContextEnvironment.get());
                    continue;
                }
                catch (NamingServerException e1) {
                    this.jnsLocal.cancel();
                    throw e1;
                }
                if (++retryCount < 5) continue;
                NamingException ne = Service.makeNamingException(e);
                return new Message(402, null, (Object)ne, null);
            }
            break;
        }
    }

    public synchronized Integer getNextListenerID() {
        ++this.listenerID;
        if (this.listenerID == Integer.MAX_VALUE) {
            this.listenerID = 0;
        }
        return new Integer(this.listenerID);
    }

    public String getKey(String str) {
        if (str.startsWith("//")) {
            return str.substring(str.indexOf(47, 2) + 1);
        }
        return str;
    }

    public void clientAuthorize(String name, String action) throws NoPermissionException {
        byte[] subjectbytes;
        if (JNSContext.subjectThreadLocal.get() != null && (subjectbytes = (byte[])JNSContext.subjectThreadLocal.get()).length != 0) {
            Message msg;
            try {
                msg = new Message(207, null, (Object)subjectbytes, (Object)new String[]{"jeus.jndi." + name.replace('/', '.'), action});
                msg = this.sendMessage(msg);
            }
            catch (Exception e) {
                throw new NoPermissionException(e.toString());
            }
            if (msg.getCode() != 401) {
                throw new NoPermissionException();
            }
        }
    }

    public void serverAuthorize(String name, String action) throws NoPermissionException {
        try {
            LoginUtil.checkPermissionWithRuntimeException((Permission)PermissionMaker.makeResourcePermission((String)("jeus.jndi." + name.replace('/', '.')), (String)action));
        }
        catch (Exception ex) {
            throw new NoPermissionException(ex.toString());
        }
    }

    public void print() {
        if (logger.isLoggable(JeusMessage_JNSLocal._47_LEVEL)) {
            logger.log(JeusMessage_JNSLocal._47_LEVEL, JeusMessage_JNSLocal._47);
        }
        Enumeration e = this.bindingCache.keys();
        while (e.hasMoreElements()) {
            String nm = (String)e.nextElement();
            if (!logger.isLoggable(JeusMessage_JNSLocal._48_LEVEL)) continue;
            logger.log(JeusMessage_JNSLocal._48_LEVEL, JeusMessage_JNSLocal._48, (Object[])new String[]{nm, this.bindingCache.get(nm).getClass().getName()});
        }
        if (logger.isLoggable(JeusMessage_JNSLocal._49_LEVEL)) {
            logger.log(JeusMessage_JNSLocal._49_LEVEL, JeusMessage_JNSLocal._49);
        }
    }

    public void print2() {
        if (logger.isLoggable(JeusMessage_JNSLocal._47_LEVEL)) {
            logger.log(JeusMessage_JNSLocal._47_LEVEL, JeusMessage_JNSLocal._47);
        }
        Enumeration e = this.bindingCache.keys();
        while (e.hasMoreElements()) {
            String nm = (String)e.nextElement();
            if (!logger.isLoggable(JeusMessage_JNSLocal._50_LEVEL)) continue;
            logger.log(JeusMessage_JNSLocal._50_LEVEL, JeusMessage_JNSLocal._50, (Object)nm);
        }
        if (logger.isLoggable(JeusMessage_JNSLocal._49_LEVEL)) {
            logger.log(JeusMessage_JNSLocal._49_LEVEL, JeusMessage_JNSLocal._49);
        }
    }

    public static String getClusterExportName(String name) {
        int index = name.indexOf(JEUS_CLUSTER_PREFIX);
        if (index != -1) {
            String dynamicLinkName = name.substring(index + JEUS_CLUSTER_PREFIX.length());
            int addrIndex = dynamicLinkName.indexOf("_$addr$_");
            dynamicLinkName = dynamicLinkName.substring(dynamicLinkName.indexOf(95) + 1, addrIndex);
            return dynamicLinkName;
        }
        return null;
    }

    public static String getDynamicLinkExportName(String name) {
        int index = name.indexOf(JEUS_LINK_PREFIX);
        if (index != -1) {
            String dynamicLinkName = name.substring(index + JEUS_LINK_PREFIX.length());
            int addrIndex = dynamicLinkName.indexOf("_$addr$_");
            dynamicLinkName = dynamicLinkName.substring(dynamicLinkName.indexOf(95) + 1, addrIndex);
            return dynamicLinkName;
        }
        return null;
    }

    public static String getDynamicLinkItem(String name) {
        int addrIndex;
        int index = name.indexOf(JEUS_LINK_PREFIX);
        if (index >= 0 && (addrIndex = name.indexOf(LINK_ITEM_PREFIX)) >= 0) {
            return name.substring(addrIndex + LINK_ITEM_PREFIX.length());
        }
        return null;
    }

    public static String getClusterExportUrl(String name) {
        int addrIndex;
        int index = name.indexOf(JEUS_CLUSTER_PREFIX);
        if (index >= 0 && (addrIndex = name.indexOf("_$addr$_")) >= 0) {
            return name.substring(addrIndex + "_$addr$_".length());
        }
        return "localhost";
    }

    public static NamingException wrapClientException(Message res) {
        Exception e = (Exception)res.get(0);
        return Service.wrapClientException(e);
    }

    public static NamingException wrapClientException(Exception e) {
        NamingException ex;
        if (e instanceof NamingException) {
            try {
                ex = (NamingException)e.getClass().newInstance();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return (NamingException)e;
            }
        } else {
            ex = new NamingException();
        }
        ex.setRootCause(e);
        return ex;
    }

    public static NamingException makeNamingException(Throwable e) {
        if (e instanceof NamingException) {
            return (NamingException)e;
        }
        NamingException ne = new NamingException(e.toString());
        ne.setRootCause(e);
        return ne;
    }
}

