/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.LinkRef;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import jeus.jndi.JNSContext;
import jeus.jndi.jns.common.DynamicLinkRef;
import jeus.jndi.jns.common.Environment;
import jeus.jndi.jns.common.JNS;
import jeus.jndi.jns.common.JeusNameClassPair;
import jeus.jndi.jns.common.NameEnumerationImpl;
import jeus.jndi.jns.local.JNSLocal;
import jeus.jndi.jns.local.Service;
import jeus.jndi.jns.server.JNSServer;
import jeus.jndi.jns.server.repository.Composite;
import jeus.jndi.jns.server.repository.ListenerProxy;
import jeus.jndi.jns.server.repository.Node;
import jeus.jndi.jns.server.repository.SearchFilter;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.util.UpdatableReference;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JNSServer;

public class DirService {
    private final Composite root = new Composite(null, "", null, null, null);
    private final Map directBindings = Collections.synchronizedMap(new LinkedHashMap(100));
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jndi");

    public void destroy() {
        this.root.remove();
    }

    public void bind(String name, Object obj, Environment env, Attributes attrs) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSServer._210_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._210_LEVEL, "DirService", "bind", JeusMessage_JNSServer._210, new Object[]{obj, name, env});
        }
        this.bindInternal(name, obj, env, attrs, false);
    }

    public void rebind(String name, Object obj, Environment env, Attributes attrs) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSServer._211_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._211_LEVEL, "DirService", "rebind", JeusMessage_JNSServer._211, new Object[]{obj, name, env});
        }
        if (obj == null && logger.isLoggable(JeusMessage_JNSServer._301_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._301_LEVEL, "DirService", "rebind", JeusMessage_JNSServer._301, (Object)name);
        }
        this.bindInternal(name, obj, env, attrs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindInternal(String name, Object obj, Environment env, Attributes attrs, boolean rebind) throws Exception {
        Node target;
        Object oldValue = null;
        Composite composite = this.root;
        synchronized (composite) {
            target = this.root.find(name);
            if (target != null) {
                oldValue = target.getValue();
                if (oldValue instanceof DynamicLinkRef && obj instanceof DynamicLinkRef) {
                    ((DynamicLinkRef)oldValue).addList((DynamicLinkRef)obj);
                    obj = oldValue;
                    target.remove();
                } else if (oldValue instanceof UpdatableReference) {
                    obj = oldValue;
                    target.remove();
                } else if (rebind) {
                    if (JNS.isJNSContext(oldValue)) {
                        return;
                    }
                    target.remove();
                } else {
                    throw new NameAlreadyBoundException(name + " " + "Already bound.");
                }
            }
            if (attrs != null && obj instanceof UpdatableReference) {
                UpdatableReference ref = (UpdatableReference)obj;
                NamingEnumeration<? extends Attribute> enumeration = attrs.getAll();
                while (enumeration.hasMoreElements()) {
                    Attribute attribute = (Attribute)enumeration.nextElement();
                    ref.addAttribute(attribute);
                }
            }
            if (env.getReplicate() && env.getForced() && !env.getDirectBind()) {
                String ctxName = "";
                CompositeName compositeName = new CompositeName(name);
                Enumeration<String> names = compositeName.getAll();
                while (names.hasMoreElements()) {
                    String atomicName = names.nextElement();
                    Node _target = this.root.find(ctxName = ctxName + atomicName);
                    if (_target == null && names.hasMoreElements()) {
                        Hashtable<String, String> _env = new Hashtable<String, String>();
                        _env.put("jeus.jndi.jns.forcedbindings", "true");
                        JNSContext ctx = new JNSContext(JNSLocal.getLocalServer(), _env, name);
                        this.root.addComposite(ctxName, ctx.getReference(), env, attrs);
                    }
                    ctxName = ctxName + "/";
                }
            }
            target = JNS.isJNSContext(obj) ? this.root.addComposite(name, obj, env, attrs) : this.root.addLeaf(name, obj, env, attrs);
        }
        if (env.getDirectBind() || env.getCluster()) {
            this.directBindings.put(name, name);
        }
        if (oldValue == null) {
            target.notify(0, new Binding(target.getName(), obj), null);
        } else {
            target.notify(3, new Binding(target.getName(), obj), new Binding(target.getName(), oldValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String oldName, String newName) throws Exception {
        Node target;
        if (logger.isLoggable(JeusMessage_JNSServer._212_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._212_LEVEL, "DirService", "rename", JeusMessage_JNSServer._212, new Object[]{oldName, newName});
        }
        Composite composite = this.root;
        synchronized (composite) {
            target = this.root.find(newName);
            if (target != null) {
                throw new NameAlreadyBoundException(newName + " " + "Already bound.");
            }
            target = this.root.find(oldName);
            if (target == null) {
                throw new NameNotFoundException("[" + oldName + "] " + "Name not found.");
            }
            Environment env = target.getEnv();
            if (!env.getDirectBind()) {
                throw new NoPermissionException("Only direct binding can be renamed.");
            }
            if (env.getDirectBind() || env.getCluster()) {
                this.directBindings.remove(oldName);
                this.directBindings.put(newName, newName);
            }
            newName = this.getLastName(newName);
            oldName = this.getLastName(oldName);
            target.setName(newName);
            target.getParent().renameChild(oldName, newName);
        }
        target.notify(2, new Binding(oldName, target.getValue()), new Binding(newName, target.getValue()));
    }

    private String getLastName(String name) {
        int index = name.lastIndexOf(47);
        if (index >= 0) {
            name = name.substring(index + 1);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unbind(String name) throws Exception {
        DynamicLinkRef obj;
        boolean noMoreLinks;
        Node _target;
        Node target;
        String dynamicLinkName;
        if (logger.isLoggable(JeusMessage_JNSServer._213_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._213_LEVEL, "DirService", "unbind", JeusMessage_JNSServer._213, (Object)name);
        }
        if ((dynamicLinkName = Service.getDynamicLinkExportName(name)) != null) {
            Node target2;
            Composite composite = this.root;
            synchronized (composite) {
                target2 = this.root.find(dynamicLinkName);
            }
            if (target2 == null) {
                throw new NameNotFoundException("[" + dynamicLinkName + "] " + "Name not found.");
            }
            Object linkRef = target2.getValue();
            if (!(linkRef instanceof DynamicLinkRef)) {
                throw new NamingException("[" + dynamicLinkName + "] is not a dynamic link ref");
            }
            String item = Service.getDynamicLinkItem(name);
            ((DynamicLinkRef)linkRef).remove(item);
            return linkRef;
        }
        Composite linkRef = this.root;
        synchronized (linkRef) {
            target = this.root.find(name);
            if (target == null) {
                throw new NameNotFoundException("[" + name + "] " + "Name not found.");
            }
            target.remove();
            this.directBindings.remove(name);
        }
        target.notify(1, new Binding(target.getName(), target.getValue()), null);
        dynamicLinkName = Service.getClusterExportName(name);
        if (dynamicLinkName != null && (_target = this.root.find(dynamicLinkName)) != null && (noMoreLinks = (obj = (DynamicLinkRef)_target.getValue()).remove(name))) {
            _target.remove();
        }
        return target.getValue();
    }

    public Object lookup(String name) throws Exception {
        Node target;
        if (logger.isLoggable(JeusMessage_JNSServer._214_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._214_LEVEL, "DirService", "lookup", JeusMessage_JNSServer._214, (Object)name);
        }
        if ((target = this.root.find(name)) == null) {
            throw new NameNotFoundException("[" + name + "] " + "Name not found.");
        }
        Object value = target.getValue();
        if (value == null && logger.isLoggable(JeusMessage_JNSServer._300_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._300_LEVEL, "DirService", "lookup", JeusMessage_JNSServer._300, (Object)name);
        }
        return value;
    }

    public Object[] lookupAndEnv(String name) throws Exception {
        Node target;
        if (logger.isLoggable(JeusMessage_JNSServer._214_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._214_LEVEL, "DirService", "lookup", JeusMessage_JNSServer._214, (Object)name);
        }
        if ((target = this.root.find(name)) == null) {
            throw new NameNotFoundException("[" + name + "] " + "Name not found.");
        }
        return new Object[]{target.getValue(), target.getEnv(), target.getAttrs()};
    }

    public NameEnumerationImpl list(String prefix) throws Exception {
        Node node;
        if (logger.isLoggable(JeusMessage_JNSServer._215_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._215_LEVEL, "DirService", "list", JeusMessage_JNSServer._215, (Object)prefix);
        }
        if (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.lastIndexOf(47));
        }
        if ((node = this.root.find(prefix)) == null) {
            throw new NameNotFoundException(prefix + " does not exist.");
        }
        if (node instanceof Composite) {
            return new NameEnumerationImpl(((Composite)node).list(), true);
        }
        ArrayList<JeusNameClassPair> list = new ArrayList<JeusNameClassPair>();
        list.add(new JeusNameClassPair(prefix, node.getValue().getClass().getName(), node.getValue(), false));
        return new NameEnumerationImpl(list, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Environment lookupEnv(String name) throws Exception {
        Node target;
        if (logger.isLoggable(JeusMessage_JNSServer._216_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._216_LEVEL, "DirService", "lookupEnv", JeusMessage_JNSServer._216, (Object)name);
        }
        Composite composite = this.root;
        synchronized (composite) {
            target = this.root.find(name);
        }
        if (target == null) {
            throw new NameNotFoundException("[" + name + "] " + "Name not found.");
        }
        return target.getEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getReplicationItems() {
        String[] directBindingNames = this.getDirectBindingNames();
        ArrayList<Object[]> result = new ArrayList<Object[]>(directBindingNames.length);
        Composite composite = this.root;
        synchronized (composite) {
            for (int i = 0; i < directBindingNames.length; ++i) {
                String name = directBindingNames[i];
                Node target = this.root.find(name);
                if (target == null || !target.getEnv().getReplicate()) continue;
                Object value = target.getValue();
                if (value == null && logger.isLoggable(JeusMessage_JNSServer._300_LEVEL)) {
                    logger.logp(JeusMessage_JNSServer._300_LEVEL, "DirService", "getReplicationItems", JeusMessage_JNSServer._300, (Object)name);
                }
                result.add(new Object[]{name, value, target.getEnv(), target.getAttrs()});
            }
        }
        return result;
    }

    public String[] getDirectBindingNames() {
        if (logger.isLoggable(JeusMessage_JNSServer._217_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._217_LEVEL, "DirService", "getDirectBindingNames", JeusMessage_JNSServer._217);
        }
        return this.directBindings.keySet().toArray(new String[0]);
    }

    public String dereference(String linkname) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSServer._218_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._218_LEVEL, "DirService", "dereference", JeusMessage_JNSServer._218, (Object)linkname);
        }
        String dereferencedName = "";
        StringTokenizer atomicNames = new StringTokenizer(linkname, "/");
        while (atomicNames.hasMoreTokens()) {
            Node node = this.root.find(dereferencedName = dereferencedName + atomicNames.nextToken());
            if (node == null) {
                throw new NameNotFoundException("[" + dereferencedName + "] " + "Name not found.");
            }
            Object obj = node.getValue();
            if (obj instanceof LinkRef) {
                String url = ((LinkRef)obj).getLinkName();
                if (url.startsWith("corbaname:") || url.startsWith("corbaloc:")) {
                    return url;
                }
                dereferencedName = this.dereference(url);
            }
            if (!atomicNames.hasMoreTokens()) continue;
            dereferencedName = dereferencedName + "/";
        }
        return dereferencedName;
    }

    public void replicate(String name, Object value, Environment env, Attributes attrs) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSServer._219_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._219_LEVEL, "DirService", "replicate", JeusMessage_JNSServer._219, new Object[]{value, name, env});
        }
        this.rebind(name, value, env, attrs);
    }

    public Attributes getAttributes(String name, String[] attrIds) throws Exception {
        Node target;
        if (logger.isLoggable(JeusMessage_JNSServer._220_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._220_LEVEL, "DirService", "getAttributes", JeusMessage_JNSServer._220, (Object)name);
        }
        if ((target = this.root.find(name)) == null) {
            throw new NameNotFoundException("[" + name + "] " + "Name not found.");
        }
        Attributes attrs = target.getAttrs();
        if (attrIds == null) {
            return attrs;
        }
        if (attrs == null) {
            return null;
        }
        Attributes ret = null;
        for (int i = 0; i < attrIds.length; ++i) {
            Attribute attr = attrs.get(attrIds[i]);
            if (attr == null) continue;
            if (ret == null) {
                ret = new BasicAttributes();
            }
            ret.put(attr);
        }
        return ret;
    }

    public Node modifyAttributes(String name, ModificationItem[] mods) throws Exception {
        Node target;
        if (logger.isLoggable(JeusMessage_JNSServer._221_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._221_LEVEL, "DirService", "modifyAttributes", JeusMessage_JNSServer._221, (Object)name);
        }
        if ((target = this.root.find(name)) == null) {
            throw new NameNotFoundException("[" + name + "] " + "Name not found.");
        }
        Attributes current = target.acquireAttrs();
        block5: for (int i = 0; i < mods.length; ++i) {
            ModificationItem mod = mods[i];
            Attribute attr = mod.getAttribute();
            switch (mod.getModificationOp()) {
                case 1: {
                    if (target.getValue() instanceof UpdatableReference) {
                        UpdatableReference ref = (UpdatableReference)target.getValue();
                        ref.addAttribute(attr);
                        continue block5;
                    }
                    Attribute old = current.get(attr.getID());
                    if (old == null) {
                        current.put(attr);
                        continue block5;
                    }
                    NamingEnumeration<?> enum1 = attr.getAll();
                    while (enum1.hasMore()) {
                        Object value = enum1.next();
                        old.add(value);
                    }
                    continue block5;
                }
                case 2: {
                    UpdatableReference ref;
                    if (target.getValue() instanceof UpdatableReference) {
                        ref = (UpdatableReference)target.getValue();
                        ref.replaceAttribute(attr);
                        continue block5;
                    }
                    current.put(attr);
                    continue block5;
                }
                case 3: {
                    UpdatableReference ref;
                    if (target.getValue() instanceof UpdatableReference) {
                        ref = (UpdatableReference)target.getValue();
                        ref.removeAttribute(attr);
                        continue block5;
                    }
                    current.remove(attr.getID());
                    continue block5;
                }
            }
        }
        return target;
    }

    public List search(String name, Attributes attrs, String[] attrIds) throws Exception {
        Node target;
        if (logger.isLoggable(JeusMessage_JNSServer._222_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._222_LEVEL, "DirService", "search", JeusMessage_JNSServer._222, (Object)name);
        }
        if ((target = this.root.find(name)) == null) {
            throw new NameNotFoundException("[" + name + "] " + "Name not found.");
        }
        return target.search(new ArrayList(), attrs, attrIds, 1);
    }

    public List search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws Exception {
        Node target;
        if (logger.isLoggable(JeusMessage_JNSServer._223_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._223_LEVEL, "DirService", "search", JeusMessage_JNSServer._223, new Object[]{name, filterExpr, cons});
        }
        if ((target = this.root.find(name)) == null) {
            throw new NameNotFoundException("[" + name + "] " + "Name not found.");
        }
        if (cons == null) {
            cons = new SearchControls();
        }
        SearchFilter filter = filterArgs == null ? new SearchFilter(filterExpr) : new SearchFilter(SearchFilter.format(filterExpr, filterArgs));
        return target.search(new ArrayList(), filter, cons);
    }

    public void addNamingListener(SocketStream sockStream, String name, Integer listenerID, Integer scope, int type) throws Exception {
        Node target;
        if (logger.isLoggable(JeusMessage_JNSServer._224_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._224_LEVEL, "DirService", "addNamingListener", JeusMessage_JNSServer._224, new Object[]{listenerID, name, scope});
        }
        if ((target = this.root.find(name)) == null) {
            throw new NameNotFoundException("[" + name + "] " + "Name not found.");
        }
        ListenerProxy listener = new ListenerProxy(target, sockStream, listenerID, scope);
        target.addListener(listener);
        JNSServer.addListener(listener);
        this.root.setExistListener(true);
    }

    public void addNamingListener(SocketStream sockStream, String name, Integer listenerID, SearchFilter filter, SearchControls cons, int type) throws Exception {
        Node target;
        if (logger.isLoggable(JeusMessage_JNSServer._225_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._225_LEVEL, "DirService", "addNamingListener", JeusMessage_JNSServer._225, new Object[]{listenerID, name, cons});
        }
        if ((target = this.root.find(name)) == null) {
            throw new NameNotFoundException("[" + name + "] " + "Name not found.");
        }
        if (cons == null) {
            cons = new SearchControls();
        }
        ListenerProxy listener = new ListenerProxy(target, sockStream, listenerID, filter, cons);
        target.addListener(listener);
        JNSServer.addListener(listener);
        this.root.setExistListener(true);
    }

    public void removeNamingListener(SocketID socketID, Integer listenerID) throws Exception {
        if (logger.isLoggable(JeusMessage_JNSServer._226_LEVEL)) {
            logger.logp(JeusMessage_JNSServer._226_LEVEL, "DirService", "removeNamingListener", JeusMessage_JNSServer._226, new Object[]{listenerID, socketID});
        }
        String ID = listenerID + "@" + socketID;
        JNSServer.removeListener(socketID, ID);
    }
}

