/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.server;

import java.io.IOException;
import java.security.Permission;
import java.util.List;
import javax.naming.LinkRef;
import javax.naming.NameNotFoundException;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import jeus.jndi.jns.common.DynamicLinkRef;
import jeus.jndi.jns.common.Environment;
import jeus.jndi.jns.common.JNS;
import jeus.jndi.jns.common.Message;
import jeus.jndi.jns.common.NameEnumerationImpl;
import jeus.jndi.jns.common.PropertyLinkRef;
import jeus.jndi.jns.common.PropertyReference;
import jeus.jndi.jns.server.DirService;
import jeus.jndi.jns.server.JNSServer;
import jeus.jndi.jns.server.repository.SearchFilter;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.security.base.Subject;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.LoginService;
import jeus.security.spi.SecurityRuntimeException;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JNSServer;

public class ServiceHandler {
    private static final DirService dirService = JNSServer.getDirService();
    private final SocketID socketID;
    private final Message reqMsg;
    private final Environment env;
    private final Object obj1;
    private final Object obj2;
    private SocketStream sockStream;
    protected static final JeusLogger logger = JNSServer.getLogger();
    private final int opcode;

    public ServiceHandler(SocketStream _sockStream, Message _msg) {
        this.sockStream = _sockStream;
        this.socketID = _sockStream.getSocketID();
        this.reqMsg = _msg;
        this.opcode = _msg.getCode();
        this.env = _msg.getEnvironment();
        this.obj1 = _msg.get(0);
        this.obj2 = _msg.get(1);
    }

    public void handle() throws Exception {
        switch (this.opcode) {
            case 201: {
                this.handleBind();
                break;
            }
            case 202: {
                this.handleRebind();
                break;
            }
            case 206: {
                this.handleRename();
                break;
            }
            case 203: {
                this.handleUnbind();
                break;
            }
            case 204: {
                this.handleLookup();
                break;
            }
            case 205: {
                this.handleList();
                break;
            }
            case 207: {
                this.handleAuthenticate();
                break;
            }
            case 208: {
                this.handleGetAttributes();
                break;
            }
            case 209: {
                this.handleModifyAttributes();
                break;
            }
            case 210: {
                this.handleSearch();
                break;
            }
            case 211: {
                this.handleGetSchema();
                break;
            }
            case 213: {
                this.handleAddNamingListener();
                break;
            }
            case 214: {
                this.handleRemoveNamingListener();
                break;
            }
            case 301: {
                this.handleReplicate();
                break;
            }
            case 302: {
                this.handleReplace();
                break;
            }
            case 303: {
                this.handleDrop();
                break;
            }
            case 105: 
            case 403: {
                break;
            }
            default: {
                this.handleDefault();
            }
        }
    }

    protected void handleBind() throws Exception {
        block7: {
            if (logger.isLoggable(JeusMessage_JNSServer._98_LEVEL)) {
                logger.log(JeusMessage_JNSServer._98_LEVEL, JeusMessage_JNSServer._98);
            }
            String obj1Name = (String)this.obj1;
            try {
                Attributes attrs = (Attributes)this.reqMsg.get(5);
                if (logger.isLoggable(JeusMessage_JNSServer._99_LEVEL)) {
                    logger.log(JeusMessage_JNSServer._99_LEVEL, JeusMessage_JNSServer._99, (Object)obj1Name);
                }
                this.env.setDirectBind(true);
                dirService.bind(obj1Name, this.obj2, this.env, attrs);
                Message resMsg = new Message(401, null);
                this.sockStream.writeReply((Object)resMsg);
                if (logger.isLoggable(JeusMessage_JNSServer._100_LEVEL)) {
                    logger.log(JeusMessage_JNSServer._100_LEVEL, JeusMessage_JNSServer._100, (Object)obj1Name);
                }
                if (ServiceHandler.isReplicateBinding(this.obj2, this.env)) {
                    this.replicateBinding(attrs);
                }
                if (this.env.getCache()) {
                    this.replicateBindingToLocalsExceptSource(attrs, null);
                }
            }
            catch (Exception e) {
                this.sendExceptionResponse(e);
                if (!logger.isLoggable(JeusMessage_JNSServer._101_LEVEL)) break block7;
                logger.log(JeusMessage_JNSServer._101_LEVEL, JeusMessage_JNSServer._101, (Object)obj1Name);
            }
        }
    }

    private void sendExceptionResponse(Exception e) throws IOException {
        Message resMsg = new Message(402, null, (Object)e, null);
        this.sockStream.writeReply((Object)resMsg);
    }

    private void replicateBinding(Attributes attrs) throws Exception {
        Environment newEnv = new Environment(this.env.toInt());
        newEnv.setDirectBind(false);
        Message manageRequest = new Message(301, newEnv, this.obj1, this.obj2);
        if (logger.isLoggable(JeusMessage_JNSServer._175_LEVEL)) {
            logger.log(JeusMessage_JNSServer._175_LEVEL, JeusMessage_JNSServer._175, this.obj1);
        }
        if (attrs != null) {
            manageRequest.put(5, attrs);
        }
        this.broadcastToServer(manageRequest);
    }

    protected void handleRebind() throws Exception {
        block8: {
            if (logger.isLoggable(JeusMessage_JNSServer._102_LEVEL)) {
                logger.log(JeusMessage_JNSServer._102_LEVEL, JeusMessage_JNSServer._102);
            }
            String obj1Name = (String)this.obj1;
            try {
                Attributes attrs = (Attributes)this.reqMsg.get(5);
                if (logger.isLoggable(JeusMessage_JNSServer._103_LEVEL)) {
                    logger.log(JeusMessage_JNSServer._103_LEVEL, JeusMessage_JNSServer._103, (Object)obj1Name);
                }
                this.env.setDirectBind(true);
                dirService.rebind(obj1Name, this.obj2, this.env, attrs);
                Message resMsg = new Message(401, null);
                if (this.obj2 instanceof DynamicLinkRef) {
                    Object obj = dirService.lookup(obj1Name);
                    resMsg.put(1, obj);
                }
                this.sockStream.writeReply((Object)resMsg);
                if (logger.isLoggable(JeusMessage_JNSServer._104_LEVEL)) {
                    logger.log(JeusMessage_JNSServer._104_LEVEL, JeusMessage_JNSServer._104, (Object)obj1Name);
                }
                if (ServiceHandler.isReplicateBinding(this.obj2, this.env)) {
                    this.replicateBinding(attrs);
                }
                if (this.env.getCache()) {
                    this.replicateBindingToLocalsExceptSource(attrs, null);
                }
            }
            catch (Exception e) {
                this.sendExceptionResponse(e);
                if (!logger.isLoggable(JeusMessage_JNSServer._105_LEVEL)) break block8;
                logger.log(JeusMessage_JNSServer._105_LEVEL, JeusMessage_JNSServer._105, (Object)obj1Name);
            }
        }
    }

    private void dropLocalBindingExceptSource() throws Exception {
        Message manageRequest = new Message(303, null, this.obj1, null);
        this.broadcastToLocal(manageRequest, this.sockStream);
    }

    protected void handleRename() throws Exception {
        block7: {
            if (logger.isLoggable(JeusMessage_JNSServer._106_LEVEL)) {
                logger.log(JeusMessage_JNSServer._106_LEVEL, JeusMessage_JNSServer._106);
            }
            String obj1Name = (String)this.obj1;
            try {
                if (logger.isLoggable(JeusMessage_JNSServer._107_LEVEL)) {
                    logger.log(JeusMessage_JNSServer._107_LEVEL, JeusMessage_JNSServer._107, (Object[])new String[]{obj1Name, (String)this.obj2});
                }
                dirService.rename(obj1Name, (String)this.obj2);
                Message resMsg = new Message(401, null);
                this.sockStream.writeReply((Object)resMsg);
                if (logger.isLoggable(JeusMessage_JNSServer._108_LEVEL)) {
                    logger.log(JeusMessage_JNSServer._108_LEVEL, JeusMessage_JNSServer._108, (Object)obj1Name);
                }
                if (this.env.getReplicate()) {
                    this.replaceBindingToServer();
                }
                if (this.env.getCache()) {
                    this.replicateBindingToLocalsExceptSource(null, null);
                }
            }
            catch (Exception e) {
                this.sendExceptionResponse(e);
                if (!logger.isLoggable(JeusMessage_JNSServer._109_LEVEL)) break block7;
                logger.log(JeusMessage_JNSServer._109_LEVEL, JeusMessage_JNSServer._109, (Object)obj1Name);
            }
        }
    }

    private void replaceBindingToServer() throws Exception {
        Environment newEnv = new Environment(this.env.toInt());
        newEnv.setDirectBind(false);
        Message manageRequest = new Message(302, newEnv, this.obj1, this.obj2);
        if (logger.isLoggable(JeusMessage_JNSServer._175_LEVEL)) {
            logger.log(JeusMessage_JNSServer._175_LEVEL, JeusMessage_JNSServer._175, this.obj1);
        }
        this.broadcastToServer(manageRequest);
    }

    private void dropLocalBinding() throws Exception {
        Message manageRequest = new Message(303, null, this.obj1, null);
        this.broadcastToLocal(manageRequest);
    }

    protected void handleUnbind() throws Exception {
        if (logger.isLoggable(JeusMessage_JNSServer._110_LEVEL)) {
            logger.log(JeusMessage_JNSServer._110_LEVEL, JeusMessage_JNSServer._110);
        }
        String obj1Name = (String)this.obj1;
        try {
            if (logger.isLoggable(JeusMessage_JNSServer._111_LEVEL)) {
                logger.log(JeusMessage_JNSServer._111_LEVEL, JeusMessage_JNSServer._111);
            }
            Object bindedObject = dirService.unbind(obj1Name);
            Message resMsg = new Message(401, null);
            this.sockStream.writeReply((Object)resMsg);
            if (logger.isLoggable(JeusMessage_JNSServer._112_LEVEL)) {
                logger.log(JeusMessage_JNSServer._112_LEVEL, JeusMessage_JNSServer._112, (Object)obj1Name);
            }
            if (ServiceHandler.isReplicateBinding(bindedObject, this.env)) {
                this.dropServerBinding();
            }
            if (this.env.getCache()) {
                this.dropLocalBindingExceptSource();
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_JNSServer._113_LEVEL)) {
                logger.log(JeusMessage_JNSServer._113_LEVEL, JeusMessage_JNSServer._113, (Object)obj1Name, (Throwable)e);
            }
            this.sendExceptionResponse(e);
        }
    }

    private void dropServerBinding() throws Exception {
        Message manageRequest = new Message(303, null, this.obj1, null);
        this.broadcastToServer(manageRequest);
    }

    protected void handleLookup() throws Exception {
        block12: {
            if (logger.isLoggable(JeusMessage_JNSServer._114_LEVEL)) {
                logger.log(JeusMessage_JNSServer._114_LEVEL, JeusMessage_JNSServer._114);
            }
            String name = (String)this.obj1;
            if (logger.isLoggable(JeusMessage_JNSServer._115_LEVEL)) {
                logger.log(JeusMessage_JNSServer._115_LEVEL, JeusMessage_JNSServer._115, (Object)name);
            }
            String derefName = "";
            boolean flag = true;
            try {
                Object[] array;
                Environment objEnv;
                Object obj;
                try {
                    Object[] array2 = dirService.lookupAndEnv(name);
                    obj = array2[0];
                    objEnv = (Environment)array2[1];
                }
                catch (NameNotFoundException e) {
                    derefName = dirService.dereference(name);
                    if (derefName.startsWith("corbaname:") || derefName.startsWith("corbaloc:")) {
                        obj = new LinkRef(derefName);
                        objEnv = Environment.defaultEnv;
                        flag = false;
                    }
                    array = dirService.lookupAndEnv(derefName);
                    obj = array[0];
                    objEnv = (Environment)array[1];
                }
                Object derefObj = null;
                if (obj instanceof LinkRef && flag) {
                    if (derefName.startsWith("corbaname:") || derefName.startsWith("corbaloc:")) {
                        objEnv = Environment.defaultEnv;
                    } else {
                        derefName = dirService.dereference(name);
                        array = dirService.lookupAndEnv(derefName);
                        derefObj = array[0];
                        objEnv = (Environment)array[1];
                        if (obj instanceof PropertyLinkRef && derefObj instanceof PropertyReference) {
                            ((PropertyReference)derefObj).setProperties(((PropertyLinkRef)obj).getProperties());
                        }
                    }
                }
                this.sockStream.writeReply((Object)new Message(401, objEnv, obj, derefObj));
                if (logger.isLoggable(JeusMessage_JNSServer._116_LEVEL)) {
                    logger.log(JeusMessage_JNSServer._116_LEVEL, JeusMessage_JNSServer._116, (Object)name);
                }
            }
            catch (Exception e) {
                this.sendExceptionResponse(e);
                if (!logger.isLoggable(JeusMessage_JNSServer._117_LEVEL)) break block12;
                logger.log(JeusMessage_JNSServer._117_LEVEL, JeusMessage_JNSServer._117, (Object)name);
            }
        }
    }

    protected void handleList() throws Exception {
        block5: {
            if (logger.isLoggable(JeusMessage_JNSServer._118_LEVEL)) {
                logger.log(JeusMessage_JNSServer._118_LEVEL, JeusMessage_JNSServer._118);
            }
            String obj1Name = (String)this.obj1;
            try {
                if (logger.isLoggable(JeusMessage_JNSServer._119_LEVEL)) {
                    logger.log(JeusMessage_JNSServer._119_LEVEL, JeusMessage_JNSServer._119, (Object)obj1Name);
                }
                NameEnumerationImpl obj = dirService.list(obj1Name);
                Message resMsg = new Message(401, null, (Object)obj, null);
                this.sockStream.writeReply((Object)resMsg);
                if (logger.isLoggable(JeusMessage_JNSServer._120_LEVEL)) {
                    logger.log(JeusMessage_JNSServer._120_LEVEL, JeusMessage_JNSServer._120, (Object)obj1Name);
                }
            }
            catch (Exception e) {
                this.sendExceptionResponse(e);
                if (!logger.isLoggable(JeusMessage_JNSServer._121_LEVEL)) break block5;
                logger.log(JeusMessage_JNSServer._121_LEVEL, JeusMessage_JNSServer._121, (Object)obj1Name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAuthenticate() throws Exception {
        if (logger.isLoggable(JeusMessage_JNSServer._122_LEVEL)) {
            logger.log(JeusMessage_JNSServer._122_LEVEL, JeusMessage_JNSServer._122);
        }
        byte[] serializedSubject = (byte[])this.obj1;
        Subject propagatedSubject = Subject.deserialize(serializedSubject);
        try {
            LoginService.login(propagatedSubject);
        }
        catch (Exception e) {
            this.sendExceptionResponse(e);
            if (logger.isLoggable(JeusMessage_JNSServer._125_LEVEL)) {
                logger.log(JeusMessage_JNSServer._125_LEVEL, JeusMessage_JNSServer._125, (Object)propagatedSubject);
            }
            return;
        }
        try {
            boolean resMsgult = true;
            try {
                String[] permissionSpec = (String[])this.obj2;
                ResourcePermission permission = PermissionMaker.makeResourcePermission((String)permissionSpec[0], (String)permissionSpec[1]);
                LoginUtil.checkPermissionWithRuntimeException((Permission)permission);
                Message resMsg = new Message(401, null);
                this.sockStream.writeReply((Object)resMsg);
                if (logger.isLoggable(JeusMessage_JNSServer._124_LEVEL)) {
                    logger.log(JeusMessage_JNSServer._124_LEVEL, JeusMessage_JNSServer._124, (Object[])new String[]{propagatedSubject.toString(), String.valueOf(resMsgult)});
                }
            }
            catch (SecurityRuntimeException ex) {
                this.sendExceptionResponse((Exception)((Object)ex));
            }
        }
        finally {
            LoginService.logout();
        }
    }

    protected void handleGetAttributes() throws Exception {
        block4: {
            if (logger.isLoggable(JeusMessage_JNSServer._126_LEVEL)) {
                logger.log(JeusMessage_JNSServer._126_LEVEL, JeusMessage_JNSServer._126);
            }
            String name = (String)this.reqMsg.get(0);
            String[] attrIds = (String[])this.reqMsg.get(6);
            try {
                Attributes attrs = dirService.getAttributes(name, attrIds);
                Message resMsg = new Message(401, null, (Object)attrs, null);
                this.sockStream.writeReply((Object)resMsg);
                if (logger.isLoggable(JeusMessage_JNSServer._128_LEVEL)) {
                    logger.log(JeusMessage_JNSServer._128_LEVEL, JeusMessage_JNSServer._128, (Object)name);
                }
            }
            catch (Exception e) {
                this.sendExceptionResponse(e);
                if (!logger.isLoggable(JeusMessage_JNSServer._129_LEVEL)) break block4;
                logger.log(JeusMessage_JNSServer._129_LEVEL, JeusMessage_JNSServer._129, (Object)name);
            }
        }
    }

    protected void handleModifyAttributes() throws Exception {
        block6: {
            if (logger.isLoggable(JeusMessage_JNSServer._130_LEVEL)) {
                logger.log(JeusMessage_JNSServer._130_LEVEL, JeusMessage_JNSServer._130);
            }
            String name = (String)this.obj1;
            ModificationItem[] mods = (ModificationItem[])this.reqMsg.get(7);
            Environment objEnv = null;
            try {
                dirService.modifyAttributes(name, mods);
                Message res = new Message(401, objEnv);
                if (logger.isLoggable(JeusMessage_JNSServer._132_LEVEL)) {
                    logger.log(JeusMessage_JNSServer._132_LEVEL, JeusMessage_JNSServer._132, (Object)name);
                }
                if (this.env.getReplicate()) {
                    Environment newEnv = new Environment(this.env.toInt());
                    newEnv.setDirectBind(false);
                    newEnv.setReplicate(false);
                    Message manageRequest = new Message(209, newEnv);
                    manageRequest.put(0, name);
                    manageRequest.put(7, mods);
                    this.broadcastToServer(manageRequest);
                    this.sockStream.writeReply((Object)res);
                }
                if (this.env.getCache()) {
                    this.replicateBindingToLocalsExceptSource(null, mods);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.sendExceptionResponse(e);
                if (!logger.isLoggable(JeusMessage_JNSServer._133_LEVEL)) break block6;
                logger.log(JeusMessage_JNSServer._133_LEVEL, JeusMessage_JNSServer._133, (Object)name);
            }
        }
    }

    protected void handleSearch() throws Exception {
        String name = (String)this.reqMsg.get(11);
        if (name == null) {
            this.handleSearchAttrs();
        } else {
            this.handleSearchFilter();
        }
    }

    protected void handleSearchAttrs() throws Exception {
        block4: {
            if (logger.isLoggable(JeusMessage_JNSServer._134_LEVEL)) {
                logger.log(JeusMessage_JNSServer._134_LEVEL, JeusMessage_JNSServer._134);
            }
            String name = (String)this.reqMsg.get(0);
            Attributes attrs = (Attributes)this.reqMsg.get(5);
            String[] attrIds = (String[])this.reqMsg.get(6);
            Environment objEnv = null;
            try {
                List v = dirService.search(name, attrs, attrIds);
                Message res = new Message(401, objEnv);
                res.put(0, v);
                this.sockStream.writeReply((Object)res);
                if (logger.isLoggable(JeusMessage_JNSServer._136_LEVEL)) {
                    logger.log(JeusMessage_JNSServer._136_LEVEL, JeusMessage_JNSServer._136, (Object)name);
                }
            }
            catch (Exception e) {
                this.sendExceptionResponse(e);
                if (!logger.isLoggable(JeusMessage_JNSServer._137_LEVEL)) break block4;
                logger.log(JeusMessage_JNSServer._137_LEVEL, JeusMessage_JNSServer._137, (Object)name);
            }
        }
    }

    protected void handleSearchFilter() throws Exception {
        block4: {
            if (logger.isLoggable(JeusMessage_JNSServer._134_LEVEL)) {
                logger.log(JeusMessage_JNSServer._134_LEVEL, JeusMessage_JNSServer._134);
            }
            String name = (String)this.reqMsg.get(0);
            String filterExpr = (String)this.reqMsg.get(11);
            Object[] filterArgs = (Object[])this.reqMsg.get(12);
            SearchControls cons = (SearchControls)this.reqMsg.get(8);
            Environment objEnv = null;
            try {
                List v = dirService.search(name, filterExpr, filterArgs, cons);
                Message res = new Message(401, objEnv);
                res.put(0, v);
                this.sockStream.writeReply((Object)res);
                if (logger.isLoggable(JeusMessage_JNSServer._136_LEVEL)) {
                    logger.log(JeusMessage_JNSServer._136_LEVEL, JeusMessage_JNSServer._136, (Object)name);
                }
            }
            catch (Exception e) {
                this.sendExceptionResponse(e);
                if (!logger.isLoggable(JeusMessage_JNSServer._137_LEVEL)) break block4;
                logger.log(JeusMessage_JNSServer._137_LEVEL, JeusMessage_JNSServer._137, (Object)name);
            }
        }
    }

    protected void handleGetSchema() throws Exception {
        if (logger.isLoggable(JeusMessage_JNSServer._138_LEVEL)) {
            logger.log(JeusMessage_JNSServer._138_LEVEL, JeusMessage_JNSServer._138);
        }
    }

    public void handleAddNamingListener() throws Exception {
        block6: {
            if (logger.isLoggable(JeusMessage_JNSServer._142_LEVEL)) {
                logger.log(JeusMessage_JNSServer._142_LEVEL, JeusMessage_JNSServer._142);
            }
            Integer listenerID = (Integer)this.reqMsg.get(9);
            String name = (String)this.reqMsg.get(0);
            Integer type = (Integer)this.reqMsg.get(10);
            Integer scope = (Integer)this.reqMsg.get(13);
            String filterExpr = (String)this.reqMsg.get(11);
            Object[] filterArgs = (Object[])this.reqMsg.get(12);
            SearchControls cons = (SearchControls)this.reqMsg.get(8);
            Environment objEnv = null;
            try {
                if (scope != null) {
                    dirService.addNamingListener(this.sockStream, name, listenerID, scope, type);
                } else {
                    SearchFilter filter = filterArgs == null ? new SearchFilter(SearchFilter.format(filterExpr, filterArgs)) : new SearchFilter(filterExpr);
                    dirService.addNamingListener(this.sockStream, name, listenerID, filter, cons, type);
                }
                Message res = new Message(401, objEnv);
                this.sockStream.writeReply((Object)res);
                if (logger.isLoggable(JeusMessage_JNSServer._144_LEVEL)) {
                    logger.log(JeusMessage_JNSServer._144_LEVEL, JeusMessage_JNSServer._144, (Object)listenerID);
                }
            }
            catch (Exception e) {
                this.sendExceptionResponse(e);
                if (!logger.isLoggable(JeusMessage_JNSServer._145_LEVEL)) break block6;
                logger.log(JeusMessage_JNSServer._145_LEVEL, JeusMessage_JNSServer._145, (Object)listenerID);
            }
        }
    }

    public void handleRemoveNamingListener() throws Exception {
        block4: {
            if (logger.isLoggable(JeusMessage_JNSServer._146_LEVEL)) {
                logger.log(JeusMessage_JNSServer._146_LEVEL, JeusMessage_JNSServer._146);
            }
            Integer listenerID = (Integer)this.reqMsg.get(9);
            try {
                dirService.removeNamingListener(this.socketID, listenerID);
                Message res = new Message(401, null);
                this.sockStream.writeReply((Object)res);
                if (logger.isLoggable(JeusMessage_JNSServer._148_LEVEL)) {
                    logger.log(JeusMessage_JNSServer._148_LEVEL, JeusMessage_JNSServer._148, (Object)listenerID);
                }
            }
            catch (Exception e) {
                this.sendExceptionResponse(e);
                if (!logger.isLoggable(JeusMessage_JNSServer._149_LEVEL)) break block4;
                logger.log(JeusMessage_JNSServer._149_LEVEL, JeusMessage_JNSServer._149);
            }
        }
    }

    protected void handleReplicate() throws Exception {
        if (logger.isLoggable(JeusMessage_JNSServer._150_LEVEL)) {
            logger.log(JeusMessage_JNSServer._150_LEVEL, JeusMessage_JNSServer._150);
        }
        try {
            Attributes attrs = (Attributes)this.reqMsg.get(5);
            dirService.replicate((String)this.obj1, this.obj2, this.env, attrs);
            if (this.env.getCache()) {
                this.replicateBindingToLocalsExceptSource(attrs, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void replicateBindingToLocalsExceptSource(Attributes attrs, ModificationItem[] mods) throws Exception {
        Message manageRequest = new Message(301, null, this.obj1, this.obj2);
        if (attrs != null) {
            manageRequest.put(5, attrs);
        }
        if (mods != null) {
            manageRequest.put(7, mods);
        }
        if (logger.isLoggable(JeusMessage_JNSServer._175_LEVEL)) {
            logger.log(JeusMessage_JNSServer._175_LEVEL, JeusMessage_JNSServer._175, this.obj1);
        }
        this.broadcastToLocal(manageRequest, this.sockStream);
    }

    protected void handleReplace() throws Exception {
        if (logger.isLoggable(JeusMessage_JNSServer._154_LEVEL)) {
            logger.log(JeusMessage_JNSServer._154_LEVEL, JeusMessage_JNSServer._154);
        }
        try {
            dirService.rename((String)this.obj1, (String)this.obj2);
            this.dropLocalBinding();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void handleDrop() throws Exception {
        if (logger.isLoggable(JeusMessage_JNSServer._158_LEVEL)) {
            logger.log(JeusMessage_JNSServer._158_LEVEL, JeusMessage_JNSServer._158);
        }
        try {
            dirService.unbind((String)this.obj1);
            if (this.env.getCache()) {
                this.dropLocalBinding();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void handleDefault() throws Exception {
        logger.log(JeusMessage_JNSServer._243_LEVEL, JeusMessage_JNSServer._243, (Object)"[JNSServer]");
    }

    protected void broadcastToServer(Message _request) {
        if (JNSServer.broadcastToServers(_request) && logger.isLoggable(JeusMessage_JNSServer._95_LEVEL)) {
            logger.log(JeusMessage_JNSServer._95_LEVEL, JeusMessage_JNSServer._95);
        }
    }

    protected void broadcastToLocal(Message _request) {
        boolean flag = JNSServer.broadcastToLocals(null, _request);
        if (flag && logger.isLoggable(JeusMessage_JNSServer._96_LEVEL)) {
            logger.log(JeusMessage_JNSServer._96_LEVEL, JeusMessage_JNSServer._96);
        }
    }

    protected void broadcastToLocal(Message _request, SocketStream _excludingSockStream) {
        boolean flag = JNSServer.broadcastToLocals(_excludingSockStream, _request);
        if (flag && logger.isLoggable(JeusMessage_JNSServer._96_LEVEL)) {
            logger.log(JeusMessage_JNSServer._96_LEVEL, JeusMessage_JNSServer._96);
        }
    }

    public static boolean isReplicateBinding(Object obj, Environment bindEnv) {
        if (JNS.isJNSContext(obj)) {
            return bindEnv.getReplicateContext();
        }
        return bindEnv.getReplicate();
    }
}

