/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.server.repository;

import java.util.List;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import jeus.jndi.jns.common.Environment;
import jeus.jndi.jns.server.repository.AttrFilter;
import jeus.jndi.jns.server.repository.Composite;
import jeus.jndi.jns.server.repository.Node;
import jeus.jndi.jns.server.repository.SearchFilter;

public class Leaf
extends Node {
    public Leaf(Composite _parent, String _name, Object _value, Environment _env, Attributes _attrs) {
        super(_parent, _name, _value, _env, _attrs);
    }

    public boolean isComposite() {
        return false;
    }

    public Node find(String _target) {
        if (_target.equals("")) {
            return this;
        }
        return null;
    }

    public List search(List v, Attributes matchings, String[] attrIds, int level) throws Exception {
        boolean flag = AttrFilter.check(this.attrs, matchings);
        if (!flag) {
            return v;
        }
        if (attrIds == null) {
            v.add(new SearchResult(this.name, this.value.getClass().getName(), this.value, this.attrs));
            return v;
        }
        BasicAttributes returnAttrs = new BasicAttributes();
        for (int i = 0; i < attrIds.length; ++i) {
            returnAttrs.put(this.attrs.get(attrIds[i]));
        }
        v.add(new SearchResult(this.name, this.value.getClass().getName(), this.value, returnAttrs));
        return v;
    }

    public List search(List v, SearchFilter filter, SearchControls cons) throws Exception {
        if (cons.getCountLimit() != 0L && cons.getCountLimit() <= (long)v.size()) {
            return v;
        }
        boolean flag = filter.check(this.attrs);
        if (!flag) {
            return v;
        }
        String[] attrIds = cons.getReturningAttributes();
        if (attrIds == null) {
            if (this.value != null) {
                v.add(new SearchResult(this.name, this.value.getClass().getName(), this.value, this.attrs));
            } else {
                v.add(new SearchResult(this.name, "javax.naming.directory.DirContext", this.value, this.attrs));
            }
            return v;
        }
        BasicAttributes returnAttrs = new BasicAttributes();
        for (int i = 0; i < attrIds.length; ++i) {
            returnAttrs.put(this.attrs.get(attrIds[i]));
        }
        flag = cons.getReturningObjFlag();
        if (flag) {
            v.add(new SearchResult(this.name, this.value.getClass().getName(), this.value, returnAttrs));
        } else {
            v.add(new SearchResult(this.name, this.value.getClass().getName(), null, returnAttrs));
        }
        return v;
    }

    public void print(String tab) {
        System.out.print(tab + "<" + this.name + ">\n");
        super.print(tab);
    }
}

