/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.server.repository;

import javax.naming.Binding;
import javax.naming.directory.SearchControls;
import jeus.jndi.jns.common.Message;
import jeus.jndi.jns.server.repository.Node;
import jeus.jndi.jns.server.repository.SearchFilter;
import jeus.net.SocketID;
import jeus.net.SocketStream;

public class ListenerProxy {
    Node node;
    Integer listenerID;
    SocketStream sockStream;
    Integer level;
    SearchFilter filter;
    SearchControls cons;

    public ListenerProxy(Node _node, SocketStream _sockStream, Integer _listenerID, Integer _level) {
        this.node = _node;
        this.sockStream = _sockStream;
        this.listenerID = _listenerID;
        this.level = _level;
        this.node.addListener(this);
    }

    public ListenerProxy(Node _node, SocketStream _sockStream, Integer _listenerID, SearchFilter _filter, SearchControls _cons) {
        this.node = _node;
        this.sockStream = _sockStream;
        this.listenerID = _listenerID;
        this.filter = _filter;
        this.cons = _cons;
        this.node.addListener(this);
    }

    public String getID() {
        return this.listenerID + "@" + this.sockStream.getSocketID();
    }

    public SocketID getSocketID() {
        return this.sockStream.getSocketID();
    }

    public Integer getListenerID() {
        return this.listenerID;
    }

    public void remove() {
        if (this.node != null) {
            this.node.removeListener(this);
        }
    }

    public void notify(int type, Binding newBd, Binding oldBd, Node source) throws Exception {
        int distance = this.node.distance(source);
        if (this.level != null) {
            int iLevel = this.level;
            switch (iLevel) {
                case 0: {
                    if (distance != 0) break;
                    this.sendNamingEvent(this.node.getValue(), new Integer(type), newBd, oldBd);
                    break;
                }
                case 1: {
                    if (distance > 1) break;
                    this.sendNamingEvent(this.node.getValue(), new Integer(type), newBd, oldBd);
                    break;
                }
                case 2: {
                    this.sendNamingEvent(this.node.getValue(), new Integer(type), newBd, oldBd);
                    break;
                }
            }
        } else {
            int iLevel = this.cons.getSearchScope();
            switch (iLevel) {
                case 0: {
                    if (distance != 0) break;
                    this.sendNamingEvent(this.node.getValue(), new Integer(type), newBd, oldBd);
                    break;
                }
                case 1: {
                    if (distance > 1) break;
                    this.sendNamingEvent(this.node.getValue(), new Integer(type), newBd, oldBd);
                    break;
                }
                case 2: {
                    this.sendNamingEvent(this.node.getValue(), new Integer(type), newBd, oldBd);
                    break;
                }
            }
        }
    }

    protected void sendNamingEvent(Object eventSource, Integer type, Binding newBd, Binding oldBd) {
        try {
            Message event = new Message(405, null);
            event.put(2, eventSource);
            event.put(10, type);
            event.put(3, newBd);
            event.put(4, oldBd);
            event.put(9, this.listenerID);
            this.sockStream.write((Object)event);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sockStream.destroy();
        }
    }
}

