/*
 * Decompiled with CFR 0.152.
 */
package jeus.loganalyzer;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import jeus.loganalyzer.StackTraceResult;
import jeus.util.logging.FileHandler;

public class StackTraceService {
    public synchronized StackTraceResult stackTrace(String pattern, String fileName, long startPos) throws IOException {
        if (pattern == null) {
            return null;
        }
        File file = null;
        if (fileName == null) {
            file = new FileHandler().getPatternedTime(pattern, Calendar.getInstance());
            startPos = -1L;
        } else {
            file = new File(fileName);
        }
        StackTraceResult result = new StackTraceResult();
        result.setPattern(pattern);
        StringBuffer trace = new StringBuffer();
        if (file.exists()) {
            startPos = this.readTrace(file, startPos, trace);
            result.setFileName(file.getPath());
            result.setStartPos(startPos);
        } else {
            startPos = 0L;
        }
        File nextFile = new FileHandler().getPatternedTime(pattern, Calendar.getInstance());
        if (!file.getPath().equals(nextFile.getPath()) && nextFile.exists()) {
            trace.append("\n");
            trace.append("File changed : " + nextFile.getPath());
            trace.append("\n");
            startPos = this.readTrace(nextFile, 0L, trace);
            result.setFileName(nextFile.getPath());
            result.setStartPos(startPos);
        }
        result.setTrace(trace.toString());
        return result;
    }

    private long readTrace(File file, long startPos, StringBuffer trace) throws IOException {
        RandomAccessFile fin = new RandomAccessFile(file, "r");
        if (startPos == -1L) {
            fin.seek(fin.length());
        } else {
            fin.seek(startPos);
        }
        byte[] buf = new byte[1024];
        int size = 0;
        while ((size = fin.read(buf)) != -1) {
            trace.append(new String(buf, 0, size));
        }
        startPos = fin.getFilePointer();
        fin.close();
        return startPos;
    }

    public static void main(String[] args) throws Exception {
    }
}

