/*
 * Decompiled with CFR 0.152.
 */
package jeus.loganalyzer.analysis;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import jeus.loganalyzer.analysis.LogParser;
import jeus.loganalyzer.analysis.TaskStatus;
import jeus.loganalyzer.common.AccessLogData;
import jeus.loganalyzer.common.CheckFieldMethod;
import jeus.loganalyzer.common.FileStorage;
import jeus.loganalyzer.common.LogAnalyzerProperty;
import jeus.loganalyzer.common.PatternInfo;
import jeus.loganalyzer.common.ResultTableModel;
import jeus.loganalyzer.common.RuleInfo;
import jeus.loganalyzer.common.chain.DayChain;
import jeus.loganalyzer.common.chain.MonthChain;
import jeus.loganalyzer.common.chain.TimeChain;
import jeus.loganalyzer.common.chain.WeekChain;
import jeus.loganalyzer.common.chain.YearChain;
import jeus.loganalyzer.pattern.PatternStorage;
import jeus.loganalyzer.pattern.ProcessingTime;
import jeus.loganalyzer.util.LogConstants;
import jeus.loganalyzer.util.LogFileEmptyException;
import jeus.loganalyzer.util.MethodUtil;
import jeus.tool.util.FileUtil;
import jeus.util.logging.AccessFormatter;

public class AccessLogParser
extends LogParser {
    private FileStorage ipStorage = null;
    private FileStorage uriStorage = null;
    private LogAnalyzerProperty props;
    private Vector srcFileTable = new Vector();
    private Vector headerVector;
    private Vector cookieVector;
    private Vector requestVector;
    private Vector sessionVector;
    private String fdbPath = null;
    private HashMap resultTable;
    private int totalRows = 0;
    private TimeChain timeChain;
    private SimpleDateFormat fileformat = LogConstants.yyyyMMddHHmmss;

    public AccessLogParser(RuleInfo ruleInfo) throws Exception {
        super(ruleInfo);
        this.resultTable = new HashMap();
        try {
            this.props = LogAnalyzerProperty.getInstance();
            this.init();
        }
        catch (Exception e) {
            this.task.setStatus(TaskStatus.FAILED);
            this.saveStatus();
            throw e;
        }
    }

    public void close() throws Exception {
        super.close();
        if (this.resultTable != null) {
            this.resultTable.clear();
        }
        if (this.ipStorage != null) {
            this.ipStorage.clear();
        }
        if (this.uriStorage != null) {
            this.uriStorage.clear();
        }
        LogAnalyzerProperty.getInstance().clear();
    }

    public void execute(String threadID) throws Exception {
        try {
            this.task.setThreadID(threadID);
            this.selectLogFile();
            this.analyze();
            this.writePatternObject();
            this.task.setStatus(TaskStatus.COMPLETED);
            this.saveStatus();
        }
        catch (LogFileEmptyException empty) {
            this.task.setStatus(TaskStatus.FAILED);
            this.saveStatus();
        }
        catch (Exception e) {
            this.task.setStatus(TaskStatus.FAILED);
            this.saveStatus();
            throw e;
        }
        finally {
            this.close();
        }
    }

    public void init() throws Exception {
        super.init();
        this.fdbPath = this.workspaceDir + this.fs + "fdb";
        File fdb = new File(this.fdbPath);
        if (!fdb.isDirectory()) {
            fdb.mkdirs();
        }
        Iterator iterator = this.moduleList.iterator();
        String key = null;
        String instanceName = null;
        while (iterator.hasNext()) {
            PatternInfo obj = (PatternInfo)iterator.next();
            key = obj.getField();
            if (key.equals("headerValues")) {
                this.headerVector = new Vector();
                this.redefinedPattern(this.headerVector, obj);
                continue;
            }
            if (key.equals("cookieValues")) {
                this.cookieVector = new Vector();
                this.redefinedPattern(this.cookieVector, obj);
                continue;
            }
            if (key.equals("requestAttributes")) {
                this.requestVector = new Vector();
                this.redefinedPattern(this.requestVector, obj);
                continue;
            }
            if (key.equals("sessionAttributes")) {
                this.sessionVector = new Vector();
                this.redefinedPattern(this.sessionVector, obj);
                continue;
            }
            instanceName = this.props.getProperty(key);
            this.loadProperty(key, instanceName);
        }
    }

    private void redefinedPattern(Vector patternList, PatternInfo obj) throws Exception {
        String value = null;
        String instanceNames = null;
        String instanceName = null;
        value = obj.getExpression();
        instanceNames = obj.getPatternObjectName();
        StringTokenizer params = new StringTokenizer(value, ",");
        StringTokenizer instances = new StringTokenizer(instanceNames, ",");
        if (params.countTokens() == instances.countTokens()) {
            while (params.hasMoreTokens()) {
                String token = params.nextToken();
                int offset = token.indexOf("=");
                String keyToken = token.substring(0, offset);
                String valueToken = token.substring(offset + 1);
                instanceName = instances.nextToken();
                patternList.add(new PatternInfo(keyToken, valueToken, instanceName));
                this.loadProperty(keyToken, instanceName);
            }
        }
    }

    private void loadProperty(String key, String instanceName) throws Exception {
        if (instanceName != null) {
            Class<?> c1 = Class.forName(instanceName);
            Class[] args = new Class[]{String.class, String.class};
            String taskName = key + "_" + this.fileformat.format(Calendar.getInstance().getTime());
            Object[] value = new Object[]{this.fdbPath, taskName};
            Constructor<?> constructor = c1.getConstructor(args);
            PatternStorage storage = (PatternStorage)constructor.newInstance(value);
            this.props.addPatternObject(key, storage);
            this.resultTable.put(key, storage);
        }
    }

    public FileStorage getIPFS() {
        return this.ipStorage;
    }

    public FileStorage getURIFS() {
        return this.uriStorage;
    }

    public PatternStorage getPatternObject(String key) {
        return this.props.getPatternObject(key);
    }

    public boolean isFileSave() {
        return this.isfdbSave;
    }

    private HashMap getResultTable() {
        return this.resultTable;
    }

    public FileStorage getFileStorage(String key) {
        return (FileStorage)this.resultTable.get(key);
    }

    private void selectLogFile() throws IOException {
        String srcFile = null;
        String destFile = null;
        String childDate = null;
        String fileName = null;
        this.startDate = this.ruleInfo.getStartDate();
        this.endDate = this.ruleInfo.getEndDate();
        int k = 0;
        int offset = 0;
        File node = new File(this.srcDir);
        long dateLong = 0L;
        File[] childs = node.listFiles();
        for (int i = 0; childs != null && i < childs.length; ++i) {
            if (!childs[i].isFile() || !(fileName = childs[i].getName()).endsWith(".log") || !fileName.startsWith(this.logFilePrefix)) continue;
            offset = this.logFilePattern.indexOf("%h") > 0 ? fileName.indexOf(".log") - 4 : fileName.indexOf(".log");
            if (this.logFilePattern.indexOf("%d") > 0) {
                childDate = fileName.substring(offset - 8, offset);
                try {
                    dateLong = Long.parseLong(childDate);
                    if (dateLong < this.startDate || dateLong > this.endDate) continue;
                    srcFile = this.srcDir + this.fs + fileName;
                    destFile = this.destDir + this.fs + fileName;
                    this.totalSize += new File(srcFile).length();
                    FileUtil.copy(srcFile, destFile);
                    this.fileList.add(k, destFile);
                    this.srcFileTable.add(k, srcFile);
                    ++k;
                    continue;
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (IOException io) {
                    throw io;
                }
            }
            srcFile = this.srcDir + this.fs + fileName;
            destFile = this.destDir + this.fs + fileName;
            this.totalSize += new File(srcFile).length();
            FileUtil.copy(srcFile, destFile);
            this.fileList.add(k, destFile);
            this.srcFileTable.add(k, srcFile);
            ++k;
        }
    }

    private void analyze() throws Exception {
        int lists = this.fileList.size();
        if (lists == 0) {
            MethodUtil.rmdir(this.resultDir);
            throw new LogFileEmptyException("not exist log file");
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.reportPath + this.fs + this.logFilePrefix + "_accesslog.txt", true), 1024);
        String taskName = null;
        YearChain yearChain = new YearChain(new FileStorage(this.fdbPath, "YEAR_STATISTICS_" + this.fileformat.format(Calendar.getInstance().getTime())));
        MonthChain monthChain = new MonthChain(yearChain, new FileStorage(this.fdbPath, "MONTH_STATISTICS_" + this.fileformat.format(Calendar.getInstance().getTime())));
        WeekChain weekChain = new WeekChain(monthChain, new FileStorage(this.fdbPath, "WEEK_STATISTICS_" + this.fileformat.format(Calendar.getInstance().getTime())));
        DayChain dayChain = new DayChain(weekChain, new FileStorage(this.fdbPath, "DAY_STATISTICS_" + this.fileformat.format(Calendar.getInstance().getTime())));
        this.timeChain = new TimeChain(dayChain, new FileStorage(this.fdbPath, "TIME_STATISTICS_" + this.fileformat.format(Calendar.getInstance().getTime())));
        if (!this.isfdbSave) {
            yearChain.setIsfdbSave(this.isfdbSave);
            monthChain.setIsfdbSave(this.isfdbSave);
            weekChain.setIsfdbSave(this.isfdbSave);
            dayChain.setIsfdbSave(this.isfdbSave);
            this.timeChain.setIsfdbSave(this.isfdbSave);
        }
        this.resultTable.put("YEAR_STATISTICS", yearChain.getStorage());
        this.resultTable.put("MONTH_STATISTICS", monthChain.getStorage());
        this.resultTable.put("WEEK_STATISTICS", weekChain.getStorage());
        this.resultTable.put("DAY_STATISTICS", dayChain.getStorage());
        this.resultTable.put("TIME_STATISTICS", this.timeChain.getStorage());
        taskName = "CLIENTIP_STATISTICS" + this.fileformat.format(Calendar.getInstance().getTime());
        this.ipStorage = new FileStorage(this.fdbPath, taskName);
        this.resultTable.put("CLIENTIP_STATISTICS", this.ipStorage);
        taskName = "REQUESTURI_STATISTICS_" + this.fileformat.format(Calendar.getInstance().getTime());
        this.uriStorage = new FileStorage(this.fdbPath, taskName);
        this.resultTable.put("REQUESTURI_STATISTICS", this.uriStorage);
        for (int i = 0; i < lists; ++i) {
            this.parsing(writer, i, (String)this.fileList.elementAt(i));
        }
        writer.flush();
        writer.close();
        FileUtil.rmdir(this.workspaceDir);
    }

    private void parsing(BufferedWriter writer, int i, String logFile) throws Exception {
        String line = null;
        HashMap jeusRecord = null;
        Vector attrVector = null;
        boolean flag = false;
        String key = null;
        String value = null;
        String recordValue = null;
        String dateKey = null;
        String ipKey = null;
        String uriKey = null;
        String tokenCode = null;
        long logTime = 0L;
        long processingTime = -1L;
        StringBuffer buf = new StringBuffer();
        boolean created = false;
        HashMap rowTable = this.readMetaInfo((String)this.srcFileTable.get(i));
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(new FileInputStream(logFile)));
        this.setFormatterProperty(rowTable, new Integer(0));
        while ((line = reader.readLine()) != null) {
            long currentTime;
            this.readDataLen(line);
            try {
                jeusRecord = (HashMap)this.formatter.getLogRecord(line);
            }
            catch (Exception e) {
                continue;
            }
            Integer lineKey = new Integer(reader.getLineNumber());
            if (created && rowTable.size() > 1 && rowTable.containsKey(lineKey)) {
                this.setFormatterProperty(rowTable, lineKey);
                created = false;
            }
            if (flag = CheckFieldMethod.checkTime(this.startDate, this.endDate, currentTime = LogConstants.getTimeScaleValue(logTime = ((Long)jeusRecord.get("millis")).longValue(), 3))) {
                dateKey = LogConstants.getTimeScaleKey(logTime, 3);
                if (jeusRecord.get("remoteIP") != null) {
                    ipKey = jeusRecord.get("remoteIP").toString();
                }
                if (jeusRecord.get("requestURL") != null) {
                    uriKey = jeusRecord.get("requestURL").toString();
                }
                if (jeusRecord.get("status") != null) {
                    tokenCode = jeusRecord.get("status").toString();
                }
                if (jeusRecord.get("processingTime") != null) {
                    processingTime = Long.parseLong(jeusRecord.get("processingTime").toString());
                }
                Enumeration e = this.moduleList.elements();
                block3: while (e.hasMoreElements()) {
                    PatternStorage patternStorage;
                    PatternInfo info = (PatternInfo)e.nextElement();
                    key = info.getField();
                    value = info.getExpression();
                    Object obj = jeusRecord.get(key);
                    if (obj == null) continue;
                    if (obj instanceof HashMap) {
                        if (key.equals("headerValues")) {
                            attrVector = this.headerVector;
                        } else if (key.equals("cookieValues")) {
                            attrVector = this.cookieVector;
                        } else if (key.equals("requestAttributes")) {
                            attrVector = this.requestVector;
                        } else if (key.equals("sessionAttributes")) {
                            attrVector = this.sessionVector;
                        }
                        Enumeration p = attrVector.elements();
                        while (p.hasMoreElements()) {
                            info = (PatternInfo)p.nextElement();
                            key = info.getField();
                            value = info.getExpression();
                            recordValue = (String)((HashMap)obj).get(key);
                            flag = recordValue == null ? false : CheckFieldMethod.checksourceModuleName(value, recordValue);
                            patternStorage = this.props.getPatternObject(key);
                            if (!flag || patternStorage == null) continue block3;
                            this.saveAttrPatternStorage(created, patternStorage, recordValue);
                        }
                        continue;
                    }
                    recordValue = obj.toString();
                    if (recordValue == null) continue;
                    flag = CheckFieldMethod.checksourceModuleName(value, recordValue);
                    patternStorage = this.props.getPatternObject(key);
                    if (!flag || patternStorage == null) break;
                    this.savePatternStorage(created, patternStorage, key, recordValue);
                    if (key.equals("remoteIP")) {
                        ipKey = recordValue;
                        continue;
                    }
                    if (key.equals("requestURL")) {
                        uriKey = recordValue;
                        continue;
                    }
                    if (key.equals("status")) {
                        tokenCode = recordValue;
                        continue;
                    }
                    if (!key.equals("processingTime")) continue;
                    processingTime = Long.parseLong(recordValue);
                }
                created = true;
            }
            if (flag) {
                if (this.tmpSize == 0L) {
                    writer.write(buf.toString());
                    buf = new StringBuffer();
                } else {
                    ++this.totalRows;
                    buf.append(line + "\n");
                }
                this.timeChain.doAction(logTime, this.tmpSize, tokenCode, processingTime);
                if (processingTime >= 0L) {
                    this.computeProcessingTime("dayly_processTime", dateKey, processingTime);
                }
                if (ipKey != null) {
                    this.statisticResult(this.ipStorage, ipKey, uriKey, tokenCode, processingTime, LogConstants.ANA_MODE_CLIENTIP);
                    if (processingTime >= 0L) {
                        this.computeProcessingTime("ip_processTime", ipKey, processingTime);
                    }
                }
                if (uriKey != null) {
                    this.statisticResult(this.uriStorage, uriKey, uriKey, tokenCode, processingTime, LogConstants.ANA_MODE_URI);
                    if (processingTime >= 0L) {
                        this.computeProcessingTime("uri_processTime", uriKey, processingTime);
                    }
                }
            }
            dateKey = null;
            ipKey = null;
            uriKey = null;
            tokenCode = null;
            logTime = 0L;
            processingTime = 0L;
        }
        writer.write(buf.toString());
        reader.close();
    }

    private void savePatternStorage(boolean created, PatternStorage patternStorage, String key, String recordValue) throws IOException {
        if (this.tmpSize == 0L && this.isfdbSave && patternStorage != null) {
            patternStorage.flush();
        }
        if (!key.equals("processingTime")) {
            if (!created) {
                patternStorage.store(recordValue, 1L);
            } else if (patternStorage.checkKey(recordValue)) {
                patternStorage.update(recordValue, 1L);
            } else {
                patternStorage.store(recordValue, 1L);
            }
        }
    }

    private void saveAttrPatternStorage(boolean created, PatternStorage patternStorage, String recordValue) throws IOException {
        if (this.tmpSize == 0L && this.isfdbSave && patternStorage != null) {
            patternStorage.flush();
        }
        if (!created) {
            patternStorage.store(recordValue, 1L);
        } else if (patternStorage.checkKey(recordValue)) {
            patternStorage.update(recordValue, 1L);
        } else {
            patternStorage.store(recordValue, 1L);
        }
    }

    private void setFormatterProperty(HashMap rowTable, Integer lineKey) {
        this.formatter = AccessFormatter.getAccessFormatter((String)rowTable.get(lineKey));
    }

    private void computeProcessingTime(String patternName, String key, long time) throws IOException {
        ProcessingTime obj = (ProcessingTime)this.props.getPatternObject(patternName);
        if (this.tmpSize == 0L && this.isfdbSave && obj != null) {
            obj.flush();
        }
        if (obj == null) {
            String taskName = patternName;
            obj = new ProcessingTime(this.fdbPath, taskName);
            obj.store(key, time);
            this.props.addPatternObject(taskName, obj);
            this.resultTable.put(taskName, obj);
        } else if (obj.checkKey(key)) {
            obj.update(key, time);
        } else {
            obj.store(key, time);
        }
    }

    private void statisticResult(FileStorage statObj, String key, String uri, String tokenCode, long tokenTime, int mode) throws IOException {
        String[] pageType = new String[]{"/", ".jsp", ".JSP", ".asp", ".ASP", ".xml", ".XML", ".html", ".HTML", ".htm", ".HTM", ".php", ".PHP", ".cgi", ".CGI", ".txt", ".TXT", ".exe", ".EXE", ".dll", ".DLL", ".php3", ".PHP3", ".shtml"};
        long avgTime = 0L;
        long error = 0L;
        long requestNum = 0L;
        if (tokenCode != null && !tokenCode.equals("200")) {
            ++error;
        }
        avgTime = tokenTime;
        if (this.tmpSize == 0L && this.isfdbSave) {
            statObj.flush();
        }
        if (statObj.checkKey(key)) {
            statObj.update(key, error, avgTime);
        } else {
            statObj.store(key, 1L, error, avgTime);
        }
    }

    private HashMap readMetaInfo(String logFile) throws IOException {
        BufferedReader metainfo_reader = new BufferedReader(new InputStreamReader(new FileInputStream(logFile + "_metainfo")));
        String line = null;
        Integer row = new Integer(0);
        String format = null;
        HashMap<Integer, String> rowTable = new HashMap<Integer, String>();
        while ((line = metainfo_reader.readLine()) != null) {
            int offset = line.indexOf(":");
            row = Integer.valueOf(line.substring(0, offset));
            format = line.substring(offset + 1);
            rowTable.put(row, format);
        }
        metainfo_reader.close();
        return rowTable;
    }

    private void writePatternObject() throws Exception {
        String key = null;
        Enumeration enum1 = null;
        AccessLogData obj = null;
        HashMap table = this.getResultTable();
        Iterator keys = table.keySet().iterator();
        ObjectOutputStream writer = null;
        RandomAccessFile resultFile = null;
        BufferedWriter bufWriter = new BufferedWriter(new FileWriter(this.resultDir + this.fs + "resultList", true), 1024);
        StringBuffer jeusBuf = new StringBuffer();
        StringBuffer userBuf = new StringBuffer();
        while (keys.hasNext()) {
            key = (String)keys.next();
            Object tableObj = table.get(key);
            if (tableObj instanceof PatternStorage) {
                File file2;
                ((PatternStorage)tableObj).flush();
                File file1 = new File(this.reportPath + this.fs + key + ".txt");
                if (file1.getParent() != null) {
                    new File(file1.getParent()).mkdirs();
                }
                if ((file2 = new File(this.reportPath + this.fs + "Idx" + this.fs + key + ".idx")).getParent() != null) {
                    new File(file2.getParent()).mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(file2);
                writer = new ObjectOutputStream(fos);
                resultFile = new RandomAccessFile(file1, "rw");
                PatternStorage patternStorage = (PatternStorage)tableObj;
                patternStorage.flush();
                ArrayList<Long> idxList = new ArrayList<Long>();
                ResultTableModel tableModel = null;
                if (patternStorage != null) {
                    tableModel = new ResultTableModel(this, key);
                    Vector accessRow = tableModel.getRowData();
                    enum1 = accessRow.elements();
                    int rows = 0;
                    while (enum1.hasMoreElements()) {
                        obj = (AccessLogData)enum1.nextElement();
                        long idxFD = resultFile.getFilePointer();
                        String s = obj.key + "\t" + obj.hits + "\t" + obj.hitRate + "\n";
                        resultFile.write(s.getBytes());
                        idxList.add(new Long(idxFD));
                        ++rows;
                    }
                    userBuf.append(key + "=" + rows + "\n");
                }
                writer.writeObject(idxList.toArray(new Long[idxList.size()]));
                writer.flush();
                writer.close();
                resultFile.close();
                tableModel.clearing();
                continue;
            }
            jeusBuf.append(this.writeGenericAnlysis(key, tableObj).toString());
        }
        bufWriter.write(this.logFilePrefix + "_accesslog" + "=" + this.totalRows + "\n");
        bufWriter.write(jeusBuf.toString());
        bufWriter.write("------------- PATTERN ID ATTRIBUTES ---------------\n");
        bufWriter.write(userBuf.toString());
        bufWriter.flush();
        bufWriter.close();
    }

    private StringBuffer writeGenericAnlysis(String key, Object tableObj) throws Exception {
        FileStorage fileStorage = (FileStorage)tableObj;
        fileStorage.flush();
        return this.writeLogData(key);
    }

    private StringBuffer writeLogData(String titleKey) throws Exception {
        Enumeration enum1 = null;
        AccessLogData obj = null;
        ResultTableModel tableModel = new ResultTableModel("LogAnalyzer", this, titleKey);
        ObjectOutputStream writer = null;
        RandomAccessFile resultFile = null;
        StringBuffer buf = new StringBuffer();
        try {
            File file2;
            File file1 = new File(this.reportPath + this.fs + titleKey + ".txt");
            if (file1.getParent() != null) {
                new File(file1.getParent()).mkdirs();
            }
            if ((file2 = new File(this.reportPath + this.fs + "Idx" + this.fs + titleKey + ".idx")).getParent() != null) {
                new File(file2.getParent()).mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(file2);
            writer = new ObjectOutputStream(fos);
            resultFile = new RandomAccessFile(file1, "rw");
            Vector accessRow = tableModel.getRowData();
            ArrayList<Long> idxList = new ArrayList<Long>();
            enum1 = accessRow.elements();
            int totalRows = 0;
            while (enum1.hasMoreElements()) {
                obj = (AccessLogData)enum1.nextElement();
                long idxFD = resultFile.getFilePointer();
                String s = obj.key + "\t" + obj.hits + "\t" + obj.hitRate + "\t" + obj.errors + "\t" + obj.errorRate + "\t" + obj.times + "\n";
                resultFile.write(s.getBytes());
                idxList.add(new Long(idxFD));
                ++totalRows;
            }
            buf.append(titleKey + "=" + totalRows + "\n");
            writer.writeObject(idxList.toArray(new Long[idxList.size()]));
            writer.flush();
            writer.close();
            resultFile.close();
            tableModel.clearing();
            return buf;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

