/*
 * Decompiled with CFR 0.152.
 */
package jeus.loganalyzer.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import jeus.loganalyzer.common.FileStorageBase;
import jeus.loganalyzer.common.StorageEntry;

public class FileStorage
extends FileStorageBase {
    public FileStorage(String _fileDBPath, String _fileDBName) throws IOException {
        this.fileDBPath = _fileDBPath;
        this.fileDBName = _fileDBName;
        this.fpTable = new HashMap();
        this.logDataTable = new HashMap();
        this.makeDBFile();
    }

    void initializeHeaderInfo() {
        this.totalLen = 0;
        this.KEY_SIZE = 4;
        this.BODY_SIZE = 32;
    }

    public void store(String idx, long hits, long errors, long times) throws IOException {
        byte[] key = idx.getBytes();
        this.totalLen = this.KEY_SIZE + key.length + this.BODY_SIZE;
        byte[] content = this.writeData(this.totalLen, key, hits, errors, times);
        this.logDataTable.put(idx, content);
        this.entry = new StorageEntry(-1L, content.length);
        this.fpTable.put(idx, this.entry);
    }

    public HashMap getFPTable() {
        return this.fpTable;
    }

    public HashMap getDataTable() {
        return this.logDataTable;
    }

    public RandomAccessFile getDBfile() {
        return this.DBfile;
    }

    public String getFileDir() {
        return this.fileDBPath;
    }

    public String getFileName() {
        return this.fileDBName;
    }

    public boolean checkKey(String idx) {
        return this.fpTable.containsKey(idx);
    }

    public long getTotalHits() {
        return this.totalHits;
    }

    public void update(String idx, long error, long avgTime) throws IOException {
        this.entry = (StorageEntry)this.fpTable.get(idx);
        byte[] content = new byte[(int)this.entry.length];
        if (this.logDataTable.containsKey(idx)) {
            content = (byte[])this.logDataTable.get(idx);
            this.logDataTable.put(idx, this.readData(this.entry.length, content, error, avgTime));
        } else {
            long originalPointer = this.DBfile.getFilePointer();
            this.DBfile.seek(this.entry.startAdd);
            this.DBfile.read(content);
            this.logDataTable.put(idx, this.readData(this.entry.length, content, error, avgTime));
            this.DBfile.seek(originalPointer);
            this.DBfile.getFD().sync();
        }
    }

    private byte[] readData(long entryLen, byte[] content, long error, long avgTime) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(content);
        DataInputStream dis = new DataInputStream(bis);
        int keyLen = dis.readInt();
        byte[] key = new byte[keyLen];
        dis.readFully(key);
        long hitsSize = dis.readLong();
        long errorsSize = dis.readLong();
        long timeAvgSize = dis.readLong();
        content = this.writeData(entryLen, key, ++hitsSize, errorsSize += error, timeAvgSize += avgTime);
        return content;
    }

    private byte[] writeData(long entryLen, byte[] key, long hitsSize, long errorsSize, long timeAvgSize) throws IOException {
        ++this.totalHits;
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)entryLen);
        DataOutputStream dout = new DataOutputStream(bos);
        dout.writeInt(key.length);
        dout.write(key, 0, key.length);
        dout.writeLong(hitsSize);
        dout.writeLong(errorsSize);
        dout.writeLong(timeAvgSize);
        return bos.toByteArray();
    }

    public void flush() throws IOException {
        Set keySet = this.logDataTable.keySet();
        Iterator keyList = keySet.iterator();
        long pos = 0L;
        while (keyList.hasNext()) {
            long originalPointer = this.DBfile.getFilePointer();
            String key = (String)keyList.next();
            StorageEntry entry = (StorageEntry)this.fpTable.get(key);
            byte[] value = (byte[])this.logDataTable.get(key);
            if (entry.startAdd == -1L) {
                entry.startAdd = pos = this.DBfile.getFilePointer();
                this.DBfile.seek(pos);
                this.DBfile.write(value);
                this.DBfile.getFD().sync();
            } else {
                pos = entry.startAdd;
                this.DBfile.seek(pos);
                this.DBfile.write(value);
                this.DBfile.seek(originalPointer);
                this.DBfile.getFD().sync();
            }
            this.fpTable.put(key, entry);
        }
        this.logDataTable.clear();
    }
}

