/*
 * Decompiled with CFR 0.152.
 */
package jeus.loganalyzer.common;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import jeus.loganalyzer.analysis.AccessLogParser;
import jeus.loganalyzer.common.AccessLogData;
import jeus.loganalyzer.common.FileStorage;
import jeus.loganalyzer.common.StorageEntry;
import jeus.loganalyzer.pattern.PatternStorage;
import jeus.loganalyzer.util.LogConstants;

public class ResultTableModel {
    private AccessLogParser logData = null;
    private Set hashCode = null;
    private Iterator hashCodeList = null;
    protected int sortCol = 0;
    protected boolean sortAsc = true;
    public String[] columnNames = null;
    private HashMap fpTable = null;
    private HashMap dataTable = null;
    private RandomAccessFile dbFile = null;
    private StorageEntry entry = null;
    private Object seqcode = null;
    private long totalCount = 0L;
    private FileStorage anaFS = null;
    private PatternStorage patternFS = null;
    private long totalTime;
    private Vector rowData;

    public ResultTableModel(String flag, AccessLogParser log, String key) throws Exception {
        this.logData = log;
        this.columnNames = key.startsWith("CLIENTIP_STATISTICS") ? LogConstants.ip_columnNames : (key.startsWith("REQUESTURI_STATISTICS") ? LogConstants.uri_columnNames : (key.startsWith("TIME") ? LogConstants.time_columnNames : LogConstants.day_columnNames));
        this.anaFS = this.logData.getFileStorage(key);
        this.totalCount = this.anaFS.getTotalHits();
        this.fpTable = this.anaFS.getFPTable();
        this.dbFile = this.anaFS.getDBfile();
        this.rowData = new Vector();
        if (this.logData.isFileSave()) {
            this.setRowData();
        } else {
            this.dataTable = this.anaFS.getDataTable();
            this.setRowMemData();
        }
    }

    public ResultTableModel(AccessLogParser log, String patternType) throws Exception {
        this.logData = log;
        this.columnNames = LogConstants.pattern_columnNames;
        this.patternFS = this.logData.getPatternObject(patternType);
        this.totalCount = this.patternFS.getTotalHits();
        this.totalTime = this.patternFS.getTotalTime();
        this.fpTable = this.patternFS.getFPTable();
        this.dbFile = this.patternFS.getDBfile();
        this.rowData = new Vector();
        if (this.logData.isFileSave()) {
            this.setPatternRowData(this.patternFS.isDigist());
        } else {
            this.dataTable = this.patternFS.getDataTable();
            this.setPatternRowMemData(this.patternFS.isDigist());
        }
    }

    public Vector getRowData() {
        return this.rowData;
    }

    public void clearing() throws Exception {
        if (this.anaFS != null) {
            this.anaFS.clear();
        }
        if (this.patternFS != null) {
            this.patternFS.clear();
        }
        if (this.fpTable != null) {
            this.fpTable.clear();
        }
        if (this.dataTable != null) {
            this.dataTable.clear();
        }
        if (this.dbFile != null) {
            this.dbFile.close();
        }
    }

    private void setRowData() throws Exception {
        this.rowData.removeAllElements();
        this.hashCode = this.fpTable.keySet();
        for (Object this.seqcode : this.hashCode) {
            this.entry = (StorageEntry)this.fpTable.get(this.seqcode);
            byte[] content = new byte[(int)this.entry.length];
            this.dbFile.seek(this.entry.startAdd);
            this.dbFile.read(content);
            ByteArrayInputStream bis = new ByteArrayInputStream(content);
            DataInputStream dis = new DataInputStream(bis);
            int keyLen = dis.readInt();
            byte[] key = new byte[keyLen];
            dis.readFully(key);
            Long hitsSize = new Long(dis.readLong());
            Long errorsSize = new Long(dis.readLong());
            long timeAvgSize = dis.readLong();
            long timeavg = 0L;
            long hitsLong = hitsSize;
            double hitRate = Math.round(hitsSize.doubleValue() / new Long(this.totalCount).doubleValue() * 100.0);
            double errorRate = Math.round((hitsSize.doubleValue() - errorsSize.doubleValue()) / hitsSize.doubleValue() * 100.0);
            if (hitsLong > 0L) {
                timeavg = timeAvgSize / hitsLong;
            }
            this.rowData.addElement(new AccessLogData((String)this.seqcode, hitsSize, hitRate, errorsSize, errorRate, timeavg));
        }
        Collections.sort(this.rowData, new LogListComparator(this.sortCol, this.sortAsc));
    }

    private void setRowMemData() throws Exception {
        this.rowData.removeAllElements();
        this.hashCode = this.fpTable.keySet();
        for (Object this.seqcode : this.hashCode) {
            this.entry = (StorageEntry)this.fpTable.get(this.seqcode);
            byte[] content = new byte[(int)this.entry.length];
            content = (byte[])this.dataTable.get(this.seqcode);
            ByteArrayInputStream bis = new ByteArrayInputStream(content);
            DataInputStream dis = new DataInputStream(bis);
            int keyLen = dis.readInt();
            byte[] key = new byte[keyLen];
            dis.readFully(key);
            Long hitsSize = new Long(dis.readLong());
            Long errorsSize = new Long(dis.readLong());
            long timeAvgSize = dis.readLong();
            long timeavg = 0L;
            long hitsLong = hitsSize;
            double hitRate = Math.round(hitsSize.doubleValue() / new Long(this.totalCount).doubleValue() * 100.0);
            double errorRate = Math.round((hitsSize.doubleValue() - errorsSize.doubleValue()) / hitsSize.doubleValue() * 100.0);
            if (hitsLong > 0L) {
                timeavg = timeAvgSize / hitsLong;
            }
            this.rowData.addElement(new AccessLogData((String)this.seqcode, hitsSize, hitRate, errorsSize, errorRate, timeavg));
        }
        Collections.sort(this.rowData, new LogListComparator(this.sortCol, this.sortAsc));
    }

    private void setPatternRowData(boolean isDigist) throws Exception {
        this.rowData.removeAllElements();
        this.hashCode = this.fpTable.keySet();
        for (Object this.seqcode : this.hashCode) {
            this.entry = (StorageEntry)this.fpTable.get(this.seqcode);
            byte[] content = new byte[(int)this.entry.length];
            this.dbFile.seek(this.entry.startAdd);
            this.dbFile.read(content);
            ByteArrayInputStream bis = new ByteArrayInputStream(content);
            DataInputStream dis = new DataInputStream(bis);
            int keyLen = dis.readInt();
            byte[] key = new byte[keyLen];
            dis.readFully(key);
            Long hitsSize = new Long(dis.readLong());
            if (isDigist) {
                this.totalCount = this.totalTime;
            }
            double hitRate = Math.round(hitsSize.doubleValue() / new Long(this.totalCount).doubleValue() * 100.0);
            this.rowData.addElement(new AccessLogData((String)this.seqcode, hitsSize, hitRate));
        }
        Collections.sort(this.rowData, new LogListComparator(this.sortCol, this.sortAsc));
    }

    private void setPatternRowMemData(boolean isDigist) throws Exception {
        this.rowData.removeAllElements();
        this.hashCode = this.fpTable.keySet();
        for (Object this.seqcode : this.hashCode) {
            this.entry = (StorageEntry)this.fpTable.get(this.seqcode);
            byte[] content = new byte[(int)this.entry.length];
            content = (byte[])this.dataTable.get(this.seqcode);
            ByteArrayInputStream bis = new ByteArrayInputStream(content);
            DataInputStream dis = new DataInputStream(bis);
            int keyLen = dis.readInt();
            byte[] key = new byte[keyLen];
            dis.readFully(key);
            Long hitsSize = new Long(dis.readLong());
            if (isDigist) {
                this.totalCount = this.totalTime;
            }
            double hitRate = Math.round(hitsSize.doubleValue() / new Long(this.totalCount).doubleValue() * 100.0);
            this.rowData.addElement(new AccessLogData((String)this.seqcode, hitsSize, hitRate));
        }
        Collections.sort(this.rowData, new LogListComparator(this.sortCol, this.sortAsc));
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.rowData == null ? 0 : this.rowData.size();
    }

    public String getColumnName(int col) {
        String str = this.columnNames[col];
        if (col == this.sortCol) {
            str = str + (this.sortAsc ? ">>" : "<<");
        }
        return str;
    }

    public Object getValueAt(int row, int col) {
        if (row < 0 || row >= this.getRowCount()) {
            return "";
        }
        AccessLogData rowList = (AccessLogData)this.rowData.elementAt(row);
        switch (col) {
            case 0: {
                return rowList.key;
            }
            case 1: {
                return rowList.hits;
            }
            case 2: {
                return rowList.hitRate;
            }
            case 3: {
                return rowList.errors;
            }
            case 4: {
                return rowList.errorRate;
            }
            case 5: {
                return rowList.times;
            }
        }
        return "";
    }

    public boolean compareDateValue(int row, int col, String date) {
        int preRow = row - 1;
        AccessLogData rowPreList = (AccessLogData)this.rowData.elementAt(preRow);
        String preDate = rowPreList.key;
        return preDate.equals(date);
    }

    public boolean compareIPValue(int row, int col, String ip) {
        int preRow = row - 1;
        AccessLogData rowPreList = (AccessLogData)this.rowData.elementAt(preRow);
        String preIP = rowPreList.key;
        return preIP.equals(ip);
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    class LogListComparator
    implements Comparator {
        protected int sortCol;
        protected boolean sortAsc;

        public LogListComparator(int sortCol, boolean sortAsc) {
            this.sortCol = sortCol;
            this.sortAsc = sortAsc;
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof AccessLogData) || !(o2 instanceof AccessLogData)) {
                return 0;
            }
            AccessLogData s1 = (AccessLogData)o1;
            AccessLogData s2 = (AccessLogData)o2;
            int result = 0;
            long preHits = 0L;
            long currentHits = 0L;
            double preRate = 0.0;
            double currentRate = 0.0;
            long preTime = 0L;
            long currentTime = 0L;
            switch (this.sortCol) {
                case 0: {
                    result = s1.key.compareTo(s2.key);
                    break;
                }
                case 1: {
                    preHits = s1.hits;
                    currentHits = s2.hits;
                    result = preHits < currentHits ? -1 : (preHits > currentHits ? 1 : 0);
                    break;
                }
                case 2: {
                    preRate = s1.hitRate;
                    currentRate = s2.hitRate;
                    result = preRate < currentRate ? -1 : (preRate > currentRate ? 1 : 0);
                    break;
                }
                case 3: {
                    preHits = s1.errors;
                    currentHits = s2.errors;
                    result = preHits < currentHits ? -1 : (preHits > currentHits ? 1 : 0);
                    break;
                }
                case 4: {
                    preRate = s1.errorRate;
                    currentRate = s2.errorRate;
                    result = preRate < currentRate ? -1 : (preRate > currentRate ? 1 : 0);
                    break;
                }
                case 5: {
                    preTime = s1.times;
                    currentTime = s2.times;
                    int n = preTime < currentTime ? -1 : (result = preTime > currentTime ? 1 : 0);
                }
            }
            if (this.sortAsc) {
                result = -result;
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LogListComparator) {
                LogListComparator compObj = (LogListComparator)obj;
                return compObj.sortCol == this.sortCol && compObj.sortAsc == this.sortAsc;
            }
            return false;
        }
    }
}

