/*
 * Decompiled with CFR 0.152.
 */
package jeus.loganalyzer.common.chain;

import java.io.IOException;
import jeus.loganalyzer.common.FileStorage;

public abstract class LogChain {
    protected LogChain chain;
    protected FileStorage storage;
    protected boolean isfdbSave = true;

    public LogChain(FileStorage storage) {
        this.storage = storage;
    }

    public LogChain(LogChain nextChain, FileStorage storage) {
        this.chain = nextChain;
        this.storage = storage;
    }

    public FileStorage getStorage() {
        return this.storage;
    }

    public void setIsfdbSave(boolean isfdbSave) {
        this.isfdbSave = isfdbSave;
    }

    abstract void doAction(long var1, long var3, String var5, long var6) throws IOException;

    protected void statisticResult(long tmpSize, String key, String tokenCode, long tokenTime) throws IOException {
        long avgTime = 0L;
        long error = 0L;
        if (tokenCode != null && !tokenCode.equals("200")) {
            ++error;
        }
        avgTime = tokenTime;
        if (tmpSize == 0L && this.isfdbSave) {
            this.storage.flush();
        }
        if (this.storage.checkKey(key)) {
            this.storage.update(key, error, avgTime);
        } else {
            this.storage.store(key, 1L, error, avgTime);
        }
    }
}

