/*
 * Decompiled with CFR 0.152.
 */
package jeus.loganalyzer.pattern;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import jeus.loganalyzer.common.StorageEntry;
import jeus.loganalyzer.pattern.PatternStorage;

public class AccessDefaultStorage
extends PatternStorage {
    public AccessDefaultStorage(String _fileDBPath, String _fileDBName) {
        super(_fileDBPath, _fileDBName);
    }

    public void initializeHeaderInfo() {
        this.totalLen = 0;
        this.KEY_SIZE = 4;
        this.BODY_SIZE = 8;
        this.totalHits = 0L;
        this.totalTime = 0L;
        this.fpTable = new HashMap();
        this.logDataTable = new HashMap();
        try {
            this.makeDBFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isDigist() {
        return false;
    }

    public void store(String idx, long value) throws IOException {
        byte[] key = idx.getBytes();
        this.totalLen = this.KEY_SIZE + key.length + this.BODY_SIZE;
        byte[] content = new byte[this.totalLen];
        content = this.writeData(this.totalLen, key, value);
        this.logDataTable.put(idx, content);
        this.entry = new StorageEntry(-1L, content.length);
        this.fpTable.put(idx, this.entry);
    }

    public void update(String idx, long value) throws IOException {
        this.entry = (StorageEntry)this.fpTable.get(idx);
        byte[] content = new byte[(int)this.entry.length];
        if (this.logDataTable.containsKey(idx)) {
            content = (byte[])this.logDataTable.get(idx);
            this.logDataTable.put(idx, this.readData(this.entry.length, content, value));
        } else {
            long originalPointer = this.DBfile.getFilePointer();
            this.DBfile.seek(this.entry.startAdd);
            this.DBfile.read(content);
            this.logDataTable.put(idx, this.readData(this.entry.length, content, value));
            this.DBfile.seek(originalPointer);
            this.DBfile.getFD().sync();
        }
    }

    protected byte[] readData(long entryLen, byte[] content, long value) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(content);
        DataInputStream dis = new DataInputStream(bis);
        int keyLen = dis.readInt();
        byte[] key = new byte[keyLen];
        dis.readFully(key);
        long readValue = dis.readLong();
        content = this.writeData(entryLen, key, ++readValue);
        return content;
    }

    protected byte[] writeData(long entryLen, byte[] key, long value) throws IOException {
        ++this.totalHits;
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)entryLen);
        DataOutputStream dout = new DataOutputStream(bos);
        dout.writeInt(key.length);
        dout.write(key, 0, key.length);
        dout.writeLong(value);
        return bos.toByteArray();
    }

    public void flush() throws IOException {
        String key = null;
        Set keySet = this.logDataTable.keySet();
        Iterator keyList = keySet.iterator();
        long pos = 0L;
        while (keyList.hasNext()) {
            long originalPointer = this.DBfile.getFilePointer();
            key = (String)keyList.next();
            StorageEntry entry = (StorageEntry)this.fpTable.get(key);
            byte[] value = new byte[(int)entry.length];
            value = (byte[])this.logDataTable.get(key);
            if (entry.startAdd == -1L) {
                entry.startAdd = pos = this.DBfile.getFilePointer();
                this.DBfile.seek(pos);
                this.DBfile.write(value);
                this.DBfile.getFD().sync();
            } else {
                pos = entry.startAdd;
                this.DBfile.seek(pos);
                this.DBfile.write(value);
                this.DBfile.seek(originalPointer);
                this.DBfile.getFD().sync();
            }
            this.fpTable.put(key, entry);
        }
        this.logDataTable.clear();
    }
}

