/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.enterprise.agent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import jeus.management.enterprise.agent.JMXConnectorNotReachableException;
import jeus.management.enterprise.agent.MBeanServerChecker;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.security.util.LoginUtil;
import jeus.util.VirtualDNS;
import jeus.util.message.JeusMessage_JMX;
import jeus.util.properties.JeusPropertyValues;

public class JNDIMBeanServerChecker
extends MBeanServerChecker {
    private InitialContext ic;

    public JNDIMBeanServerChecker(String serverName, MBeanServer server, Hashtable jndiEnv) throws NamingException {
        super(serverName, server, jndiEnv);
        String realHost;
        String host = (String)jndiEnv.get("java.naming.provider.url");
        if (host != null && host.indexOf(":") < 0 && !host.equals(realHost = VirtualDNS.getRealNodeName(host))) {
            this.jndiEnv.put("java.naming.provider.url", realHost);
        }
        this.ic = new InitialContext(jndiEnv);
    }

    public List checkNewMBeanServer() {
        if (this.isConnecting) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException e) {
                logger.log(Level.FINEST, "This thread is interrupted", (Throwable)e);
            }
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> list = new ArrayList<String>();
        try {
            InitialContext ic = new InitialContext(this.jndiEnv);
            NamingEnumeration<NameClassPair> ne = ic.list("mgmt/rmbs/");
            while (ne.hasMore()) {
                NameClassPair b = ne.next();
                String jndiName = b.getName();
                if (this.cachedConnector.containsKey(jndiName) || this.serverName != null && jndiName.endsWith(this.serverName)) continue;
                if (logger.isLoggable(JeusMessage_JMX.JMX_05_LEVEL)) {
                    logger.log(JeusMessage_JMX.JMX_05_LEVEL, JeusMessage_JMX.JMX_05, (Object)jndiName);
                }
                this.isConnecting = true;
                list.add(jndiName);
            }
            return list;
        }
        catch (NamingException e) {
            if (logger.isLoggable(JeusMessage_JMX.JMX_04_LEVEL)) {
                logger.log(JeusMessage_JMX.JMX_04_LEVEL, JeusMessage_JMX.JMX_04, (Throwable)e);
            }
            return Collections.EMPTY_LIST;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getRemoteMBeanServers() {
        List newServerBindings = this.checkNewMBeanServer();
        if (newServerBindings.isEmpty()) {
            return this.cachedMBeanServerSet;
        }
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            for (String jndiName : newServerBindings) {
                try {
                    this.connectServer(jndiName);
                }
                catch (JMXConnectorNotReachableException e) {
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.log(Level.FINEST, "The node or container " + jndiName + " is not reachable", (Throwable)e);
                }
                catch (NamingException e) {
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.log(Level.FINEST, "The node or container " + jndiName + " is not reachable", (Throwable)e);
                }
                catch (Exception e) {
                    logger.log(JeusMessage_JMX.JMX_03_LEVEL, JeusMessage_JMX.JMX_03, (Object)jndiName, (Throwable)e);
                }
            }
        }
        catch (Exception ex) {
            if (logger.isLoggable(JeusMessage_JMX.JMX_04_LEVEL)) {
                logger.log(JeusMessage_JMX.JMX_04_LEVEL, JeusMessage_JMX.JMX_04, (Throwable)ex);
            }
        }
        finally {
            this.isConnecting = false;
            JNDIMBeanServerChecker ex = this;
            synchronized (ex) {
                ((Object)((Object)this)).notifyAll();
            }
            LoginUtil.logoutWithRuntimeException();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "before return mbean server set");
            for (MBeanServerConnection mBeanServerConnection : this.cachedMBeanServerSet) {
                logger.log(Level.FINER, "cached mbean server : " + mBeanServerConnection);
            }
        }
        return this.cachedMBeanServerSet;
    }

    private boolean isInClusterForNodeOrContainerName(String nodeName) {
        if (JeusPropertyValues.JEUS_CATEGORY == 0) {
            return true;
        }
        int index = nodeName.lastIndexOf(95);
        if (index >= 0) {
            return MEJBUtility.isInCluster((String)nodeName.substring(0, index)) || MEJBUtility.isInCluster((String)nodeName);
        }
        return MEJBUtility.isInCluster((String)nodeName);
    }

    protected synchronized void connectServer(String dedicatedJMXManagerName) throws Exception {
        MBeanServerConnection sc;
        if (!this.isInClusterForNodeOrContainerName(dedicatedJMXManagerName)) {
            throw new JMXConnectorNotReachableException("The node or container " + dedicatedJMXManagerName + " is not reachable from this node, maybe ClusterService has not detected the node yet");
        }
        String jndiName = "mgmt/rmbs/" + dedicatedJMXManagerName;
        JMXConnector connector = (JMXConnector)this.ic.lookup(jndiName);
        if (logger.isLoggable(JeusMessage_JMX.JMX_05_LEVEL)) {
            logger.log(JeusMessage_JMX.JMX_05_LEVEL, JeusMessage_JMX.JMX_05, (Object)dedicatedJMXManagerName);
        }
        try {
            connector.connect();
            sc = connector.getMBeanServerConnection();
        }
        catch (IOException ex) {
            block6: {
                try {
                    connector.close();
                }
                catch (Exception e) {
                    if (!logger.isLoggable(JeusMessage_JMX.JMX_09_LEVEL)) break block6;
                    logger.log(JeusMessage_JMX.JMX_09_LEVEL, JeusMessage_JMX.JMX_09, (Throwable)e);
                }
            }
            throw ex;
        }
        this.cachedConnector.put(dedicatedJMXManagerName, connector);
        this.cachedMBeanServer.put(dedicatedJMXManagerName, sc);
        this.cachedMBeanServerSet.add(sc);
    }
}

