/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.io.IOException;
import java.security.PermissionCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.client.container.AppClientHelper;
import jeus.client.container.AppClientProperties;
import jeus.container.namingenv.EjbRef;
import jeus.container.namingenv.EnvRef;
import jeus.container.namingenv.EnvironmentContext;
import jeus.container.namingenv.JndiEnvironmentMappingGroup;
import jeus.container.namingenv.NamingEnvironment;
import jeus.container.namingenv.ResourceRef;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.ModuleTypeSerializable;
import jeus.deploy.TargetModuleIDImpl;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.ArchiveHelper;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.InputJarArchive;
import jeus.deploy.io.AppClientDeploymentDescriptorFile;
import jeus.deploy.io.runtime.AppClientRuntimeDDFile;
import jeus.management.j2ee.AppClientModuleMBean;
import jeus.management.j2ee.DeploymentException;
import jeus.management.j2ee.J2EEApplication;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEModule;
import jeus.management.j2ee.J2EEServer;
import jeus.persistence.container.PersistenceUnits;
import jeus.security.util.LoginUtil;
import jeus.server.enginecontainer.EngineContainer;
import jeus.util.file.FileUtils;
import jeus.util.message.JeusMessage_JMX;
import jeus.webservices.spi.EWSProvider;
import jeus.xml.binding.ObjectFactoryHelper;
import jeus.xml.binding.j2ee.ApplicationClientType;
import jeus.xml.binding.jeusDD.ClientComponentType;
import jeus.xml.binding.jeusDD.JeusClientDdType;
import jeus.xml.binding.jeusDD.JndiInfoType;
import jeus.xml.binding.jeusDD.JndiRefType;
import jeus.xml.binding.jeusDD.ObjectFactory;

public class AppClientModule
extends J2EEModule
implements AppClientModuleMBean {
    Object target = null;
    private ClientComponentType type;
    private ApplicationClientType stdDD;
    private JeusClientDdType extDD;
    private boolean metadataComplete;
    private Class mainClass;
    private NamingEnvironment environment;
    private static final double VERSION_5 = 5.0;
    private static final double DEFAULT_VERSION = 5.0;
    private double appClientVersion = 5.0;

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        AppClientModule object = new AppClientModule(parent, target);
        return object.createMBean(mBeanName, "AppClientModule", parent, parentKeyMap, null);
    }

    public AppClientModule(ObjectName parent, Object _target) {
        super(parent);
        this.target = _target;
    }

    public PermissionCollection getDefaultPermissions() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return this.appClassLoader;
    }

    protected TargetModuleID deploy(Object deployDesc) throws Exception {
        this.isDeployed = true;
        this.myModuleID = new TargetModuleIDImpl(this.myObjectName, EngineContainer.serverMBean.getTarget());
        FileArchive appRoot = J2EEServer.getAppRootArchive(this.path);
        this.pushDeploymentContext();
        try {
            if (this.deployType.equals("EAR")) {
                if (FileUtils.isExploded((String)appRoot.getArchiveUri(), (String)this.type.getUri())) {
                    this.deployExplodedStandaloneAppClient(appRoot.getEmbeddedArchive(this.type.getUri()));
                } else {
                    this.deployStandaloneAppClient(this.type.getUri(), appRoot);
                }
            } else if (this.deployType.equals("COMPONENT")) {
                if (JeusDeploymentManager.isExploded(this.appType)) {
                    this.deployExplodedStandaloneAppClient(appRoot.getEmbeddedArchive(this.type.getUri()));
                } else {
                    this.deployStandaloneAppClient(this.type.getUri(), appRoot);
                }
            }
        }
        catch (Throwable ex) {
            throw new DeploymentException("Deployment application client module " + this.getAppModuleName() + " failed.", ex);
        }
        finally {
            this.popDeploymentContext();
            appRoot.close();
        }
        return this.myModuleID;
    }

    public ModuleTypeSerializable getModuleType() {
        LoginUtil.checkPermissionWithRuntimeException(this.getModuleTypePermission);
        return ModuleTypeSerializable.CAR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployStandaloneAppClient(String fileName, FileArchive standaloneHomeArchive) {
        String javaFileHome = fileName.substring(0, fileName.lastIndexOf(".jar"));
        FileArchive jarFileArchive = null;
        InputJarArchive archive = null;
        try {
            standaloneHomeArchive.deleteEntry(javaFileHome);
            jarFileArchive = (FileArchive)standaloneHomeArchive.getEmbeddedArchive(javaFileHome);
            archive = standaloneHomeArchive.getEmbeddedJarArchive(fileName);
            FileArchive explodedArchive = ArchiveHelper.extractArchive((FileArchive)standaloneHomeArchive, (String)fileName, (String)".jar");
            this.deployExplodedStandaloneAppClient((AbstractArchive)explodedArchive);
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_JMX.JMX_23_LEVEL)) {
                logger.log(JeusMessage_JMX.JMX_23_LEVEL, JeusMessage_JMX.JMX_23, (Throwable)e);
            }
        }
        finally {
            if (archive != null) {
                try {
                    archive.close();
                }
                catch (IOException e) {}
            }
            if (jarFileArchive != null) {
                try {
                    jarFileArchive.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void deployExplodedStandaloneAppClient(AbstractArchive archive) throws Exception {
        this.setRootArchive((FileArchive)archive);
        AppClientDeploymentDescriptorFile appClientDeploymentDescriptorFile = new AppClientDeploymentDescriptorFile();
        AppClientRuntimeDDFile appClientRuntimeDDFile = new AppClientRuntimeDDFile();
        if (appClientDeploymentDescriptorFile.existsDescriptorFile(archive)) {
            this.stdDD = (ApplicationClientType)appClientDeploymentDescriptorFile.getDeploymentDescriptor(archive);
            if (this.stdDD.isSetVersion()) {
                this.appClientVersion = Double.parseDouble(this.stdDD.getVersion());
            }
            if (this.appClientVersion < 5.0) {
                this.metadataComplete = true;
            } else {
                boolean bl = this.metadataComplete = this.stdDD.isSetMetadataComplete() && this.stdDD.isMetadataComplete();
            }
        }
        if (appClientRuntimeDDFile.existsDescriptorFile(archive)) {
            this.extDD = (JeusClientDdType)appClientRuntimeDDFile.getDeploymentDescriptor(archive);
        } else {
            this.extDD = (JeusClientDdType)appClientRuntimeDDFile.newDeploymentDescriptor();
            this.extDD.getModuleInfo().setModuleName(this.getUniqueModuleName());
        }
        if (!this.isStandAloneModule()) {
            EWSProvider provider;
            String mainClassName = AppClientHelper.getMainClassAttribute(archive);
            if (mainClassName != null && !mainClassName.equals("")) {
                this.extDD.getModuleInfo().setAppMainClass(mainClassName);
            } else {
                mainClassName = this.extDD.getModuleInfo().getAppMainClass();
            }
            if (mainClassName == null) {
                throw new DeploymentException("Application client module " + this.getAppModuleName() + " should have Main-Class attribute in Manifest or jeus-client-dd.xml");
            }
            try {
                mainClassName = mainClassName.trim();
                this.mainClass = this.appClassLoader.loadClass(mainClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new DeploymentException("Could not load Main-Class '" + mainClassName + "' of the application client module " + this.getAppModuleName());
            }
            if (!this.metadataComplete) {
                this.environment = AppClientHelper.processEnvironmentAnnotations(this.mainClass);
            }
            this.environment = AppClientHelper.processDescriptorEnvironmentEntries(this.environment, this.stdDD, this.appClassLoader, this.mainClass.getName());
            if (this.environment == null) {
                this.environment = new NamingEnvironment();
            }
            if ((provider = EWSProvider.getProvider()) != null) {
                provider.processServiceRefs(this, this.isFastDeploy, this.isKeepGenerated, this.extDD, this.stdDD);
            }
            this.fillEnvRefMapping();
            appClientRuntimeDDFile.marshalDescriptor((Object)new ObjectFactory().createJeusClientDd(this.extDD), archive);
        }
        AppClientProperties properties = new AppClientProperties();
        properties.setStandalone(this.isStandAloneModule());
        if (!this.isStandAloneModule()) {
            J2EEApplication app = this.getApplication();
            properties.setEarPath(app.getRootArchive().getArchiveUri());
            properties.setModuleUri(this.getModuleUri());
            StringBuffer puUriPath = new StringBuffer();
            for (PersistenceUnits pus : app.getAllPersistenceUnits()) {
                puUriPath.append(pus.getPersistenceUnitUri()).append(":");
            }
            properties.setEarPersistenceUnitPath(puUriPath.toString());
        }
        properties.store(archive);
        if (this.stdDD != null) {
            appClientDeploymentDescriptorFile.serializeDescriptor(this.stdDD, archive);
        }
        if (this.extDD != null) {
            appClientRuntimeDDFile.serializeDescriptor(this.extDD, archive);
        }
    }

    private void fillEnvRefMapping() {
        Collection<EnvRef> entries = this.environment.entries();
        ObjectFactory oFactory = ObjectFactoryHelper.getJeusDDObjectFactory();
        HashMap<String, JndiInfoType> ejbRefMap = new HashMap<String, JndiInfoType>();
        JndiRefType ejbRef = this.extDD.getEjbRef();
        if (ejbRef == null) {
            ejbRef = oFactory.createJndiRefType();
            this.extDD.setEjbRef(ejbRef);
        }
        List ejbRefInfoList = ejbRef.getJndiInfo();
        for (JndiInfoType info : ejbRefInfoList) {
            ejbRefMap.put(info.getRefName(), info);
        }
        HashMap<String, JndiInfoType> msgDestRefMap = new HashMap<String, JndiInfoType>();
        JndiRefType msgDestRef = this.extDD.getMessageDestinationRef();
        if (msgDestRef == null) {
            msgDestRef = oFactory.createJndiRefType();
            this.extDD.setMessageDestinationRef(msgDestRef);
        }
        List msgDestRefList = msgDestRef.getJndiInfo();
        for (JndiInfoType info : msgDestRefList) {
            msgDestRefMap.put(info.getRefName(), info);
        }
        JndiEnvironmentMappingGroup mapping = new JndiEnvironmentMappingGroup();
        mapping.setEjbRefMapping(ejbRef);
        EnvironmentContext envContext = new EnvironmentContext(this, mapping);
        for (EnvRef entry : entries) {
            String jndiName;
            String link;
            ResourceRef resEntry;
            JndiInfoType jndiInfo;
            String refName;
            if (entry instanceof EjbRef) {
                String jndiName2;
                EjbRef ejbentry = (EjbRef)entry;
                refName = ejbentry.getName();
                jndiInfo = (JndiInfoType)ejbRefMap.get(refName);
                if (jndiInfo != null && !AppClientModule.isNullOrEmpty(jndiInfo.getExportName()) || (jndiName2 = ejbentry.getJndiName(envContext)) == null) continue;
                if (jndiInfo == null) {
                    jndiInfo = oFactory.createJndiInfoType();
                    jndiInfo.setRefName(refName);
                    ejbRefInfoList.add(jndiInfo);
                }
                jndiInfo.setExportName(jndiName2);
                continue;
            }
            if (!(entry instanceof ResourceRef) || !(resEntry = (ResourceRef)entry).isMessageDestinationRef() || resEntry.getMsgDestinationLink() == null || (jndiInfo = (JndiInfoType)msgDestRefMap.get(refName = resEntry.getName())) != null && !AppClientModule.isNullOrEmpty(jndiInfo.getExportName()) || AppClientModule.isNullOrEmpty(link = resEntry.getMsgDestinationLink()) || (jndiName = this.getMessageDestinationJndiNameWithLink(link)) == null) continue;
            if (jndiInfo == null) {
                jndiInfo = oFactory.createJndiInfoType();
                jndiInfo.setRefName(refName);
                msgDestRefList.add(jndiInfo);
            }
            jndiInfo.setExportName(jndiName);
        }
    }

    public void setComponentType(Object deployDesc) {
        this.type = (ClientComponentType)deployDesc;
    }

    public Object getComponentType() {
        return this.type;
    }

    private static boolean isNullOrEmpty(String name) {
        return name == null || name.trim().equals("");
    }
}

