/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import jeus.deploy.archivist.FileArchive;
import jeus.management.j2ee.J2EEApplication;
import jeus.management.j2ee.J2EEDeployedObject;
import jeus.management.j2ee.J2EEModule;
import jeus.util.ArrayListStack;
import jeus.xml.binding.j2ee.EjbJarType;
import jeus.xml.binding.jeusDD.EjbComponentType;
import jeus.xml.binding.jeusDD.JeusEjbDdType;

public class DeploymentContext {
    protected static ThreadLocal<ArrayListStack> context = new ThreadLocal();
    protected J2EEDeployedObject deployedObject;
    protected Map<String, Object> contextData = new HashMap<String, Object>();
    protected boolean compileOnlyMode;
    protected FileArchive clientViewHome;
    protected EjbJarType ejbJar;
    protected JeusEjbDdType jeusEjbDd;
    protected String securityDomainName;
    protected EjbComponentType ejbComponent;

    public static DeploymentContext currentContext() {
        ArrayListStack stack = context.get();
        if (stack == null) {
            return null;
        }
        try {
            return (DeploymentContext)stack.peek();
        }
        catch (EmptyStackException ex) {
            return null;
        }
    }

    public static void pushContext(DeploymentContext dc) {
        ArrayListStack stack = context.get();
        if (stack == null) {
            stack = new ArrayListStack();
            context.set(stack);
        }
        stack.push((Object)dc);
    }

    public static void popContext() {
        ArrayListStack stack = context.get();
        if (stack == null) {
            return;
        }
        try {
            stack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public DeploymentContext(J2EEDeployedObject deployedObject) {
        this.deployedObject = deployedObject;
    }

    public J2EEDeployedObject getJ2EEDeployedObject() {
        return this.deployedObject;
    }

    public J2EEApplication getJ2EEApplication() {
        if (this.deployedObject instanceof J2EEApplication) {
            return (J2EEApplication)this.deployedObject;
        }
        if (this.deployedObject instanceof J2EEModule) {
            return ((J2EEModule)this.deployedObject).getApplication();
        }
        return null;
    }

    public J2EEModule getJ2EEModule() {
        if (this.deployedObject instanceof J2EEModule) {
            return (J2EEModule)this.deployedObject;
        }
        return null;
    }

    public void setContextData(String key, Object value) {
        this.contextData.put(key, value);
    }

    public Object getContextData(String key) {
        return this.contextData.get(key);
    }

    public String getApplicationName() {
        return this.deployedObject.getApplicationName();
    }

    public String getModuleName() {
        if (this.deployedObject instanceof J2EEModule) {
            return ((J2EEModule)this.deployedObject).getAppModuleName();
        }
        return null;
    }

    public boolean isCompileOnlyMode() {
        return this.compileOnlyMode;
    }

    public void setCompileOnlyMode(boolean compileOnlyMode) {
        this.compileOnlyMode = compileOnlyMode;
    }

    public boolean isKeepGenerated() {
        return this.deployedObject.isKeepGenerated();
    }

    public FileArchive getClientViewHome() {
        return this.clientViewHome;
    }

    public void setClientViewHome(FileArchive clientViewHome) {
        this.clientViewHome = clientViewHome;
    }

    public EjbJarType getEjbJar() {
        return this.ejbJar;
    }

    public void setEjbJar(EjbJarType ejbJar) {
        this.ejbJar = ejbJar;
    }

    public JeusEjbDdType getJeusEjbDD() {
        return this.jeusEjbDd;
    }

    public void setJeusEjbDd(JeusEjbDdType jeusEjbDd) {
        this.jeusEjbDd = jeusEjbDd;
    }

    public String getSecurityDomainName() {
        return this.securityDomainName;
    }

    public void setSecurityDomainName(String securityDomainName) {
        this.securityDomainName = securityDomainName;
    }

    public EjbComponentType getEjbComponentType() {
        return this.ejbComponent;
    }

    public void setEjbComponentType(EjbComponentType ejbComponent) {
        this.ejbComponent = ejbComponent;
    }
}

