/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.deploy.JeusDeploymentException;
import jeus.deploy.ModuleTypeSerializable;
import jeus.deploy.TargetModuleIDImpl;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.InputJarArchive;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.deploy.io.EjbDeploymentDescriptorFile;
import jeus.deploy.io.runtime.EjbRuntimeDDFile;
import jeus.ejb.BeanContainer;
import jeus.ejb.EJB3Module;
import jeus.ejb.EJBEngine;
import jeus.ejb.ejbserver.FailedBeanInfo;
import jeus.ejb.metadata.BeanInfo;
import jeus.ejb.metadata.ModuleInfo;
import jeus.ejb.util.EJBRootClassLoader;
import jeus.management.JMXUtility;
import jeus.management.j2ee.EJB;
import jeus.management.j2ee.EJBModuleMBean;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEModule;
import jeus.management.j2ee.J2EEServer;
import jeus.security.base.Policy;
import jeus.security.container.ear.ApplicationSecurity;
import jeus.security.container.ejb.EJBSecurity;
import jeus.security.spi.LoginService;
import jeus.security.spi.PolicyNotExistsException;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.enginecontainer.EngineContainer;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.service.descriptor.DescriptorFile;
import jeus.service.library.ClassPathEntry;
import jeus.service.library.LibraryManager;
import jeus.service.library.LibraryNotFoundException;
import jeus.service.library.LibraryRef;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRuntimeException;
import jeus.util.StringUtil;
import jeus.util.file.FileUtils;
import jeus.util.message.JeusMessage_EJB8;
import jeus.util.message.JeusMessage_JMX;
import jeus.webservices.spi.EWSProvider;
import jeus.xml.binding.j2ee.EjbJarType;
import jeus.xml.binding.j2ee.Persistence;
import jeus.xml.binding.jeusDD.ClassFtpUnitType;
import jeus.xml.binding.jeusDD.EjbComponentType;
import jeus.xml.binding.jeusDD.JeusEjbDdType;
import jeus.xml.binding.jeusDD.LibraryRefType;
import jeus.xml.binding.jeusDD.SecurityPermissionType;

public class EJBModule
extends J2EEModule
implements EJBModuleMBean {
    protected Vector beans = new Vector();
    protected ArchiveArrayClassLoader loader;
    protected String loaderModuleName;
    protected EjbComponentType type;
    protected Vector webserviceModules = new Vector();
    protected boolean isStarted;
    protected String clientViewPath;
    protected List additionalModuleUris = Collections.EMPTY_LIST;
    protected boolean classFtpJarMode;
    protected Permission getejbsPermission;
    protected Permission getejbCountPermission;
    protected Permission getClientViewPathPermission;
    protected FileArchive appRoot;
    protected boolean isExploded;
    protected boolean compileOnly;
    private boolean prepared;
    private static final PermissionCollection defaultPermissions;
    protected EJB3Module module;
    protected EJBEngine ejbEngine = EJBEngine.getDefaultEngine();
    protected EjbJarType ejbJarDD;
    protected JeusEjbDdType jeusEjbDD;
    protected FileArchive generatedClassesDirArchive;

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        EJBModule object = new EJBModule(parent, target);
        return object.createMBean(mBeanName, "EJBModule", parent, parentKeyMap, null);
    }

    protected void makePermissions() {
        super.makePermissions();
        this.getejbCountPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getejbCount");
        this.getejbsPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getejbs");
        this.getClientViewPathPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getClientViewPath");
    }

    public EJBModule(ObjectName parent, Object _target) {
        super(parent);
    }

    public void addChild(ObjectName pChild) {
        LoginService.checkCodeSubject();
        String lType = JMXUtility.getJ2eeType(pChild);
        if ("EntityBean".equals(lType) || "StatelessSessionBean".equals(lType) || "StatefulSessionBean".equals(lType) || "MessageDrivenBean".equals(lType)) {
            this.beans.add(pChild);
        } else if ("WebModule".equals(lType)) {
            this.webserviceModules.add(pChild);
        }
        super.addChild(pChild);
    }

    public void removeChild(ObjectName pChild) {
        LoginService.checkCodeSubject();
        String lType = JMXUtility.getJ2eeType(pChild);
        if ("EntityBean".equals(lType) || "StatelessSessionBean".equals(lType) || "StatefulSessionBean".equals(lType) || "MessageDrivenBean".equals(lType)) {
            this.beans.remove(pChild);
        } else if ("WebModule".equals(lType)) {
            this.webserviceModules.remove(pChild);
        }
        super.removeChild(pChild);
    }

    public FileArchive getGeneratedClassesDirArchive() throws IOException {
        if (this.generatedClassesDirArchive == null) {
            this.generatedClassesDirArchive = (FileArchive)this.getModuleGenerationDirectoryArchive().getEmbeddedArchive("classes");
        }
        return this.generatedClassesDirArchive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        LoginUtil.checkPermissionWithCodeSubject(this.startPermission);
        try {
            super.startRecursive();
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    protected void preStart() throws Exception {
        if (this.isStarted) {
            this.module.resume();
        } else {
            this.module.start();
            this.isStarted = true;
        }
    }

    protected void preStop() throws Exception {
        this.module.suspend();
    }

    public String[] getejbs() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.getejbsPermission);
        return JMXUtility.getAsStringArray(this.beans);
    }

    public int getejbCount() {
        LoginUtil.checkPermissionWithRuntimeException(this.getejbCountPermission);
        return this.beans.size();
    }

    public String[] getFailedEjbs() {
        return new String[0];
    }

    public String getClientViewPath() {
        LoginUtil.checkPermissionWithRuntimeException(this.getClientViewPathPermission);
        return this.clientViewPath;
    }

    public String getURI() {
        return this.type == null ? null : this.type.getUri();
    }

    /*
     * Loose catch block
     */
    protected void undeployInternal(long gracefulTimeout) throws Exception {
        block20: {
            block18: {
                block17: {
                    ObjectName[] webModules;
                    for (ObjectName webModule : webModules = this.webserviceModules.toArray(new ObjectName[0])) {
                        try {
                            this.mbs.invoke(webModule, "undeploy", null, null);
                        }
                        catch (Exception ex) {
                            if (!logger.isLoggable(JeusMessage_JMX.JMX_24_LEVEL)) continue;
                            logger.log(JeusMessage_JMX.JMX_24_LEVEL, JeusMessage_JMX.JMX_24, (Object)webModule, (Throwable)ex);
                        }
                    }
                    if (this.module == null) break block17;
                    this.module.stop();
                    this.module.destroy(gracefulTimeout);
                }
                Object var10_9 = null;
                if (!this.isStandAloneModule()) break block20;
                try {
                    ApplicationSecurity.removePolicy(this.appPolicy, this.appType.getSecurityDomainName());
                }
                catch (PolicyNotExistsException ex) {
                    if (!logger.isLoggable(JeusMessage_JMX.JMX_26_LEVEL)) break block18;
                    logger.log(JeusMessage_JMX.JMX_26_LEVEL, JeusMessage_JMX.JMX_26, (Object)this.appPolicy, (Throwable)ex);
                }
            }
            if (!this.isIsolatedClassloading) {
                EngineContainer.rootClassLoader.remove(this.loaderModuleName);
            } else if (this.loader != null) {
                this.loader.clear();
            }
            break block20;
            {
                catch (Exception ex) {
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (this.isStandAloneModule()) {
                    block19: {
                        try {
                            ApplicationSecurity.removePolicy(this.appPolicy, this.appType.getSecurityDomainName());
                        }
                        catch (PolicyNotExistsException ex) {
                            if (!logger.isLoggable(JeusMessage_JMX.JMX_26_LEVEL)) break block19;
                            logger.log(JeusMessage_JMX.JMX_26_LEVEL, JeusMessage_JMX.JMX_26, (Object)this.appPolicy, (Throwable)ex);
                        }
                    }
                    if (!this.isIsolatedClassloading) {
                        EngineContainer.rootClassLoader.remove(this.loaderModuleName);
                    } else if (this.loader != null) {
                        this.loader.clear();
                    }
                }
                EJBSecurity.removeEJBSubjectsFromApp(this.appType.getSecurityDomainName(), this.getUniqueModuleName());
                throw throwable;
            }
        }
        EJBSecurity.removeEJBSubjectsFromApp(this.appType.getSecurityDomainName(), this.getUniqueModuleName());
    }

    public PermissionCollection getDefaultPermissions() {
        return defaultPermissions;
    }

    public void setComponentType(Object deployDesc) {
        this.type = (EjbComponentType)deployDesc;
    }

    public EjbJarType getEjbJarDD() {
        return this.ejbJarDD;
    }

    public JeusEjbDdType getJeusEjbDD() {
        return this.jeusEjbDD;
    }

    protected TargetModuleID deploy(Object deployDesc) throws Exception {
        this.isDeployed = true;
        this.myModuleID = new TargetModuleIDImpl(this.myObjectName, EngineContainer.serverMBean.getTarget());
        assert (this.path != null);
        if (this.appRoot == null) {
            this.appRoot = J2EEServer.getAppRootArchive(this.path);
        }
        this.deployEJB();
        return this.myModuleID;
    }

    public FailedBeanInfo[] compile(EjbComponentType type, FileArchive appRoot, String moduleUri) throws Exception {
        this.appRoot = appRoot;
        this.type = type;
        this.moduleUri = moduleUri;
        this.prepared = false;
        return this.deployEJB();
    }

    protected FailedBeanInfo[] deployEJB() throws JeusDeploymentException {
        assert (this.type != null);
        assert (this.moduleUri != null);
        this.additionalModuleUris = new ArrayList();
        this.pushDeploymentContext();
        try {
            if (this.appPolicy == null) {
                this.appPolicy = new Policy();
            }
            this.preDeploy();
            this.deployEJBExploded();
        }
        catch (JeusDeploymentException ex) {
            ex.setModuleName(this.getAppModuleName());
            throw ex;
        }
        finally {
            this.popDeploymentContext();
        }
        return new FailedBeanInfo[0];
    }

    public ModuleTypeSerializable getModuleType() {
        LoginUtil.checkPermissionWithRuntimeException(this.getModuleTypePermission);
        return ModuleTypeSerializable.EJB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preDeploy() throws JeusDeploymentException {
        if (this.prepared) {
            return;
        }
        assert (this.appRoot != null);
        assert (this.moduleUri != null);
        this.isExploded = FileUtils.isExploded((String)this.appRoot.getArchiveUri(), (String)this.moduleUri);
        try {
            String classFtpArchiveName;
            if (this.isExploded) {
                this.rootArchive = (FileArchive)this.appRoot.getEmbeddedArchive(this.moduleUri);
                classFtpArchiveName = FileUtils.getFileNameFromPath((String)this.moduleUri);
            } else {
                InputJarArchive archive = this.appRoot.getEmbeddedJarArchive(this.moduleUri);
                if (archive == null) {
                    throw new JeusRuntimeException("The " + this.moduleUri + " does not exist in the application");
                }
                try {
                    String rootPath = FileUtils.getExtractDirectoryName((String)this.moduleUri);
                    this.appRoot.deleteEntry(rootPath);
                    archive.extractArchive(this.appRoot, rootPath);
                    this.rootArchive = (FileArchive)this.appRoot.getEmbeddedArchive(rootPath);
                }
                finally {
                    archive.close();
                }
                classFtpArchiveName = FileUtils.getFileNameWithoutExtension((String)this.moduleUri);
            }
            if (this.classFtpJarMode) {
                this.rootArchive.setClassFtpArchiveName(classFtpArchiveName);
            }
            this.ejbJarDD = this.getEjbJar(this.type, this.rootArchive);
            this.jeusEjbDD = this.getJeusEjbDd(this.type, this.rootArchive, this.ejbJarDD);
            this.prepared = true;
        }
        catch (IOException e) {
            throw new JeusDeploymentException(e);
        }
    }

    protected void deployEJBExploded() throws JeusDeploymentException {
        boolean isSetAppPolicy = false;
        int isLoaderReleased = 0;
        try {
            EWSProvider provider;
            Persistence puDescriptor;
            FileArchive clientViewHome;
            String clientViewJarPath;
            this.clientViewPath = this.type.getClientViewPath();
            if (this.clientViewPath == null) {
                clientViewJarPath = this.moduleUri;
                if (this.isExploded) {
                    clientViewJarPath = clientViewJarPath + ".jar";
                }
                clientViewHome = this.compileOnly ? this.rootArchive : this.getGeneratedClassesDirArchive();
            } else {
                clientViewJarPath = this.clientViewPath + ".jar";
                if (!this.appRoot.contains(this.clientViewPath) && this.appRoot.contains(clientViewJarPath)) {
                    this.appRoot.getEmbeddedJarArchive(clientViewJarPath).extractArchive(this.appRoot, this.clientViewPath);
                }
                clientViewHome = (FileArchive)this.appRoot.getEmbeddedArchive(this.clientViewPath, true);
                this.additionalModuleUris.add(clientViewJarPath);
            }
            if (this.isStandAloneModule()) {
                LinkedHashMap<String, Object> classpathMap = new LinkedHashMap<String, Object>();
                classpathMap.put(this.moduleUri, this.rootArchive);
                if (this.clientViewPath != null) {
                    classpathMap.put(clientViewHome.getArchiveUri() + ".jar", clientViewHome);
                }
                if (!this.compileOnly) {
                    classpathMap.put("_generated_classes_", this.getGeneratedClassesDirArchive());
                }
                EJBModule.getClassPathLoaders(this.rootArchive, classpathMap);
                if (this.jeusEjbDD != null && this.jeusEjbDD.isSetLibraryRef()) {
                    LibraryManager libraryManager = LibraryManager.getInstance();
                    libraryManager.refresh();
                    for (LibraryRefType r : this.jeusEjbDD.getLibraryRef()) {
                        LibraryRef ref = new LibraryRef(r);
                        try {
                            List<ClassPathEntry> entries = libraryManager.getClassPathEntries(ref);
                            if (entries == null) continue;
                            for (ClassPathEntry entry : entries) {
                                try {
                                    classpathMap.put(entry.getPath(), entry.openArchive());
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        catch (LibraryNotFoundException ex) {
                            throw new JeusDeploymentException(ex.getMessage(), ex);
                        }
                    }
                }
                AbstractArchive[] classpathArchives = classpathMap.values().toArray(new AbstractArchive[classpathMap.size()]);
                this.loaderModuleName = this.appName;
                if (System.getSecurityManager() != null) {
                    ArrayList permissionsList = new ArrayList();
                    SecurityPermissionType permissionType = this.appType.getJavaSecurityPermission();
                    if (permissionType != null) {
                        this.addDescPermission(permissionType.getSecurityPermissionSpec(), permissionsList);
                    }
                    if ((permissionType = this.type.getJavaSecurityPermission()) != null) {
                        this.addDescPermission(permissionType.getSecurityPermissionSpec(), permissionsList);
                    }
                    PermissionCollection ejbPermissions = this.getPermissions(permissionsList, (ClassLoader)EngineContainer.rootClassLoader);
                    for (AbstractArchive loaderArchive : classpathArchives) {
                        loaderArchive.setCodeSource(this.codeSource);
                        loaderArchive.setPermissionCollection(ejbPermissions);
                    }
                }
                this.loader = ArchiveArrayClassLoader.createClassLoader(classpathArchives, EngineContainer.rootClassLoader, this.isIsolatedClassloading, this.appName);
                isLoaderReleased = 1;
            } else {
                this.loader = (ArchiveArrayClassLoader)this.appClassLoader;
            }
            assert (this.appType != null);
            String securityDomainName = this.appType.getSecurityDomainName();
            if (!this.compileOnly && (puDescriptor = this.getPersistenceDescriptor((AbstractArchive)this.rootArchive)) != null) {
                if (logger.isLoggable(JeusMessage_EJB8._5205_LEVEL)) {
                    logger.log(JeusMessage_EJB8._5205_LEVEL, JeusMessage_EJB8._5205);
                }
                this.addPersistenceUnits("", puDescriptor);
                this.loadPersistenceUnits();
            }
            if (this.rootArchive.contains("META-INF/webservices.xml") && (provider = EWSProvider.getProvider()) != null) {
                provider.writeJeusWebservicesDD((AbstractArchive)this.rootArchive);
            }
            this.deploymentContext.setCompileOnlyMode(this.compileOnly);
            this.deploymentContext.setSecurityDomainName(securityDomainName);
            this.deploymentContext.setEjbJar(this.ejbJarDD);
            this.deploymentContext.setJeusEjbDd(this.jeusEjbDD);
            this.deploymentContext.setClientViewHome(clientViewHome);
            this.deploymentContext.setEjbComponentType(this.type);
            this.module = EJB3Module.createAndDeploy();
            EJBSecurity.addEJBSubjectsToApp(securityDomainName, this.getUniqueModuleName(), clientViewHome.getArchiveUri() + File.separator + "META-INF");
            if (this.compileOnly || this.classFtpJarMode && !this.isFastDeploy) {
                if (clientViewHome.entries().hasMoreElements()) {
                    if (this.compileOnly) {
                        if (this.clientViewPath != null) {
                            this.makeClientViewFiles(clientViewHome, clientViewHome);
                        }
                        clientViewHome.jarArchive((AbstractArchive)this.appRoot, clientViewJarPath);
                    } else {
                        FileArchive clientViewArchive = (FileArchive)this.getModuleGenerationDirectoryArchive().getEmbeddedArchive("client_view");
                        FileUtils.copyDirectory((String)clientViewHome.getArchiveUri(), (String)clientViewArchive.getArchiveUri());
                        this.makeClientViewFiles(clientViewHome, clientViewArchive);
                        clientViewArchive.jarArchive((AbstractArchive)this.getModuleGenerationDirectoryArchive(), clientViewJarPath);
                        clientViewArchive.delete();
                        this.getGeneratedClassesDirArchive().setClassFtpArchiveName(FileUtils.getFileNameWithoutExtension((String)clientViewJarPath));
                    }
                } else if (logger.isLoggable(JeusMessage_EJB8._5204_LEVEL)) {
                    logger.log(JeusMessage_EJB8._5204_LEVEL, JeusMessage_EJB8._5204, (Object)this.module.getModuleName());
                }
            }
            if (!this.compileOnly) {
                this.installModule();
                if (this.isStandAloneModule()) {
                    if (!this.isIsolatedClassloading || !this.isFastDeploy) {
                        isLoaderReleased = 2;
                        this.loader.loadAllClasses();
                    }
                    if (!this.isIsolatedClassloading) {
                        EJBRootClassLoader.reloadWebContainer();
                    }
                    ApplicationSecurity.addPolicy(this.appPolicy, this.appType.getSecurityDomainName(), this.appType);
                    isSetAppPolicy = true;
                }
            }
        }
        catch (Throwable e) {
            block45: {
                if (isSetAppPolicy) {
                    try {
                        ApplicationSecurity.removePolicy(this.appPolicy, this.appType.getSecurityDomainName());
                    }
                    catch (Exception e1) {
                        if (!logger.isLoggable(JeusMessage_JMX.JMX_26_LEVEL)) break block45;
                        logger.log(JeusMessage_JMX.JMX_26_LEVEL, JeusMessage_JMX.JMX_26, (Object)this.appPolicy, (Throwable)e1);
                    }
                }
            }
            if (e instanceof JeusDeploymentException) {
                throw (JeusDeploymentException)e;
            }
            throw new JeusDeploymentException(e);
        }
        finally {
            if (isLoaderReleased == 1 && !this.isIsolatedClassloading) {
                this.loader.releaseLock();
            }
        }
    }

    public void makeClientViewFiles(FileArchive clientViewHome, FileArchive clientViewArchive) throws IOException {
        List<BeanInfo> beanList = this.module.getModuleInfo().getBeanList();
        for (BeanInfo beanInfo : beanList) {
            Vector<String> fileList = new Vector<String>();
            if (beanInfo.getEJBObjectImplClassName() != null) {
                fileList.add(beanInfo.getEJBObjectImplClassName());
                fileList.add(beanInfo.getEJBObjectImplClassName() + "_Skel");
                fileList.add(beanInfo.getEJBObjectImplClassName() + "_Stub");
            }
            if (beanInfo.getEJBHomeClassName() != null) {
                fileList.add(beanInfo.getEJBHomeImplClassName());
                fileList.add(beanInfo.getEJBHomeImplClassName() + "_Skel");
                fileList.add(beanInfo.getEJBHomeImplClassName() + "_Stub");
            }
            if (beanInfo.getEJBLocalHomeClassName() != null) {
                fileList.add(beanInfo.getEJBLocalHomeImplClassName());
                fileList.add(beanInfo.getEJBLocalObjectImplClassName());
            }
            if (beanInfo.getExportIIOP()) {
                if (beanInfo.getIIOPEJBHomeImplClassName() != null) {
                    fileList.add(beanInfo.getIIOPEJBHomeImplClassName());
                }
                if (beanInfo.getIIOPEJBObjectImplClassName() != null) {
                    fileList.add(beanInfo.getIIOPEJBObjectImplClassName());
                }
            }
            for (String fileName : fileList) {
                if ((fileName = fileName.replace('.', File.separatorChar)).indexOf("_Stub") == -1) {
                    clientViewArchive.deleteEntry(fileName + ".class");
                }
                clientViewArchive.deleteEntry(fileName + ".java");
            }
            String homeInterface = beanInfo.getEJBHomeClassName();
            String localHomeInterface = beanInfo.getEJBLocalHomeClassName();
            String remoteComponentInterface = beanInfo.getEJBObjectClassName();
            String localComponentInterface = beanInfo.getEJBLocalObjectClassName();
            Vector<String> interfaceList = new Vector<String>();
            if (homeInterface != null) {
                interfaceList.add(homeInterface);
            }
            if (localHomeInterface != null) {
                interfaceList.add(localHomeInterface);
            }
            if (remoteComponentInterface != null) {
                interfaceList.add(remoteComponentInterface);
            }
            if (localComponentInterface != null) {
                interfaceList.add(localComponentInterface);
            }
            for (String interfaceName : interfaceList) {
                File classFile = this.rootArchive.getFile(interfaceName = interfaceName.replace('.', File.separatorChar) + ".class");
                if (classFile == null) continue;
                File destFile = new File(clientViewArchive.getFile(), interfaceName);
                try {
                    FileUtils.copy((File)classFile, (File)destFile);
                }
                catch (IOException ex) {
                    if (!logger.isLoggable(JeusMessage_EJB8._5206_LEVEL)) continue;
                    logger.log(JeusMessage_EJB8._5206_LEVEL, JeusMessage_EJB8._5206, new Object[]{classFile, destFile}, (Throwable)ex);
                }
            }
        }
    }

    protected EjbJarType getEjbJar(EjbComponentType ejbComponent, FileArchive archive) throws JeusDeploymentException {
        EjbJarType ejbJar = null;
        InputStream ejbJarIs = null;
        try {
            String ejbJarPath = ejbComponent.getEjbJar();
            String descName = "ejb-jar";
            EjbDeploymentDescriptorFile ejbDescFile = new EjbDeploymentDescriptorFile();
            File ejbJarPathFile = EJBModule.getDescriptorFile(ejbJarPath, descName, archive, this.appName, ejbDescFile);
            if (ejbJarPathFile == null) {
                EjbJarType ejbJarType = null;
                return ejbJarType;
            }
            if (logger.isLoggable(JeusMessage_EJB8._5100_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5100_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5100);
            }
            ejbJarIs = new FileInputStream(ejbJarPathFile);
            ejbJar = (EjbJarType)ejbDescFile.getDeploymentDescriptor(ejbJarIs);
            if (logger.isLoggable(JeusMessage_EJB8._5101_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5101_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5101);
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_EJB8._5103_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5103_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5103);
            }
            throw new JeusDeploymentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB8._5102, (Object)archive.getArchiveUri()), e);
        }
        finally {
            if (ejbJarIs != null) {
                try {
                    ejbJarIs.close();
                }
                catch (IOException e) {}
            }
        }
        return ejbJar;
    }

    protected JeusEjbDdType getJeusEjbDd(EjbComponentType ejbComponent, FileArchive archive, EjbJarType ejbJar) throws JeusDeploymentException {
        JeusEjbDdType ejbDD = null;
        InputStream ejbDDIs = null;
        try {
            String ejbDDPath = ejbComponent.getJeusEjbDd();
            EjbRuntimeDDFile ejbDDFile = new EjbRuntimeDDFile();
            String descName = "jeus-ejb-dd";
            File descFile = EJBModule.getDescriptorFile(ejbDDPath, descName, archive, this.appName, ejbDDFile);
            if (descFile != null) {
                if (logger.isLoggable(JeusMessage_EJB8._5100_LEVEL)) {
                    logger.logp(JeusMessage_EJB8._5100_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5100);
                }
                ejbDDIs = new FileInputStream(descFile);
                ejbDD = (JeusEjbDdType)ejbDDFile.getDeploymentDescriptor(ejbDDIs);
                if (logger.isLoggable(JeusMessage_EJB8._5101_LEVEL)) {
                    logger.logp(JeusMessage_EJB8._5101_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5101);
                }
            } else {
                ejbDD = (JeusEjbDdType)ejbDDFile.newDeploymentDescriptor();
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_EJB8._5103_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5103_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5103);
            }
            throw new JeusDeploymentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB8._5102, (Object)archive.getArchiveUri()), e);
        }
        finally {
            if (ejbDDIs != null) {
                try {
                    ejbDDIs.close();
                }
                catch (IOException e) {}
            }
        }
        return ejbDD;
    }

    public static File getDescriptorFile(String descPath, String descriptorName, FileArchive moduleHome, String appName, DescriptorFile descriptorFile) {
        File file = null;
        if (descPath != null) {
            file = new File(descPath);
            if (!file.isAbsolute()) {
                throw new JeusRuntimeException(JeusMessage_JMX.JMX_28, (Object)descriptorName);
            }
            if (file.isDirectory()) {
                file = new File(file, descriptorName + "_" + appName + ".xml");
            }
            if (!file.exists()) {
                throw new JeusRuntimeException("The ejb-jar.xml in the specified path does not exist : " + file.getAbsolutePath());
            }
        } else if (moduleHome != null) {
            file = descriptorFile.getDeploymentDescriptorFile(moduleHome);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getClassPathLoaders(FileArchive archive, Map classpathMap) throws IOException {
        Attributes attribs;
        String classPaths;
        Manifest manifest = archive.getManifest();
        if (manifest != null && (classPaths = (attribs = manifest.getMainAttributes()).getValue(Attributes.Name.CLASS_PATH)) != null) {
            Vector<String> pathList = jeus.management.util.StringUtil.parseClasspathInManifest(classPaths);
            for (String path : pathList) {
                String classPath = archive.getArchiveUri() + File.separator + path;
                if (classpathMap.containsKey(classPath)) continue;
                AbstractArchive newArchive = null;
                try {
                    newArchive = JarArchiveFactory.openArchiveStatic((String)classPath);
                    classpathMap.put(newArchive.getArchiveUri(), newArchive);
                }
                finally {
                    if (newArchive != null) {
                        newArchive.close();
                    }
                }
            }
        }
    }

    public static File getEjbJarFile(String ejbJarPath, String descriptorName, FileArchive jarFileArchive, String appName, DescriptorFile descriptorFile) throws FileNotFoundException {
        File ejbJarPathFile;
        if (ejbJarPath != null) {
            ejbJarPathFile = new File(ejbJarPath);
            if (!ejbJarPathFile.isAbsolute()) {
                throw new JeusRuntimeException(JeusMessage_JMX.JMX_28, (Object)descriptorName);
            }
            if (ejbJarPathFile.isDirectory()) {
                ejbJarPathFile = new File(ejbJarPathFile, descriptorName + "_" + appName + ".xml");
            }
            if (!ejbJarPathFile.exists()) {
                throw new JeusRuntimeException("The ejb-jar.xml in the specified path does not exist : " + ejbJarPathFile.getAbsolutePath());
            }
        } else if (jarFileArchive != null) {
            ejbJarPathFile = descriptorFile.getDeploymentDescriptorFile(jarFileArchive);
            if (ejbJarPathFile == null || !ejbJarPathFile.exists()) {
                throw new JeusRuntimeException("The ejb-jar.xml in the archive path does not exist : " + jarFileArchive.getArchiveUri());
            }
        } else {
            throw new FileNotFoundException(ejbJarPath);
        }
        return ejbJarPathFile;
    }

    public void setClassLoader(ArchiveArrayClassLoader loader) {
        this.loader = loader;
    }

    private void installModule() {
        Map<String, BeanContainer> containerList = this.module.getContainerList();
        EJB mo = null;
        try {
            for (String beanName : containerList.keySet()) {
                BeanContainer container = containerList.get(beanName);
                mo = container.createMBean(this.myObjectName);
            }
        }
        catch (Exception ex) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_30, (Throwable)ex);
        }
    }

    public List getAdditionalModuleUris() {
        return this.additionalModuleUris;
    }

    public void setClassFtpMode(ClassFtpUnitType mode) {
        this.classFtpJarMode = mode == ClassFtpUnitType.JAR;
    }

    public void setForcedCompile(boolean forcedCompile) {
    }

    public Object getComponentType() {
        return this.type;
    }

    protected void setAdditionalNameProperties(Map prop) {
        prop.put("EJBEngine", EJBEngine.getDefaultEngine().getName());
        super.setAdditionalNameProperties(prop);
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public boolean isExploded() {
        return this.isExploded;
    }

    public void setCompileOnlyMode(boolean flag) {
        this.compileOnly = flag;
    }

    public boolean hasEJB(String beanName) {
        ModuleInfo moduleInfo = this.module.getModuleInfo();
        BeanInfo beanInfo = moduleInfo.getBeanInfo(beanName);
        return beanInfo != null;
    }

    public String getBeanJndiName(String beanName, String beanInterface, Boolean isRemote) {
        ModuleInfo moduleInfo = this.module.getModuleInfo();
        if (!StringUtil.isNullOrEmpty((String)beanName)) {
            BeanInfo beanInfo = moduleInfo.getBeanInfo(beanName);
            if (beanInfo != null) {
                return beanInfo.getJndiName(beanInterface, isRemote);
            }
        } else {
            for (BeanInfo beanInfo : moduleInfo.getBeanList()) {
                String jndiName = beanInfo.getJndiName(beanInterface, isRemote);
                if (jndiName == null) continue;
                return jndiName;
            }
        }
        return null;
    }

    public String getMessageDestinationJndiName(String msgDestName) {
        ModuleInfo moduleInfo = this.module.getModuleInfo();
        return moduleInfo.getMessageDestinationJndiName(msgDestName);
    }

    static {
        try {
            defaultPermissions = java.security.Policy.getPolicy().getPermissions(new CodeSource(new URL("file:/jeus/ejb/"), (Certificate[])null));
        }
        catch (MalformedURLException e) {
            throw new JeusRuntimeException((Throwable)e);
        }
    }
}

