/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import jeus.deploy.JeusDeploymentException;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.ModuleTypeSerializable;
import jeus.deploy.TargetModuleIDImpl;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.ArchiveHelper;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.archivist.InputJarArchive;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.deploy.io.AppClientDeploymentDescriptorFile;
import jeus.deploy.io.ApplicationDeploymentDescriptorFile;
import jeus.deploy.io.ConfigurationDeploymentDescriptorFile;
import jeus.deploy.io.ConnectorDeploymentDescriptorFile;
import jeus.deploy.io.DeploymentDescriptorFile;
import jeus.deploy.io.EjbDeploymentDescriptorFile;
import jeus.deploy.io.WebDeploymentDescriptorFile;
import jeus.deploy.io.runtime.AppClientRuntimeDDFile;
import jeus.deploy.io.runtime.ConnectorRuntimeDDFile;
import jeus.deploy.io.runtime.EjbRuntimeDDFile;
import jeus.deploy.io.runtime.WebRuntimeDDFile;
import jeus.ejb.util.EJBRootClassLoader;
import jeus.management.JMXUtility;
import jeus.management.j2ee.AppClientModule;
import jeus.management.j2ee.DeploymentException;
import jeus.management.j2ee.EJBModule;
import jeus.management.j2ee.J2EEApplicationMBean;
import jeus.management.j2ee.J2EEDeployedObject;
import jeus.management.j2ee.J2EEModule;
import jeus.management.j2ee.J2EEServer;
import jeus.management.j2ee.ResourceAdapterModule;
import jeus.management.j2ee.WebModule;
import jeus.management.util.StringUtil;
import jeus.security.base.Policy;
import jeus.security.container.ear.ApplicationSecurity;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.enginecontainer.EngineContainer;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.service.library.ClassPathEntry;
import jeus.service.library.LibraryManager;
import jeus.service.library.LibraryNotFoundException;
import jeus.service.library.LibraryRef;
import jeus.util.JeusException;
import jeus.util.JeusProperties;
import jeus.util.JeusRuntimeException;
import jeus.util.file.FileUtils;
import jeus.util.message.JeusMessage_JMX;
import jeus.util.properties.JeusAppProperties;
import jeus.xml.binding.ObjectFactoryHelper;
import jeus.xml.binding.j2ee.ObjectFactory;
import jeus.xml.binding.j2ee.PathType;
import jeus.xml.binding.j2ee.Persistence;
import jeus.xml.binding.j2ee.WebType;
import jeus.xml.binding.jeusDD.ApplicationType;
import jeus.xml.binding.jeusDD.ClassloadingType;
import jeus.xml.binding.jeusDD.ClientComponentType;
import jeus.xml.binding.jeusDD.ConnectorComponentType;
import jeus.xml.binding.jeusDD.DeploymentTypeType;
import jeus.xml.binding.jeusDD.EjbComponentType;
import jeus.xml.binding.jeusDD.JeusEjbDdType;
import jeus.xml.binding.jeusDD.LibraryRefType;
import jeus.xml.binding.jeusDD.SecurityPermissionType;
import jeus.xml.binding.jeusDD.WebComponentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2EEApplication
extends J2EEDeployedObject
implements J2EEApplicationMBean {
    public static final String DEFAULT_LIBRARY_DIRECTORY_PATH = "lib";
    public static final String APP_LIBRARY_DIRECTORY_PATH = "APP-INF/lib";
    public static final String APP_LIBRARY_CLASSES_PATH = "APP-INF/classes";
    private Vector mModules = new Vector();
    public static final String DEPLOY_TYPE_EAR = "EAR";
    public static final String DEPLOY_TYPE_EXPLODED_EAR = "EXPLODED_EAR";
    public static final String DEPLOY_TYPE_COMPONENT = "COMPONENT";
    private boolean isExploded;
    private String loaderModuleName;
    private Permission getModulesPermission;
    private static final PermissionCollection defaultPermissions;
    protected jeus.xml.binding.j2ee.ApplicationType applicationDescriptor;
    protected Map<String, J2EEModule> moduleTable = new HashMap<String, J2EEModule>();

    public static Object createMBean(String mBeanName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        J2EEApplication object = new J2EEApplication(parent, target);
        return object.createMBean(mBeanName, "J2EEApplication", parent, parentKeyMap, null);
    }

    private J2EEApplication(ObjectName parent, Object _target) {
        super(parent);
    }

    @Override
    protected void makePermissions() {
        super.makePermissions();
        this.getModulesPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getmodules");
    }

    @Override
    public String[] getmodules() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.getModulesPermission);
        return JMXUtility.getAsStringArray(this.mModules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void undeployInternal(long gracefulTimeout) throws Exception {
        Exception e122;
        block17: {
            try {
                ArrayList modules = new ArrayList(this.mModules);
                for (int i = modules.size() - 1; i >= 0; --i) {
                    ObjectName objectName = (ObjectName)modules.get(i);
                    try {
                        this.mbs.invoke(objectName, "undeploy", null, null);
                        continue;
                    }
                    catch (Throwable t) {
                        if (!logger.isLoggable(JeusMessage_JMX.JMX_31_LEVEL)) continue;
                        logger.log(JeusMessage_JMX.JMX_31_LEVEL, JeusMessage_JMX.JMX_31, new Object[]{objectName.getKeyProperty("name"), this.myNameString}, t);
                    }
                }
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Exception e122;
                block19: {
                    Object var8_7 = null;
                    try {
                        ApplicationSecurity.removePolicy(this.appPolicy, this.appType.getSecurityDomainName());
                    }
                    catch (Exception e122) {
                        if (!logger.isLoggable(JeusMessage_JMX.JMX_26_LEVEL)) break block19;
                        logger.log(JeusMessage_JMX.JMX_26_LEVEL, JeusMessage_JMX.JMX_26, (Object)this.appPolicy, (Throwable)e122);
                    }
                }
                try {
                    ApplicationSecurity.removeSubjects(this.appType.getSecurityDomainName(), this.loaderModuleName);
                }
                catch (Exception e122) {
                    // empty catch block
                }
                if (!this.isIsolatedClassloading) {
                    EngineContainer.rootClassLoader.remove(this.loaderModuleName);
                } else if (this.appClassLoader != null) {
                    ((ArchiveArrayClassLoader)this.appClassLoader).clear();
                }
                throw throwable;
            }
            try {
                ApplicationSecurity.removePolicy(this.appPolicy, this.appType.getSecurityDomainName());
            }
            catch (Exception e122) {
                if (!logger.isLoggable(JeusMessage_JMX.JMX_26_LEVEL)) break block17;
                logger.log(JeusMessage_JMX.JMX_26_LEVEL, JeusMessage_JMX.JMX_26, (Object)this.appPolicy, (Throwable)e122);
            }
        }
        try {
            ApplicationSecurity.removeSubjects(this.appType.getSecurityDomainName(), this.loaderModuleName);
        }
        catch (Exception e122) {
            // empty catch block
        }
        if (!this.isIsolatedClassloading) {
            EngineContainer.rootClassLoader.remove(this.loaderModuleName);
        } else if (this.appClassLoader != null) {
            ((ArchiveArrayClassLoader)this.appClassLoader).clear();
        }
    }

    public CodeSource getDefaultCodeSource() {
        return null;
    }

    @Override
    public PermissionCollection getDefaultPermissions() {
        return defaultPermissions;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.appClassLoader;
    }

    @Override
    public void addChild(ObjectName pChild) {
        LoginService.checkCodeSubject();
        String lType = JMXUtility.getJ2eeType(pChild);
        if ("EJBModule".equals(lType) || "WebModule".equals(lType) || "ResourceAdapterModule".equals(lType) || "AppClientModule".equals(lType)) {
            this.mModules.add(pChild);
            super.addChild(pChild);
        }
    }

    @Override
    public void removeChild(ObjectName pChild) {
        LoginService.checkCodeSubject();
        String lType = JMXUtility.getJ2eeType(pChild);
        if ("EJBModule".equals(lType) || "WebModule".equals(lType) || "ResourceAdapterModule".equals(lType) || "AppClientModule".equals(lType)) {
            this.mModules.remove(pChild);
            super.removeChild(pChild);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TargetModuleID deploy(Object deployDesc) throws Exception {
        block11: {
            this.isDeployed = true;
            ApplicationType appType = (ApplicationType)deployDesc;
            DeploymentTypeType deployType = JeusDeploymentManager.getApplicationDeploymentTypeType(appType);
            FileArchive earHomeArchive = null;
            this.myModuleID = new TargetModuleIDImpl(this.myObjectName, EngineContainer.serverMBean.getTarget());
            this.pushDeploymentContext();
            try {
                if (deployType == DeploymentTypeType.EAR) {
                    this.isExploded = JeusDeploymentManager.isExploded(appType);
                    if (this.isExploded) {
                        this.deployEARExploded(appType, false);
                    } else {
                        earHomeArchive = EngineContainer.getDeploymentHome();
                        this.deployEAR(earHomeArchive, appType, false);
                    }
                    break block11;
                }
                throw new IllegalArgumentException("The deployment description requests component deployments, not an application deployment");
            }
            finally {
                this.popDeploymentContext();
                if (earHomeArchive != null) {
                    try {
                        earHomeArchive.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return this.myModuleID;
    }

    @Override
    public ModuleTypeSerializable getModuleType() {
        LoginUtil.checkPermissionWithRuntimeException(this.getModuleTypePermission);
        return ModuleTypeSerializable.EAR;
    }

    public J2EEModule getModule(String moduleUri) {
        return this.moduleTable.get(moduleUri);
    }

    public EJBModule[] getEJBModules() {
        ArrayList<EJBModule> ejbs = new ArrayList<EJBModule>();
        for (J2EEModule module : this.moduleTable.values()) {
            if (!(module instanceof EJBModule)) continue;
            ejbs.add((EJBModule)module);
        }
        return ejbs.toArray(new EJBModule[ejbs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployEAR(FileArchive earHomeArchive, ApplicationType appType, boolean isOnlyGenerating) throws Exception {
        String earFileName = JeusDeploymentManager.getApplicationPath(appType);
        InputJarArchive earArchive = null;
        String earFileHome = null;
        String earTemp = null;
        try {
            try {
                earArchive = earHomeArchive.getEmbeddedJarArchive(earFileName);
            }
            catch (IOException e) {
                throw new JeusException(JeusMessage_JMX.JMX_33, (Object)earFileName, (Throwable)e);
            }
            if (earArchive == null) {
                throw new JeusException(JeusMessage_JMX.JMX_129, (Object)(earHomeArchive.getArchiveUri() + File.separator + earFileName));
            }
            earFileHome = FileUtils.getFileNameWithoutExtension((String)earFileName, (String)".ear");
            earHomeArchive.deleteEntry(earFileHome);
            earArchive.extractArchive(earHomeArchive, earFileHome);
            earTemp = earFileHome + "_temp_";
            earHomeArchive.deleteEntry(earTemp);
            earArchive.extractArchive(earHomeArchive, earTemp);
        }
        catch (Exception e) {
            File tempDir;
            if (earTemp != null && (tempDir = new File(earHomeArchive.getArchiveUri(), earTemp)).exists()) {
                tempDir.delete();
            }
            throw e;
        }
        finally {
            try {
                if (earArchive != null) {
                    earArchive.close();
                }
            }
            catch (IOException e) {}
        }
        FileArchive earFileArchive = null;
        FileArchive tempArchive = null;
        try {
            earFileArchive = (FileArchive)earHomeArchive.getEmbeddedArchive(earFileHome);
            List moduleList = this.deployModules(earFileArchive, earFileHome, appType, DEPLOY_TYPE_EAR);
            tempArchive = (FileArchive)earHomeArchive.getEmbeddedArchive(earTemp);
            for (Object module : moduleList) {
                String subModuleFileName = (String)module;
                File subModule = new File(earFileArchive.getArchiveUri() + File.separator + subModuleFileName);
                if (subModule.isDirectory()) {
                    FileUtils.copyDirectory((String)(earFileArchive.getArchiveUri() + File.separator + subModuleFileName), (String)(tempArchive.getArchiveUri() + File.separator + subModuleFileName));
                    continue;
                }
                InputStream is = null;
                OutputStream os = null;
                try {
                    is = earFileArchive.getEntry(subModuleFileName);
                    os = tempArchive.addEntry(subModuleFileName);
                    ArchiveHelper.copy((InputStream)is, (OutputStream)os);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    if (os == null) continue;
                    os.close();
                }
            }
            earArchive.delete();
            tempArchive.jarArchive((AbstractArchive)earHomeArchive, earFileName);
            tempArchive.delete();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (earFileArchive != null) {
                try {
                    earFileArchive.close();
                }
                catch (IOException e) {}
            }
            if (tempArchive != null) {
                try {
                    tempArchive.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private List deployModules(FileArchive earArchive, String earFileHome, ApplicationType appType, String deployType) throws Exception {
        if (EngineContainer.rootClassLoader == null) {
            throw new JeusException(JeusMessage_JMX._72);
        }
        this.setRootArchive(earArchive);
        boolean isSetAppPolicy = false;
        boolean isSetAppSubjects = false;
        int isLoaderReleased = 0;
        ArchiveArrayClassLoader loader = null;
        try {
            TargetModuleID childID;
            ClassloadingType classLoading;
            SecurityPermissionType permissionType;
            jeus.xml.binding.j2ee.ApplicationType app;
            this.appPolicy = new Policy();
            this.applicationDescriptor = app = this.getApplicationInfo((AbstractArchive)earArchive);
            this.setDeploymentDescriptor(this.readApplicationDescriptor((AbstractArchive)earArchive));
            this.setJeusDeploymentPlan("\n" + appType.strip2());
            this.fillApplicationComponents(appType, earArchive, app);
            PermissionCollection appPermissionCollection = null;
            if (System.getSecurityManager() != null && (permissionType = appType.getJavaSecurityPermission()) != null) {
                appPermissionCollection = this.getPermissions(permissionType.getSecurityPermissionSpec(), (ClassLoader)EngineContainer.rootClassLoader);
            }
            if ((classLoading = appType.getClassloading()) == null) {
                classLoading = ClassloadingType.valueOf((String)JeusAppProperties.DEFAULT_CLASSLOADING);
            }
            boolean isIsolated = classLoading == ClassloadingType.ISOLATED;
            this.setIsolatedClassloading(isIsolated);
            LinkedHashMap<String, AbstractArchive> classpathMap = new LinkedHashMap<String, AbstractArchive>();
            ArrayList<AbstractArchive> jarArchiveList = new ArrayList<AbstractArchive>();
            LinkedList<LibraryRef> libraryRefList = new LinkedList<LibraryRef>();
            LinkedList<AbstractArchive> classpathArchiveList = new LinkedList<AbstractArchive>();
            J2EEApplication.putAppLibraryDirectory(earArchive, classpathMap, APP_LIBRARY_CLASSES_PATH, false, this.codeSource, appPermissionCollection);
            J2EEApplication.putAppLibraryDirectory(earArchive, classpathMap, APP_LIBRARY_DIRECTORY_PATH, true, this.codeSource, appPermissionCollection);
            String libDirPath = appType.getLibraryDirectory();
            if (libDirPath == null) {
                libDirPath = DEFAULT_LIBRARY_DIRECTORY_PATH;
            }
            if (libDirPath.trim().equals("")) {
                libDirPath = "";
            } else {
                J2EEApplication.putAppLibraryDirectory(earArchive, classpathMap, libDirPath, true, this.codeSource, appPermissionCollection);
            }
            ArrayList<EJBModule> ejbModules = new ArrayList<EJBModule>();
            ArrayList<ResourceAdapterModule> raModules = new ArrayList<ResourceAdapterModule>();
            ArrayList<WebModule> webModules = new ArrayList<WebModule>();
            ArrayList<AppClientModule> appClientModules = new ArrayList<AppClientModule>();
            ArrayList<String> moduleList = new ArrayList<String>();
            List components = appType.getNameAndPathAndDeploymentType();
            for (JAXBElement componentElement : components) {
                String moduleUri;
                Object component = componentElement.getValue();
                if (component instanceof EjbComponentType) {
                    EjbComponentType ejbComponent = (EjbComponentType)component;
                    if (!J2EEServer.doesEJBEngineExists) {
                        throw new JeusRuntimeException(JeusMessage_JMX._72);
                    }
                    moduleUri = ejbComponent.getUri();
                    EJBModule ejbModule = (EJBModule)this.initializeMBean(ModuleType.EJB, moduleList, moduleUri, appType, earFileHome, deployType, earArchive);
                    ejbModules.add(ejbModule);
                    this.predeployEJBComponent(moduleUri, ejbModule, earArchive, isIsolated, classpathMap, appPermissionCollection, jarArchiveList, libraryRefList);
                    continue;
                }
                if (component instanceof ConnectorComponentType) {
                    ConnectorComponentType connectorComponent = (ConnectorComponentType)component;
                    moduleUri = connectorComponent.getUri();
                    ResourceAdapterModule raModule = (ResourceAdapterModule)this.initializeMBean(ModuleType.RAR, moduleList, moduleUri, appType, earFileHome, deployType, earArchive);
                    this.predeployConnectorComponent(raModule, appType, isIsolated, raModules, appPermissionCollection, classpathArchiveList);
                    continue;
                }
                if (component instanceof ClientComponentType) {
                    ClientComponentType clientComponent = (ClientComponentType)component;
                    moduleUri = clientComponent.getUri();
                    AbstractArchive appclientArchive = earArchive.getEmbeddedArchive(moduleUri);
                    AppClientModule clientModule = (AppClientModule)this.initializeMBean(ModuleType.CAR, moduleList, moduleUri, appType, earFileHome, deployType, earArchive);
                    appClientModules.add(clientModule);
                    this.predeployClientComponent(clientModule, appclientArchive, isIsolated, appPermissionCollection);
                    classpathMap.put(moduleUri, appclientArchive);
                    jarArchiveList.add(appclientArchive);
                    continue;
                }
                if (!(component instanceof WebComponentType)) continue;
                WebComponentType webComponent = (WebComponentType)component;
                if (!J2EEServer.doesWebEngineExists) {
                    throw new JeusRuntimeException(JeusMessage_JMX._117);
                }
                moduleUri = webComponent.getUri();
                WebModule webModule = (WebModule)this.initializeMBean(ModuleType.WAR, moduleList, moduleUri, appType, earFileHome, deployType, earArchive);
                webModules.add(webModule);
                webModule.setFastDeploy(appType.isFastDeploy());
                webModule.setKeepGenerated(webComponent.isKeepGenerated());
            }
            this.scanPersistenceUnits(earArchive, libDirPath, moduleList, classpathMap);
            for (AbstractArchive jarFileArchive : jarArchiveList) {
                J2EEApplication.getClasspathArchives(jarFileArchive, (AbstractArchive)earArchive, classpathMap);
            }
            classpathArchiveList.addAll(((HashMap)classpathMap).values());
            if (appType.isSetLibraryRef()) {
                for (LibraryRefType r : appType.getLibraryRef()) {
                    libraryRefList.add(new LibraryRef(r));
                }
            }
            LibraryManager libraryManager = LibraryManager.getInstance();
            if (libraryRefList.size() > 0) {
                libraryManager.refresh();
            }
            for (LibraryRef libraryRef : libraryRefList) {
                try {
                    List<ClassPathEntry> entries = libraryManager.getClassPathEntries(libraryRef);
                    if (entries == null) continue;
                    for (ClassPathEntry path : entries) {
                        try {
                            AbstractArchive archive = path.openArchive();
                            if (System.getSecurityManager() != null) {
                                archive.setCodeSource(this.codeSource);
                                archive.setPermissionCollection(appPermissionCollection);
                            }
                            classpathArchiveList.add(archive);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (LibraryNotFoundException ex) {
                    throw new JeusDeploymentException(ex.getMessage(), ex);
                }
            }
            this.loaderModuleName = earFileHome;
            loader = ArchiveArrayClassLoader.createClassLoader(classpathArchiveList.toArray(AbstractArchive.nullArray), EngineContainer.rootClassLoader, isIsolated, this.loaderModuleName);
            isLoaderReleased = 1;
            this.setAppClassLoader(loader);
            this.loadPersistenceUnits();
            try {
                for (ResourceAdapterModule raModule : raModules) {
                    if (!raModule.isStandaloneDeploy()) {
                        raModule.setAppClassLoader(loader);
                    }
                    if ((childID = raModule.deploy(null)) == null) continue;
                    this.myModuleID.addChildModuleID(childID);
                }
                for (EJBModule ejbModule : ejbModules) {
                    ejbModule.setAppClassLoader(loader);
                    childID = ejbModule.deploy(null);
                    if (childID != null) {
                        this.myModuleID.addChildModuleID(childID);
                    }
                    List additionalModuleList = ejbModule.getAdditionalModuleUris();
                    for (Object additionalModule : additionalModuleList) {
                        String module = (String)additionalModule;
                        module = module.substring(module.lastIndexOf(File.separator) + 1);
                        moduleList.add(module);
                    }
                }
            }
            catch (Throwable t) {
                loader.releaseLock();
                throw t;
            }
            if (!isIsolated) {
                isLoaderReleased = 2;
                loader.loadAllClasses();
            }
            if (!isIsolated) {
                EJBRootClassLoader.reloadWebContainer();
            }
            for (WebModule webModule : webModules) {
                webModule.setAppClassLoader(loader);
                webModule.setIsolatedClassloading(isIsolated);
                childID = webModule.deploy(null);
                if (childID == null) continue;
                this.myModuleID.addChildModuleID(childID);
            }
            for (AppClientModule mo : appClientModules) {
                mo.setAppClassLoader(loader);
                this.deployClientComponent(mo);
            }
            ApplicationSecurity.addSubjects(appType.getSecurityDomainName(), this.loaderModuleName, earArchive.getArchiveUri() + File.separator + "META-INF");
            isSetAppSubjects = true;
            ApplicationSecurity.addPolicy(this.appPolicy, appType.getSecurityDomainName(), appType);
            isSetAppPolicy = true;
            ArrayList<String> arrayList = moduleList;
            return arrayList;
        }
        catch (Throwable e) {
            block47: {
                if (isSetAppPolicy) {
                    try {
                        ApplicationSecurity.removePolicy(this.appPolicy, appType.getSecurityDomainName());
                    }
                    catch (Exception e1) {
                        if (!logger.isLoggable(JeusMessage_JMX.JMX_26_LEVEL)) break block47;
                        logger.log(JeusMessage_JMX.JMX_26_LEVEL, JeusMessage_JMX.JMX_26, (Object)this.appPolicy, (Throwable)e1);
                    }
                }
            }
            if (isSetAppSubjects) {
                try {
                    ApplicationSecurity.removeSubjects(appType.getSecurityDomainName(), this.loaderModuleName);
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            if (e instanceof JeusDeploymentException) {
                throw (JeusDeploymentException)e;
            }
            throw new JeusDeploymentException(e);
        }
        finally {
            if (isLoaderReleased == 1) {
                loader.releaseLock();
            }
        }
    }

    private jeus.xml.binding.j2ee.ApplicationType getApplicationInfo(AbstractArchive archive) throws Exception {
        jeus.xml.binding.j2ee.ApplicationType app;
        block8: {
            ApplicationDeploymentDescriptorFile file;
            block7: {
                file = new ApplicationDeploymentDescriptorFile();
                if (file.existsDescriptorFile(archive)) {
                    app = (jeus.xml.binding.j2ee.ApplicationType)file.getDeploymentDescriptor(archive);
                } else {
                    app = JeusDeploymentManager.makeApplicationInfo(archive);
                    try {
                        ObjectFactory of = ObjectFactoryHelper.getJ2EEObjectFactory();
                        file.marshalDescriptor((Object)of.createApplication(app), archive);
                    }
                    catch (Exception ex) {
                        if (!logger.isLoggable(Level.FINE)) break block7;
                        logger.log(Level.FINE, "Could not write back the generated application.xml descriptor", (Throwable)ex);
                    }
                }
            }
            if (JeusProperties.CTS_ENABLED) {
                try {
                    file.serializeDescriptor(app, archive);
                }
                catch (Exception ex) {
                    if (!logger.isLoggable(Level.FINE)) break block8;
                    logger.log(Level.FINE, "Could not write back the serialized application.xml descriptor", (Throwable)ex);
                }
            }
        }
        return app;
    }

    private String readApplicationDescriptor(AbstractArchive archive) throws Exception {
        ApplicationDeploymentDescriptorFile file = new ApplicationDeploymentDescriptorFile();
        if (file.existsDescriptorFile(archive)) {
            return file.getDescriptorString(archive);
        }
        return "";
    }

    private void predeployClientComponent(AppClientModule mo, AbstractArchive archive, boolean isolated, PermissionCollection appPermissionCollection) {
        mo.setFastDeploy(this.appType.isFastDeploy());
        mo.setIsolatedClassloading(isolated);
        CodeSource cs = mo.getCodeSource();
        PermissionCollection permissions = null;
        if (System.getSecurityManager() != null) {
            permissions = mo.getPermissions(null);
            J2EEApplication.addPermission(appPermissionCollection, permissions);
            archive.setCodeSource(cs);
            archive.setPermissionCollection(permissions);
        }
    }

    private void deployClientComponent(AppClientModule mo) throws Exception {
        TargetModuleID childID = mo.deploy(null);
        if (childID != null) {
            this.myModuleID.addChildModuleID(childID);
        }
    }

    private void predeployConnectorComponent(ResourceAdapterModule mo, ApplicationType appType, boolean isolated, List<ResourceAdapterModule> raModules, PermissionCollection appPermissionCollection, List<AbstractArchive> refJars) throws IOException {
        mo.setFastDeploy(appType.isFastDeploy());
        mo.setIsolatedClassloading(isolated);
        raModules.add(mo);
        List connectorArchives = mo.extract();
        CodeSource cs = mo.getCodeSource();
        PermissionCollection connectorPermissionCollection = null;
        if (System.getSecurityManager() != null) {
            connectorPermissionCollection = mo.getPermissions(null);
            J2EEApplication.addPermission(appPermissionCollection, connectorPermissionCollection);
            for (Object connectorArchive : connectorArchives) {
                AbstractArchive abstractArchive = (AbstractArchive)connectorArchive;
                abstractArchive.setCodeSource(cs);
                abstractArchive.setPermissionCollection(connectorPermissionCollection);
            }
        }
        refJars.addAll(connectorArchives);
    }

    private void predeployEJBComponent(String moduleUri, EJBModule ejbModule, FileArchive appRoot, boolean isolated, HashMap<String, AbstractArchive> classpathMap, PermissionCollection appPermissionCollection, List<AbstractArchive> jarArchiveList, List<LibraryRef> libraryRefList) throws JeusDeploymentException {
        ejbModule.setClassFtpMode(this.appType.getClassFtpUnit());
        ejbModule.setFastDeploy(this.appType.isFastDeploy());
        ejbModule.setIsolatedClassloading(isolated);
        ejbModule.appRoot = appRoot;
        EjbComponentType ejbComponentType = (EjbComponentType)ejbModule.getComponentType();
        ejbModule.setKeepGenerated(ejbComponentType.isKeepGenerated());
        ejbModule.preDeploy();
        String clientViewPath = ejbComponentType.getClientViewPath();
        boolean isExploded = ejbModule.isExploded();
        FileArchive moduleRoot = ejbModule.getRootArchive();
        FileArchive clientViewArchive = null;
        try {
            JeusEjbDdType jeusEjbDD;
            String archiveUri = moduleUri;
            if (isExploded) {
                archiveUri = archiveUri + ".jar";
            }
            if ((jeusEjbDD = ejbModule.getJeusEjbDD()) != null) {
                for (LibraryRefType l : jeusEjbDD.getLibraryRef()) {
                    libraryRefList.add(new LibraryRef(l));
                }
            }
            classpathMap.put(archiveUri, (AbstractArchive)moduleRoot);
            jarArchiveList.add((AbstractArchive)moduleRoot);
            CodeSource cs = ejbModule.getCodeSource();
            PermissionCollection ejbPermissionCollection = null;
            if (System.getSecurityManager() != null) {
                SecurityPermissionType permissionType;
                String ejbPermissionSpec = null;
                if (ejbComponentType != null && (permissionType = ejbComponentType.getJavaSecurityPermission()) != null) {
                    ejbPermissionSpec = permissionType.getSecurityPermissionSpec();
                }
                ejbPermissionCollection = ejbModule.getPermissions(ejbPermissionSpec, (ClassLoader)EngineContainer.rootClassLoader);
                J2EEApplication.addPermission(appPermissionCollection, ejbPermissionCollection);
                moduleRoot.setCodeSource(ejbModule.getCodeSource());
                moduleRoot.setPermissionCollection(ejbPermissionCollection);
            }
            if (clientViewPath != null && !classpathMap.containsValue(clientViewArchive = (FileArchive)appRoot.getEmbeddedArchive(clientViewPath))) {
                classpathMap.put(archiveUri + "_client", (AbstractArchive)clientViewArchive);
                if (System.getSecurityManager() != null) {
                    clientViewArchive.setCodeSource(cs);
                    clientViewArchive.setPermissionCollection(ejbPermissionCollection);
                }
            }
            FileArchive generatedClassesDir = ejbModule.getGeneratedClassesDirArchive();
            classpathMap.put(moduleUri + "_generated_classes_", (AbstractArchive)generatedClassesDir);
            if (System.getSecurityManager() != null) {
                generatedClassesDir.setCodeSource(cs);
                generatedClassesDir.setPermissionCollection(ejbPermissionCollection);
            }
        }
        catch (IOException ex) {
            if (clientViewArchive != null) {
                try {
                    clientViewArchive.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            throw new JeusDeploymentException(ex);
        }
    }

    private J2EEModule initializeMBean(ModuleType type, List moduleList, String moduleUri, ApplicationType appType, String earFileHome, String deployType, FileArchive earArchive) throws InstanceAlreadyExistsException, IOException, JAXBException {
        ConfigurationDeploymentDescriptorFile jeusDD;
        DeploymentDescriptorFile jarDD;
        J2EEModule mo;
        String moduleName;
        moduleList.add(moduleUri);
        if (type.equals(ModuleType.EJB)) {
            moduleName = FileUtils.getPathWithoutExtension((String)moduleUri, (String)".jar");
            Object deployDesc = this.getEjbComponentType(appType, moduleUri, earArchive);
            mo = (EJBModule)EJBModule.createMBean(moduleName, this.myObjectName, null);
            mo.setComponentType(deployDesc);
            jarDD = new EjbDeploymentDescriptorFile();
            jeusDD = new EjbRuntimeDDFile();
        } else if (type.equals(ModuleType.RAR)) {
            moduleName = FileUtils.getPathWithoutExtension((String)moduleUri, (String)".rar");
            Object deployDesc = this.getConnectorComponentType(appType, moduleUri, (AbstractArchive)earArchive);
            mo = (ResourceAdapterModule)ResourceAdapterModule.createMBean(moduleName, this.myObjectName, deployDesc, false);
            mo.setComponentType(deployDesc);
            jarDD = new ConnectorDeploymentDescriptorFile();
            jeusDD = new ConnectorRuntimeDDFile();
        } else if (type.equals(ModuleType.CAR)) {
            moduleName = FileUtils.getPathWithoutExtension((String)moduleUri, (String)".jar");
            Object deployDesc = this.getClientComponentType(appType, moduleUri, (AbstractArchive)earArchive);
            mo = (AppClientModule)AppClientModule.createMBean(moduleName, this.myObjectName, null);
            mo.setComponentType(deployDesc);
            jarDD = new AppClientDeploymentDescriptorFile();
            jeusDD = new AppClientRuntimeDDFile();
        } else if (type.equals(ModuleType.WAR)) {
            moduleName = FileUtils.getPathWithoutExtension((String)moduleUri, (String)".war");
            Object deployDesc = this.getWebComponentType(appType, moduleUri, (AbstractArchive)earArchive);
            mo = (WebModule)WebModule.createMBean(moduleName, this.myObjectName, null);
            mo.setComponentType(deployDesc);
            jarDD = new WebDeploymentDescriptorFile();
            jeusDD = new WebRuntimeDDFile(null);
        } else {
            throw new RuntimeException();
        }
        mo.setPath(earFileHome);
        mo.setDeployType(deployType);
        mo.setApplicationType(appType);
        mo.setAppPolicy(this.appPolicy);
        mo.setApplicationName(this.appName);
        mo.setAppModuleName(moduleName);
        mo.setApplication(this);
        mo.setModuleUri(moduleUri);
        String moduleFullPath = earArchive.getArchiveUri() + File.separator + moduleUri;
        mo.setDeploymentDescriptor(jarDD.getDescriptorString(moduleFullPath));
        mo.setJeusDeploymentPlan(jeusDD.getDescriptorString(moduleFullPath));
        this.moduleTable.put(moduleUri, mo);
        return mo;
    }

    private Object getEjbComponentType(ApplicationType appType, String ejbUri, FileArchive earArchive) throws JAXBException, IOException {
        EjbComponentType componentType;
        String existentEjbUri = ejbUri;
        String alternativeEjbUri = ejbUri.endsWith(".jar") ? FileUtils.getPathWithoutExtension((String)ejbUri, (String)".jar") : FileUtils.getPathWithExtension((String)ejbUri, (String)".jar");
        File ejbFile = new File(earArchive.getArchiveUri(), ejbUri);
        if (!ejbFile.exists()) {
            File alternativeEjbFile = new File(earArchive.getArchiveUri(), alternativeEjbUri);
            if (alternativeEjbFile.exists()) {
                existentEjbUri = alternativeEjbUri;
            } else {
                new RuntimeException("The ear does not contain the component " + ejbFile.getAbsolutePath() + " and " + alternativeEjbFile.getAbsolutePath());
            }
        }
        List appList = appType.getNameAndPathAndDeploymentType();
        for (JAXBElement application : appList) {
            Object component = application.getValue();
            if (!(component instanceof EjbComponentType) || !(componentType = (EjbComponentType)component).getUri().equals(ejbUri) && !componentType.getUri().equals(alternativeEjbUri)) continue;
            componentType.setUri(existentEjbUri);
            J2EEApplication.initEjbComponentType(componentType, appType);
            return componentType;
        }
        jeus.xml.binding.jeusDD.ObjectFactory objectFactory = new jeus.xml.binding.jeusDD.ObjectFactory();
        componentType = objectFactory.createEjbComponentType();
        componentType.setUri(existentEjbUri);
        J2EEApplication.initEjbComponentType(componentType, appType);
        appType.getNameAndPathAndDeploymentType().add(objectFactory.createApplicationTypeEjbComponent(componentType));
        return componentType;
    }

    public static void initEjbComponentType(EjbComponentType type, ApplicationType appType) {
        if (!type.isSetKeepGenerated()) {
            type.setKeepGenerated(appType.isKeepGenerated());
        }
    }

    private Object getClientComponentType(ApplicationType appType, String clientUri, AbstractArchive earFileArchive) throws JAXBException, IOException {
        ClientComponentType componentType;
        String existentUri = clientUri;
        String alternativeUri = clientUri.endsWith(".jar") ? FileUtils.getPathWithoutExtension((String)clientUri, (String)".jar") : FileUtils.getPathWithExtension((String)clientUri, (String)".jar");
        File clientFile = new File(earFileArchive.getArchiveUri(), clientUri);
        if (!clientFile.exists()) {
            File alternativeClientFile = new File(earFileArchive.getArchiveUri(), alternativeUri);
            if (alternativeClientFile.exists()) {
                existentUri = alternativeUri;
            } else {
                new RuntimeException("The ear does not contain the component " + clientFile.getAbsolutePath() + " and " + alternativeClientFile.getAbsolutePath());
            }
        }
        List appList = appType.getNameAndPathAndDeploymentType();
        for (JAXBElement application : appList) {
            Object component = application.getValue();
            if (!(component instanceof ClientComponentType) || !(componentType = (ClientComponentType)component).getUri().equals(clientUri) && !componentType.getUri().equals(alternativeUri)) continue;
            componentType.setUri(existentUri);
            return componentType;
        }
        jeus.xml.binding.jeusDD.ObjectFactory objectFactory = new jeus.xml.binding.jeusDD.ObjectFactory();
        componentType = objectFactory.createClientComponentType();
        componentType.setUri(existentUri);
        appType.getNameAndPathAndDeploymentType().add(objectFactory.createApplicationTypeClientComponent(componentType));
        return componentType;
    }

    private Object getConnectorComponentType(ApplicationType appType, String connetorUri, AbstractArchive earFileArchive) throws JAXBException, IOException {
        ConnectorComponentType componentType;
        String existentUri = connetorUri;
        String alternativeUri = connetorUri.endsWith(".rar") ? FileUtils.getPathWithoutExtension((String)connetorUri, (String)".rar") : FileUtils.getPathWithExtension((String)connetorUri, (String)".rar");
        File connectorFile = new File(earFileArchive.getArchiveUri(), connetorUri);
        if (!connectorFile.exists()) {
            File alternativeConnectorFile = new File(earFileArchive.getArchiveUri(), alternativeUri);
            if (alternativeConnectorFile.exists()) {
                existentUri = alternativeUri;
            } else {
                new RuntimeException("The ear does not contain the component " + connectorFile.getAbsolutePath() + " and " + alternativeConnectorFile.getAbsolutePath());
            }
        }
        List appList = appType.getNameAndPathAndDeploymentType();
        for (JAXBElement application : appList) {
            Object component = application.getValue();
            if (!(component instanceof ConnectorComponentType) || !(componentType = (ConnectorComponentType)component).getUri().equals(connetorUri) && !componentType.getUri().equals(alternativeUri)) continue;
            componentType.setUri(existentUri);
            return componentType;
        }
        jeus.xml.binding.jeusDD.ObjectFactory objectFactory = new jeus.xml.binding.jeusDD.ObjectFactory();
        componentType = objectFactory.createConnectorComponentType();
        componentType.setUri(existentUri);
        appType.getNameAndPathAndDeploymentType().add(objectFactory.createApplicationTypeConnectorComponent(componentType));
        return componentType;
    }

    private Object getWebComponentType(ApplicationType appType, String webUri, AbstractArchive earFileArchive) throws JAXBException, IOException {
        WebComponentType componentType;
        String existentUri = webUri;
        String alternativeUri = webUri.endsWith(".war") ? FileUtils.getPathWithoutExtension((String)webUri, (String)".war") : FileUtils.getPathWithExtension((String)webUri, (String)".war");
        File webFile = new File(earFileArchive.getArchiveUri(), webUri);
        if (!webFile.exists()) {
            File alternativeWebFile = new File(earFileArchive.getArchiveUri(), alternativeUri);
            if (alternativeWebFile.exists()) {
                existentUri = alternativeUri;
            } else {
                new RuntimeException("The ear does not contain the component " + webFile.getAbsolutePath() + " and " + alternativeWebFile.getAbsolutePath());
            }
        }
        List appList = appType.getNameAndPathAndDeploymentType();
        for (JAXBElement application : appList) {
            Object component = application.getValue();
            if (!(component instanceof WebComponentType) || !(componentType = (WebComponentType)component).getUri().equals(webUri) && !componentType.getUri().equals(alternativeUri)) continue;
            componentType.setUri(existentUri);
            J2EEApplication.initWebComponentType(componentType, appType);
            return componentType;
        }
        jeus.xml.binding.jeusDD.ObjectFactory objectFactory = new jeus.xml.binding.jeusDD.ObjectFactory();
        componentType = objectFactory.createWebComponentType();
        componentType.setUri(existentUri);
        componentType.setDeploymentTarget(objectFactory.createDeploymentTargetType());
        J2EEApplication.initWebComponentType(componentType, appType);
        appType.getNameAndPathAndDeploymentType().add(objectFactory.createApplicationTypeWebComponent(componentType));
        return componentType;
    }

    public static void initWebComponentType(WebComponentType type, ApplicationType appType) {
        if (!type.isSetKeepGenerated()) {
            type.setKeepGenerated(appType.isKeepGenerated());
        }
    }

    protected void deployEARExploded(ApplicationType appType, boolean isOnlyGenerating) throws Exception {
        String earFileHome = JeusDeploymentManager.getApplicationPath(appType);
        FileArchive earFileArchive = null;
        try {
            earFileArchive = (FileArchive)FileArchiveFactory.openArchiveStatic((String)earFileHome);
            this.deployModules(earFileArchive, earFileHome, appType, DEPLOY_TYPE_EAR);
        }
        catch (Exception e) {
            if (earFileArchive != null) {
                try {
                    earFileArchive.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static void putAppLibraries(FileArchive earFileArchive, HashMap<String, AbstractArchive> classpathMap) throws IOException {
        J2EEApplication.putAppLibraryDirectory(earFileArchive, classpathMap, APP_LIBRARY_CLASSES_PATH, false, null, null);
        J2EEApplication.putAppLibraryDirectory(earFileArchive, classpathMap, APP_LIBRARY_DIRECTORY_PATH, true, null, null);
    }

    static void putAppLibraryDirectory(FileArchive archive, HashMap<String, AbstractArchive> classpathMap, String dirPath, boolean includeJars, CodeSource cs, PermissionCollection pc) throws IOException {
        if (!archive.contains(dirPath)) {
            return;
        }
        FileArchive dirArchive = (FileArchive)archive.getEmbeddedArchive(dirPath);
        if (includeJars) {
            Enumeration enumeration = dirArchive.entries();
            while (enumeration.hasMoreElements()) {
                String entryName = (String)enumeration.nextElement();
                if (!entryName.endsWith(".jar")) continue;
                InputJarArchive entryArchive = dirArchive.getEmbeddedJarArchive(entryName);
                if (System.getSecurityManager() != null) {
                    entryArchive.setCodeSource(cs);
                    entryArchive.setPermissionCollection(pc);
                }
                classpathMap.put(dirPath + "/" + entryName, (AbstractArchive)entryArchive);
            }
        } else {
            if (System.getSecurityManager() != null) {
                dirArchive.setCodeSource(cs);
                dirArchive.setPermissionCollection(pc);
            }
            classpathMap.put(dirPath, (AbstractArchive)dirArchive);
        }
    }

    public static void getClasspathArchives(AbstractArchive archive, AbstractArchive outerArchive, HashMap<String, AbstractArchive> classpathMap) throws IOException {
        J2EEApplication.getClassPathLoaders(archive, outerArchive, classpathMap, archive.getCodeSource(), archive.getPermissionCollection(), null);
    }

    private static void getClassPathLoaders(AbstractArchive archive, AbstractArchive outerArchive, Map classpathMap, CodeSource cs, PermissionCollection pc, String parentPath) throws IOException {
        Manifest manifest = archive.getManifest();
        if (manifest != null) {
            String absolutePath = outerArchive.getArchiveUri();
            Attributes attribs = manifest.getMainAttributes();
            String classPath = attribs.getValue(Attributes.Name.CLASS_PATH);
            if (classPath != null) {
                Vector<String> pathList = StringUtil.parseClasspathInManifest(classPath);
                for (String path : pathList) {
                    String libName;
                    if (outerArchive.contains(path)) {
                        libName = absolutePath + File.separator + path;
                        if (classpathMap.containsKey(libName)) continue;
                        String pathPrefix = null;
                        int index = path.lastIndexOf(File.separator);
                        if (index == -1) {
                            index = path.lastIndexOf(47);
                        }
                        if (index > -1) {
                            pathPrefix = path.substring(0, index);
                        }
                        J2EEApplication.recursiveAddPath(libName, classpathMap, cs, pc, true, pathPrefix);
                        continue;
                    }
                    if (!archive.contains(path) || classpathMap.containsKey(libName = archive.getArchiveUri() + File.separator + path)) continue;
                    J2EEApplication.recursiveAddPath(libName, classpathMap, cs, pc, false, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recursiveAddPath(String path, Map classpathMap, CodeSource cs, PermissionCollection pc, boolean checkRecursive, String parentPath) throws IOException {
        if (!classpathMap.containsKey(path)) {
            AbstractArchive archive = null;
            try {
                archive = JarArchiveFactory.openArchiveStatic((String)path);
                String archivePath = archive.getArchiveUri();
                if (System.getSecurityManager() != null) {
                    archive.setCodeSource(cs);
                    archive.setPermissionCollection(pc);
                }
                classpathMap.put(archivePath, archive);
                if (checkRecursive) {
                    int index2;
                    int index1 = archivePath.lastIndexOf(47);
                    archivePath = archivePath.substring(0, index1 > (index2 = archivePath.lastIndexOf(File.separator)) ? index1 : index2);
                    J2EEApplication.getClassPathLoaders(archive, FileArchiveFactory.openArchiveStatic((String)archivePath), classpathMap, cs, pc, parentPath);
                }
            }
            finally {
                if (archive != null) {
                    archive.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        LoginUtil.checkPermissionWithCodeSubject(this.startPermission);
        try {
            this.startRecursive();
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    @Override
    protected void preStart() throws Exception {
    }

    private ApplicationType fillApplicationComponents(ApplicationType appType, FileArchive earArchive, jeus.xml.binding.j2ee.ApplicationType applicationInfo) {
        try {
            List modules = applicationInfo.getModule();
            for (Object module : modules) {
                String moduleUri;
                jeus.xml.binding.j2ee.ModuleType moduleInfo = (jeus.xml.binding.j2ee.ModuleType)module;
                PathType ejbType = moduleInfo.getEjb();
                PathType clientType = moduleInfo.getJava();
                WebType webType = moduleInfo.getWeb();
                PathType rarType = moduleInfo.getConnector();
                if (ejbType != null) {
                    moduleUri = ejbType.getValue();
                    this.getEjbComponentType(appType, moduleUri, earArchive);
                    continue;
                }
                if (clientType != null) {
                    moduleUri = clientType.getValue();
                    this.getClientComponentType(appType, moduleUri, (AbstractArchive)earArchive);
                    continue;
                }
                if (webType != null) {
                    PathType webPath = webType.getWebUri();
                    moduleUri = webPath.getValue();
                    WebComponentType webComponent = (WebComponentType)this.getWebComponentType(appType, moduleUri, (AbstractArchive)earArchive);
                    if (webComponent.isSetContextRoot()) continue;
                    webComponent.setContextRoot(webType.getContextRoot().getValue());
                    continue;
                }
                if (rarType == null) continue;
                moduleUri = rarType.getValue();
                this.getConnectorComponentType(appType, moduleUri, (AbstractArchive)earArchive);
            }
            if (!appType.isSetLibraryDirectory() && applicationInfo.isSetLibraryDirectory()) {
                appType.setLibraryDirectory(applicationInfo.getLibraryDirectory().getValue());
            }
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return appType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanPersistenceUnits(FileArchive earArchive, String libDirPath, List<String> moduleList, HashMap<String, AbstractArchive> classpathMap) throws DeploymentException {
        AbstractArchive subArchive;
        File earRoot = earArchive.getFile();
        for (String entry : earRoot.list()) {
            if (!entry.endsWith(".jar")) continue;
            boolean belongToModule = false;
            for (String moduleURI : moduleList) {
                if (!entry.equals(moduleURI)) continue;
                belongToModule = true;
                break;
            }
            if (belongToModule) continue;
            subArchive = null;
            try {
                subArchive = earArchive.getEmbeddedArchive(entry);
                Persistence puDescriptor = this.getPersistenceDescriptor(subArchive);
                if (puDescriptor == null) continue;
                if (logger.isLoggable(JeusMessage_JMX.JMX_133_LEVEL)) {
                    logger.log(JeusMessage_JMX.JMX_133_LEVEL, JeusMessage_JMX.JMX_133, (Object)entry);
                }
                this.addPersistenceUnits(entry, puDescriptor);
                classpathMap.put(entry, subArchive);
                subArchive = null;
            }
            catch (IOException ex) {
                throw new DeploymentException(ex);
            }
            finally {
                try {
                    if (subArchive != null) {
                        subArchive.close();
                    }
                }
                catch (IOException ex) {}
            }
        }
        if (!libDirPath.equals("")) {
            AbstractArchive libDirArchive = null;
            try {
                libDirArchive = earArchive.getEmbeddedArchive(libDirPath);
                Enumeration enumeration = libDirArchive.entries();
                while (enumeration.hasMoreElements()) {
                    String entry = (String)enumeration.nextElement();
                    subArchive = libDirArchive.getEmbeddedArchive(entry);
                    try {
                        Persistence puDescriptor = this.getPersistenceDescriptor(subArchive);
                        if (puDescriptor == null) continue;
                        String uri = libDirPath + "/" + entry;
                        if (logger.isLoggable(JeusMessage_JMX.JMX_133_LEVEL)) {
                            logger.log(JeusMessage_JMX.JMX_133_LEVEL, JeusMessage_JMX.JMX_133, (Object)uri);
                        }
                        this.addPersistenceUnits(uri, puDescriptor);
                    }
                    finally {
                        try {
                            subArchive.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (IOException ex) {
                throw new DeploymentException(ex);
            }
            finally {
                if (libDirArchive != null) {
                    try {
                        libDirArchive.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public boolean isExploded() {
        return this.isExploded;
    }

    static {
        try {
            defaultPermissions = java.security.Policy.getPolicy().getPermissions(new CodeSource(new URL("file:/jeus/app/"), (Certificate[])null));
        }
        catch (MalformedURLException e) {
            throw new JeusRuntimeException((Throwable)e);
        }
    }
}

