/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import jeus.deploy.TargetModuleIDImpl;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.io.PersistenceDescriptorFile;
import jeus.deploy.util.AutoDeployTask;
import jeus.management.JMXUtility;
import jeus.management.j2ee.DeploymentContext;
import jeus.management.j2ee.DeploymentException;
import jeus.management.j2ee.J2EEApplication;
import jeus.management.j2ee.J2EEDeployedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.J2EEModule;
import jeus.persistence.container.PersistenceUnit;
import jeus.persistence.container.PersistenceUnitNotFoundException;
import jeus.persistence.container.PersistenceUnits;
import jeus.security.base.Policy;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.enginecontainer.EngineContainer;
import jeus.service.archive.parser.PermissionParseException;
import jeus.service.archive.parser.PermissionParser;
import jeus.util.JeusRuntimeException;
import jeus.util.file.FileUtils;
import jeus.util.message.JeusMessage_JMX;
import jeus.util.properties.JeusAppProperties;
import jeus.xml.binding.j2ee.Persistence;
import jeus.xml.binding.jeusDD.ApplicationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class J2EEDeployedObject
extends J2EEManagedObjectSupport
implements J2EEDeployedObjectMBean {
    public static final int APPLICATION = 0;
    public static final int WEB = 1;
    public static final int EJB = 2;
    public static final int RAR = 3;
    public static final int JEUS_EJB = 4;
    public static final int JEUS_WEB = 5;
    private static final String[] sDescriptors = new String[]{"META-INF/application.xml", "WEB-INF/web.xml", "META-INF/ejb-jar.xml", "META-INF/ra.xml", "META-INF/jeus-ejb-dd_.xml", "WEB-INF/jeus-web-dd_.xml"};
    private static final Class[] STRING_CLASS = new Class[]{String.class};
    private static final Class[] TWO_STRING_CLASS = new Class[]{String.class, String.class};
    protected ObjectName serverObjectName;
    private AutoDeployTask autoDeployTask;
    protected TargetModuleIDImpl myModuleID;
    protected ApplicationType appType;
    private Permission readDescPermission;
    private Permission getServerPermission;
    private Permission getJeusDescPermission;
    private Permission getModuleIDPermission;
    protected Permission getModuleTypePermission;
    private Permission getApplicationTypePermission;
    private Permission isUndeployedPermission;
    private Permission undeployPermission;
    private Permission undeployForcedPermission;
    protected CodeSource codeSource;
    protected boolean isIsolatedClassloading;
    protected boolean isSystemApp;
    protected boolean isFastDeploy;
    protected boolean isKeepGenerated;
    protected boolean isDeployed;
    private boolean isUndeployed;
    protected FileArchive rootArchive;
    private FileArchive generationDirectoryArchive;
    protected String appName;
    protected Policy appPolicy;
    private String deploymentDescriptor = "";
    private String deploymentPlan;
    protected ClassLoader appClassLoader;
    protected Map<String, PersistenceUnits> persistenceUnits = new HashMap<String, PersistenceUnits>();
    protected DeploymentContext deploymentContext = new DeploymentContext(this);

    public J2EEDeployedObject(ObjectName parent) {
        super(parent);
    }

    public DeploymentContext getDeploymentContext() {
        return this.deploymentContext;
    }

    protected void pushDeploymentContext() {
        DeploymentContext.pushContext(this.deploymentContext);
    }

    protected void popDeploymentContext() {
        DeploymentContext.popContext();
    }

    @Override
    protected void postCreation(boolean pRegistrationDone) throws Exception {
        if (pRegistrationDone) {
            String appName;
            if (this.parentObjectName.getKeyProperty("j2eeType").equals("J2EEServer")) {
                appName = null;
                this.serverObjectName = this.parentObjectName;
            } else {
                String jeusType = this.parentObjectName.getKeyProperty("jeusType");
                if (jeusType != null && jeusType.equals("JeusManager")) {
                    appName = null;
                    this.serverObjectName = this.parentObjectName;
                } else {
                    appName = this.parentObjectName.getKeyProperty("name");
                    this.serverObjectName = new ObjectName((String)this.mbs.getAttribute(this.parentObjectName, "server"));
                }
            }
            if (appName == null) {
                this.permissionName = "jeus.management.app." + this.myNameString;
                if (System.getSecurityManager() != null) {
                    this.codeSource = new CodeSource(new URL("file:/jeus/app/" + this.myNameString + "/"), (Certificate[])null);
                }
            } else {
                this.permissionName = "jeus.management.app." + appName + "." + this.myNameString;
                if (System.getSecurityManager() != null) {
                    this.codeSource = new CodeSource(new URL("file:/jeus/app/" + appName + "/" + this.myNameString + "/"), (Certificate[])null);
                }
            }
        }
    }

    @Override
    public void destroyMBean() {
        this.destroyMBean(false);
    }

    public void destroyMBean(boolean forced) {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (!this.isUndeployed) {
                this.undeploy(forced);
            }
        }
        catch (Exception e) {
            logger.log(JeusMessage_JMX._84_LEVEL, JeusMessage_JMX._84, (Object)this.myObjectName, (Throwable)e);
        }
        super.destroyMBean();
    }

    @Override
    protected String initPermissionName() {
        J2EEManagedObjectMBean parent = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return parent.getPermissionName() + ".app." + this.getAppPath(".");
    }

    private String getAppPath(String pathSeparator) {
        String appName = this.myObjectName.getKeyProperty("J2EEApplication");
        if (appName == null || appName.equals("null")) {
            return this.myNameString;
        }
        return appName + pathSeparator + this.myNameString;
    }

    @Override
    protected void makePermissions() {
        super.makePermissions();
        this.readDescPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getdeploymentDescriptor");
        this.getServerPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getserver");
        this.getJeusDescPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getjeusDeploymentPlan");
        this.undeployPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"undeploy");
        this.undeployForcedPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"undeployForced");
        this.getModuleIDPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getTargetModuleID");
        this.getModuleTypePermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getModuleType");
        this.getApplicationTypePermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getApplicationType");
        this.isUndeployedPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"isUndeployed");
    }

    @Override
    public String getdeploymentDescriptor() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.readDescPermission);
        return this.deploymentDescriptor;
    }

    @Override
    public String getjeusDeploymentPlan() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.getJeusDescPermission);
        return this.deploymentPlan;
    }

    @Override
    public String getserver() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.getServerPermission);
        return this.serverObjectName.toString();
    }

    public void setDeploymentDescriptor(String desc) {
        this.deploymentDescriptor = desc;
    }

    public void setJeusDeploymentPlan(String plan) {
        this.deploymentPlan = plan;
    }

    protected abstract TargetModuleID deploy(Object var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        this.pushDeploymentContext();
        try {
            super.start();
        }
        finally {
            this.popDeploymentContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startRecursive() throws Exception {
        this.pushDeploymentContext();
        try {
            super.startRecursive();
        }
        finally {
            this.popDeploymentContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        this.pushDeploymentContext();
        try {
            super.stop();
        }
        finally {
            this.popDeploymentContext();
        }
    }

    public void setAutoDeployTask(AutoDeployTask autoDeployTask) {
        this.autoDeployTask = autoDeployTask;
        autoDeployTask.setDeployedObject(this);
    }

    @Override
    public boolean isUndeployed() {
        LoginUtil.checkPermissionWithRuntimeException(this.isUndeployedPermission);
        return this.isUndeployed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void undeploy(boolean forced) throws Exception {
        LoginUtil.checkPermissionWithCodeSubject(forced ? this.undeployForcedPermission : this.undeployPermission);
        try {
            this.undeployObject(forced, JeusAppProperties.DEFAULT_GRACEFUL_UNDEPLOYMENT_TIMEOUT);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void undeploy() throws Exception {
        LoginUtil.checkPermissionWithCodeSubject(this.undeployPermission);
        try {
            this.undeployObject(false, JeusAppProperties.DEFAULT_GRACEFUL_UNDEPLOYMENT_TIMEOUT);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void undeploy(int gracefulTimeout) throws Exception {
        LoginUtil.checkPermissionWithCodeSubject(this.undeployPermission);
        try {
            this.undeployObject(false, gracefulTimeout);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployObject(boolean forced, int gracefulTimeout) throws Exception {
        if (this.checkDeploy(forced)) {
            return;
        }
        this.pushDeploymentContext();
        try {
            this.undeployCommon();
            EngineContainer.serverMBean.sendNotification("jeus.deploy.preundeploy", "preundeploy", this.myObjectName);
            try {
                this.undeployInternal(gracefulTimeout * 1000);
            }
            finally {
                this.sendNotification("jeus.deploy.postundeploy", "postundeploy", this.myObjectName);
                this.destroyMBean();
            }
        }
        finally {
            this.popDeploymentContext();
        }
    }

    protected boolean checkDeploy(boolean forced) {
        if (this.isSystemApp && !forced) {
            throw new JeusRuntimeException(JeusMessage_JMX._83, (Object)this.myObjectName.toString());
        }
        if (this.isUndeployed) {
            logger.log(JeusMessage_JMX._77_LEVEL, JeusMessage_JMX._77, (Object)this.myObjectName);
            throw new JeusRuntimeException(JeusMessage_JMX._78, (Object)this.myObjectName.toString());
        }
        if (!this.isDeployed) {
            this.isUndeployed = true;
            this.destroyMBean();
            return true;
        }
        return false;
    }

    private void undeployCommon() throws MalformedObjectNameException {
        if (this.isEarAppNotUndeployed()) {
            TargetModuleID parentModuleID = this.getTargetModuleID().getParentTargetModuleID();
            throw new JeusRuntimeException("This module is a part of the application " + new ObjectName(parentModuleID.getModuleID()).getKeyProperty("name") + ", cannot undeploy this alone");
        }
        this.unloadPersistenceUnits();
        this.isUndeployed = true;
        if (logger.isLoggable(JeusMessage_JMX._76_LEVEL)) {
            logger.log(JeusMessage_JMX._76_LEVEL, JeusMessage_JMX._76, (Object)this.myObjectName);
        }
        if (this.autoDeployTask != null) {
            this.autoDeployTask.cancel();
        }
    }

    protected void undeployInternal(long gracefulTimeout) throws Exception {
    }

    public boolean isEarAppNotUndeployed() {
        try {
            TargetModuleID parentModuleID = this.getTargetModuleID().getParentTargetModuleID();
            return parentModuleID != null && (Boolean)JMXUtility.getAttributeWithTargetModuleID(this.mbs, parentModuleID, "Undeployed") == false;
        }
        catch (Exception ex) {
            throw new JeusRuntimeException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getDeploymentDescriptor(URL pJarUrl, int pType) {
        if (pJarUrl == null) {
            return "";
        }
        String lDD = null;
        Reader lInput = null;
        StringWriter lOutput = null;
        try {
            int lLength;
            if (pJarUrl.toString().endsWith(".xml")) {
                lInput = new InputStreamReader(pJarUrl.openStream());
            } else {
                URLClassLoader localCl = new URLClassLoader(new URL[]{pJarUrl});
                InputStream lStream = ((ClassLoader)localCl).getResourceAsStream(sDescriptors[pType]);
                if (lStream == null) {
                    String string = null;
                    return string;
                }
                lInput = new InputStreamReader(lStream);
            }
            lOutput = new StringWriter();
            char[] lBuffer = new char[1024];
            while ((lLength = lInput.read(lBuffer)) > 0) {
                lOutput.write(lBuffer, 0, lLength);
            }
            lDD = lOutput.toString();
        }
        catch (Exception e) {
        }
        finally {
            if (lInput != null) {
                try {
                    lInput.close();
                }
                catch (Exception e) {}
            }
            if (lOutput != null) {
                try {
                    lOutput.close();
                }
                catch (Exception e) {}
            }
        }
        return lDD;
    }

    public void setApplicationType(ApplicationType originalAppType) {
        this.appType = originalAppType;
    }

    @Override
    public ApplicationType getApplicationType() {
        LoginUtil.checkPermissionWithRuntimeException(this.getApplicationTypePermission);
        return this.appType;
    }

    protected PermissionCollection getPermissions(String permissionGrantStmt, ClassLoader loader) {
        if (System.getSecurityManager() != null) {
            try {
                Permission[] p = null;
                if (permissionGrantStmt != null) {
                    p = this.createPermissionsFromDescriptor(permissionGrantStmt, loader);
                }
                return this.getPermissions(p);
            }
            catch (Exception e) {
                throw new JeusRuntimeException((Throwable)e);
            }
        }
        return null;
    }

    protected PermissionCollection getPermissions(List permissionList, ClassLoader loader) {
        try {
            return this.getPermissions(permissionList.toArray(new Permission[permissionList.size()]));
        }
        catch (Exception e) {
            throw new JeusRuntimeException((Throwable)e);
        }
    }

    protected Permission[] createPermissionsFromDescriptor(String permissionGrantStmt, ClassLoader loader) throws PermissionParseException, InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        ArrayList list = PermissionParser.parse(permissionGrantStmt);
        Permission[] p = new Permission[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            GenericDeclaration c;
            String[] strings = (String[])list.get(i);
            if (strings[1] == null) {
                c = loader.loadClass(strings[0]);
                p[i] = (Permission)((Class)c).newInstance();
                continue;
            }
            if (strings[2] == null) {
                c = loader.loadClass(strings[0]).getConstructor(STRING_CLASS);
                p[i] = (Permission)((Constructor)c).newInstance(strings[1]);
                continue;
            }
            c = loader.loadClass(strings[0]).getConstructor(TWO_STRING_CLASS);
            p[i] = (Permission)((Constructor)c).newInstance(strings[1], strings[2]);
        }
        return p;
    }

    protected abstract PermissionCollection getDefaultPermissions();

    PermissionCollection getPermissions(Permission[] permissions) {
        PermissionCollection defaultPc = this.getDefaultPermissions();
        PermissionCollection appPc = java.security.Policy.getPolicy().getPermissions(this.codeSource);
        Permissions permissionCollection = new Permissions();
        J2EEDeployedObject.addPermission(appPc, permissionCollection);
        if (defaultPc != null && defaultPc.elements().hasMoreElements()) {
            J2EEDeployedObject.addPermission(defaultPc, permissionCollection);
        }
        if (permissions != null && permissions.length > 0) {
            for (int i = 0; i < permissions.length; ++i) {
                Permission permission = permissions[i];
                permissionCollection.add(permission);
            }
        }
        return permissionCollection;
    }

    protected static void addPermission(PermissionCollection source, PermissionCollection target) {
        if (source == null) {
            return;
        }
        Enumeration<Permission> e = source.elements();
        while (e.hasMoreElements()) {
            Permission permission = e.nextElement();
            target.add(permission);
        }
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    protected void addDescPermission(String permissionSpec, ArrayList permissionsList) throws PermissionParseException, InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Permission[] descPermissions = this.createPermissionsFromDescriptor(permissionSpec, EngineContainer.rootClassLoader);
        for (int i = 0; i < descPermissions.length; ++i) {
            Permission descPermission = descPermissions[i];
            permissionsList.add(descPermission);
        }
    }

    public void setIsolatedClassloading(boolean b) {
        this.isIsolatedClassloading = b;
    }

    @Override
    public boolean isIsolatedClassloading() {
        return this.isIsolatedClassloading;
    }

    public void setSystemApp(boolean systemApp) {
        this.isSystemApp = systemApp;
    }

    @Override
    public boolean getSystemApp() {
        return this.isSystemApp;
    }

    public boolean isFastDeploy() {
        return this.isFastDeploy;
    }

    public void setFastDeploy(boolean isFastDeploy) {
        this.isFastDeploy = isFastDeploy;
    }

    public boolean isKeepGenerated() {
        return this.isKeepGenerated;
    }

    public void setKeepGenerated(boolean isKeepGenerated) {
        this.isKeepGenerated = isKeepGenerated;
    }

    @Override
    public TargetModuleID getTargetModuleID() {
        LoginUtil.checkPermissionWithRuntimeException(this.getModuleIDPermission);
        return this.myModuleID;
    }

    @Override
    protected void setAdditionalNameProperties(Map prop) {
    }

    public FileArchive getRootArchive() {
        return this.rootArchive;
    }

    public void setRootArchive(FileArchive rootArchive) {
        this.rootArchive = rootArchive;
    }

    public ClassLoader getAppClassLoader() {
        return this.appClassLoader;
    }

    public void setAppClassLoader(ClassLoader loader) {
        this.appClassLoader = loader;
    }

    public abstract ClassLoader getClassLoader();

    protected void addPersistenceUnits(String puUri, Persistence puDescriptor) throws IOException {
        File puFile = puUri == null || puUri.equals("") ? new File(this.getRootArchive().getArchiveUri()) : new File(this.getRootArchive().getArchiveUri(), puUri.replace('/', File.separatorChar));
        PersistenceUnits pu = new PersistenceUnits(puUri, puFile, puDescriptor);
        this.persistenceUnits.put(puUri, pu);
    }

    protected PersistenceUnits getPersistenceUnits(String puUri) {
        return this.persistenceUnits.get(puUri);
    }

    protected Collection<PersistenceUnits> getAllPersistenceUnits() {
        return Collections.unmodifiableCollection(this.persistenceUnits.values());
    }

    public boolean isPersistenceUnitDeclared() {
        return this.persistenceUnits.size() > 0;
    }

    protected Persistence getPersistenceDescriptor(AbstractArchive puRootArchive) throws DeploymentException {
        PersistenceDescriptorFile descFile;
        Persistence persistence;
        block7: {
            persistence = null;
            descFile = new PersistenceDescriptorFile();
            if (descFile.existsDescriptorFile(puRootArchive)) break block7;
            Persistence persistence2 = null;
            return persistence2;
        }
        try {
            if (logger.isLoggable(JeusMessage_JMX.JMX_134_LEVEL)) {
                logger.log(JeusMessage_JMX.JMX_134_LEVEL, JeusMessage_JMX.JMX_134);
            }
            persistence = (Persistence)descFile.getDeploymentDescriptor(puRootArchive);
            logger.log(Level.FINE, "[persistence] persistence.xml is parsed successfully");
        }
        catch (Exception ex) {
            if (logger.isLoggable(JeusMessage_JMX.JMX_135_LEVEL)) {
                logger.log(JeusMessage_JMX.JMX_135_LEVEL, JeusMessage_JMX.JMX_135);
            }
            throw new DeploymentException(ex);
        }
        return persistence;
    }

    protected void loadPersistenceUnits() throws DeploymentException {
        try {
            for (String puUri : this.persistenceUnits.keySet()) {
                PersistenceUnits pu = this.getPersistenceUnits(puUri);
                String puPath = pu.getPersistenceUnitRootFile().getAbsolutePath();
                if (logger.isLoggable(JeusMessage_JMX.JMX_136_LEVEL)) {
                    logger.log(JeusMessage_JMX.JMX_136_LEVEL, JeusMessage_JMX.JMX_136, (Object)puPath);
                }
                pu.load(this.getClassLoader());
            }
        }
        catch (DeploymentException ex) {
            if (logger.isLoggable(JeusMessage_JMX.JMX_137_LEVEL)) {
                logger.log(JeusMessage_JMX.JMX_137_LEVEL, JeusMessage_JMX.JMX_137, (Throwable)ex);
            }
            throw ex;
        }
    }

    protected PersistenceUnit getPersistenceUnit(String unitName) throws PersistenceUnitNotFoundException {
        if (unitName == null || unitName.trim().equals("")) {
            Collection<PersistenceUnits> pus = this.getAllPersistenceUnits();
            if (pus.size() > 1) {
                throw new PersistenceUnitNotFoundException("There are more than one persistence unit. So unitName should be given");
            }
            PersistenceUnits pu = pus.iterator().next();
            Collection<PersistenceUnit> managers = pu.getPersistenceUnitCollection();
            if (managers.size() > 1) {
                throw new PersistenceUnitNotFoundException("There are more than one persistence unit. So unitName should be given");
            }
            if (managers.size() == 1) {
                return managers.iterator().next();
            }
        } else {
            PersistenceUnit emf = null;
            for (PersistenceUnits pu : this.getAllPersistenceUnits()) {
                emf = pu.getPersistenceUnit(unitName);
                if (emf == null) continue;
                return emf;
            }
        }
        return null;
    }

    protected void unloadPersistenceUnits() {
        if (this.isPersistenceUnitDeclared()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Destroying Persistence Units...");
            }
            for (PersistenceUnits pu : this.getAllPersistenceUnits()) {
                pu.close();
            }
        }
    }

    public String getApplicationName() {
        return this.appName;
    }

    public void setApplicationName(String name) {
        this.appName = name;
    }

    public Policy getAppPolicy() {
        return this.appPolicy;
    }

    protected void setAppPolicy(Policy appPolicy) {
        this.appPolicy = appPolicy;
    }

    public File getModuleGenerationDirectory() {
        File dir;
        if (this instanceof J2EEModule) {
            J2EEModule thisModule = (J2EEModule)this;
            J2EEApplication app = thisModule.getApplication();
            if (app != null) {
                String moduleDirPath = FileUtils.getExtractDirectoryName((String)thisModule.getModuleUri());
                dir = new File(app.getModuleGenerationDirectory(), moduleDirPath);
            } else {
                dir = new File(EngineContainer.container.getGeneratedModulesDirHome().getFile(), thisModule.getApplicationName());
            }
        } else {
            dir = new File(EngineContainer.container.getGeneratedAppsDirHome().getFile(), this.getApplicationName());
        }
        return dir;
    }

    public FileArchive getModuleGenerationDirectoryArchive() throws IOException {
        if (this.generationDirectoryArchive == null) {
            String dirPath = this.getModuleGenerationDirectory().getAbsolutePath();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Generation directory for " + this.getApplicationName() + " : " + dirPath);
            }
            this.generationDirectoryArchive = (FileArchive)FileArchiveFactory.createArchiveStatic((String)dirPath);
        }
        return this.generationDirectoryArchive;
    }

    protected void clearModuleGenerationDirectory() {
        File dir = this.getModuleGenerationDirectory();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Delete generation directory - " + dir);
        }
        FileUtils.whack((File)dir);
    }
}

