/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.zip.ZipOutputStream;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.ModuleInfo;
import jeus.deploy.ModuleTypeSerializable;
import jeus.deploy.TargetImpl;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.ArchiveHelper;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.archivist.InputJarArchive;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.deploy.archivist.OutputJarArchive;
import jeus.deploy.io.AppClientDeploymentDescriptorFile;
import jeus.deploy.io.ConfigurationDeploymentDescriptorFile;
import jeus.deploy.io.ConnectorDeploymentDescriptorFile;
import jeus.deploy.io.DeploymentDescriptorFile;
import jeus.deploy.io.EjbDeploymentDescriptorFile;
import jeus.deploy.io.WebDeploymentDescriptorFile;
import jeus.deploy.io.runtime.AppClientRuntimeDDFile;
import jeus.deploy.io.runtime.ConnectorRuntimeDDFile;
import jeus.deploy.io.runtime.EjbRuntimeDDFile;
import jeus.deploy.io.runtime.WebRuntimeDDFile;
import jeus.deploy.util.AutoDeployTask;
import jeus.deploy.util.ModuleTypeResolver;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.jeusserver.EngineContainerDescriptor;
import jeus.jndi.jns.common.JNS;
import jeus.jndi.jns.common.JeusNameClassPair;
import jeus.jndi.jns.common.NameEnumerationImpl;
import jeus.management.JMXManagerException;
import jeus.management.JMXUtility;
import jeus.management.j2ee.AppClientModule;
import jeus.management.j2ee.EJBModule;
import jeus.management.j2ee.J2EEApplication;
import jeus.management.j2ee.J2EEDeployedObject;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.J2EEModule;
import jeus.management.j2ee.J2EEServerMBean;
import jeus.management.j2ee.ResourceAdapterModule;
import jeus.management.j2ee.WebModule;
import jeus.security.base.Policy;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.NodeControllerStub;
import jeus.server.RootClassLoader;
import jeus.server.enginecontainer.EngineContainer;
import jeus.server.enginecontainer.EngineContainerException;
import jeus.server.manager.JeusVersion;
import jeus.server.service.JNDILocalInfo;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.bind.ContextDescriptorJB;
import jeus.tool.util.JarManager;
import jeus.util.CUtility;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.JNDIUtil;
import jeus.util.JeusProperties;
import jeus.util.JeusRootClassLoader;
import jeus.util.JeusRuntimeException;
import jeus.util.ScheduledExecutor;
import jeus.util.StringUtil;
import jeus.util.VirtualDNS;
import jeus.util.file.FileUtils;
import jeus.util.message.JeusMessage_JMX;
import jeus.util.properties.JeusAppProperties;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.xml.binding.BindingHelper;
import jeus.xml.binding.jeusDD.ApplicationType;
import jeus.xml.binding.jeusDD.AutoDeployType;
import jeus.xml.binding.jeusDD.ClassloadingType;
import jeus.xml.binding.jeusDD.ClientComponentType;
import jeus.xml.binding.jeusDD.ConnectorComponentType;
import jeus.xml.binding.jeusDD.ContextType;
import jeus.xml.binding.jeusDD.DeploymentTypeType;
import jeus.xml.binding.jeusDD.EjbComponentType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.WebComponentType;
import jeus.xml.binding.jeusDDHelper.JeusMainHelper;
import jeus.xml.binding.util.JAXBContextFactory;

public class J2EEServer
extends J2EEManagedObjectSupport
implements J2EEServerMBean {
    private Vector mDeployedObjects = new Vector();
    private Vector mJVMs = new Vector();
    private Vector mResources = new Vector();
    private static final TargetModuleID[] dummyDeployedObjectArray = new TargetModuleID[0];
    private String nodeName;
    private Vector mEngines = new Vector();
    private Vector services = new Vector();
    private EngineContainer container;
    public static final String[] STRING_JMX_PARAM = new String[]{"java.lang.String"};
    private TargetImpl target;
    private Permission getEnginesPermission;
    private Permission getjavaVMsPermission;
    private Permission getresourcesPermission;
    private Permission deployPermission;
    private Permission getApplicationTypePermission;
    private Permission getDistributedModulesPermission;
    private Permission getModulesPermission;
    private ResourcePermission getserverInfoPermission;
    private Permission getModuleDescriptorPermission;
    private Permission setModuleDescriptorPermission;
    private Permission getModulePathPermission;
    private List appHomeList;
    private ArrayList appArchiveList;
    public static final String ABSOLUTE_PATH = "absolute-path";
    public static final String SYSTEM_APP = "isSystemApp";
    public static final String APP_NAME = "app-name";
    public static boolean doesWebEngineExists;
    public static boolean doesEJBEngineExists;
    private static Set extensions;

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException, IOException {
        J2EEServer srvmbean = new J2EEServer(parent, target);
        return srvmbean.createMBean(srvName, "J2EEServer", parent, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String initPermissionName() throws JMXManagerException {
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            MBeanServerConnection msFacade = J2EEServer.getMEJBUtility();
            J2EEManagedObjectMBean parent = JMXUtility.getProxy(msFacade, this.parentObjectName, J2EEManagedObjectMBean.class, false);
            String string = parent.getPermissionName() + ".container." + JeusManagerPropertyValues.containerName;
            return string;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    protected void makePermissions() {
        super.makePermissions();
        this.getEnginesPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getEngines");
        this.getjavaVMsPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getjavaVMs");
        this.getresourcesPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getresources");
        this.getserverInfoPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getserverInfo");
        this.deployPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"deploy");
        this.getApplicationTypePermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getApplicationType");
        this.getDistributedModulesPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getDistributedModules");
        this.getModulesPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getModules");
        this.getModuleDescriptorPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getModuleDescriptor");
        this.setModuleDescriptorPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"setModuleDescriptor");
        this.getModulePathPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getModulePath");
    }

    private J2EEServer(ObjectName parentName, Object targetInput) throws IOException {
        this.nodeName = parentName.getKeyProperty("name");
        this.container = (EngineContainer)targetInput;
        this.appHomeList = this.container.getAppHomeList();
        this.appArchiveList = new ArrayList();
        for (Object anAppHomeList : this.appHomeList) {
            String path = (String)anAppHomeList;
            this.appArchiveList.add(FileArchiveFactory.appendArchive((String)path));
        }
    }

    protected void postCreation(boolean pRegistrationDone) throws Exception {
        this.target = new TargetImpl(this.myObjectName);
    }

    public void addChild(ObjectName pChild) {
        LoginService.checkCodeSubject();
        String lType = JMXUtility.getJ2eeType(pChild);
        if ("J2EEApplication".equals(lType) || "EJBModule".equals(lType) || "ResourceAdapterModule".equals(lType) || "WebModule".equals(lType) || "AppClientModule".equals(lType)) {
            this.mDeployedObjects.add(pChild);
            super.addChild(pChild);
        } else if ("JVM".equals(lType)) {
            this.mJVMs.add(pChild);
            super.addChild(pChild);
        } else if ("JNDIResource".equals(lType) || "JMSResource".equals(lType) || "URLResource".equals(lType) || "JavaMailResource".equals(lType) || "JDBCResource".equals(lType) || "JCAResource".equals(lType) || "JTAResource".equals(lType)) {
            this.mResources.add(pChild);
            super.addChild(pChild);
        } else {
            String jeusType = JMXUtility.getJeusType(pChild);
            if ("WebEngine".equals(jeusType) || "EJBEngine".equals(jeusType) || "JMSEngine".equals(jeusType) || "WSEngine".equals(jeusType)) {
                this.mEngines.add(pChild);
                if ("WebEngine".equals(jeusType)) {
                    doesWebEngineExists = true;
                } else if ("EJBEngine".equals(jeusType)) {
                    doesEJBEngineExists = true;
                }
                super.addChild(pChild);
            } else if ("JeusService".equals(lType)) {
                this.services.add(pChild);
                super.addChild(pChild);
            }
        }
    }

    public void removeChild(ObjectName pChild) {
        LoginService.checkCodeSubject();
        String lType = JMXUtility.getJ2eeType(pChild);
        if ("J2EEApplication".equals(lType) || "EJBModule".equals(lType) || "ResourceAdapterModule".equals(lType) || "WebModule".equals(lType) || "AppClientModule".equals(lType)) {
            this.mDeployedObjects.remove(pChild);
            super.removeChild(pChild);
        } else if ("JVM".equals(lType)) {
            this.mJVMs.remove(pChild);
            super.removeChild(pChild);
        } else if ("JNDIResource".equals(lType) || "JMSResource".equals(lType) || "URLResource".equals(lType) || "JavaMailResource".equals(lType) || "JDBCResource".equals(lType) || "JCAResource".equals(lType) || "JTAResource".equals(lType)) {
            this.mResources.remove(pChild);
            super.removeChild(pChild);
        } else {
            String jeusType = JMXUtility.getJeusType(pChild);
            if ("WebEngine".equals(jeusType) || "EJBEngine".equals(jeusType) || "JMSEngine".equals(jeusType) || "WSEngine".equals(jeusType)) {
                if ("WebEngine".equals(jeusType)) {
                    doesWebEngineExists = false;
                } else if ("EJBEngine".equals(jeusType)) {
                    doesEJBEngineExists = false;
                }
                this.mEngines.remove(pChild);
                super.removeChild(pChild);
            } else if ("JeusService".equals(lType)) {
                this.services.remove(pChild);
                super.removeChild(pChild);
            }
        }
    }

    public String getserverVersion() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.getserverInfoPermission);
        return JeusVersion.getVersion();
    }

    public String getserverVendor() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.getserverInfoPermission);
        return "TMAX SOFT";
    }

    public String[] getjavaVMs() {
        LoginUtil.checkPermissionWithRuntimeException(this.getjavaVMsPermission);
        return JMXUtility.getAsStringArray(this.mJVMs);
    }

    public String[] getresources() {
        LoginUtil.checkPermissionWithRuntimeException(this.getresourcesPermission);
        return JMXUtility.getAsStringArray(this.mResources);
    }

    public String[] getjeusServices() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.getserverInfoPermission);
        return JMXUtility.getAsStringArray(this.services);
    }

    public void down() throws EngineContainerException {
        LoginService.checkCodeSubject();
        try {
            this.container.down();
        }
        catch (Throwable t) {
            throw new EngineContainerException(JeusMessage_JMX.JMX_38, this.myNameString, t);
        }
    }

    public ObjectName[] getEngines() {
        LoginUtil.checkPermissionWithRuntimeException(this.getEnginesPermission);
        return this.mEngines.toArray(new ObjectName[this.mEngines.size()]);
    }

    public String[] getEnginesFromDescriptor() {
        LoginUtil.checkPermissionWithRuntimeException(this.getEnginesPermission);
        return this.container.getEngineNamesFromDescriptor();
    }

    public void checkAlive() {
    }

    public void startEngine(String engineName) throws EngineContainerException {
        if (logger.isLoggable(JeusMessage_JMX.JMX_131_LEVEL)) {
            logger.log(JeusMessage_JMX.JMX_131_LEVEL, JeusMessage_JMX.JMX_131);
        }
        throw new EngineContainerException(JeusMessage_JMX.JMX_131);
    }

    public void downEngine(String engineName) throws EngineContainerException {
        if (logger.isLoggable(JeusMessage_JMX.JMX_131_LEVEL)) {
            logger.log(JeusMessage_JMX.JMX_131_LEVEL, JeusMessage_JMX.JMX_131);
        }
        throw new EngineContainerException(JeusMessage_JMX.JMX_131);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleTypeSerializable getModuleType(String absolutePath, String moduleName) throws IOException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.getserverInfoPermission);
        AbstractArchive archive = null;
        try {
            File subFile;
            if (absolutePath != null) {
                subFile = new File(absolutePath);
                if (!subFile.exists()) {
                    throw new JeusRuntimeException("The absolute path " + absolutePath + " does not exist");
                }
            } else {
                subFile = this.getFileFromAppHome(moduleName);
                if (subFile == null) {
                    throw new JeusRuntimeException("The module " + moduleName + " does not exist");
                }
            }
            archive = subFile.isDirectory() ? FileArchiveFactory.openArchiveStatic((File)subFile) : JarArchiveFactory.openArchiveStatic((File)subFile);
            ModuleTypeSerializable moduleTypeSerializable = JeusDeploymentManager.getModuleTypeSerializable(archive);
            return moduleTypeSerializable;
        }
        finally {
            if (archive != null) {
                archive.close();
            }
        }
    }

    public File getFileFromAppHome(String moduleName) {
        for (int i = 0; i < this.appArchiveList.size(); ++i) {
            FileArchive fileArchive = (FileArchive)this.appArchiveList.get(i);
            File returnFile = fileArchive.getFile(moduleName);
            if (returnFile == null) continue;
            return returnFile;
        }
        return null;
    }

    public String[] getdeployedObjects() {
        LoginUtil.checkPermissionWithRuntimeException(this.getModulesPermission);
        return JMXUtility.getAsStringArray(this.mDeployedObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID deployWebContext(String contextGroup, String context, String docbase) throws Exception {
        LoginUtil.checkPermissionWithCodeSubject(this.deployPermission);
        try {
            this.container.getEngineList();
            ObjectName engineName = null;
            for (Object mEngine : this.mEngines) {
                ObjectName objName = (ObjectName)mEngine;
                String name = objName.getKeyProperty("name");
                if (name.indexOf("_servlet_") <= 0) continue;
                engineName = objName;
                break;
            }
            if (engineName == null) {
                throw new Exception("Web Engine not found");
            }
            if ((docbase = docbase.replaceAll("/", File.separator)).endsWith(File.separator)) {
                docbase = docbase.substring(0, docbase.length() - 1);
            }
            String webInfPath = docbase + File.separator + "WEB-INF" + File.separator + "jeus-web-dd.xml";
            String webEngPath = JeusProperties.JEUS_CONFIG_HOME + File.separator + this.nodeName + File.separator + engineName.getKeyProperty("name") + File.separator + "jeus-web-dd_" + context + ".xml";
            JAXBContext jaxbctx = JAXBContextFactory.getContext("jeus.xml.binding.jeusDD");
            Unmarshaller unmarshaller = jaxbctx.createUnmarshaller();
            File webDDFile = new File(webInfPath);
            ContextType webDD = null;
            int i = docbase.lastIndexOf(File.separator);
            if (i >= 0) {
                String path = docbase.substring(i + 1);
            } else {
                String path = docbase;
            }
            if (!webDDFile.exists() && !(webDDFile = new File(webEngPath)).exists()) {
                ObjectFactory objFact = new ObjectFactory();
                webDD = objFact.createContextType();
                webDD.setContextPath("/" + context);
            }
            if (webDD == null && webDDFile.exists()) {
                webDD = (ContextType)((JAXBElement)unmarshaller.unmarshal(webDDFile)).getValue();
                webDD.setContextPath("/" + context);
            }
            webDDFile = new File(webInfPath);
            webDDFile.delete();
            ObjectFactory fac = new ObjectFactory();
            String xmldoc = BindingHelper.marshalDescriptor(fac.createJeusWebDd(webDD), "jeus.xml.binding.jeusDD");
            BufferedOutputStream ddOut = new BufferedOutputStream(new FileOutputStream(webDDFile));
            ddOut.write(xmldoc.getBytes());
            ddOut.flush();
            ddOut.close();
            File warDir = ((FileArchive)this.appArchiveList.get(0)).getFile();
            warDir.mkdirs();
            File warFile = new File(warDir, context + ModuleType.WAR.getModuleExtension());
            JarManager.jar(warFile, docbase);
            webDDFile.delete();
            xmldoc = BindingHelper.marshalDescriptor(fac.createJeusWebDd(webDD), "jeus.xml.binding.jeusDD");
            ddOut = new BufferedOutputStream(new FileOutputStream(webDDFile));
            ddOut.write(xmldoc.getBytes());
            ddOut.flush();
            ddOut.close();
            MBeanServerConnection msFacade = J2EEServer.getMEJBUtility();
            if (contextGroup == null) {
                Vector groupNames = (Vector)msFacade.getAttribute(engineName, "ContextGroupNames");
                contextGroup = (String)groupNames.get(0);
            }
            ContextDescriptor ctxDesc = ContextDescriptorJB.getContextDescriptor(context, null, docbase + File.separator + "WEB-INF", true);
            TargetModuleID targetModuleID = (TargetModuleID)msFacade.invoke(engineName, "deployContext", new Object[]{contextGroup, null, ctxDesc, null}, new String[]{String.class.getName(), String.class.getName(), ContextDescriptor.class.getName(), Policy.class.getName()});
            return targetModuleID;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TargetModuleID deploy(String node, String src, ApplicationType appType) throws Exception {
        LoginUtil.checkPermissionWithCodeSubject(this.deployPermission);
        File srcFile = new File(src.substring(4));
        if (srcFile.isDirectory()) {
            throw new IllegalArgumentException("Automatic source distibute of exploded module is not permitted.");
        }
        try {
            File baseDir = ((FileArchive)this.appArchiveList.get(0)).getFile();
            if (!baseDir.exists()) {
                baseDir.mkdirs();
            }
            File destFile = new File(baseDir, srcFile.getName());
            if (!this.nodeName.equals(node) || !destFile.equals(srcFile)) {
                NodeControllerStub ncStub = new NodeControllerStub();
                ncStub.connectTo(VirtualDNS.getRealNodeName(node));
                ncStub.rftp(src, destFile.getPath());
                ncStub.disconnect();
                ncStub.close();
            }
            if (!destFile.exists()) {
                throw new FileNotFoundException(destFile.getName());
            }
            appType = (ApplicationType)appType.cloneType();
            JeusDeploymentManager.setApplicationPath(appType, destFile.getPath());
            TargetModuleID targetModuleID = this.deploy(appType);
            return targetModuleID;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TargetModuleID deploy(ApplicationType appType) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "deploy the following application : " + appType.strip2());
        }
        LoginUtil.checkPermissionWithCodeSubject(this.deployPermission);
        if (JeusDeploymentManager.getApplicationPath(appType) != null) {
            JeusDeploymentManager.setApplicationPath(appType, StringUtil.normalizeFileSeparator((String)JeusDeploymentManager.getApplicationPath(appType)));
        }
        try {
            appType = (ApplicationType)appType.cloneType();
            String type = JeusDeploymentManager.getApplicationDeploymentTypeType(appType).value();
            boolean isEAR = type.equals("EAR");
            List appList = appType.getNameAndPathAndDeploymentType();
            boolean isSystemApp = false;
            Object o = appType.getInfoMap().get(SYSTEM_APP);
            if (o != null) {
                isSystemApp = (Boolean)o;
            }
            this.setPathWithAppHomes(appType);
            if (type.equals("COMPONENT")) {
                this.setUriForComponentType(appType);
            }
            AutoDeployType autoDeployType = appType.getAutoDeploy();
            AutoDeployTask autoDeployTask = null;
            if (JeusDeploymentManager.getApplicationPath(appType) != null && autoDeployType != null && autoDeployType.isCheckAbsolutePath() != null && autoDeployType.isSetCheckAbsolutePath() && autoDeployType.isCheckAbsolutePath().booleanValue()) {
                autoDeployTask = new AutoDeployTask(appType);
            }
            ApplicationType originalAppType = appType;
            this.copyArchiveForAbsolutePath(appType);
            if (!appType.isSetFastDeploy()) {
                appType.setFastDeploy(Boolean.valueOf(JeusAppProperties.APP_FAST_DEPLOY));
            }
            boolean fastDeploy = appType.isFastDeploy();
            if (!appType.isSetKeepGenerated()) {
                appType.setKeepGenerated(Boolean.valueOf(JeusAppProperties.APP_KEEP_GENERATED));
            }
            boolean keepGenerated = appType.isKeepGenerated();
            EngineContainerDescriptor.setContextGroup(appType, JeusMainDescriptorJB.getContextGroupName(appType.getDeploymentTarget()), keepGenerated);
            TargetModuleID moduleId = null;
            J2EEDeployedObject deployedMBean = null;
            String appName = JeusDeploymentManager.getApplicationName(appType);
            if (appName == null && (appName = JeusDeploymentManager.getNameFromPath(appType)) == null) {
                throw new JeusRuntimeException("The name of application is null.");
            }
            if (this.isAppNameAlreadyUsed(appName)) {
                throw new JeusRuntimeException("The name of application is already used by another application : " + appName);
            }
            if (isEAR) {
                J2EEApplication appMBean;
                try {
                    appMBean = (J2EEApplication)J2EEApplication.createMBean(appName, this.myObjectName, null);
                }
                catch (InstanceAlreadyExistsException ex) {
                    String message = ex.getMessage();
                    ObjectName connectorObject = new ObjectName(message);
                    if (connectorObject.getKeyProperty("name").equals("lifecycle_ejb_vehicle")) {
                        this.mbs.invoke(new ObjectName(message), "undeploy", null, null);
                        appMBean = (J2EEApplication)J2EEApplication.createMBean(JeusDeploymentManager.getNameFromPath(appType), this.myObjectName, null);
                    }
                    throw new JeusRuntimeException(JeusMessage_JMX.JMX_40, (Object)appName, (Throwable)ex);
                }
                deployedMBean = appMBean;
                appMBean.setApplicationName(appName);
                appMBean.setSystemApp(isSystemApp);
                if (autoDeployTask != null) {
                    appMBean.setAutoDeployTask(autoDeployTask);
                }
                appMBean.setApplicationType(originalAppType);
                appMBean.setFastDeploy(fastDeploy);
                this.sendNotification("jeus.deploy.predeploy", "predeploy", deployedMBean.getObjectName());
                try {
                    this.postInitJ2EEApplication(appMBean);
                    moduleId = appMBean.deploy(appType);
                }
                catch (Exception ex) {
                    if (logger.isLoggable(JeusMessage_JMX.JMX_41_LEVEL)) {
                        logger.log(JeusMessage_JMX.JMX_41_LEVEL, JeusMessage_JMX.JMX_41, (Object)appName, (Throwable)ex);
                    }
                    try {
                        appMBean.destroyMBean();
                    }
                    catch (Exception ex1) {
                        // empty catch block
                    }
                    throw new JeusRuntimeException(JeusMessage_JMX.JMX_41, (Object)appName, (Throwable)ex);
                }
            }
            for (JAXBElement nameAndPathElement : appList) {
                J2EEModule appMBean;
                ConnectorComponentType compType;
                JeusRuntimeException e;
                EjbComponentType compType2;
                Object nameAndPath = nameAndPathElement.getValue();
                String elementName = nameAndPathElement.getName().getLocalPart();
                if (elementName.equals("name") || elementName.equals("path") || nameAndPath instanceof DeploymentTypeType) continue;
                if (nameAndPath instanceof EjbComponentType) {
                    int _index;
                    String ejbJarPath;
                    compType2 = (EjbComponentType)nameAndPath;
                    if (compType2 != null && (ejbJarPath = compType2.getEjbJar()) != null && (_index = (ejbJarPath = FileUtils.getFileNameWithoutExtension((String)ejbJarPath)).indexOf(95)) >= 0) {
                        JeusDeploymentManager.setApplicationName(appType, ejbJarPath.substring(_index + 1));
                    }
                    if (!doesEJBEngineExists) {
                        e = new JeusRuntimeException("Can not deploy EJB module without EJB engine");
                        if (logger.isLoggable(JeusMessage_JMX._116_LEVEL)) {
                            logger.log(JeusMessage_JMX._116_LEVEL, JeusMessage_JMX._116, (Throwable)e);
                        }
                        throw e;
                    }
                    EJBModule appMBean2 = (EJBModule)EJBModule.createMBean(JeusDeploymentManager.getNameFromPath(appType), this.myObjectName, null);
                    deployedMBean = appMBean2;
                    try {
                        this.setAppTypeInfo(appMBean2, appType, autoDeployTask, isSystemApp, originalAppType);
                        appMBean2.setClassFtpMode(appType.getClassFtpUnit() == null ? appType.getDefaultClassFtpUnit() : appType.getClassFtpUnit());
                        this.sendNotification("jeus.deploy.predeploy", "predeploy", deployedMBean.getObjectName());
                        J2EEApplication.initEjbComponentType(compType2, appType);
                        appMBean2.setComponentType(compType2);
                        this.postInitJ2EEModule(appMBean2, appType, compType2.getUri());
                        moduleId = appMBean2.deploy(null);
                        continue;
                    }
                    catch (Exception ex) {
                        if (logger.isLoggable(JeusMessage_JMX.JMX_41_LEVEL)) {
                            logger.log(JeusMessage_JMX.JMX_41_LEVEL, JeusMessage_JMX.JMX_41, (Object)appName, (Throwable)ex);
                        }
                        try {
                            appMBean2.destroyMBean();
                        }
                        catch (Exception ex1) {
                            // empty catch block
                        }
                        throw new JeusRuntimeException(JeusMessage_JMX.JMX_41, (Object)appName, (Throwable)ex);
                    }
                }
                if (nameAndPath instanceof WebComponentType) {
                    compType2 = (WebComponentType)nameAndPath;
                    if (!doesWebEngineExists) {
                        e = new JeusRuntimeException("Can not deploy Web module without Servlet engine");
                        if (logger.isLoggable(JeusMessage_JMX._118_LEVEL)) {
                            logger.log(JeusMessage_JMX._118_LEVEL, JeusMessage_JMX._118, (Object)appName, (Throwable)e);
                        }
                        throw e;
                    }
                    String moduleName = JeusDeploymentManager.getApplicationName(appType);
                    if (moduleName == null) {
                        moduleName = JeusDeploymentManager.getNameFromPath(appType);
                    }
                    WebModule appMBean3 = (WebModule)WebModule.createMBean(moduleName, this.myObjectName, null);
                    deployedMBean = appMBean3;
                    try {
                        this.setAppTypeInfo(appMBean3, appType, autoDeployTask, isSystemApp, originalAppType);
                        this.sendNotification("jeus.deploy.predeploy", "predeploy", deployedMBean.getObjectName());
                        appMBean3.setComponentType(compType2);
                        this.postInitJ2EEModule(appMBean3, appType, compType2.getUri());
                        moduleId = appMBean3.deploy(null);
                        continue;
                    }
                    catch (Exception ex) {
                        if (logger.isLoggable(JeusMessage_JMX.JMX_41_LEVEL)) {
                            logger.log(JeusMessage_JMX.JMX_41_LEVEL, JeusMessage_JMX.JMX_41, (Object)appName, (Throwable)ex);
                        }
                        try {
                            appMBean3.destroyMBean();
                        }
                        catch (Exception ex1) {
                            // empty catch block
                        }
                        throw new JeusRuntimeException(JeusMessage_JMX.JMX_41, (Object)appName, (Throwable)ex);
                    }
                }
                if (nameAndPath instanceof ConnectorComponentType) {
                    compType = (ConnectorComponentType)nameAndPath;
                    appMBean = (ResourceAdapterModule)ResourceAdapterModule.createMBean(JeusDeploymentManager.getNameFromPath(appType), this.myObjectName, compType, true);
                    try {
                        deployedMBean = appMBean;
                        this.setAppTypeInfo(appMBean, appType, autoDeployTask, isSystemApp, originalAppType);
                        this.postInitJ2EEModule(appMBean, appType, compType.getUri());
                        ((ResourceAdapterModule)appMBean).extract();
                        this.sendNotification("jeus.deploy.predeploy", "predeploy", deployedMBean.getObjectName());
                        moduleId = ((ResourceAdapterModule)appMBean).deploy(null);
                        continue;
                    }
                    catch (Exception ex) {
                        if (logger.isLoggable(JeusMessage_JMX.JMX_41_LEVEL)) {
                            logger.log(JeusMessage_JMX.JMX_41_LEVEL, JeusMessage_JMX.JMX_41, (Object)appName, (Throwable)ex);
                        }
                        try {
                            appMBean.destroyMBean();
                        }
                        catch (Exception ex1) {
                            // empty catch block
                        }
                        throw new JeusRuntimeException(JeusMessage_JMX.JMX_41, (Object)appName, (Throwable)ex);
                    }
                }
                if (!(nameAndPath instanceof ClientComponentType)) continue;
                appMBean = (AppClientModule)AppClientModule.createMBean(JeusDeploymentManager.getNameFromPath(appType), this.myObjectName, null);
                deployedMBean = appMBean;
                try {
                    this.setAppTypeInfo(appMBean, appType, autoDeployTask, isSystemApp, originalAppType);
                    compType = (ClientComponentType)nameAndPath;
                    this.postInitJ2EEModule(appMBean, appType, compType.getUri());
                    this.sendNotification("jeus.deploy.predeploy", "predeploy", deployedMBean.getObjectName());
                    ((AppClientModule)appMBean).setComponentType(compType);
                    moduleId = ((AppClientModule)appMBean).deploy(null);
                }
                catch (Exception ex) {
                    if (logger.isLoggable(JeusMessage_JMX.JMX_41_LEVEL)) {
                        logger.log(JeusMessage_JMX.JMX_41_LEVEL, JeusMessage_JMX.JMX_41, (Object)appName, (Throwable)ex);
                    }
                    try {
                        appMBean.destroyMBean();
                    }
                    catch (Exception ex1) {
                        // empty catch block
                    }
                    throw new JeusRuntimeException(JeusMessage_JMX.JMX_41, (Object)appName, (Throwable)ex);
                }
            }
            if (autoDeployTask != null) {
                long interval;
                autoDeployTask.setModifiedTime();
                ObjectFactory objFact = new ObjectFactory();
                AutoDeployType autoDeply = appType.getAutoDeploy();
                if (autoDeply != null) {
                    long l = interval = autoDeply.getAutoDeployCheckInterval() != null ? autoDeply.getAutoDeployCheckInterval().longValue() : autoDeply.getDefaultAutoDeployCheckInterval();
                    if (interval < 1L) {
                        interval = autoDeply.getDefaultAutoDeployCheckInterval();
                    }
                } else {
                    interval = objFact.createAutoDeployType().getDefaultAutoDeployCheckInterval();
                }
                ScheduledExecutor.getInstance().scheduleWithFixedDelay(autoDeployTask, interval, interval);
            }
            this.sendNotification("jeus.deploy.postdeploy", "postdeploy", deployedMBean.getObjectName());
            TargetModuleID targetModuleID = moduleId;
            return targetModuleID;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    private boolean isAppNameAlreadyUsed(String appName) {
        for (Object mDeployedObject : this.mDeployedObjects) {
            ObjectName objectName = (ObjectName)mDeployedObject;
            if (!objectName.getKeyProperty("name").equals(appName)) continue;
            return true;
        }
        return false;
    }

    private void setUriForComponentType(ApplicationType appType) {
        String path = FileUtils.getFileNameFromPath((String)JeusDeploymentManager.getApplicationPath(appType));
        List appList = appType.getNameAndPathAndDeploymentType();
        for (JAXBElement nameAndPathElement : appList) {
            Object obj = nameAndPathElement.getValue();
            if (obj instanceof EjbComponentType) {
                ((EjbComponentType)obj).setUri(path);
                return;
            }
            if (obj instanceof WebComponentType) {
                ((WebComponentType)obj).setUri(path);
                return;
            }
            if (obj instanceof ClientComponentType) {
                ((ClientComponentType)obj).setUri(path);
                return;
            }
            if (!(obj instanceof ConnectorComponentType)) continue;
            ((ConnectorComponentType)obj).setUri(path);
            return;
        }
        throw new JeusRuntimeException("For COMPONENT deployment type, one component element such as <ejb-component> or <web-component> should be in the application setting in JEUSMain.xml or jeus-application-dd.xml");
    }

    private void setPathWithAppHomes(ApplicationType appType) throws IOException {
        String absolutePath;
        String path = JeusDeploymentManager.getApplicationPath(appType);
        String string = absolutePath = path == null ? appType.getAbsolutePath() : path;
        if (path != null && !new File(path).isAbsolute()) {
            boolean isAppExists = false;
            String appAbsPath = appType.getAbsolutePath();
            for (Object appArchive : this.appArchiveList) {
                FileArchive fileArchive = (FileArchive)appArchive;
                if (!fileArchive.contains(path)) continue;
                absolutePath = fileArchive.getArchiveUri() + File.separator + path;
                JeusDeploymentManager.setApplicationPath(appType, absolutePath);
                isAppExists = true;
                break;
            }
            if (appAbsPath != null) {
                absolutePath = appAbsPath.endsWith(File.separator) ? appAbsPath + path : appAbsPath + File.separator + path;
                JeusDeploymentManager.setApplicationPath(appType, absolutePath);
                isAppExists = true;
            }
            if (!isAppExists) {
                throw new JeusRuntimeException("The application does not exists in the application directories such as APP_HOME : " + path);
            }
        }
        appType.getInfoMap().put(ABSOLUTE_PATH, absolutePath);
    }

    private void setAppTypeInfo(J2EEModule appMBean, ApplicationType appType, AutoDeployTask autoDeployTask, boolean isSystemApp, ApplicationType originalAppType) throws IOException {
        ConfigurationDeploymentDescriptorFile jeusDD;
        DeploymentDescriptorFile standardDD;
        appMBean.setSystemApp(isSystemApp);
        appMBean.setPath(JeusDeploymentManager.getApplicationPath(appType));
        String appName = JeusDeploymentManager.getNameFromPath(appType);
        appMBean.setApplicationName(appName);
        appMBean.setAppModuleName(null);
        appMBean.setDeployType(JeusDeploymentManager.getApplicationDeploymentTypeType(appType).value());
        appMBean.setAppClassLoader(((RootClassLoader)JeusRootClassLoader.loader).getEJBRootClassLoader());
        ClassloadingType classloadingType = appType.getClassloading();
        if (classloadingType == null) {
            classloadingType = ClassloadingType.valueOf((String)JeusAppProperties.DEFAULT_CLASSLOADING);
        }
        appMBean.setIsolatedClassloading(classloadingType == ClassloadingType.ISOLATED);
        if (autoDeployTask != null) {
            appMBean.setAutoDeployTask(autoDeployTask);
        }
        appMBean.setApplicationType(originalAppType);
        appMBean.setFastDeploy(appType.isFastDeploy());
        appMBean.setKeepGenerated(appType.isKeepGenerated());
        String path = (String)appType.getInfoMap().get(ABSOLUTE_PATH);
        if (path == null) {
            path = EngineContainer.getDeploymentHome().getArchiveUri() + File.separator + JeusDeploymentManager.getApplicationPath(appType) + JeusMainHelper.getComponentPath(appType);
        }
        if (appMBean instanceof WebModule) {
            standardDD = new WebDeploymentDescriptorFile();
            jeusDD = new WebRuntimeDDFile(null);
        } else if (appMBean instanceof EJBModule) {
            standardDD = new EjbDeploymentDescriptorFile();
            jeusDD = new EjbRuntimeDDFile();
        } else if (appMBean instanceof ResourceAdapterModule) {
            standardDD = new ConnectorDeploymentDescriptorFile();
            jeusDD = new ConnectorRuntimeDDFile();
        } else if (appMBean instanceof AppClientModule) {
            standardDD = new AppClientDeploymentDescriptorFile();
            jeusDD = new AppClientRuntimeDDFile();
        } else {
            throw new JeusRuntimeException("Wrong MBean type : " + appMBean);
        }
        appMBean.setDeploymentDescriptor(standardDD.getDescriptorString(path));
        appMBean.setJeusDeploymentPlan(jeusDD.getDescriptorString(path));
    }

    private void postInitJ2EEApplication(J2EEApplication app) {
        app.clearModuleGenerationDirectory();
    }

    private void postInitJ2EEModule(J2EEModule module, ApplicationType appType, String moduleUri) {
        module.setModuleUri(moduleUri);
        module.clearModuleGenerationDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationType copyArchiveForAbsolutePath(ApplicationType appType) throws IOException {
        String type = JeusDeploymentManager.getApplicationDeploymentTypeType(appType).value();
        boolean isEAR = type.equals("EAR");
        String absolutePath = (String)appType.getInfoMap().get(ABSOLUTE_PATH);
        File pathFile = new File(absolutePath);
        String newPath = absolutePath;
        if (!pathFile.isDirectory()) {
            FileInputStream is = null;
            OutputStream os = null;
            try {
                String fileName;
                if (isEAR) {
                    fileName = FileUtils.getFileNameWithExtension((String)absolutePath);
                    is = new FileInputStream(pathFile);
                    os = EngineContainer.getDeploymentHome().addEntry(fileName);
                    ArchiveHelper.copy((InputStream)is, (OutputStream)os);
                } else {
                    fileName = FileUtils.getFileNameWithExtension((String)absolutePath);
                    is = new FileInputStream(pathFile);
                    FileArchive compHomeArchive = (FileArchive)EngineContainer.getArchiveFromDeploymentHome(fileName);
                    os = compHomeArchive.addEntry(fileName);
                    ArchiveHelper.copy((InputStream)is, (OutputStream)os);
                }
                newPath = fileName;
                appType.setAbsolutePath(absolutePath.substring(0, absolutePath.indexOf(fileName)));
            }
            finally {
                if (is != null) {
                    is.close();
                    is = null;
                }
                if (os != null) {
                    os.close();
                    os = null;
                }
            }
        } else if (!isEAR) {
            newPath = StringUtil.getParentDirectory((String)absolutePath);
            if (JeusDeploymentManager.getApplicationName(appType) == null) {
                String moduleName = absolutePath.substring(newPath.length());
                JeusDeploymentManager.setApplicationName(appType, moduleName);
            }
        }
        JeusDeploymentManager.setApplicationPath(appType, newPath);
        return appType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getAvailableModules(ModuleTypeSerializable moduleType) throws Exception {
        LoginUtil.checkPermissionWithCodeSubject(this.getModulesPermission);
        try {
            ObjectName[] j2EEDeployedObjects = new ObjectName[this.mDeployedObjects.size()];
            j2EEDeployedObjects = this.mDeployedObjects.toArray(j2EEDeployedObjects);
            ArrayList<Object> list = new ArrayList<Object>();
            for (ObjectName obj : j2EEDeployedObjects) {
                Object objType = this.mbs.getAttribute(obj, "ModuleType");
                if (moduleType != null && !objType.equals(moduleType)) continue;
                list.add(this.mbs.getAttribute(obj, "TargetModuleID"));
            }
            TargetModuleID[] targetModuleIDArray = list.toArray(dummyDeployedObjectArray);
            return targetModuleIDArray;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getNonRunningModules(ModuleTypeSerializable moduleType) throws Exception {
        LoginUtil.checkPermissionWithCodeSubject(this.getModulesPermission);
        try {
            ObjectName[] j2EEDeployedObjects = new ObjectName[this.mDeployedObjects.size()];
            j2EEDeployedObjects = this.mDeployedObjects.toArray(j2EEDeployedObjects);
            ArrayList<Object> list = new ArrayList<Object>();
            for (ObjectName obj : j2EEDeployedObjects) {
                Object objTtype = this.mbs.getAttribute(obj, "ModuleType");
                if (moduleType != null && !objTtype.equals(moduleType) || (Integer)this.mbs.getAttribute(obj, "state") == 1) continue;
                list.add(this.mbs.getAttribute(obj, "TargetModuleID"));
            }
            TargetModuleID[] targetModuleIDArray = list.toArray(dummyDeployedObjectArray);
            return targetModuleIDArray;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    public TargetModuleID[] getRunningModules(ModuleTypeSerializable moduleType) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.getModulesPermission);
        ObjectName[] j2EEDeployedObjects = new ObjectName[this.mDeployedObjects.size()];
        j2EEDeployedObjects = this.mDeployedObjects.toArray(j2EEDeployedObjects);
        ArrayList<Object> list = new ArrayList<Object>();
        for (ObjectName obj : j2EEDeployedObjects) {
            Object objTtype = this.mbs.getAttribute(obj, "ModuleType");
            if (moduleType != null && !objTtype.equals(moduleType) || (Integer)this.mbs.getAttribute(obj, "state") != 1) continue;
            list.add(this.mbs.getAttribute(obj, "TargetModuleID"));
        }
        return list.toArray(dummyDeployedObjectArray);
    }

    public ObjectName getDeployedObjectName(String moduleName) {
        LoginUtil.checkPermissionWithRuntimeException(this.getModulesPermission);
        for (Object mDeployedObject : this.mDeployedObjects) {
            ObjectName objectName = (ObjectName)mDeployedObject;
            if (!objectName.getKeyProperty("name").equals(moduleName)) continue;
            return objectName;
        }
        return null;
    }

    public String getNodeName() {
        LoginUtil.checkPermissionWithRuntimeException(this.deployPermission);
        return this.nodeName;
    }

    public String getFTPDestination(ApplicationType appType) {
        LoginUtil.checkPermissionWithRuntimeException(this.deployPermission);
        return "abs:" + this.appHomeList.get(0) + "/" + JeusDeploymentManager.getApplicationPath(appType);
    }

    public ApplicationType getApplicationType(String path) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.getApplicationTypePermission);
        File moduleFile = new File(path);
        AbstractArchive moduleArchive = moduleFile.isDirectory() ? FileArchiveFactory.openArchiveStatic((File)moduleFile) : JarArchiveFactory.openArchiveStatic((File)moduleFile);
        return JeusDeploymentManager.fillApplicationDDInfoFromArchive(moduleArchive, null);
    }

    public ModuleTypeSerializable getModuleType(String path) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.getApplicationTypePermission);
        File moduleFile = new File(path);
        if (!moduleFile.exists()) {
            throw new FileNotFoundException("cannot find module file : " + moduleFile.getAbsolutePath());
        }
        AbstractArchive moduleArchive = moduleFile.isDirectory() ? FileArchiveFactory.openArchiveStatic((File)moduleFile) : JarArchiveFactory.openArchiveStatic((File)moduleFile);
        return ModuleTypeSerializable.getModuleTypeSerializable(JeusDeploymentManager.getModuleType(moduleArchive));
    }

    public ModuleInfo[] getDistributedModules() throws IOException {
        LoginUtil.checkPermissionWithRuntimeException(this.getDistributedModulesPermission);
        ArrayList moduleInfos = new ArrayList();
        List<String> deployedNames = Arrays.asList(JMXUtility.getNameStringArray(this.mDeployedObjects.toArray(new ObjectName[this.mDeployedObjects.size()])));
        Hashtable<String, ModuleType> deployedModules = new Hashtable<String, ModuleType>();
        for (Object mDeployedObject : this.mDeployedObjects) {
            ObjectName objName = (ObjectName)mDeployedObject;
            ModuleType moduleType = null;
            String type = objName.getKeyProperty("j2eeType");
            if (type.equals("J2EEApplication")) {
                moduleType = ModuleType.EAR;
            } else if (type.equals("EJBModule")) {
                moduleType = ModuleType.EJB;
            } else if (type.equals("WebModule")) {
                moduleType = ModuleType.WAR;
            } else if (type.equals("ResourceAdapterModule")) {
                moduleType = ModuleType.RAR;
            } else if (type.equals("AppClientModule")) {
                moduleType = ModuleType.CAR;
            }
            String moduleName = objName.getKeyProperty("name");
            deployedModules.put(moduleName, moduleType);
        }
        for (Object appArchive : this.appArchiveList) {
            FileArchive archive = (FileArchive)appArchive;
            moduleInfos.addAll(this.listModules(archive, deployedNames, deployedModules));
        }
        return moduleInfos.toArray(new ModuleInfo[moduleInfos.size()]);
    }

    private List listModules(FileArchive filearch, List deployedNames, Hashtable deployedModules) throws IOException {
        File[] moduleFiles = filearch.getFile().listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                if (pathname.getName().lastIndexOf(46) < 0) {
                    return false;
                }
                String extension = pathname.getName().substring(pathname.getName().lastIndexOf(46));
                return extensions.contains(extension);
            }
        });
        ArrayList<ModuleInfo> modules = new ArrayList<ModuleInfo>();
        for (File moduleFile : moduleFiles) {
            String distributedType;
            String moduleName;
            ModuleType moduleType;
            AbstractArchive archive = moduleFile.isDirectory() ? FileArchiveFactory.openArchiveStatic((File)moduleFile) : JarArchiveFactory.openArchiveStatic((File)moduleFile);
            try {
                moduleType = ModuleTypeResolver.getModuleType(archive);
            }
            catch (RuntimeException re) {
                continue;
            }
            if (moduleType == null || moduleFile.isDirectory() && ModuleType.EAR.equals(moduleType)) continue;
            if (moduleFile.isFile()) {
                moduleName = moduleFile.getName();
                int dot = moduleName.lastIndexOf(".");
                if (dot >= 0) {
                    moduleName = moduleName.substring(0, dot);
                }
                distributedType = "ARCHIVED";
            } else {
                moduleName = moduleFile.getName();
                distributedType = "EXPLODED";
            }
            String modulePath = archive.getArchiveUri();
            ModuleInfo info = new ModuleInfo();
            info.setModuleType(moduleType);
            info.setModuleName(moduleName);
            info.setModulePath(modulePath);
            info.setDistributedType(distributedType);
            if (deployedNames.contains(moduleName) && deployedModules.containsKey(moduleName) && moduleType.equals(deployedModules.get(moduleName))) {
                info.setDeployed(true);
            }
            modules.add(info);
            this.cleanArchive(archive);
        }
        return modules;
    }

    private void cleanArchive(AbstractArchive archive) {
        if (archive != null) {
            try {
                archive.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String[] getEventTypes() {
        return eventType;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return eventNotificationInfo;
    }

    public TargetImpl getTarget() {
        return this.target;
    }

    protected void setAdditionalNameProperties(Map prop) {
        String containerName = (String)prop.get("name");
        if (StringUtil.isDefaultContainerName((String)containerName)) {
            try {
                prop.put("JMXManager", StringUtil.getNodeNameFromContainerName((String)containerName));
            }
            catch (IllegalJeusSystemNameException e) {
                throw new JeusRuntimeException((Throwable)e);
            }
        } else {
            prop.put("JMXManager", containerName);
        }
    }

    public JNDILocalInfo localList(String name) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("jeus.jndi.jns.localbindings", "true");
        InitialContext ctx = new InitialContext(env);
        NameEnumerationImpl ne = (NameEnumerationImpl)ctx.list(name);
        if (ne.isContext()) {
            Vector v2 = new Vector();
            this.subContext((Context)ctx.lookup(name), v2);
            return new JNDILocalInfo(name, Reference.class.getName(), v2);
        }
        if (ne.hasMoreElements()) {
            JeusNameClassPair nc = (JeusNameClassPair)ne.next();
            return new JNDILocalInfo(nc.getName(), nc.getClassName());
        }
        throw new NamingException("Not context : " + name);
    }

    public JeusNameClassPair localLookup(String name) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("jeus.jndi.jns.localbindings", "true");
        InitialContext ctx = new InitialContext(env);
        NamingEnumeration<NameClassPair> enumeration = ctx.list(name);
        if (enumeration.hasMoreElements()) {
            return (JeusNameClassPair)enumeration.nextElement();
        }
        throw new NameNotFoundException(name);
    }

    private void subContext(Context ctx, Vector v) {
        NamingEnumeration<NameClassPair> ne;
        try {
            ne = ctx.list("");
        }
        catch (NamingException e) {
            return;
        }
        while (ne.hasMoreElements()) {
            try {
                JeusNameClassPair nc = (JeusNameClassPair)ne.next();
                String name = nc.getName();
                String className = nc.getClassName();
                Reference ref = nc.getReference();
                if (ref != null && JNS.isJNSContext(ref)) {
                    Vector v2 = new Vector();
                    this.subContext((Context)ctx.lookup(name), v2);
                    v.add(new JNDILocalInfo(name, className, v2));
                    continue;
                }
                v.add(new JNDILocalInfo(name, className));
            }
            catch (NamingException e) {}
        }
    }

    public void dumpThread() {
        System.out.println("Dump Stack for the container " + JeusManagerPropertyValues.containerName);
        CUtility.dumpThreadStack((int)CUtility.thisProcessPID);
        System.out.println("End of dump Stack for the container " + JeusManagerPropertyValues.containerName);
    }

    public List getAppPaths() {
        return this.appHomeList;
    }

    public ArrayList getAppArchives() {
        return this.appArchiveList;
    }

    public String getModuleDescriptor(String modulePath, String descriptorPath) throws IOException {
        LoginUtil.checkPermissionWithRuntimeException(this.getModuleDescriptorPermission);
        File f = new File(modulePath);
        if (f.exists()) {
            return this.getStringFromFile(descriptorPath, f, f.isDirectory());
        }
        for (Object appArchive : this.appArchiveList) {
            FileArchive abstractArchive = (FileArchive)appArchive;
            f = abstractArchive.getFile(modulePath);
            if (f == null) continue;
            return this.getStringFromFile(descriptorPath, f, f.isDirectory());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringFromFile(String descriptorPath, File f, boolean isExploded) throws IOException {
        AbstractArchive archive = null;
        try {
            String string;
            InputStream is;
            if (!isExploded) {
                archive = JarArchiveFactory.openArchiveStatic((File)f);
                if (archive == null) {
                    throw new IOException("The file " + f.getAbsolutePath() + " does not exist");
                }
                int index = descriptorPath.indexOf("!/");
                if (index >= 0) {
                    String filePath = descriptorPath.substring(0, index);
                    descriptorPath = descriptorPath.substring(index + 2);
                    AbstractArchive innerArchive = archive.getEmbeddedArchive(filePath);
                    is = innerArchive.getEntry(descriptorPath);
                } else {
                    is = archive.getEntry(descriptorPath);
                }
            } else if (f.exists()) {
                try {
                    is = new FileInputStream(f.getAbsolutePath() + File.separator + descriptorPath);
                }
                catch (FileNotFoundException e) {
                    String string2 = null;
                    if (archive != null) {
                        archive.close();
                    }
                    return string2;
                }
            } else {
                String string3 = null;
                return string3;
            }
            if (is == null) {
                String string4 = null;
                return string4;
            }
            try {
                string = StringUtil.getStringFromInputStream((InputStream)is);
            }
            catch (Throwable throwable) {
                is.close();
                throw throwable;
            }
            is.close();
            return string;
        }
        finally {
            if (archive != null) {
                archive.close();
            }
        }
    }

    public void setModuleDescriptor(String modulePath, String descriptorPath, String descriptor) throws IOException {
        LoginUtil.checkPermissionWithRuntimeException(this.setModuleDescriptorPermission);
        File f = new File(modulePath);
        if (!f.isAbsolute()) {
            for (Object appArchive : this.appArchiveList) {
                FileArchive abstractArchive = (FileArchive)appArchive;
                f = abstractArchive.getFile(modulePath);
                if (f == null) continue;
                this.setDescriptor(f.getAbsolutePath(), descriptorPath, descriptor, f.isDirectory());
                return;
            }
            throw new IOException("The file " + modulePath + " does not exist in the app_home directories");
        }
        this.setDescriptor(modulePath, descriptorPath, descriptor, f.isDirectory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setDescriptor(String modulePath, String descriptorPath, String descriptor, boolean isExploded) throws IOException {
        if (!isExploded) {
            InputJarArchive archive = (InputJarArchive)JarArchiveFactory.openArchiveStatic((String)modulePath);
            OutputJarArchive outArchive = JarArchiveFactory.appendJarArchive((InputJarArchive)archive, (String)descriptorPath);
            try {
                ZipOutputStream os = (ZipOutputStream)outArchive.addEntry(descriptorPath);
                os.write(descriptor.getBytes());
                os.closeEntry();
            }
            finally {
                if (outArchive != null) {
                    outArchive.close();
                    outArchive = null;
                }
                if (archive != null) {
                    archive.close();
                    archive = null;
                }
            }
        }
        OutputStream os = FileArchiveFactory.openArchiveStatic((String)modulePath).addEntry(descriptorPath);
        try {
            os.write(descriptor.getBytes());
        }
        finally {
            os.close();
        }
    }

    public String getModulePath(String moduleName) throws IOException {
        LoginUtil.checkPermissionWithRuntimeException(this.getModulePathPermission);
        File result = null;
        for (Object appArchive : this.appArchiveList) {
            AbstractArchive archive = (AbstractArchive)appArchive;
            if (!archive.contains(moduleName)) continue;
            File file = new File(archive.getArchiveUri() + "/" + moduleName);
            if ((result == null || file.lastModified() <= result.lastModified()) && result != null) continue;
            result = file;
        }
        if (result != null) {
            return result.getPath().replaceAll("\\\\", "/");
        }
        return null;
    }

    public String getRealModuleName(String moduleName) throws IOException {
        String dirName;
        boolean hasExtension;
        LoginUtil.checkPermissionWithRuntimeException(this.getModulePathPermission);
        if (moduleName.endsWith(".ear") || moduleName.endsWith(".jar") || moduleName.endsWith(".war") || moduleName.endsWith(".rar")) {
            hasExtension = true;
            dirName = moduleName.substring(0, moduleName.lastIndexOf(46));
        } else {
            hasExtension = false;
            dirName = moduleName;
        }
        String earName = moduleName + ".ear";
        String jarName = moduleName + ".jar";
        String warName = moduleName + ".war";
        String rarName = moduleName + ".rar";
        for (Object appArchive : this.appArchiveList) {
            AbstractArchive archive = (AbstractArchive)appArchive;
            if (hasExtension && archive.contains(moduleName)) {
                return moduleName;
            }
            if (archive.contains(dirName)) {
                return dirName;
            }
            if (archive.contains(earName)) {
                return earName;
            }
            if (archive.contains(jarName)) {
                return jarName;
            }
            if (archive.contains(warName)) {
                return warName;
            }
            if (!archive.contains(rarName)) continue;
            return rarName;
        }
        return null;
    }

    public String getRealModulePath(String moduleName) throws IOException {
        String dirName;
        boolean hasExtension;
        LoginUtil.checkPermissionWithRuntimeException(this.getModulePathPermission);
        if (moduleName.endsWith(".ear") || moduleName.endsWith(".jar") || moduleName.endsWith(".war") || moduleName.endsWith(".rar")) {
            hasExtension = true;
            dirName = moduleName.substring(0, moduleName.lastIndexOf(46));
        } else {
            hasExtension = false;
            dirName = moduleName;
        }
        String earName = moduleName + ".ear";
        String jarName = moduleName + ".jar";
        String warName = moduleName + ".war";
        String rarName = moduleName + ".rar";
        for (Object appArchive : this.appArchiveList) {
            AbstractArchive archive = (AbstractArchive)appArchive;
            if (hasExtension && archive.contains(moduleName)) {
                return (archive.getArchiveUri() + "/" + moduleName).replaceAll("\\\\", "/");
            }
            if (archive.contains(dirName)) {
                return (archive.getArchiveUri() + "/" + dirName).replaceAll("\\\\", "/");
            }
            if (archive.contains(earName)) {
                return (archive.getArchiveUri() + "/" + earName).replaceAll("\\\\", "/");
            }
            if (archive.contains(jarName)) {
                return (archive.getArchiveUri() + "/" + jarName).replaceAll("\\\\", "/");
            }
            if (archive.contains(warName)) {
                return (archive.getArchiveUri() + "/" + warName).replaceAll("\\\\", "/");
            }
            if (!archive.contains(rarName)) continue;
            return (archive.getArchiveUri() + "/" + rarName).replaceAll("\\\\", "/");
        }
        throw new FileNotFoundException("invalid module name " + moduleName);
    }

    public String getJndiInfo(String jndiName) throws NamingException {
        return JNDIUtil.getJndiInfo(jndiName, null);
    }

    public String getJndiListInfo(String jndiName, boolean allInfos) throws NamingException {
        return JNDIUtil.getJndiListInfo(jndiName, null, allInfos);
    }

    public static ObjectName makeObjectName(String containerName) throws MalformedObjectNameException {
        String jeusManager;
        try {
            jeusManager = StringUtil.getNodeNameFromContainerName((String)containerName);
        }
        catch (IllegalJeusSystemNameException e) {
            throw new MalformedObjectNameException("Invalid container name");
        }
        String jmxManager = containerName;
        if (containerName.endsWith("default")) {
            jmxManager = jeusManager;
        }
        String name = "JEUS:JMXManager=" + jmxManager + "," + "JeusManager" + "=" + jeusManager + "," + "j2eeType" + "=" + "J2EEServer" + "," + "name" + "=" + containerName + "," + "isTargetable" + "=true";
        return new ObjectName(name);
    }

    public static FileArchive getAppRootArchive(String path) throws IOException {
        File file = new File(path);
        if (file.isAbsolute()) {
            return (FileArchive)FileArchiveFactory.openArchiveStatic((File)file);
        }
        FileArchive deployHome = EngineContainer.getDeploymentHome();
        return (FileArchive)deployHome.getEmbeddedArchive(path);
    }

    static {
        extensions = new HashSet();
        extensions.add(ModuleType.EAR.getModuleExtension());
        extensions.add(ModuleType.WAR.getModuleExtension());
        extensions.add(ModuleType.EJB.getModuleExtension());
        extensions.add(ModuleType.CAR.getModuleExtension());
        extensions.add(ModuleType.RAR.getModuleExtension());
    }
}

