/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.ResourceAdapterInternalException;
import jeus.connector.CMInfo;
import jeus.connector.ConnectorFactory;
import jeus.connector.ManagedConnectionPool;
import jeus.connector.RollOverFileWriter;
import jeus.jndi.jns.common.PropertyReference;
import jeus.jndi.objectfactory.SerializableRefAddr;
import jeus.management.JMXManagerException;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEResource;
import jeus.management.j2ee.JCAConnectionFactory;
import jeus.management.j2ee.JCAResourceMBean;
import jeus.management.j2ee.ResourceAdapterModule;
import jeus.management.j2ee.statistics.JCAStatsImpl;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.transaction.TMService;
import jeus.util.JeusProperties;
import jeus.util.OS;
import jeus.xml.binding.connectorHelper.ConnectionDefinitionsDescriptor;
import jeus.xml.binding.connectorHelper.ConnectorPair;

public class JCAResource
extends J2EEResource
implements JCAResourceMBean {
    private static final String MODULE_NAME = "MODULENAME";
    private static final String EXPORT_NAME = "EXPORTNAME";
    private static final String PROPERTIES = "PROPERTIES";
    protected static final String[] childTypes = new String[]{"JCAConnectionFactory"};
    private final JCAStatsImpl stats = new JCAStatsImpl();
    private final Hashtable jcaConnectionFactoryTable = new Hashtable();
    private final Hashtable connectionPropertyListTable = new Hashtable();
    private final String moduleName;
    private final ResourceAdapter spiResourceAdapter;
    private final ConnectorPair connectorPair;
    private final String appName;
    private final ClassLoader classLoader;
    private final boolean standaloneDeploy;
    private final Vector recoveredReferences;

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target, ConnectorPair desc, String appName, ClassLoader loader, boolean isStandaloneDeploy) {
        try {
            JCAResource object = new JCAResource(mBeanName, parent, target, desc, appName, loader, isStandaloneDeploy);
            return object.createMBean(mBeanName, "JCAResource", parent, JCAResourceMBean.parentKeyMap, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JCAResource(String moduleName, ObjectName parent, Object ra, ConnectorPair desc, String appName, ClassLoader loader, boolean standaloneDeploy) {
        super(parent);
        this.moduleName = moduleName;
        this.spiResourceAdapter = (ResourceAdapter)ra;
        this.connectorPair = desc;
        this.appName = appName;
        this.classLoader = loader;
        this.standaloneDeploy = standaloneDeploy;
        this.recoveredReferences = ResourceAdapterModule.getRecoveredReference(this.moduleName);
    }

    protected String initPermissionName() throws JMXManagerException {
        J2EEManagedObjectMBean parent = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return parent.getPermissionName() + "." + "jca_resource" + "." + this.myNameString;
    }

    public void addChild(ObjectName pChild) {
        LoginService.checkCodeSubject();
        logger.debug(" ---- [JCAResource/addChild] " + this.moduleName + " <- " + pChild);
        super.addChild(pChild);
    }

    public void removeChild(ObjectName pChild) {
        LoginService.checkCodeSubject();
        logger.debug(" ---- [JCAResource/removeChild] " + this.moduleName + " -> " + pChild);
        super.removeChild(pChild);
    }

    void deploy() throws ResourceException {
        logger.debug(" ---- [JCAResource/deploy] " + this.moduleName);
        Iterator iter = this.connectorPair.getAllOutbounds();
        while (iter.hasNext()) {
            ConnectionDefinitionsDescriptor connectionDefinition = (ConnectionDefinitionsDescriptor)iter.next();
            String exportName = connectionDefinition.getExportName();
            if (connectionDefinition.getTransactionSupport() == 2) {
                this.registerDataSource(exportName);
            }
            JCAConnectionFactory jcaConnectionFactory = this.createJCAConnectionFactory(connectionDefinition);
            jcaConnectionFactory.deploy();
            this.recover(exportName, jcaConnectionFactory);
        }
    }

    void undeploy() throws ResourceException {
        logger.debug(" ---- [JCAResource/undeploy] " + this.moduleName);
        for (JCAConnectionFactory jcaFactory : this.jcaConnectionFactoryTable.values()) {
            jcaFactory.undeploy();
        }
        this.jcaConnectionFactoryTable.clear();
        this.destroyMBean();
    }

    private void registerDataSource(String exportName) throws ResourceException {
        try {
            TMService.registerConnector(this.getRecoveryReference(exportName), exportName);
        }
        catch (Exception ex) {
            throw new ResourceException("failed to deploy jca resource " + this.moduleName, (Throwable)ex);
        }
    }

    private ArrayList createConnectionPropertyList(ConnectionDefinitionsDescriptor connectionDefinition) {
        ArrayList properties = new ArrayList();
        properties.addAll(connectionDefinition.getJarProperties());
        properties.addAll(connectionDefinition.getProperties());
        return properties;
    }

    private ManagedConnectionFactory createManagedConnectionFactory(ConnectionDefinitionsDescriptor connectionDefinition, ArrayList properties) throws ResourceException {
        String factoryClassName = connectionDefinition.getManagedconnectionfactoryClass();
        try {
            ManagedConnectionFactory managedConnectionFactory = ConnectorFactory.createManagedConnectionFactory(factoryClassName, this.classLoader, properties);
            if (connectionDefinition.getLogFile() != null) {
                managedConnectionFactory.setLogWriter(JCAResource.createLogWriter(connectionDefinition));
            }
            if (managedConnectionFactory instanceof ResourceAdapterAssociation) {
                ((ResourceAdapterAssociation)managedConnectionFactory).setResourceAdapter(this.spiResourceAdapter);
            }
            return managedConnectionFactory;
        }
        catch (Throwable t) {
            throw new ResourceException(t);
        }
    }

    private JCAConnectionFactory createJCAConnectionFactory(ConnectionDefinitionsDescriptor connectionDefinition) throws ResourceException {
        ManagedConnectionPool managedConnectionPool;
        String exportName = connectionDefinition.getExportName();
        logger.debug(" ------ [JCAResource/createFactory] outbound factory " + exportName);
        ArrayList properties = this.createConnectionPropertyList(connectionDefinition);
        this.connectionPropertyListTable.put(exportName, properties);
        ManagedConnectionFactory managedConnectionFactory = this.createManagedConnectionFactory(connectionDefinition, properties);
        Object connectionFactory = managedConnectionFactory.createConnectionFactory();
        if (!(connectionFactory instanceof Referenceable)) {
            throw new ResourceAdapterInternalException("Connection factory implementation class must implement javax.resource.Referenceable");
        }
        Referenceable connectionFactoryRef = (Referenceable)connectionFactory;
        connectionFactoryRef.setReference(this.getBindingReference(exportName));
        try {
            managedConnectionPool = new ManagedConnectionPool(this.moduleName, this.appName, connectionDefinition, managedConnectionFactory, this.classLoader);
        }
        catch (Throwable t) {
            throw new InvalidPropertyException(t);
        }
        JCAConnectionFactory jcaConnectionFactory = (JCAConnectionFactory)JCAConnectionFactory.createMBean(exportName, this.myObjectName, managedConnectionPool);
        jcaConnectionFactory.setConnectionFactory(connectionFactoryRef);
        jcaConnectionFactory.initStatsMonitor(this.stats);
        this.jcaConnectionFactoryTable.put(exportName, jcaConnectionFactory);
        return jcaConnectionFactory;
    }

    private synchronized void recover(String exportName, JCAConnectionFactory jcaFactory) {
        Iterator iter = this.recoveredReferences.iterator();
        while (iter.hasNext()) {
            Reference ref = (Reference)iter.next();
            if (!exportName.equals(ref.get(1))) continue;
            jcaFactory.resyncCM(ref);
            iter.remove();
        }
    }

    private Reference getBindingReference(String exportName) {
        PropertyReference ref = new PropertyReference(ManagedConnectionFactory.class.getName(), ConnectorFactory.class.getName(), null);
        ref.add(0, new StringRefAddr(MODULE_NAME, this.moduleName));
        ref.add(1, new StringRefAddr(EXPORT_NAME, exportName));
        ref.add(2, new SerializableRefAddr(PROPERTIES, (ArrayList)this.connectionPropertyListTable.get(exportName)));
        return ref;
    }

    private Reference getRecoveryReference(String export) {
        return JCAResource.getRecoveryReference(this.moduleName, export);
    }

    public static Reference getRecoveryReference(String moduleName, String export) {
        Reference ref = new Reference(ManagedConnection.class.getName(), ConnectorFactory.class.getName(), null);
        ref.add(0, new StringRefAddr(MODULE_NAME, moduleName));
        ref.add(1, new StringRefAddr(EXPORT_NAME, export));
        return ref;
    }

    public JCAConnectionFactory getJCAConnectionFactory(String exportName) {
        return (JCAConnectionFactory)this.jcaConnectionFactoryTable.get(exportName);
    }

    public void resyncCM() throws ResourceException {
        Enumeration keys = this.jcaConnectionFactoryTable.keys();
        while (keys.hasMoreElements()) {
            String exportName = (String)keys.nextElement();
            this.resyncCM(exportName);
        }
    }

    public void resyncCM(String exportName) throws ResourceException {
        this.getConnectionFactory(exportName).resyncCM(this.getBindingReference(exportName));
    }

    public void enableCM() {
        for (JCAConnectionFactory factory : this.jcaConnectionFactoryTable.values()) {
            factory.enableCM();
        }
    }

    public void enableCM(String exportName) throws ResourceException {
        this.getConnectionFactory(exportName).enableCM();
    }

    public void disableCM() {
        for (JCAConnectionFactory factory : this.jcaConnectionFactoryTable.values()) {
            factory.disableCM();
        }
    }

    public void disableCM(String exportName) throws ResourceException {
        this.getConnectionFactory(exportName).disableCM();
    }

    public boolean isWorking(String exportName) throws Exception {
        return this.getConnectionFactory(exportName).isWorking();
    }

    public void destroy() {
        JCAConnectionFactory[] factorys = this.jcaConnectionFactoryTable.values().toArray(new JCAConnectionFactory[0]);
        for (int i = 0; i < factorys.length; ++i) {
            factorys[i].destroy();
        }
    }

    public void destroy(String exportName) throws ResourceException {
        this.getConnectionFactory(exportName).destroy();
    }

    public void shrinkCM() {
        for (JCAConnectionFactory factory : this.jcaConnectionFactoryTable.values()) {
            factory.shrinkCM();
        }
    }

    public void shrinkCM(String exportName) throws ResourceException {
        this.getConnectionFactory(exportName).shrinkCM();
    }

    public void invalidateCM() {
        for (JCAConnectionFactory factory : this.jcaConnectionFactoryTable.values()) {
            factory.invalidateCM();
        }
    }

    public void invalidateCM(String exportName) throws ResourceException {
        this.getConnectionFactory(exportName).invalidateCM();
    }

    public void dissociateCM() {
        for (JCAConnectionFactory factory : this.jcaConnectionFactoryTable.values()) {
            factory.dissociateCM();
        }
    }

    public void dissociateCM(String exportName) throws ResourceException {
        this.getConnectionFactory(exportName).dissociateCM();
    }

    public int getmin(String exportName) throws ResourceException {
        return this.getConnectionFactory(exportName).getmin();
    }

    public void setmin(String exportName, int min) throws ResourceException {
        this.getConnectionFactory(exportName).setmin(min);
    }

    public int getmax(String exportName) throws ResourceException {
        return this.getConnectionFactory(exportName).getmax();
    }

    public int getmaxWaiter(String exportName) throws ResourceException {
        return this.getConnectionFactory(exportName).getmaxWaiter();
    }

    public void setmaxWaiter(String exportName, int maxWaiter) throws ResourceException {
        this.getConnectionFactory(exportName).setmaxWaiter(maxWaiter);
    }

    public int getmaxDisposableCount(String exportName) throws ResourceException {
        return this.getConnectionFactory(exportName).getmaxDisposableCount();
    }

    public void setmaxDisposableCount(String exportName, int maxDisposableCount) throws ResourceException {
        this.getConnectionFactory(exportName).setmaxDisposableCount(maxDisposableCount);
    }

    public int getwaitTrial(String exportName) throws ResourceException {
        return this.getConnectionFactory(exportName).getwaitTrial();
    }

    public void setwaitTrial(String exportName, int waitTrial) throws ResourceException {
        this.getConnectionFactory(exportName).setwaitTrial(waitTrial);
    }

    public long getwaitingTime(String exportName) throws ResourceException {
        return this.getConnectionFactory(exportName).getwaitingTime();
    }

    public void setwaitingTime(String exportName, long waitingTime) throws ResourceException {
        this.getConnectionFactory(exportName).setwaitingTime(waitingTime);
    }

    public long getpooledTimeout(String exportName) throws ResourceException {
        return this.getConnectionFactory(exportName).getpooledTimeout();
    }

    public void setpooledTimeout(String exportName, long pooledTimeout) throws ResourceException {
        this.getConnectionFactory(exportName).setpooledTimeout(pooledTimeout);
    }

    public long getdissociationtimeout(String exportName) throws ResourceException {
        return this.getConnectionFactory(exportName).getdissociationtimeout();
    }

    public void setdissociationtimeout(String exportName, long dissociationtimeout) throws ResourceException {
        this.getConnectionFactory(exportName).setdissociationtimeout(dissociationtimeout);
    }

    public long getinvalidationtimeout(String exportName) throws ResourceException {
        return this.getConnectionFactory(exportName).getinvalidationtimeout();
    }

    public void setinvalidationtimeout(String exportName, long invalidationtimeout) throws ResourceException {
        this.getConnectionFactory(exportName).setinvalidationtimeout(invalidationtimeout);
    }

    public long getvalidationtimeout(String exportName) throws Exception {
        return this.getConnectionFactory(exportName).getvalidationtimeout();
    }

    public void setvalidationtimeout(String export, long validationtimeout) throws Exception {
        this.getConnectionFactory(export).setvalidationtimeout(validationtimeout);
    }

    public boolean getskipMatching(String exportName) throws ResourceException {
        return this.getConnectionFactory(exportName).getskipMatching();
    }

    public void setskipMatching(String exportName, boolean skipMatching) throws ResourceException {
        this.getConnectionFactory(exportName).setskipMatching(skipMatching);
    }

    public boolean getuseWrapper(String exportName) throws ResourceException {
        return this.getConnectionFactory(exportName).getuseWrapper();
    }

    public void setuseWrapper(String exportName, boolean useWrapper) throws ResourceException {
        this.getConnectionFactory(exportName).setuseWrapper(true);
    }

    private JCAConnectionFactory getConnectionFactory(String exportName) throws ResourceException {
        JCAConnectionFactory factory = (JCAConnectionFactory)this.jcaConnectionFactoryTable.get(exportName);
        if (factory == null) {
            throw new ResourceException("invalid export name " + exportName);
        }
        return factory;
    }

    public boolean isStandalone() {
        return this.standaloneDeploy;
    }

    public Stats getstats() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.stats;
    }

    private static PrintWriter createLogWriter(ConnectionDefinitionsDescriptor desc) throws IOException {
        String logFilename;
        String filename = logFilename = JCAResource.getAbsolutePath(desc.getLoggerFileName());
        String extension = "log";
        int pos1 = logFilename.lastIndexOf(46);
        int pos2 = logFilename.lastIndexOf(File.separatorChar);
        if (pos1 >= 0 && pos1 > pos2) {
            filename = logFilename.substring(0, pos1);
            extension = logFilename.substring(pos1 + 1);
        }
        int validDay = desc.getLoggerFileValidDay();
        int bufSize = desc.getBufferSize();
        return new PrintWriter((Writer)new RollOverFileWriter(filename, extension, true, bufSize, validDay), false);
    }

    private static String getAbsolutePath(String path) {
        File file = new File(path);
        String nativePath = file.getPath();
        if (file.isAbsolute()) {
            return nativePath;
        }
        if (OS.isWindows() && nativePath.length() > 1 && nativePath.charAt(0) == File.separatorChar) {
            return JeusProperties.JEUS_HOME.substring(0, 2) + nativePath;
        }
        return JeusProperties.JEUS_LOG_HOME + File.separatorChar + nativePath;
    }

    public ObjectName getresourceAdaptor() {
        return this.parentObjectName;
    }

    public ObjectName[] getconnectionFactories() {
        JCAConnectionFactory[] connectionFactories = this.jcaConnectionFactoryTable.values().toArray(new JCAConnectionFactory[0]);
        ObjectName[] objNames = new ObjectName[connectionFactories.length];
        for (int i = 0; i < connectionFactories.length; ++i) {
            objNames[i] = connectionFactories[i].getObjectName();
        }
        return objNames;
    }

    public CMInfo[] getCMInfo() throws Exception {
        JCAConnectionFactory[] factories = this.jcaConnectionFactoryTable.values().toArray(new JCAConnectionFactory[0]);
        CMInfo[] infos = new CMInfo[factories.length];
        for (int i = 0; i < factories.length; ++i) {
            infos[i] = factories[i].getCMInfo();
        }
        return infos;
    }
}

