/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanNotificationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.xml.bind.JAXBException;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.ModuleInfo;
import jeus.deploy.ModuleTypeSerializable;
import jeus.deploy.PermanentTarget;
import jeus.deploy.PermanentTargetModuleID;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.deploy.command.CommandUtils;
import jeus.deploy.util.ModuleTypeResolver;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.ejb.util.StringUtil;
import jeus.management.JMXUtility;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.management.enterprise.support.OrderNotificationBroadcasterSupport;
import jeus.management.j2ee.FileView;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.JEUSManagerMBean;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.JeusServer;
import jeus.server.JeusServerException;
import jeus.server.NodeControllerStub;
import jeus.server.manager.JeusVersion;
import jeus.server.util.ServerUtil;
import jeus.tool.util.FileUtil;
import jeus.tool.util.JarManager;
import jeus.util.CUtility;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusProperties;
import jeus.util.VirtualDNS;
import jeus.xml.binding.jeusDD.ApplicationType;
import jeus.xml.binding.jeusDD.JeusNodeType;
import jeus.xml.binding.jeusDD.JeusSystemType;
import jeus.xml.binding.jeusDD.ObjectFactory;

public class JEUSManager
extends J2EEManagedObjectSupport
implements JEUSManagerMBean {
    private Vector mJVMs = new Vector();
    private JeusServer server;
    private OrderNotificationBroadcasterSupport broadcaster;
    private Vector servers = new Vector();
    private Vector services = new Vector();
    private Permission addApplicationPermission;
    private Permission removeApplicationPermission;
    private Permission getServerInfoPermission;
    private Permission getFileInfoPermission;
    private Permission permanentDeployPermission;
    private Permission permanentUndeployPermission;
    private Permission getPIDPermission;
    private Permission getApplicationTypePermission;
    private Permission compilerPermission;
    private static Set extensions = new HashSet();
    private final String BACKUP_DIR = JeusBootstrapProperties.JEUS_HOME + File.separator + "webhome" + File.separator + "admin_home" + File.separator + "WEB-INF" + File.separator + "backup";

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    protected String initPermissionName() {
        return "jeus.server." + VirtualDNS.LOCAL_VIRTUALNAME;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.getApplicationTypePermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getApplicationType");
        this.addApplicationPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"addApplication");
        this.removeApplicationPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"removeApplication");
        this.getServerInfoPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getserverInfo");
        this.getFileInfoPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getFileInfo");
        this.permanentDeployPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"permanentDeploy");
        this.permanentUndeployPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"permanentUndeploy");
        this.getPIDPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"getPID");
        this.compilerPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"remote_compiler");
    }

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        JEUSManager mo = new JEUSManager(target);
        return mo.createMBean(srvName, "JeusService", parent, null, "JeusManager");
    }

    private JEUSManager(Object target) {
        super(new OrderNotificationBroadcasterSupport());
        this.server = (JeusServer)target;
        this.broadcaster = (OrderNotificationBroadcasterSupport)this.getNotificationBroadcasterSupport();
    }

    public String[] getjavaVMs() {
        LoginUtil.checkPermissionWithRuntimeException(this.getServerInfoPermission);
        return JMXUtility.getAsStringArray(this.mJVMs);
    }

    public String getserverVersion() {
        LoginUtil.checkPermissionWithRuntimeException(this.getServerInfoPermission);
        return JeusVersion.getVersion();
    }

    public String getserverVendor() {
        LoginUtil.checkPermissionWithRuntimeException(this.getServerInfoPermission);
        return "TMAX SOFT";
    }

    public String[] getjeusServices() {
        LoginUtil.checkPermissionWithRuntimeException(this.getServerInfoPermission);
        return JMXUtility.getAsStringArray(this.services);
    }

    public String[] getj2eeServers() {
        LoginUtil.checkPermissionWithRuntimeException(this.getServerInfoPermission);
        return JMXUtility.getAsStringArray(this.servers);
    }

    public ObjectName[] getj2eeServerNames() {
        LoginUtil.checkPermissionWithRuntimeException(this.getServerInfoPermission);
        return this.servers.toArray(new ObjectName[this.servers.size()]);
    }

    public boolean isWorking() {
        LoginUtil.checkPermissionWithRuntimeException(this.getServerInfoPermission);
        return this.server.isBooted();
    }

    public boolean isInCluster(String nodeName) {
        LoginUtil.checkPermissionWithRuntimeException(this.getServerInfoPermission);
        return this.server.isInCluster(nodeName);
    }

    public ApplicationType getApplicationType(String path) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.getApplicationTypePermission);
        File moduleFile = new File(path);
        AbstractArchive moduleArchive = moduleFile.isDirectory() ? FileArchiveFactory.openArchiveStatic((File)moduleFile) : JarArchiveFactory.openArchiveStatic((File)moduleFile);
        return JeusDeploymentManager.fillApplicationDDInfoFromArchive(moduleArchive, null);
    }

    public ModuleTypeSerializable getModuleType(String path) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.getApplicationTypePermission);
        File moduleFile = new File(path);
        if (!moduleFile.exists()) {
            throw new FileNotFoundException("cannot find module file : " + moduleFile.getAbsolutePath());
        }
        AbstractArchive moduleArchive = moduleFile.isDirectory() ? FileArchiveFactory.openArchiveStatic((File)moduleFile) : JarArchiveFactory.openArchiveStatic((File)moduleFile);
        return JeusDeploymentManager.getModuleTypeSerializable(moduleArchive);
    }

    public void addApplicationType(ApplicationType appType) throws IOException, JAXBException {
        LoginUtil.checkPermissionWithRuntimeException(this.addApplicationPermission);
        JeusMainDescriptorJB.addApplication(appType);
    }

    public void removeApplicationType(String moduleName) throws IOException, JAXBException {
        LoginUtil.checkPermissionWithRuntimeException(this.removeApplicationPermission);
        JeusMainDescriptorJB.removeApplication(new String[]{moduleName});
    }

    public void removeApplicationType(String[] moduleName) throws IOException, JAXBException {
        LoginUtil.checkPermissionWithRuntimeException(this.removeApplicationPermission);
        JeusMainDescriptorJB.removeApplication(moduleName);
    }

    public String[] getNodesFromDescriptor() throws IOException {
        LoginUtil.checkPermissionWithRuntimeException(this.getServerInfoPermission);
        JeusSystemType jeusSystem = JeusMainDescriptorJB.getJeusMainDescriptor();
        List nodeList = jeusSystem.getNode();
        String[] names = new String[nodeList.size()];
        for (int i = 0; i < nodeList.size(); ++i) {
            JeusNodeType nodeType = (JeusNodeType)nodeList.get(i);
            names[i] = nodeType.getName();
        }
        return names;
    }

    public String[] getAliveNodeNames() {
        LoginUtil.checkPermissionWithRuntimeException(this.getServerInfoPermission);
        Vector<String> list = this.server.getAliveNodeList();
        return list.toArray(new String[list.size()]);
    }

    public String[] boot() {
        Vector list = this.server.boot();
        return list.toArray(new String[list.size()]);
    }

    public boolean down() {
        return this.server.down();
    }

    public void addChild(ObjectName pChild) {
        LoginService.checkCodeSubject();
        String lType = JMXUtility.getJ2eeType(pChild);
        if ("JVM".equals(lType)) {
            this.mJVMs.add(pChild);
            super.addChild(pChild);
        } else if ("J2EEServer".equals(lType)) {
            if (!this.servers.contains(pChild)) {
                this.servers.add(pChild);
            }
            super.addChild(pChild);
        } else if ("JeusService".equals(lType)) {
            this.services.add(pChild);
            super.addChild(pChild);
        }
    }

    public void removeChild(ObjectName pChild) {
        LoginService.checkCodeSubject();
        String lType = JMXUtility.getJ2eeType(pChild);
        if ("JVM".equals(lType)) {
            this.mJVMs.remove(pChild);
            super.removeChild(pChild);
        } else if ("J2EEServer".equals(lType)) {
            this.servers.remove(pChild);
            super.removeChild(pChild);
        } else if ("JeusService".equals(lType)) {
            this.services.remove(pChild);
            super.removeChild(pChild);
        }
    }

    public String[] getEventTypes() {
        return new String[0];
    }

    public void sendNotificationByLIFO(String event, String message, Serializable userData) {
        Notification notification = this.getNotificationObject(event, this.myObjectName, message, userData);
        this.broadcaster.sendNotificationByLIFO(notification);
    }

    public JeusServer getJeusServer() {
        return this.server;
    }

    public FileView[] listFiles(String dirpath) {
        LoginUtil.checkPermissionWithRuntimeException(this.getFileInfoPermission);
        File[] files = null;
        if (dirpath.equals("/")) {
            if (System.getProperty("os.name").toLowerCase().indexOf("win") > -1) {
                files = File.listRoots();
            } else {
                File root = new File("/");
                files = root.listFiles();
            }
        } else {
            File dir = new File(dirpath);
            if (!(dir.exists() && dir.isDirectory() && dir.canRead())) {
                return new FileView[0];
            }
            files = dir.listFiles();
        }
        if (files == null || files.length == 0) {
            return new FileView[0];
        }
        ArrayList<FileView> list = new ArrayList<FileView>();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].exists() || !files[i].canRead()) continue;
            list.add(new FileView(files[i]));
        }
        FileView[] views = new FileView[list.size()];
        return list.toArray(views);
    }

    public FileView getjeusHome() {
        LoginUtil.checkPermissionWithRuntimeException(this.getFileInfoPermission);
        return new FileView(new File(JeusBootstrapProperties.JEUS_HOME));
    }

    public void dumpThread() {
        LoginUtil.checkPermissionWithRuntimeException(this.getServerInfoPermission);
        System.out.println("Dump Stack for the JEUS manager");
        CUtility.dumpThreadStack((int)CUtility.thisProcessPID);
        System.out.println("End of dump Stack for the JEUS manager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID deploy(String node, String srcPath, ApplicationType appType) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.permanentDeployPermission);
        ObjectFactory objFact = new ObjectFactory();
        appType = appType.cloneType(objFact.createApplicationType());
        NodeControllerStub ncStub = null;
        try {
            LoginUtil.loginCodeSubjectWithRuntimeException();
            String nodeName = this.myObjectName.getKeyProperty("name");
            String[] j2eeServers = this.getj2eeServers();
            String[] targets = CommandUtils.getJ2EEServerTargets(nodeName, j2eeServers, appType.getDeploymentTarget());
            String desPath = this.getAbsolutePath(targets[0], appType);
            ncStub = new NodeControllerStub();
            ncStub.connectTo(VirtualDNS.getRealNodeName(node));
            ncStub.rftp("abs:/" + srcPath, desPath);
            ncStub.disconnect();
            JeusDeploymentManager.setApplicationPath(appType, desPath);
        }
        finally {
            if (ncStub != null) {
                ncStub.disconnect();
            }
            LoginUtil.logoutWithRuntimeException();
        }
        JeusMainDescriptorJB.addApplication(appType);
        return new PermanentTargetModuleID(new PermanentTarget(this.myObjectName), JeusDeploymentManager.getNameFromPath(appType));
    }

    public TargetModuleID deploy(ApplicationType appType) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.permanentDeployPermission);
        ObjectFactory objFact = new ObjectFactory();
        appType = appType.cloneType(objFact.createApplicationType());
        JeusMainDescriptorJB.addApplication(appType);
        return new PermanentTargetModuleID(new PermanentTarget(this.myObjectName), JeusDeploymentManager.getNameFromPath(appType));
    }

    private String getAbsolutePath(String j2eeServer, ApplicationType appType) {
        if (this.servers == null || this.servers.size() == 0) {
            return null;
        }
        String basePath = null;
        for (int i = 0; i < this.servers.size(); ++i) {
            ObjectName objName = (ObjectName)this.servers.get(i);
            if (!objName.getKeyProperty("name").equals(j2eeServer)) continue;
            try {
                List result = (List)MEJBUtility.getMEJBUtility().getAttribute(objName, "AppPaths");
                basePath = (String)result.get(0);
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String fs = File.separator;
        return basePath + fs + new File(JeusDeploymentManager.getApplicationPath(appType)).getName();
    }

    public void undeploy(String name) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.permanentUndeployPermission);
        JeusMainDescriptorJB.removeApplication(new String[]{name});
    }

    public int getPID() {
        LoginUtil.checkPermissionWithRuntimeException(this.getPIDPermission);
        return CUtility.thisProcessPID;
    }

    public String getConfigModifyInfo() {
        return this.server.getConfigModifyInfo();
    }

    public boolean isBackupNode() {
        return this.server.isBackupNode();
    }

    public static ObjectName makeObjectName(String nodeName) throws MalformedObjectNameException {
        String name = "JEUS:j2eeType=JeusService,jeusType=JeusManager,JMXManager=" + nodeName + "," + "name" + "=" + nodeName;
        return new ObjectName(name);
    }

    private List getDeployNames() {
        if (this.servers == null || this.servers.size() == 0) {
            return null;
        }
        ArrayList<String> deployNames = new ArrayList<String>();
        for (int i = 0; i < this.servers.size(); ++i) {
            ObjectName objName = (ObjectName)this.servers.get(i);
            try {
                String[] deployedObjects = (String[])MEJBUtility.getMEJBUtility().getAttribute(objName, "DeployedObjects");
                int j = 0;
                while (i < deployedObjects.length) {
                    deployNames.add(deployedObjects[j]);
                    ++j;
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return deployNames;
    }

    public String getAppHome() {
        return JeusProperties.JEUS_APP_HOME;
    }

    public List getAppArchives(String path) throws MalformedURLException {
        ArrayList<AbstractArchive> appArchiveList = new ArrayList<AbstractArchive>();
        if (path == null) {
            appArchiveList.add(FileArchiveFactory.appendArchive((String)JeusProperties.JEUS_APP_HOME));
            appArchiveList.add(FileArchiveFactory.appendArchive((String)JeusProperties.AUTO_DEPLOY_DIR));
        } else {
            appArchiveList.add(FileArchiveFactory.appendArchive((String)path));
        }
        return appArchiveList;
    }

    public ModuleInfo[] getDistributedModules(String path, Vector mDeployedObjects) throws IOException {
        return this.getDistributedModules(path, mDeployedObjects, 0);
    }

    public int getContainerBasePort(String containerName) {
        try {
            return JeusMainDescriptorJB.getContainerBasePort(containerName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getContainerBasePortFromEngineName(String engineName) {
        try {
            return JeusMainDescriptorJB.getContainerBasePortFromEngineName(engineName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List listModules(FileArchive filearch, List deployedNames, Hashtable deployedModules, int level) throws IOException {
        File[] moduleFiles = filearch.getFile().listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                if (pathname.getName().lastIndexOf(46) < 0) {
                    return false;
                }
                String extension = pathname.getName().substring(pathname.getName().lastIndexOf(46));
                return extensions.contains(extension);
            }
        });
        ArrayList<ModuleInfo> modules = new ArrayList<ModuleInfo>();
        for (int i = 0; i < moduleFiles.length; ++i) {
            String distributedType;
            String moduleName;
            ModuleType moduleType;
            File moduleFile = moduleFiles[i];
            AbstractArchive archive = moduleFile.isDirectory() ? FileArchiveFactory.openArchiveStatic((File)moduleFile) : JarArchiveFactory.openArchiveStatic((File)moduleFile);
            try {
                moduleType = ModuleTypeResolver.getModuleType(archive, level);
            }
            catch (Exception re) {
                continue;
            }
            if (moduleType == null) continue;
            if (moduleFile.isFile()) {
                moduleName = moduleFile.getName();
                int dot = moduleName.lastIndexOf(".");
                if (dot >= 0) {
                    moduleName = moduleName.substring(0, dot);
                }
                distributedType = "ARCHIVED";
            } else {
                moduleName = moduleFile.getName();
                distributedType = "EXPLODED";
            }
            String modulePath = archive.getArchiveUri();
            ModuleInfo info = new ModuleInfo();
            info.setModuleType(moduleType);
            info.setModuleName(moduleName);
            info.setModulePath(modulePath);
            info.setDistributedType(distributedType);
            if (deployedNames != null && deployedNames.contains(moduleName) && deployedModules.containsKey(moduleName) && moduleType.equals(deployedModules.get(moduleName))) {
                info.setDeployed(true);
            }
            modules.add(info);
            this.cleanArchive(archive);
        }
        return modules;
    }

    private void cleanArchive(AbstractArchive archive) {
        if (archive != null) {
            try {
                archive.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String ejbCompiler(String[] args) throws JeusServerException {
        LoginUtil.checkPermissionWithRuntimeException(this.compilerPermission);
        try {
            String jrePath = System.getProperty("java.home");
            String command = jrePath.substring(0, jrePath.lastIndexOf(File.separator.charAt(0))) + File.separator + "bin" + File.separator + "java -classpath ";
            command = command + JeusBootstrapProperties.JEUS_HOME + File.separator + "lib" + File.separator + "system" + File.separator + "bootstrap.jar";
            String path = JeusBootstrapProperties.SERVER_CLASSPATH;
            if (path != null) {
                command = File.separator.equals("/") ? command + " -Djeus.server.classpath=" + path : command + " \"-Djeus.server.classpath=" + path + "\"";
            }
            command = command + " -Djeus.home=" + JeusBootstrapProperties.JEUS_HOME;
            command = command + " -Djava.endorsed.dirs=" + JeusBootstrapProperties.JEUS_HOME + File.separator + "lib" + File.separator + "endorsed";
            command = command + " jeus.tool.compiler.AppCompilerBootstrapper ";
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                command = command + arg + " ";
            }
            Runtime process = Runtime.getRuntime();
            Process p = process.exec(command);
            return StringUtil.getStringFromInputStream(p);
        }
        catch (Throwable e) {
            String msg = "fail to generate and compile with the argment ";
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                msg = msg + arg + " ";
            }
            throw new JeusServerException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyBackupDescription(String name) {
        String nodeName = this.server.getNodeName();
        String nodeDir = JeusProperties.JEUS_CONFIG_HOME + File.separator + nodeName;
        String backupDir = this.BACKUP_DIR + File.separator + nodeName + File.separator + "backup";
        try {
            if (name.equals("backup")) {
                String backuptemp = this.BACKUP_DIR + File.separator + nodeName + File.separator + "backup_temp";
                FileUtil.rmdir(backuptemp);
                FileUtil.copyDirectory(nodeDir, backuptemp);
                FileUtil.rmdir(nodeDir);
                FileUtil.copyDirectory(backupDir, nodeDir);
                FileUtil.rmdir(backupDir);
                FileUtil.copyDirectory(backuptemp, backupDir);
                FileUtil.rmdir(backuptemp);
            } else {
                String sourceDir = this.BACKUP_DIR + File.separator + nodeName + File.separator + name;
                FileUtil.rmdir(backupDir);
                FileUtil.copyDirectory(nodeDir, backupDir);
                FileUtil.rmdir(nodeDir);
                FileUtil.copyDirectory(sourceDir, nodeDir);
            }
        }
        catch (Exception e1) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean backupDescription(String name, String content) {
        block15: {
            String nodeName = this.server.getNodeName();
            File parent = new File(this.BACKUP_DIR, nodeName);
            File target = new File(parent, name);
            if (target.exists()) {
                return false;
            }
            String sourceDir = JeusProperties.JEUS_CONFIG_HOME + File.separator + nodeName;
            try {
                FileUtil.copyDirectory(sourceDir, target.getCanonicalPath());
                if (content == null) break block15;
                BufferedWriter writer = null;
                try {
                    writer = new BufferedWriter(new FileWriter(new File(parent, name + "_description.txt")));
                    writer.write(content);
                    writer.flush();
                }
                catch (IOException e) {
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (IOException e1) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getBackupDescriptionInfo(String name) {
        String nodeName = this.server.getNodeName();
        File parent = new File(this.BACKUP_DIR, nodeName);
        File backup = new File(parent, name);
        if (!backup.exists()) {
            return null;
        }
        String[] info = new String[3];
        info[0] = name;
        info[1] = String.valueOf(backup.lastModified());
        File backupDescription = new File(parent, name + "_description.txt");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(backupDescription));
            StringWriter writer = new StringWriter();
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.write(line + "\n");
            }
            info[2] = writer.toString();
        }
        catch (Exception e) {
            info[2] = "";
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return info;
    }

    public String[] getBackupDescriptionNames() {
        String nodeName = this.server.getNodeName();
        File backup = new File(this.BACKUP_DIR, nodeName);
        File[] backups = backup.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (backups == null) {
            return new String[0];
        }
        String[] backupNames = new String[backups.length];
        int length = backups.length;
        for (int i = 0; i < length; ++i) {
            backupNames[i] = backups[i].getName();
        }
        return backupNames;
    }

    public void removeBackupDescription(String name) {
        String nodeName = this.server.getNodeName();
        FileUtil.rmdir(this.BACKUP_DIR + File.separator + nodeName + File.separator + name);
        File description = new File(this.BACKUP_DIR + File.separator + nodeName + File.separator + name + "_description.txt");
        if (description.exists()) {
            description.delete();
        }
    }

    public void backupModule(String moduleName, String source, String content) {
        block6: {
            String base = JeusProperties.JEUS_HOME + "/webhome/app_backup_home/" + moduleName;
            BufferedWriter writer = null;
            File target = null;
            try {
                AbstractArchive archive = JarArchiveFactory.openArchiveStatic((String)source);
                ModuleType moduleType = ModuleTypeResolver.getModuleType(archive);
                File sourceFile = new File(source);
                String fileName = sourceFile.getName();
                long time = System.currentTimeMillis();
                base = base + File.separator + moduleType.getValue() + "__" + time + "__" + fileName;
                target = new File(base, fileName);
                FileUtil.copy(sourceFile, target);
            }
            catch (Exception e) {
                if (target != null && target.exists()) {
                    target.delete();
                    target.getParentFile().delete();
                }
                content = null;
            }
            if (content != null) {
                target = null;
                try {
                    target = new File(base + "_description.txt");
                    writer = new BufferedWriter(new FileWriter(target));
                    writer.write(content);
                    writer.flush();
                }
                catch (IOException e) {
                    if (target == null || !target.exists()) break block6;
                    target.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listBackupModules() {
        File parent = new File(JeusProperties.JEUS_HOME + "/webhome/app_backup_home/");
        File[] modules = parent.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        ArrayList<String> result = new ArrayList<String>();
        for (File module : modules) {
            File[] sub = module.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            int sLength = sub.length;
            for (int s = 0; s < sLength; ++s) {
                String content = "";
                File backupDescription = new File(module, sub[s].getName() + "_description.txt");
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(backupDescription));
                    StringWriter writer = new StringWriter();
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        writer.write(line + "\n");
                    }
                    content = writer.toString();
                }
                catch (Exception e) {
                    content = "";
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                result.add(module.getName() + "::" + sub[s].getName() + "::" + content);
            }
        }
        return result;
    }

    public void removeBackupModule(String moduleName, String key) {
        String target = JeusProperties.JEUS_HOME + "/webhome/app_backup_home/" + moduleName + "/" + key;
        String description = JeusProperties.JEUS_HOME + "/webhome/app_backup_home/" + moduleName + "/" + key + "_description.txt";
        FileUtil.rmdir(target);
        File file = new File(description);
        if (file.exists()) {
            file.delete();
        }
    }

    public ModuleInfo[] getDistributedModules(String path, Vector mDeployedObjects, int level) throws IOException {
        ArrayList moduleInfos = new ArrayList();
        List appArchiveList = this.getAppArchives(path);
        List<String> deployedNames = Arrays.asList(JMXUtility.getNameStringArray(mDeployedObjects.toArray(new ObjectName[mDeployedObjects.size()])));
        Hashtable<String, ModuleType> deployedModules = new Hashtable<String, ModuleType>();
        for (int k = 0; k < mDeployedObjects.size(); ++k) {
            ObjectName objName = (ObjectName)mDeployedObjects.get(k);
            ModuleType moduleType = null;
            String type = objName.getKeyProperty("j2eeType");
            if (type.equals("J2EEApplication")) {
                moduleType = ModuleType.EAR;
            } else if (type.equals("EJBModule")) {
                moduleType = ModuleType.EJB;
            } else if (type.equals("WebModule")) {
                moduleType = ModuleType.WAR;
            } else if (type.equals("ResourceAdapterModule")) {
                moduleType = ModuleType.RAR;
            } else if (type.equals("AppClientModule")) {
                moduleType = ModuleType.CAR;
            }
            String moduleName = objName.getKeyProperty("name");
            deployedModules.put(moduleName, moduleType);
        }
        for (int i = 0; i < appArchiveList.size(); ++i) {
            FileArchive archive = (FileArchive)appArchiveList.get(i);
            moduleInfos.addAll(this.listModules(archive, deployedNames, deployedModules, 1));
        }
        return moduleInfos.toArray(new ModuleInfo[moduleInfos.size()]);
    }

    public ModuleInfo getModuleInfo(String path) throws IOException {
        File targetFile = new File(path);
        if (targetFile.isAbsolute() ? !targetFile.exists() : !(targetFile = new File(this.getAppHome(), path)).exists()) {
            throw new FileNotFoundException(targetFile.getName());
        }
        AbstractArchive archive = null;
        archive = targetFile.isDirectory() ? FileArchiveFactory.openArchiveStatic((File)targetFile) : JarArchiveFactory.openArchiveStatic((File)targetFile);
        ModuleType moduleType = ModuleTypeResolver.getModuleType(archive, 1);
        String moduleName = targetFile.getName();
        int i = moduleName.lastIndexOf(".");
        if (i > 0) {
            moduleName = moduleName.substring(0, i);
        }
        ModuleInfo mi = new ModuleInfo();
        if (targetFile.isDirectory()) {
            mi.setDistributedType("EXPLODED");
        } else {
            mi.setDistributedType("ARCHIVED");
        }
        mi.setModuleName(moduleName);
        mi.setModulePath(targetFile.getCanonicalPath());
        mi.setModuleType(moduleType);
        return mi;
    }

    public FileView getFileInfo(String path) throws IOException {
        LoginUtil.checkPermissionWithRuntimeException(this.getFileInfoPermission);
        return new FileView(new File(ServerUtil.getNodeDependentPath(path)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ftp(String srcpath, String destnode, String destparent) throws IOException {
        File src = new File(srcpath);
        if (!src.exists()) {
            throw new FileNotFoundException(srcpath);
        }
        String prefix = null;
        boolean isUnjar = false;
        if (src.isDirectory()) {
            isUnjar = true;
            prefix = src.getName();
            File temp = File.createTempFile(prefix, ".jar");
            JarManager.jar(temp, src.getCanonicalPath());
            src = temp;
        }
        NodeControllerStub ncStub = null;
        try {
            LoginUtil.loginCodeSubjectWithRuntimeException();
            String dest = null;
            dest = destparent == null ? "web:/app_home" : "abs:" + destparent;
            dest = isUnjar ? dest + "/" + prefix + "/" + src.getName() : dest + "/" + src.getName();
            ncStub = new NodeControllerStub();
            ncStub.connectTo(VirtualDNS.getRealNodeName(destnode));
            boolean bl = ncStub.ftp(src.getCanonicalPath(), dest, isUnjar);
            return bl;
        }
        finally {
            if (ncStub != null) {
                ncStub.disconnect();
            }
            if (isUnjar && src.exists()) {
                src.delete();
            }
            LoginUtil.logoutWithRuntimeException();
        }
    }

    static {
        extensions.add(ModuleType.EAR.getModuleExtension());
        extensions.add(ModuleType.WAR.getModuleExtension());
        extensions.add(ModuleType.EJB.getModuleExtension());
        extensions.add(ModuleType.CAR.getModuleExtension());
        extensions.add(ModuleType.RAR.getModuleExtension());
    }
}

