/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee;

import java.security.Permission;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.JVMMBean;
import jeus.management.j2ee.manager.JeusProcess;
import jeus.management.j2ee.statistics.BoundedRangeStatisticImpl;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.management.j2ee.statistics.JVMStats;
import jeus.management.j2ee.statistics.JVMStatsImpl;
import jeus.management.j2ee.statistics.RangeStatisticImpl;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;

public class JVM
extends J2EEManagedObjectSupport
implements JVMMBean {
    private RangeStatisticImpl totalSize;
    private Permission runGCPermission = PermissionMaker.makeResourcePermission((String)"jeus.management.jvm", (String)"runGC");
    private Permission getstatsPermission = PermissionMaker.makeResourcePermission((String)"jeus.management.jvm", (String)"getstats");
    public static final String PERMISSION_NAME = "jeus.management.jvm";
    private JVMStatsImpl stat;
    private JeusProcess target;
    private BoundedRangeStatisticImpl heapSize;
    private CountStatisticImpl upTime;

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        JVM jvmMbean = new JVM(parent, (JeusProcess)target);
        return jvmMbean.createMBean(mBeanName, "JVM", parent, parentKeyMap, null);
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean parent = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return parent.getPermissionName() + ".jvm";
    }

    public JVM(ObjectName parent, JeusProcess target) {
        super(parent);
        this.target = target;
        this.stat = new JVMStatsImpl();
        this.heapSize = new BoundedRangeStatisticImpl("HeapSize", "byte", "The size of the JVM's heap", 0L, 0L);
        this.totalSize = new RangeStatisticImpl("TotalSize", "byte", "The size of the total memory");
        this.upTime = new CountStatisticImpl("UpTime", "millisecond", "The amount of time the JVM has been running");
        this.stat.setStatistic((Statistic)this.heapSize);
        this.stat.setStatistic((Statistic)this.totalSize);
        this.stat.setStatistic((Statistic)this.upTime);
    }

    private long getCurrentMemory() {
        Runtime r = Runtime.getRuntime();
        return r.totalMemory() - r.freeMemory();
    }

    public String getjavaVersion() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.readPropertiesPermission);
        return System.getProperty("java.vm.version");
    }

    public String getjavaVendor() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.readPropertiesPermission);
        return System.getProperty("java.vm.vendor");
    }

    public String getOSName() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.readPropertiesPermission);
        return System.getProperty("os.name");
    }

    public String getOSVersion() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.readPropertiesPermission);
        return System.getProperty("os.version");
    }

    public Properties getAllProperties() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.readPropertiesPermission);
        return System.getProperties();
    }

    public String getnode() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.readPropertiesPermission);
        try {
            return this.target.getNodeName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getContainer() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.readPropertiesPermission);
        try {
            return this.target.getContainerName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void runGC() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException(this.runGCPermission);
        System.gc();
    }

    public Stats getstats() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        this.upTime.setValue(System.currentTimeMillis() - this.upTime.getStartTime());
        this.heapSize.set(this.getCurrentMemory());
        this.totalSize.set(Runtime.getRuntime().totalMemory());
        return this.stat;
    }

    public JVMStats getStats() {
        return (JVMStats)this.getstats();
    }
}

