/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.security;

import java.security.Permission;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.security.base.CredentialFactory;
import jeus.security.base.Domain;
import jeus.security.base.PropertyHolder;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.resource.ExpiryTimeFactory;
import jeus.security.resource.LockFactory;
import jeus.security.resource.PasswordFactory;
import jeus.security.resource.PrincipalImpl;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.spi.GroupNotExistsException;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.security.util.SetUtil;

public class SubjectMo
extends J2EEManagedObjectSupport
implements SubjectMoMBean {
    private AuthenticationRepositoryService target;
    private ResourcePermission subjectPermission;
    private String domainName;

    public SubjectMo(ObjectName parent, Object target) {
        super(parent);
        this.target = (AuthenticationRepositoryService)target;
        this.domainName = this.target.getDomain().getName();
    }

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        SubjectMo object = new SubjectMo(parent, target);
        return object.createMBean(mBeanName, "JeusService", parent, SubjectMoMBean.parentKeyMap, "SecuritySubject");
    }

    public Stats getstats() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject getSubject(String name) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            Subject subject = AuthenticationRepositoryService.getSubject(this.target.getDomain(), name);
            return subject;
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getSubjectNames() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            Set set = AuthenticationRepositoryService.getSubjectNames(this.target.getDomain());
            return set;
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubject(Subject subject) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            AuthenticationRepositoryService.addSubject(this.target.getDomain(), subject);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubject(Subject subject) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            AuthenticationRepositoryService.removeSubject(this.target.getDomain(), subject);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubject(String name) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            AuthenticationRepositoryService.removeSubject(this.target.getDomain(), name);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    public void save() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        AuthenticationRepositoryService.save(this.target.getDomain());
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean parent = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return parent.getPermissionName() + ".subject";
    }

    protected void makePermissions() {
        super.makePermissions();
        this.subjectPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"subjectControl");
    }

    public Object readSubjectsInRepository() throws ServiceException, SecurityException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        return AuthenticationRepositoryService.readSubject(this.target.getDomain());
    }

    public void writeSubjectsToRepository(Object subjects) throws ServiceException, SecurityException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        AuthenticationRepositoryService.writeSubject(this.target.getDomain(), subjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean userExist(String userName) throws ServiceException, SecurityException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            boolean bl = AuthenticationRepositoryService.userExist(userName);
            return bl;
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean groupExist(String groupName) throws ServiceException, SecurityException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            boolean bl = AuthenticationRepositoryService.groupExist(groupName);
            return bl;
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(Group group) throws GroupNotExistsException, ServiceException, SecurityException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            AuthenticationRepositoryService.addGroup(group);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserToGroup(String groupName, Principal principal) throws GroupNotExistsException, ServiceException, SecurityException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            AuthenticationRepositoryService.addUserToGroup(groupName, principal);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGroup(String groupName) throws GroupNotExistsException, ServiceException, SecurityException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            Group group = AuthenticationRepositoryService.getGroup(groupName);
            return group;
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getGroupNames() throws ServiceException, SecurityException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            Set set = AuthenticationRepositoryService.getGroupNames();
            return set;
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group[] getGroupList() throws GroupNotExistsException, ServiceException, SecurityException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            Group[] groupArray = AuthenticationRepositoryService.getGroupList();
            return groupArray;
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(String groupName) throws GroupNotExistsException, ServiceException, SecurityException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            AuthenticationRepositoryService.removeGroup(groupName);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserFromGroup(String groupName, Principal principal) throws GroupNotExistsException, ServiceException, SecurityException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            AuthenticationRepositoryService.removeUserFromGroup(groupName, principal);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMember(String groupName, Principal principal) throws GroupNotExistsException, ServiceException, SecurityException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            boolean bl = AuthenticationRepositoryService.isMember(groupName, principal);
            return bl;
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getMembersFromGroup(String groupName) throws GroupNotExistsException, ServiceException, SecurityException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            ArrayList arrayList = AuthenticationRepositoryService.getMemberListFromGroup(groupName);
            return arrayList;
        }
        finally {
            Domain.unsetCurrentDomain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setPassword(String username, String password) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            Subject sub = Subject.makeSubject(username, password, true);
            Subject sub2 = AuthenticationRepositoryService.getSubject(username);
            Set s = SetUtil.getMembers(PasswordFactory.class, sub2.getCredentialFactories());
            Subject sub3 = Subject.makeSubject(username);
            sub3.getCredentialFactories().addAll(s);
            AuthenticationRepositoryService.addSubject(sub);
            AuthenticationRepositoryService.removeSubject(sub3);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
        return "Password set for " + username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lockSubject(String username) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            AuthenticationRepositoryService.getSubject(username);
            Subject sub = Subject.makeSubject(username);
            sub.getCredentialFactories().add(new LockFactory());
            AuthenticationRepositoryService.addSubject(sub);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
        return "Subject " + username + " has been locked out";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String unlockSubject(String username) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            Subject sub = AuthenticationRepositoryService.getSubject(username);
            Set s = SetUtil.getMembers(LockFactory.class, sub.getCredentialFactories());
            Subject sub3 = Subject.makeSubject(username);
            sub3.getCredentialFactories().addAll(s);
            AuthenticationRepositoryService.removeSubject(sub3);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
        return "Unlocked " + username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setSubjectExpiration(String username, String expirytime) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            AuthenticationRepositoryService.getSubject(username);
            Subject sub = Subject.makeSubject(username);
            ExpiryTimeFactory etf = new ExpiryTimeFactory();
            etf.setProperty("expires", expirytime);
            sub.getCredentialFactories().add(etf);
            AuthenticationRepositoryService.addSubject(sub);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
        return "Expiration time set for Subject " + expirytime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clearSubjectExpiration(String username) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            Subject sub = AuthenticationRepositoryService.getSubject(username);
            Set s = SetUtil.getMembers(ExpiryTimeFactory.class, sub.getCredentialFactories());
            Subject sub3 = Subject.makeSubject(username);
            sub3.getCredentialFactories().addAll(s);
            AuthenticationRepositoryService.removeSubject(sub3);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
        return "Expiration time removed for Subject " + username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addPrincipal(String username, String principal) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            AuthenticationRepositoryService.getSubject(username);
            Subject sub = Subject.makeSubject(username);
            sub.getPrincipals().add(new PrincipalImpl(principal));
            AuthenticationRepositoryService.addSubject(sub);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
        return "Added principal " + principal + " to Subject " + username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removePrincipal(String username, String principal) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            Subject sub = Subject.makeSubject(username);
            sub.getPrincipals().add(new PrincipalImpl(principal));
            AuthenticationRepositoryService.removeSubject(sub);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
        return "Removed principal " + principal + " from Subject " + username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setSubjectDescription(String username, String desc) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            AuthenticationRepositoryService.getSubject(username);
            Subject sub = Subject.makeSubject(username);
            sub.setDescription(desc);
            AuthenticationRepositoryService.addSubject(sub);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
        return "Set description for Subject " + username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addCredential(String username, String classname, String properties) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            Subject sub = Subject.makeSubject(username);
            CredentialFactory cf = (CredentialFactory)Class.forName(classname).newInstance();
            this.addProperties(cf, properties);
            sub.getCredentialFactories().add(cf);
            AuthenticationRepositoryService.addSubject(sub);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
        return "Added credential with credential factory \"" + classname + "\" to Subject \"" + username + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeCredential(String username, String classname, String properties) throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        Domain.setCurrentDomain(this.domainName);
        try {
            Subject sub = Subject.makeSubject(username);
            CredentialFactory cf = (CredentialFactory)Class.forName(classname).newInstance();
            this.addProperties(cf, properties);
            sub.getCredentialFactories().add(cf);
            AuthenticationRepositoryService.removeSubject(sub);
        }
        finally {
            Domain.unsetCurrentDomain();
        }
        return "Removed credential with credential factory \"" + classname + "\" from Subject \"" + username + "\"";
    }

    public void addProperties(PropertyHolder holder, String properties) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.subjectPermission);
        if (properties == null || holder == null) {
            return;
        }
        properties = properties.trim();
        StringTokenizer st = new StringTokenizer(properties, ";");
        while (st.hasMoreTokens()) {
            String prop = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(prop, "=");
            if (!st2.hasMoreTokens()) continue;
            String name = st2.nextToken().trim();
            String value = null;
            if (st2.hasMoreTokens()) {
                value = st2.nextToken().trim();
            }
            if (value != null) {
                holder.setProperty(name, value);
                continue;
            }
            holder.setProperty(name, "true");
        }
    }
}

