/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.servlet;

import java.rmi.ServerException;
import java.security.Permission;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.WebModule;
import jeus.management.j2ee.servlet.ContextGroupMoMBean;
import jeus.management.j2ee.servlet.WebListenerMo;
import jeus.management.j2ee.servlet.WebModuleDeployInfo;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.servlet.connection.Connector;
import jeus.servlet.connection.WebtobConnector;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ServletWrapper;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.xml.binding.jeusDD.SessionConfigType;

public class ContextGroupMo
extends J2EEManagedObjectSupport
implements ContextGroupMoMBean {
    private ContextGroup target;
    private Vector webModules = new Vector();
    private Hashtable contextNames = new Hashtable();
    private Vector webListeners = new Vector();
    private List sessionManagers = new CopyOnWriteArrayList();
    private ResourcePermission contextGroupInfoPermission;
    private ResourcePermission contextGroupControlPermission;
    private Hashtable deployTable = new Hashtable();
    private Object tableSync = new Object();

    public ContextGroupMo(Object target, ObjectName parent) {
        super(parent);
        this.target = (ContextGroup)target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDeployTable(String ctxName, WebModuleDeployInfo winfo) {
        Object object = this.tableSync;
        synchronized (object) {
            this.deployTable.put(ctxName, winfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebModuleDeployInfo[] getDeployObjects() {
        Object object = this.tableSync;
        synchronized (object) {
            return this.deployTable.values().toArray(new WebModuleDeployInfo[this.deployTable.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebModuleDeployInfo getDeployObject(String ctxName) {
        Object object = this.tableSync;
        synchronized (object) {
            return (WebModuleDeployInfo)this.deployTable.get(ctxName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWebModuleDeployInfo(String ctxName, WebModuleDeployInfo winfo) {
        Object object = this.tableSync;
        synchronized (object) {
            this.deployTable.put(ctxName, winfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWebModuleDeployInfo(String ctxName) {
        Object object = this.tableSync;
        synchronized (object) {
            this.deployTable.remove(ctxName);
        }
    }

    public void clearDeployTable() {
        this.deployTable.clear();
    }

    public boolean isExistRuntimeDeplyModule() {
        Enumeration enum1 = this.deployTable.elements();
        while (enum1.hasMoreElements()) {
            WebModuleDeployInfo winfo = (WebModuleDeployInfo)enum1.nextElement();
            if (!winfo.isRuntimeDeploy()) continue;
            return true;
        }
        return false;
    }

    public String[] getWebModules() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.contextGroupInfoPermission);
        return JMXUtility.getAsStringArray(this.webModules);
    }

    public String[] getWebListeners() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.contextGroupInfoPermission);
        return JMXUtility.getAsStringArray(this.webListeners);
    }

    public List getSessionContainer() throws Exception {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.contextGroupInfoPermission);
        return this.sessionManagers;
    }

    public boolean suspendContextGroup() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.contextGroupControlPermission);
        return this.target.execSuspend();
    }

    public boolean resumeContextGroup() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.contextGroupControlPermission);
        return this.target.execResume();
    }

    public boolean clearStatContextGroup() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.contextGroupControlPermission);
        boolean result = true;
        Enumeration enum2 = this.target.getContexts();
        while (enum2.hasMoreElements()) {
            Context context = (Context)enum2.nextElement();
            Enumeration enum1 = context.getContextLoader().getServlets();
            while (enum1.hasMoreElements()) {
                ServletWrapper wrapper = (ServletWrapper)enum1.nextElement();
                result &= wrapper.clearRequestCount();
            }
            context.clearStatistic();
        }
        return result;
    }

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        ContextGroupMo object = new ContextGroupMo(target, parent);
        return object.createMBean(mBeanName, "JeusService", parent, parentKeyMap, "ContextGroup");
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean module = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        String name = module.getPermissionName();
        name = name + ".contextGroup." + this.myNameString;
        return name;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.contextGroupInfoPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"contextGroupInfo");
        this.contextGroupControlPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"contextGroupControl");
    }

    public void addWebModule(String contextName, ObjectName objectName) {
        this.contextNames.put(contextName, objectName);
        this.webModules.add(objectName);
    }

    public ObjectName getContextByName(String contextName) {
        return (ObjectName)this.contextNames.get(contextName);
    }

    public void setSessionTimeout(String timeout) {
        try {
            this.target.setSessionTimeout(timeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSessionTimeout() {
        SessionConfigType sessionDescType = this.target.getContextGroupDescriptor().getSessionDescType();
        if (sessionDescType != null) {
            return "" + sessionDescType.getTimeout();
        }
        return "";
    }

    public ObjectName getListenerByName(String listenerId) {
        Enumeration enum1 = this.webListeners.elements();
        while (enum1.hasMoreElements()) {
            ObjectName objName = (ObjectName)enum1.nextElement();
            if (!objName.getKeyProperty("name").equals(listenerId)) continue;
            return objName;
        }
        return null;
    }

    public void removeWebModule(String contextName) {
        Object objectName = this.contextNames.remove(contextName);
        if (objectName != null) {
            this.webModules.remove(objectName);
        }
    }

    public void addChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType(pChild);
        if (lType.equals("WebListener")) {
            this.webListeners.add(pChild);
        }
        if (lType.equals("SessionContainer") || lType.equals("SessionContainerCentral") || lType.equals("SessionContainerP2P")) {
            this.sessionManagers.add(pChild);
        }
        super.addChild(pChild);
    }

    public void removeChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType(pChild);
        if (lType.equals("WebListener")) {
            this.webListeners.remove(pChild);
        }
        if (lType.equals("SessionContainer") || lType.equals("SessionContainerCentral") || lType.equals("SessionContainerP2P")) {
            this.sessionManagers.remove(pChild);
        }
        super.removeChild(pChild);
    }

    protected void preStart() throws Exception {
        Enumeration enum1 = this.target.getContexts();
        while (enum1.hasMoreElements()) {
            Context ctx = (Context)enum1.nextElement();
            this.resumeContext(ctx.getContextName());
        }
    }

    protected void preStop() throws Exception {
        Enumeration enum1 = this.target.getContexts();
        while (enum1.hasMoreElements()) {
            Context ctx = (Context)enum1.nextElement();
            this.suspendContext(ctx.getContextName());
        }
    }

    public boolean reload() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.contextGroupControlPermission);
        boolean success = true;
        Enumeration enum1 = this.webModules.elements();
        while (enum1.hasMoreElements()) {
            ObjectName objName = (ObjectName)enum1.nextElement();
            String contextName = JMXUtility.getNameValue(objName);
            success &= this.reloadContext(contextName);
        }
        return success;
    }

    public boolean reloadContext(String contextName) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.contextGroupControlPermission);
        Context context = this.target.getContextByName(contextName);
        boolean result = false;
        if (context != null) {
            try {
                result = context.execReload();
            }
            catch (Exception e) {
                if (logger.isLoggable(JeusMessage_WebContainer0._1550_LEVEL)) {
                    logger.log(JeusMessage_WebContainer0._1550_LEVEL, JeusMessage_WebContainer0._1550, new Object[]{contextName}, (Throwable)e);
                }
                result = false;
            }
        }
        if (!result && logger.isLoggable(JeusMessage_WebContainer0._1508_LEVEL)) {
            logger.log(JeusMessage_WebContainer0._1508_LEVEL, JeusMessage_WebContainer0._1508, new Object[]{"reload", contextName});
        }
        return result;
    }

    public boolean restartContext(String contextName) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.contextGroupControlPermission);
        Context ctx = this.target.getContextByName(contextName);
        if (ctx != null && !ctx.isWarDeploy() && !this.target.terminateContext(contextName)) {
            logger.log(JeusMessage_WebContainer0._1508_LEVEL, JeusMessage_WebContainer0._1508, new Object[]{"restart", contextName});
            return false;
        }
        try {
            WebModuleDeployInfo info = (WebModuleDeployInfo)this.deployTable.get(contextName);
            if (info == null || info.isRuntimeDeploy()) {
                return false;
            }
            return this.target.restartContext(contextName);
        }
        catch (ServerException e) {
            if (logger.isLoggable(JeusMessage_WebContainer0._1508_LEVEL)) {
                logger.log(JeusMessage_WebContainer0._1508_LEVEL, JeusMessage_WebContainer0._1508, new Object[]{"restart", contextName}, (Throwable)e);
            }
            return false;
        }
    }

    public boolean resumeContext(String contextName) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.contextGroupControlPermission);
        Context context = this.target.getContextByName(contextName);
        WebModule mbean = context.getMBean();
        if (mbean == null) {
            return false;
        }
        try {
            if (mbean.getstate() == 3) {
                mbean.start();
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_WebContainer0._1508_LEVEL)) {
                logger.log(JeusMessage_WebContainer0._1508_LEVEL, JeusMessage_WebContainer0._1508, new Object[]{"resume", contextName}, (Throwable)e);
            }
            return false;
        }
        return true;
    }

    public boolean suspendContext(String contextName) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.contextGroupControlPermission);
        Context context = this.target.getContextByName(contextName);
        if (context != null) {
            WebModule mbean = context.getMBean();
            if (mbean == null) {
                return false;
            }
            try {
                mbean.stop();
            }
            catch (Exception e) {
                if (logger.isLoggable(JeusMessage_WebContainer0._1508_LEVEL)) {
                    logger.log(JeusMessage_WebContainer0._1508_LEVEL, JeusMessage_WebContainer0._1508, new Object[]{"suspend", contextName}, (Throwable)e);
                }
                return false;
            }
        }
        return true;
    }

    public boolean clearStatContext(String contextName) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.contextGroupControlPermission);
        Context context = this.target.getContextByName(contextName);
        boolean result = true;
        if (context != null) {
            Enumeration enum1 = context.getContextLoader().getServlets();
            while (enum1.hasMoreElements()) {
                ServletWrapper wrapper = (ServletWrapper)enum1.nextElement();
                result &= wrapper.clearRequestCount();
            }
            context.clearStatistic();
            return result;
        }
        return false;
    }

    public boolean terminateContext(String contextName) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.contextGroupControlPermission);
        Context context = this.target.getContextByName(contextName);
        if (context != null) {
            return this.target.terminateContext(contextName);
        }
        return false;
    }

    public boolean resumeWebtobListener(String listenerId) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.contextGroupControlPermission);
        HashMap connectors = this.target.getConnectors();
        if (connectors == null) {
            return false;
        }
        Connector connector = (Connector)connectors.get(listenerId);
        if (connector == null) {
            return false;
        }
        if (!connector.getListenerType().equals("WebtobListener")) {
            return false;
        }
        WebListenerMo mbean = connector.getMBean();
        try {
            mbean.startRecursive();
            return true;
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_WebContainer0._1509_LEVEL)) {
                logger.log(JeusMessage_WebContainer0._1509_LEVEL, JeusMessage_WebContainer0._1509, new Object[]{"resume", listenerId}, (Throwable)e);
            }
            return false;
        }
    }

    public boolean suspendWebtobListener(String listenerId) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.contextGroupControlPermission);
        HashMap connectors = this.target.getConnectors();
        if (connectors == null) {
            return false;
        }
        Connector connector = (Connector)connectors.get(listenerId);
        if (connector == null) {
            return false;
        }
        if (!connector.getListenerType().equals("WebtobListener")) {
            return false;
        }
        WebListenerMo mbean = connector.getMBean();
        try {
            mbean.stop();
            return true;
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_WebContainer0._1509_LEVEL)) {
                logger.log(JeusMessage_WebContainer0._1509_LEVEL, JeusMessage_WebContainer0._1509, new Object[]{"suspend", listenerId}, (Throwable)e);
            }
            return false;
        }
    }

    public boolean webtobFailback(String listenerId, String webtobFailback) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.contextGroupControlPermission);
        HashMap connectors = this.target.getConnectors();
        if (connectors == null) {
            return false;
        }
        Connector connector = (Connector)connectors.get(listenerId);
        if (connector == null) {
            return false;
        }
        if (!connector.getListenerType().equals("WebtobListener")) {
            return false;
        }
        WebtobConnector wcon = (WebtobConnector)connector;
        int serverIndex = -1;
        try {
            serverIndex = Integer.parseInt(webtobFailback);
        }
        catch (Exception e) {
            serverIndex = -1;
        }
        if (serverIndex >= 0) {
            wcon.failback(serverIndex);
        }
        return true;
    }
}

