/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.servlet;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.servlet.SessionContainerMoMBean;
import jeus.management.j2ee.servlet.SessionContainerStatsImpl;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.sessionmanager.SessionMonitoring;
import jeus.sessionmanager.central.CentralSessionServerInfo;
import jeus.sessionmanager.distributed.DistributedSessionServerInfo;

public class SessionContainerMo
extends J2EEManagedObjectSupport
implements SessionContainerMoMBean {
    private SessionMonitoring target;
    private SessionContainerStatsImpl scStats;
    private ResourcePermission sessionContainerInfoPermission;
    private ResourcePermission sessionContainerControlPermission;

    public SessionContainerMo(Object target, ObjectName parent) {
        super(parent);
        this.target = (SessionMonitoring)target;
        this.scStats = new SessionContainerStatsImpl();
    }

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        SessionContainerMo object = new SessionContainerMo(target, parent);
        return object.createMBean(mBeanName, "JeusService", parent, parentKeyMap, "SessionContainer");
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean module = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        String name = module.getPermissionName();
        name = name + ".sessionContainer." + this.myNameString;
        return name;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.sessionContainerInfoPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"sessionContainerInfo");
        this.sessionContainerControlPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"sessionContainerControl");
    }

    public CentralSessionServerInfo getCentralServerInfo() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        return null;
    }

    public DistributedSessionServerInfo getDistributedServerInfo() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        return null;
    }

    public boolean isExist(String id) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        return this.target.isExist(id);
    }

    public ArrayList getLocalSessionKeys() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        return this.target.getLocalSessionKeys();
    }

    public boolean invalidateSession(String id) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerControlPermission);
        return this.target.invalidateSession(id);
    }

    public int getContainerType() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        return 1;
    }

    public Hashtable getP2PConnectionStatus() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionContainerInfoPermission);
        return null;
    }

    public Stats getstats() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        return this.target.updateStats(this.scStats);
    }
}

