/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.statistics;

import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.JCAConnectionPoolStats;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.TimeStatistic;
import jeus.connector.stats.JCAConnectionPoolExtendedStats;
import jeus.management.j2ee.statistics.JCAConnectionStatsImpl;

public class JCAConnectionPoolStatsImpl
extends JCAConnectionStatsImpl
implements JCAConnectionPoolStats,
JCAConnectionPoolExtendedStats {
    public JCAConnectionPoolStatsImpl(String name) {
        super(name);
    }

    public CountStatistic getCreateCount() {
        return (CountStatistic)this.getStatistic("CreateCount");
    }

    public CountStatistic getCloseCount() {
        return (CountStatistic)this.getStatistic("CloseCount");
    }

    public BoundedRangeStatistic getPoolSize() {
        return (BoundedRangeStatistic)this.getStatistic("PoolSize");
    }

    public BoundedRangeStatistic getFreePoolSize() {
        return (BoundedRangeStatistic)this.getStatistic("FreePoolSize");
    }

    public RangeStatistic getWaitingThreadCount() {
        return (RangeStatistic)this.getStatistic("WaitingThreadCount");
    }

    public CountStatistic getShrinkCount() {
        return (CountStatistic)this.getStatistic("ShrinkCount");
    }

    public CountStatistic getInvalidationCount() {
        return (CountStatistic)this.getStatistic("InvalidationCount");
    }

    public CountStatistic getMatchFailCount() {
        return (CountStatistic)this.getStatistic("MatchFailCount");
    }

    public CountStatistic getMatchSuccessCount() {
        return (CountStatistic)this.getStatistic("MatchSuccessCount");
    }

    public CountStatistic getAcquireFailCount() {
        return (CountStatistic)this.getStatistic("AcquireFailCount");
    }

    public BoundedRangeStatistic getDisposableConnections() {
        return (BoundedRangeStatistic)this.getStatistic("DisposableConnections");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getUseTime().toString());
        buffer.append(this.getWaitTime().toString());
        buffer.append(this.getCreateCount().toString());
        buffer.append(this.getCloseCount().toString());
        buffer.append(this.getPoolSize().toString());
        buffer.append(this.getFreePoolSize().toString());
        buffer.append(this.getWaitingThreadCount().toString());
        buffer.append(this.getMatchFailCount().toString());
        buffer.append(this.getMatchSuccessCount().toString());
        buffer.append(this.getAcquireFailCount().toString());
        buffer.append(this.getDisposableConnections().toString());
        return buffer.toString();
    }

    public String toSimpleString() {
        StringBuffer buffer = new StringBuffer();
        TimeStatistic useTime = this.getUseTime();
        buffer.append("use time  : [m").append(useTime.getMinTime()).append(":M").append(useTime.getMaxTime()).append(":T").append(useTime.getTotalTime()).append(":C").append(useTime.getCount()).append("]\n");
        TimeStatistic waitTime = this.getWaitTime();
        buffer.append("wait time : [m").append(waitTime.getMinTime()).append(":M").append(waitTime.getMaxTime()).append(":T").append(waitTime.getTotalTime()).append(":C").append(waitTime.getCount()).append("]\n");
        CountStatistic createCount = this.getCreateCount();
        buffer.append("creation  : [C").append(createCount.getCount()).append("]  - ");
        CountStatistic closeCount = this.getCloseCount();
        buffer.append("destory   : [C").append(closeCount.getCount()).append("]\n");
        BoundedRangeStatistic poolSize = this.getPoolSize();
        buffer.append("pool size : [C").append(poolSize.getCurrent()).append(":L").append(poolSize.getLowWaterMark()).append(":H").append(poolSize.getHighWaterMark()).append("]\n");
        BoundedRangeStatistic freePoolSize = this.getFreePoolSize();
        buffer.append("free size : [C").append(freePoolSize.getCurrent()).append(":L").append(freePoolSize.getLowWaterMark()).append(":H").append(freePoolSize.getHighWaterMark()).append("]\n");
        RangeStatistic waitingThreadCount = this.getWaitingThreadCount();
        buffer.append("waiting   : [C").append(waitingThreadCount.getCurrent()).append(":L").append(waitingThreadCount.getLowWaterMark()).append(":H").append(waitingThreadCount.getHighWaterMark()).append("]\n");
        CountStatistic matchSuccessCount = this.getMatchSuccessCount();
        buffer.append("match success: [C").append(matchSuccessCount.getCount()).append("]  - ");
        CountStatistic matchFailCount = this.getMatchFailCount();
        buffer.append("match fail   : [C").append(matchFailCount.getCount()).append("]\n");
        CountStatistic acquireFailCount = this.getAcquireFailCount();
        buffer.append("acquire fail : [C").append(acquireFailCount.getCount()).append("]\n");
        BoundedRangeStatistic disposableConnections = this.getDisposableConnections();
        buffer.append("disposable   : [C").append(disposableConnections.getCurrent()).append(":L").append(disposableConnections.getLowWaterMark()).append(":H").append(disposableConnections.getHighWaterMark()).append("]\n");
        return buffer.toString();
    }
}

