/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.thread;

import java.security.Permission;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.j2ee.thread.ThreadPoolMBean;
import jeus.management.j2ee.thread.ThreadPoolStatsImpl;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.util.StatisticRefinedThreadPoolExecutor;
import jeus.util.concurrent50.concurrent.TimeUnit;

public class ThreadPool
extends J2EEManagedObjectSupport
implements ThreadPoolMBean {
    private StatisticRefinedThreadPoolExecutor executor;
    private ResourcePermission threadPoolPermission;
    ThreadPoolStatsImpl stat = new ThreadPoolStatsImpl();

    public ThreadPool(Object target) {
        this.executor = (StatisticRefinedThreadPoolExecutor)((Object)target);
        this.executor.setStatistic(this.stat);
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean parent = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return parent.getPermissionName() + ".threadpool." + this.myNameString;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.threadPoolPermission = PermissionMaker.makeResourcePermission((String)this.getPermissionName(), (String)"control");
    }

    public static J2EEManagedObject createMBean(String mBeanName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        ThreadPool object = new ThreadPool(target);
        return object.createMBean(mBeanName, "JeusService", parent, parentKeyMap, "ThreadPool");
    }

    public long getKeepAliveTime() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolPermission);
        return this.executor.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    public void setKeepAliveTime(long time) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolPermission);
        this.executor.setKeepAliveTime(time, TimeUnit.MILLISECONDS);
    }

    public int getMaximumPoolSize() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolPermission);
        return this.executor.getMaximumPoolSize();
    }

    public void setMaximumPoolSize(int max) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolPermission);
        this.executor.setMaximumPoolSize(max);
    }

    public int getCorePoolSize() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolPermission);
        return this.executor.getCorePoolSize();
    }

    public void setCorePoolSize(int max) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolPermission);
        this.executor.setCorePoolSize(max);
    }

    public int getActiveCount() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolPermission);
        return this.executor.getActiveCount();
    }

    public int getPoolSize() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolPermission);
        return this.executor.getPoolSize();
    }

    public long getTaskCount() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolPermission);
        return this.executor.getTaskCount();
    }

    public long getLargestPoolSize() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolPermission);
        return this.executor.getLargestPoolSize();
    }

    public List getActiveThreadInfo() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.threadPoolPermission);
        return this.executor.getThreadInfo();
    }

    public Stats getstats() {
        return this.stat;
    }
}

