/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.adaptor;

import java.util.Hashtable;
import jeus.management.snmp.core.SecurityInterface;
import jeus.util.SecurityUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_SNMP;

public class SnmpSecurity
implements SecurityInterface {
    Hashtable stats = new Hashtable();
    Hashtable passwordTable = new Hashtable();
    long startTime = System.currentTimeMillis();
    long engineBoots = 1L;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.management");

    public int getUserProfile(byte[] userName) {
        return 5;
    }

    public byte[] getEncryptionPassword(byte[] userName) {
        return this.getAuthenticationPassword(userName);
    }

    public byte[] getAuthenticationPassword(byte[] userName) {
        String strUserName = new String(userName);
        try {
            return SecurityUtil.getPlainPassword(strUserName).getBytes();
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_SNMP.SNMP_32_LEVEL)) {
                logger.log(JeusMessage_SNMP.SNMP_32_LEVEL, JeusMessage_SNMP.SNMP_32, t);
            }
            return null;
        }
    }

    public int getAuthenticationAlgorithm(byte[] userName) {
        return 1;
    }

    public long getEngineBoots() {
        return this.engineBoots;
    }

    public long getEngineTime() {
        return (System.currentTimeMillis() - this.startTime) / 1000L;
    }

    public byte[] getEngineID() {
        return "JEUSEngineID".getBytes();
    }

    public int getStats(String OID) {
        Integer nbr = (Integer)this.stats.get(OID);
        int count = nbr == null ? 1 : nbr + 1;
        this.stats.put(OID, new Integer(count));
        return count;
    }
}

