/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.agent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import jeus.management.enterprise.agent.MBSCAlreadyClosedException;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.management.snmp.agent.SnmpAgentImpl;
import jeus.security.util.LoginUtil;
import jeus.util.ScheduleTask;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_SNMP;

public class SnmpTimerTask
extends ScheduleTask {
    private MEJBUtility mbsc;
    private Hashtable remoteMbeanServers = new Hashtable();
    private SnmpAgentImpl snmpAgent;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.management");
    private int criticalCnt = 0;
    private static int maxCriticalCnt = 10;

    public SnmpTimerTask(MEJBUtility mbsc, SnmpAgentImpl snmpAgent) {
        this.mbsc = mbsc;
        this.snmpAgent = snmpAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            int i;
            if (this.mbsc == null || this.snmpAgent == null) {
                ++this.criticalCnt;
                this.checkCancel();
                return;
            }
            String[] mservers = null;
            try {
                LoginUtil.loginCodeSubjectWithRuntimeException();
                mservers = this.mbsc.getRemoteMBeanServerNames(true);
            }
            catch (MBSCAlreadyClosedException e) {
                ++this.criticalCnt;
                this.checkCancel();
                return;
            }
            catch (Exception e) {
                if (logger.isLoggable(JeusMessage_SNMP.SNMP_47_LEVEL)) {
                    logger.log(JeusMessage_SNMP.SNMP_47_LEVEL, JeusMessage_SNMP.SNMP_47, (Throwable)e);
                }
                ++this.criticalCnt;
                this.checkCancel();
                return;
            }
            finally {
                LoginUtil.logoutWithRuntimeException();
            }
            if (mservers == null) {
                ++this.criticalCnt;
                this.checkCancel();
                return;
            }
            if (logger.isLoggable(JeusMessage_SNMP.SNMP_41_LEVEL)) {
                ArrayList<String> remoteServers = new ArrayList<String>();
                for (i = 0; i < mservers.length; ++i) {
                    remoteServers.add(mservers[i]);
                }
                logger.log(JeusMessage_SNMP.SNMP_41_LEVEL, JeusMessage_SNMP.SNMP_41, (Object[])new String[]{this.snmpAgent.getManagerName(), this.remoteMbeanServers.values().toString(), remoteServers.toString()});
            }
            Hashtable checkServers = (Hashtable)this.remoteMbeanServers.clone();
            for (i = 0; i < mservers.length; ++i) {
                MBeanServerConnection mbeanServer = null;
                try {
                    mbeanServer = this.mbsc.getRemoteMBeanServer(mservers[i]);
                }
                catch (IOException e) {
                    if (!logger.isLoggable(JeusMessage_SNMP.SNMP_48_LEVEL)) continue;
                    logger.log(JeusMessage_SNMP.SNMP_48_LEVEL, JeusMessage_SNMP.SNMP_48, (Object)mservers[i], (Throwable)e);
                    continue;
                }
                if (mbeanServer != null) {
                    Object obj = checkServers.remove(mbeanServer);
                    if (obj != null) continue;
                    this.remoteMbeanServers.put(mbeanServer, mservers[i]);
                    this.snmpAgent.registerSnmpFromMbeanServer(mservers[i], mbeanServer);
                    continue;
                }
                if (!logger.isLoggable(JeusMessage_SNMP.SNMP_48_LEVEL)) continue;
                logger.log(JeusMessage_SNMP.SNMP_48_LEVEL, JeusMessage_SNMP.SNMP_48, (Object)mservers[i]);
            }
            for (MBeanServerConnection mbeanServer : checkServers.keySet()) {
                String mbeanServerName = (String)checkServers.get(mbeanServer);
                this.snmpAgent.unregisterSnmpFromMbeanServer(mbeanServerName, mbeanServer);
                this.remoteMbeanServers.remove(mbeanServer);
            }
            checkServers.clear();
            this.criticalCnt = 0;
            return;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
    }

    public void cancel() {
        if (logger.isLoggable(JeusMessage_SNMP.SNMP_42_LEVEL)) {
            logger.log(JeusMessage_SNMP.SNMP_42_LEVEL, JeusMessage_SNMP.SNMP_42, (Object)this.snmpAgent.getManagerName());
        }
        super.cancel();
        if (this.remoteMbeanServers.isEmpty()) {
            return;
        }
        Hashtable removeServers = (Hashtable)this.remoteMbeanServers.clone();
        for (MBeanServerConnection mbeanServer : removeServers.keySet()) {
            String mbeanServerName = (String)removeServers.get(mbeanServer);
            this.snmpAgent.unregisterSnmpFromMbeanServer(mbeanServerName, mbeanServer);
            this.remoteMbeanServers.remove(mbeanServer);
        }
        removeServers.clear();
    }

    private void checkCancel() {
        if (this.criticalCnt > maxCriticalCnt) {
            this.cancel();
        }
    }
}

