/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jeus.management.snmp.core.AsnObject;
import jeus.util.message.JeusMessage_SNMP;

public class AsnOID
extends AsnObject {
    private int[] value = new int[]{1, 3, 6, 1, 4, 1, 674, 10889, 2, 1, 0};

    public AsnOID() {
        this.setType((byte)6);
    }

    public AsnOID(InputStream inputstream, int i) throws IOException {
        this.setType((byte)6);
        byte[] abyte0 = new byte[i];
        if (i != inputstream.read(abyte0, 0, i)) {
            throw new IOException("Could not read input stream");
        }
        int j = 1;
        for (int k = 0; k < i; ++k) {
            if (abyte0[k] < 0) continue;
            ++j;
        }
        this.value = new int[j];
        this.value[0] = abyte0[0] / 40;
        this.value[1] = abyte0[0] % 40;
        int l = 1;
        for (int i1 = 2; i1 < this.value.length; ++i1) {
            int j1 = 0;
            do {
                j1 <<= 7;
                j1 |= abyte0[l] & 0x7F;
            } while (abyte0[l++] < 0);
            this.value[i1] = j1;
        }
    }

    public AsnOID(String s) {
        this.setType((byte)6);
        this.setOID(s);
    }

    public void changeIndex(String s) {
        this.value[this.value.length - 1] = Integer.valueOf(s);
    }

    private void encodeSubID(OutputStream outputstream, int i) throws IOException {
        int byte0 = 15;
        int j = 0;
        byte0 = 15;
        for (j = 28; j > 0 && (i >> j & byte0) == 0; j -= 7) {
            byte0 = 127;
        }
        while (j >= 0) {
            outputstream.write((byte)(i >> j & byte0 | (j <= 0 ? 0 : 128)));
            byte0 = 127;
            j -= 7;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof AsnOID) {
            return this.same((AsnOID)obj);
        }
        return super.equals(obj);
    }

    public int extractIndex() {
        if (this.value.length > 1) {
            return this.value[this.value.length - 1];
        }
        return 0;
    }

    private int getSubIDLength(int i) {
        int j = 1;
        while ((i >>= 7) != 0) {
            ++j;
        }
        return j;
    }

    public int[] getValue() {
        return this.value;
    }

    public boolean same(AsnOID asnoid) {
        boolean flag = false;
        if (this.value.length == asnoid.value.length) {
            int i = 0;
            for (i = 0; i < this.value.length && this.value[i] == asnoid.value[i]; ++i) {
            }
            flag = i == this.value.length;
        }
        return flag;
    }

    public void setOID(String s) {
        block4: {
            int l = 1;
            int i = s.indexOf(46);
            while (i >= 0) {
                i = s.indexOf(46, i + 1);
                ++l;
            }
            this.value = new int[l];
            int k = 0;
            try {
                for (int i1 = 0; i1 < l; ++i1) {
                    int j = s.indexOf(46, k);
                    String s1 = j > 0 ? s.substring(k, j) : s.substring(k);
                    Integer integer = Integer.valueOf(s1);
                    this.value[i1] = integer;
                    k = j + 1;
                }
            }
            catch (NumberFormatException numberformatexception) {
                if (!logger.isLoggable(JeusMessage_SNMP.SNMP_8_LEVEL)) break block4;
                logger.log(JeusMessage_SNMP.SNMP_8_LEVEL, JeusMessage_SNMP.SNMP_8, new Object[]{s, numberformatexception.getMessage()});
            }
        }
    }

    public void setValue(int[] ai) {
        this.value = ai;
    }

    public int size() {
        int j = this.getSubIDLength(this.value[0] * 40 + this.value[1]);
        for (int i = 2; i < this.value.length; ++i) {
            j += this.getSubIDLength(this.value[i]);
        }
        return j;
    }

    public String toString(String s) {
        StringBuffer stringbuffer = new StringBuffer();
        for (int i = 0; i < this.value.length - 1; ++i) {
            stringbuffer.append(this.value[i] + ".");
        }
        stringbuffer.append(this.value[this.value.length - 1]);
        return stringbuffer.toString();
    }

    public void write(OutputStream outputstream) throws IOException {
        AsnObject.buildAsnHeader(outputstream, this.getType(), this.size());
        this.encodeSubID(outputstream, this.value[0] * 40 + this.value[1]);
        for (int i = 2; i < this.value.length; ++i) {
            this.encodeSubID(outputstream, this.value[i]);
        }
    }
}

