/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jeus.util.logging.JeusLogger;

public abstract class AsnObject {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.management");
    public static final byte ASN_BOOLEAN = 1;
    public static final byte ASN_INTEGER = 2;
    public static final byte ASN_BIT_STR = 3;
    public static final byte ASN_OCTET_STR = 4;
    public static final byte ASN_NULL = 5;
    public static final byte ASN_OBJECT_ID = 6;
    public static final byte ASN_SEQUENCE = 16;
    public static final byte ASN_SET = 17;
    public static final byte ASN_UNIVERSAL = 0;
    public static final byte ASN_APPLICATION = 64;
    public static final byte ASN_CONTEXT = -128;
    public static final byte ASN_PRIVATE = -64;
    public static final byte ASN_PRIMITIVE = 0;
    public static final byte ASN_CONSTRUCTOR = 32;
    public static final byte ASN_LONG_LEN = -128;
    public static final byte ASN_EXTENSION_ID = 31;
    public static final byte ASN_BIT8 = -128;
    public static final byte INTEGER = 2;
    public static final byte STRING = 4;
    public static final byte OBJID = 6;
    public static final byte NULLOBJ = 5;
    public static final byte IPADDRESS = 64;
    public static final byte COUNTER = 65;
    public static final byte GAUGE = 66;
    public static final byte TIMETICKS = 67;
    public static final byte OPAQUE = 68;
    public static final byte COUNTER64 = 70;
    public static final byte ASN_NOSUCHOBJECT = -128;
    public static final byte ASN_NOSUCHINSTANCE = -126;
    public static final byte ASN_ENDOFMIBVIEW = -126;
    public static final byte SNMP_TRAP_COLDSTART = 0;
    public static final byte SNMP_TRAP_WARMSTART = 1;
    public static final byte SNMP_TRAP_LINKDOWN = 2;
    public static final byte SNMP_TRAP_LINKUP = 3;
    public static final byte SNMP_TRAP_AUTHFAIL = 4;
    public static final byte SNMP_TRAP_EGPNEIGHBORLOSS = 5;
    public static final byte SNMP_TRAP_ENTERPRISESPECIFIC = 6;
    public static final byte SNMP_VERSION_1 = 0;
    public static final byte SNMP_VERSION_2 = 1;
    public static final byte SNMP_VERSION_3 = 3;
    public static final byte GET_REQ_MSG = -96;
    public static final byte GETNEXT_REQ_MSG = -95;
    public static final byte GET_RSP_MSG = -94;
    public static final byte SET_REQ_MSG = -93;
    public static final byte TRP_REQ_MSG = -92;
    public static final byte GET_BULK_MSG = -91;
    public static final byte INFO_REQ_MSG = -90;
    public static final byte SNMPV2_TRAP = -89;
    public static final byte REPORT = -88;
    public static final byte CONS_SEQ = 48;
    public static int MAX_PACKET_SIZE = 4096;
    byte type = (byte)5;

    public AsnObject add(AsnObject asnobject) {
        return asnobject;
    }

    public static void buildAsnHeader(OutputStream outputstream, byte byte0, int i) throws IOException {
        outputstream.write(byte0);
        int j = AsnObject.getLengthFieldSize(i);
        if (j > 1) {
            byte byte1 = (byte)(0x80 | (byte)(--j));
            outputstream.write(byte1);
        }
        while (j != 0) {
            outputstream.write((byte)(i >> (--j << 3) & 0xFF));
        }
    }

    public static long bytesToInteger(byte[] abyte0) {
        int byte0 = 127;
        long l = 0L;
        for (int i = 0; i < abyte0.length; ++i) {
            byte byte1 = abyte0[i];
            long l1 = byte0 & byte1;
            if (byte1 < 0) {
                l1 += 128L;
            }
            l *= 256L;
            l += l1;
        }
        return l;
    }

    public static int getLengthFieldSize(int i) {
        if (i < 128) {
            return 1;
        }
        int j = -16777216;
        int k = 4;
        while ((i & j) == 0) {
            j >>= 8;
            --k;
        }
        return k + 1;
    }

    public String getOIDValue(String s) {
        return "";
    }

    public AsnObject getSnmpPDU() {
        return null;
    }

    public byte getType() {
        return this.type;
    }

    public static int readLength(InputStream inputstream) throws IOException {
        int i = 0;
        byte byte0 = (byte)inputstream.read();
        if ((0x80 & byte0) != 0) {
            int j = 0x7F & byte0;
            if (j < 4) {
                byte[] abyte0 = new byte[j];
                int k = inputstream.read(abyte0, 0, j);
                if (k != j) {
                    throw new IOException("Not enough data");
                }
                for (int l = 0; l < j; ++l) {
                    int i1 = 0x7F & abyte0[l];
                    if ((0x80 & abyte0[l]) != 0) {
                        i1 += 128;
                    }
                    i = (i << 8) + i1;
                }
            }
        } else {
            i = 0x7F & byte0;
        }
        return i;
    }

    public void setType(byte byte0) {
        this.type = byte0;
    }

    public int size() {
        return 0;
    }

    public static void setMaxPacketSize(int maxPacketSize) {
        MAX_PACKET_SIZE = maxPacketSize;
    }

    public String toString() {
        return this.toString("");
    }

    public abstract String toString(String var1);

    public abstract void write(OutputStream var1) throws IOException;
}

