/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.core;

import java.util.Vector;
import jeus.management.snmp.core.AsnNameValuePair;
import jeus.management.snmp.core.AsnNull;
import jeus.management.snmp.core.AsnOID;
import jeus.management.snmp.core.AsnObject;
import jeus.management.snmp.core.LeafOIDListener;
import jeus.management.snmp.core.MIBGroup;
import jeus.management.snmp.core.MIBTree;
import jeus.management.snmp.core.SecurityInterface;
import jeus.management.snmp.core.SnmpException;
import jeus.management.snmp.core.SnmpGetSetPdu;
import jeus.management.snmp.core.SnmpMessageEvent;
import jeus.management.snmp.core.SnmpPdu;
import jeus.management.snmp.core.SnmpServer;
import jeus.management.snmp.core.SnmpServerListener;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_SNMP;

public class SnmpDispatcher {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.management");
    MIBTree mibTree = new MIBTree();
    MIBGroup currentGroup;
    LeafOIDListener currentListener;
    SecurityInterface security = null;
    SnmpServerListener otherListener = null;
    int event_types = 0;
    byte[] contextEngineID;
    byte[] contextName;

    public void removeEventListener(String oid, String uniqueId) {
        int groupLastIndex = -1;
        String groupOid = null;
        MIBGroup mibGroup = null;
        groupLastIndex = oid.lastIndexOf(46);
        if (groupLastIndex <= 0) {
            if (logger.isLoggable(JeusMessage_SNMP.SNMP_46_LEVEL)) {
                logger.log(JeusMessage_SNMP.SNMP_46_LEVEL, JeusMessage_SNMP.SNMP_46);
            }
            return;
        }
        groupOid = oid.substring(0, groupLastIndex);
        mibGroup = this.mibTree.findMIBGroup(groupOid);
        if (mibGroup == null) {
            return;
        }
        mibGroup.removeLeafOIDListener(oid + "." + uniqueId);
        if (mibGroup.isEmpty()) {
            this.mibTree.removeMIBGroup(mibGroup);
        }
    }

    public void addEventListener(LeafOIDListener leafoidlistener) {
        String s;
        int i;
        int mibOidIndex;
        String oid = leafoidlistener.getOID();
        String uniqueId = leafoidlistener.getUniqueID();
        if (uniqueId != null && (mibOidIndex = oid.lastIndexOf("." + uniqueId)) != -1) {
            oid = oid.substring(0, mibOidIndex);
        }
        if ((i = (s = oid).lastIndexOf(46)) <= 0) {
            if (logger.isLoggable(JeusMessage_SNMP.SNMP_11_LEVEL)) {
                logger.log(JeusMessage_SNMP.SNMP_11_LEVEL, JeusMessage_SNMP.SNMP_11);
            }
            return;
        }
        String s1 = s.substring(0, i);
        MIBGroup mibgroup = this.mibTree.findMIBGroup(s1);
        if (mibgroup == null) {
            mibgroup = new MIBGroup();
            mibgroup.setGroupOID(s1);
            this.mibTree.addMIBGroup(mibgroup);
        }
        mibgroup.addLeafOIDListener(leafoidlistener);
    }

    public void addEventListener(SnmpServerListener snmpserverlistener, int i) {
        this.otherListener = snmpserverlistener;
        this.event_types = i;
    }

    public void addSnmpSecurityInterface(SecurityInterface securityinterface) {
        this.security = securityinterface;
    }

    void findListener(String s) throws SnmpException {
        this.currentGroup = this.mibTree.findMIBGroup(s);
        if (this.currentGroup == null) {
            throw new SnmpException(20);
        }
        this.currentListener = this.currentGroup.findLeafOIDListener(s);
        if (this.currentListener == null) {
            throw new SnmpException(20);
        }
    }

    private void findNextListener(String s) throws SnmpException {
        this.currentGroup = this.mibTree.findMIBGroup(s);
        if (this.currentGroup == null) {
            this.currentGroup = this.mibTree.findFirstMIBGroup();
            if (this.currentGroup == null) {
                if (logger.isLoggable(JeusMessage_SNMP.SNMP_12_LEVEL)) {
                    logger.log(JeusMessage_SNMP.SNMP_12_LEVEL, JeusMessage_SNMP.SNMP_12, (Object)s);
                }
                throw new SnmpException(22);
            }
            this.currentListener = this.currentGroup.findFirstLeafOIDListener();
        } else {
            this.currentListener = this.currentGroup.findNextLeafOIDListener(s);
            if (this.currentListener == null) {
                MIBGroup mibgroup = this.mibTree.findNextMIBGroup(this.currentGroup);
                if (mibgroup == null) {
                    if (logger.isLoggable(JeusMessage_SNMP.SNMP_13_LEVEL)) {
                        logger.log(JeusMessage_SNMP.SNMP_13_LEVEL, JeusMessage_SNMP.SNMP_13);
                    }
                    this.currentGroup = null;
                    throw new SnmpException(22);
                }
                this.currentListener = mibgroup.findFirstLeafOIDListener();
            }
        }
        if (this.currentListener == null) {
            if (logger.isLoggable(JeusMessage_SNMP.SNMP_14_LEVEL)) {
                logger.log(JeusMessage_SNMP.SNMP_14_LEVEL, JeusMessage_SNMP.SNMP_14);
            }
            throw new SnmpException(20);
        }
    }

    public void get(SnmpGetSetPdu snmpgetsetpdu) {
        block6: for (int i = 0; i < snmpgetsetpdu.getValueSize(); ++i) {
            AsnNameValuePair asnnamevaluepair = snmpgetsetpdu.getNameValuePair(i);
            AsnOID asnoid = asnnamevaluepair.getName();
            String s = asnoid.toString();
            boolean flag = false;
            try {
                this.findListener(s);
                if (this.currentListener.getOID().equals(s)) {
                    flag = true;
                    s = s + ".0";
                }
                if (this.currentListener.getOID().length() > s.length()) {
                    if (logger.isLoggable(JeusMessage_SNMP.SNMP_15_LEVEL)) {
                        logger.log(JeusMessage_SNMP.SNMP_15_LEVEL, JeusMessage_SNMP.SNMP_15, (Object)s);
                    }
                    throw new SnmpException(20);
                }
                this.currentListener.setCName(this.contextEngineID, this.contextName);
                AsnObject asnobject = this.currentListener.getValue(s);
                if (flag) {
                    asnnamevaluepair.setName(new AsnOID(s));
                }
                asnnamevaluepair.setValue(asnobject);
                continue;
            }
            catch (SnmpException snmpexception) {
                switch (snmpexception.getErrorCode()) {
                    case 2: 
                    case 20: {
                        asnnamevaluepair.setValue(new AsnNull(-128));
                        continue block6;
                    }
                    case 21: {
                        asnnamevaluepair.setValue(new AsnNull(-126));
                        continue block6;
                    }
                    default: {
                        snmpgetsetpdu.setErrorStatus(5L);
                        snmpgetsetpdu.setErrorIndex(i + 1);
                        AsnNull asnnull = new AsnNull();
                        AsnNameValuePair asnnamevaluepair1 = new AsnNameValuePair(s, asnnull);
                        Vector<AsnNameValuePair> vector = new Vector<AsnNameValuePair>();
                        vector.addElement(asnnamevaluepair1);
                        snmpgetsetpdu.setVarBinds(vector);
                        return;
                    }
                }
            }
        }
    }

    public void getBulk(SnmpGetSetPdu snmpgetsetpdu) {
        Vector vector = snmpgetsetpdu.getVarBinds();
        Vector<AsnNameValuePair> vector1 = new Vector<AsnNameValuePair>();
        Vector<AsnNameValuePair> vector2 = new Vector<AsnNameValuePair>();
        Vector<AsnNameValuePair> vector3 = new Vector<AsnNameValuePair>();
        for (int i = 0; (long)i < snmpgetsetpdu.getNonRepeaters() && i < snmpgetsetpdu.getValueSize(); ++i) {
            vector1.addElement(snmpgetsetpdu.getNameValuePair(i));
        }
        for (int j = (int)snmpgetsetpdu.getNonRepeaters(); j < snmpgetsetpdu.getValueSize(); ++j) {
            vector2.addElement(snmpgetsetpdu.getNameValuePair(j));
        }
        snmpgetsetpdu.setVarBinds(vector1);
        this.getNext(snmpgetsetpdu);
        if (snmpgetsetpdu.getErrorStatus() != 0L) {
            snmpgetsetpdu.setVarBinds(vector);
            return;
        }
        for (int k = 0; k < snmpgetsetpdu.getValueSize(); ++k) {
            vector3.addElement(snmpgetsetpdu.getNameValuePair(k));
        }
        snmpgetsetpdu.setVarBinds(vector2);
        int l = 0;
        while ((long)l < snmpgetsetpdu.getMaxRepetitions()) {
            this.getNext(snmpgetsetpdu);
            if (snmpgetsetpdu.getErrorStatus() != 0L) {
                snmpgetsetpdu.setVarBinds(vector);
                snmpgetsetpdu.setErrorIndex(snmpgetsetpdu.getErrorIndex() + (long)vector1.size());
                return;
            }
            boolean flag = false;
            for (int i1 = 0; i1 < snmpgetsetpdu.getValueSize(); ++i1) {
                vector3.addElement(snmpgetsetpdu.getNameValuePair(i1));
                AsnObject asnobject = snmpgetsetpdu.getValue(i1);
                if (asnobject.getType() == -126 || asnobject.getType() == -128 || asnobject.getType() == -126) continue;
                flag = true;
            }
            if (!flag) break;
            ++l;
        }
        snmpgetsetpdu.setVarBinds(vector3);
    }

    public void getNext(SnmpGetSetPdu snmpgetsetpdu) {
        Vector<AsnNameValuePair> vector = new Vector<AsnNameValuePair>();
        for (int i = 0; i < snmpgetsetpdu.getValueSize(); ++i) {
            AsnNameValuePair asnnamevaluepair = snmpgetsetpdu.getNameValuePair(i);
            AsnOID asnoid = asnnamevaluepair.getName();
            String s = asnoid.toString();
            String s1 = null;
            AsnObject obj = null;
            AsnNameValuePair asnnamevaluepair1 = null;
            try {
                this.findListener(s);
                s1 = this.currentListener.getNextInstanceID(s);
            }
            catch (SnmpException _ex) {
                // empty catch block
            }
            if (s1 == null) {
                try {
                    this.findNextListener(s);
                    s1 = this.currentListener.getOID() + this.currentListener.getFirstIndex();
                }
                catch (SnmpException _ex) {
                    // empty catch block
                }
            }
            try {
                if (s1 == null) {
                    throw new SnmpException(22);
                }
                this.currentListener.setCName(this.contextEngineID, this.contextName);
                obj = this.currentListener.getValue(s1);
            }
            catch (SnmpException snmpexception) {
                switch (snmpexception.getErrorCode()) {
                    case 2: 
                    case 20: {
                        obj = new AsnNull(-128);
                        break;
                    }
                    case 22: {
                        obj = new AsnNull(-126);
                        break;
                    }
                    case 21: {
                        obj = new AsnNull(-126);
                        break;
                    }
                    default: {
                        snmpgetsetpdu.setErrorStatus(5L);
                        snmpgetsetpdu.setErrorIndex(i + 1);
                        obj = new AsnNull();
                        if (s1 == null) {
                            s1 = asnoid.toString();
                        }
                        asnnamevaluepair1 = new AsnNameValuePair(s1, obj);
                        Vector<AsnNameValuePair> vector1 = new Vector<AsnNameValuePair>();
                        vector1.addElement(asnnamevaluepair1);
                        snmpgetsetpdu.setVarBinds(vector1);
                        return;
                    }
                }
            }
            if (s1 == null) {
                s1 = asnoid.toString();
            }
            asnnamevaluepair1 = new AsnNameValuePair(s1, obj);
            vector.addElement(asnnamevaluepair1);
        }
        snmpgetsetpdu.setVarBinds(vector);
    }

    public void notifyEvent(SnmpMessageEvent snmpmessageevent) {
        SnmpPdu snmppdu = snmpmessageevent.getSnmpMessage().getPdu();
        this.contextEngineID = snmpmessageevent.getSnmpMessage().getContextEngineID();
        this.contextName = snmpmessageevent.getSnmpMessage().getContextName();
        if (snmppdu instanceof SnmpGetSetPdu) {
            switch (snmppdu.getMsgType()) {
                case -96: {
                    this.get((SnmpGetSetPdu)snmppdu);
                    snmppdu.setMsgType((byte)-94);
                    break;
                }
                case -95: {
                    this.getNext((SnmpGetSetPdu)snmppdu);
                    snmppdu.setMsgType((byte)-94);
                    break;
                }
                case -93: {
                    this.set((SnmpGetSetPdu)snmppdu);
                    snmppdu.setMsgType((byte)-94);
                    break;
                }
                case -91: {
                    this.getBulk((SnmpGetSetPdu)snmppdu);
                    snmppdu.setMsgType((byte)-94);
                    break;
                }
                default: {
                    if (this.otherListener != null) {
                        if (!(snmppdu.getMsgType() == -92 && (this.event_types & SnmpServer.TRAP_V1) != 0 || snmppdu.getMsgType() == -89 && (this.event_types & SnmpServer.TRAP_V2) != 0 || snmppdu.getMsgType() == -90 && (this.event_types & SnmpServer.INFORM) != 0) && (snmppdu.getMsgType() != -88 || (this.event_types & SnmpServer.REPORT) == 0)) break;
                        this.otherListener.snmpRequest(snmppdu);
                        break;
                    }
                    SnmpGetSetPdu snmpgetsetpdu = (SnmpGetSetPdu)snmppdu;
                    snmpgetsetpdu.setErrorStatus(5L);
                    snmpgetsetpdu.setErrorIndex(0L);
                    snmpgetsetpdu.setVarBinds(null);
                }
            }
        }
    }

    public void set(SnmpGetSetPdu snmpgetsetpdu) {
        LeafOIDListener[] aleafoidlistener = new LeafOIDListener[snmpgetsetpdu.getValueSize()];
        for (int i = 0; i < snmpgetsetpdu.getValueSize(); ++i) {
            AsnNameValuePair asnnamevaluepair = snmpgetsetpdu.getNameValuePair(i);
            AsnOID asnoid = asnnamevaluepair.getName();
            AsnObject asnobject = asnnamevaluepair.getValue();
            try {
                this.findListener(asnoid.toString());
                aleafoidlistener[i] = this.currentListener;
                this.currentListener.setCName(this.contextEngineID, this.contextName);
                this.currentListener.setValue(asnoid.toString(), asnobject);
                continue;
            }
            catch (SnmpException snmpexception) {
                snmpgetsetpdu.setErrorStatus(snmpexception.getErrorCode());
                snmpgetsetpdu.setErrorIndex(i + 1);
                return;
            }
        }
        for (int j = 0; j < snmpgetsetpdu.getValueSize(); ++j) {
            try {
                if (aleafoidlistener[j].isJustCommit()) continue;
                aleafoidlistener[j].commit();
                continue;
            }
            catch (SnmpException _ex) {
                for (int k = 0; k < j; ++k) {
                    try {
                        aleafoidlistener[k].undo();
                        continue;
                    }
                    catch (SnmpException _ex2) {
                        snmpgetsetpdu.setErrorStatus(15L);
                        snmpgetsetpdu.setErrorIndex(0L);
                        return;
                    }
                }
                snmpgetsetpdu.setErrorStatus(14L);
                snmpgetsetpdu.setErrorIndex(j + 1);
                return;
            }
        }
    }
}

