/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.core;

import java.util.Enumeration;
import java.util.Vector;
import jeus.management.snmp.core.AsnFactory;
import jeus.management.snmp.core.AsnInteger;
import jeus.management.snmp.core.AsnNameValuePair;
import jeus.management.snmp.core.AsnNull;
import jeus.management.snmp.core.AsnOID;
import jeus.management.snmp.core.AsnObject;
import jeus.management.snmp.core.AsnOctets;
import jeus.management.snmp.core.AsnSequence;
import jeus.management.snmp.core.AsnUnsignedInteger;
import jeus.management.snmp.core.SnmpPdu;

public class SnmpTrapPdu
extends SnmpPdu {
    protected String enterprise = null;
    protected String agentAddr = null;
    protected long genericTrap = 6L;
    protected long specificTrap = 0L;
    protected long timeStamp = 0L;
    protected Vector varbinds = new Vector();

    public SnmpTrapPdu() {
        this.setMsgType((byte)-92);
    }

    public SnmpTrapPdu(AsnSequence asnsequence) {
        this.init(asnsequence);
    }

    public void addNameValuePair(AsnNameValuePair asnnamevaluepair) {
        this.varbinds.addElement(asnnamevaluepair);
    }

    public void addNameValuePair(String s) {
        AsnNameValuePair asnnamevaluepair = new AsnNameValuePair(s);
        this.varbinds.addElement(asnnamevaluepair);
    }

    public AsnSequence createAsnSequence() {
        AsnSequence asnsequence = new AsnSequence();
        asnsequence.setType(this.getMsgType());
        asnsequence.add(new AsnOID(this.enterprise));
        byte[] abyte0 = new byte[]{127, 0, 0, 1};
        AsnOctets asnoctets = new AsnOctets(this.agentAddr);
        asnoctets.setType((byte)64);
        asnsequence.add(asnoctets);
        asnsequence.add(new AsnInteger(this.genericTrap));
        asnsequence.add(new AsnInteger(this.specificTrap));
        AsnUnsignedInteger asnunsignedinteger = new AsnUnsignedInteger(this.timeStamp);
        asnunsignedinteger.setType((byte)67);
        asnsequence.add(asnunsignedinteger);
        AsnSequence asnsequence1 = new AsnSequence();
        asnsequence.add(asnsequence1);
        Enumeration enumeration = this.varbinds.elements();
        while (enumeration.hasMoreElements()) {
            AsnNameValuePair asnnamevaluepair = (AsnNameValuePair)enumeration.nextElement();
            AsnSequence asnsequence2 = new AsnSequence();
            asnsequence2.add(asnnamevaluepair.getName());
            asnsequence2.add(asnnamevaluepair.getValue());
            asnsequence1.add(asnsequence2);
        }
        return asnsequence;
    }

    public String getAgentAddr() {
        return this.agentAddr;
    }

    public String getEnterprise() {
        return this.enterprise;
    }

    public long getGenericTrap() {
        return this.genericTrap;
    }

    public AsnNameValuePair getNameValuePair(int i) {
        return (AsnNameValuePair)this.varbinds.elementAt(i);
    }

    public long getSpecificTrap() {
        return this.specificTrap;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public AsnObject getValue(int i) {
        AsnNameValuePair asnnamevaluepair = (AsnNameValuePair)this.varbinds.elementAt(i);
        return asnnamevaluepair.getValue();
    }

    public AsnObject getValue(AsnOID asnoid) {
        Enumeration enumeration = this.varbinds.elements();
        while (enumeration.hasMoreElements()) {
            AsnNameValuePair asnnamevaluepair = (AsnNameValuePair)enumeration.nextElement();
            if (!asnnamevaluepair.getName().same(asnoid)) continue;
            return asnnamevaluepair.getValue();
        }
        return new AsnNull();
    }

    public AsnObject getValue(String s) {
        return this.getValue(new AsnOID(s));
    }

    public int getValueSize() {
        return this.varbinds.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(AsnSequence asnsequence) {
        this.setMsgType(asnsequence.getType());
        this.enterprise = ((AsnOID)asnsequence.getObj(0)).toString();
        this.agentAddr = ((AsnOctets)asnsequence.getObj(1)).toString();
        this.genericTrap = ((AsnInteger)asnsequence.getObj(2)).getValue();
        this.specificTrap = ((AsnInteger)asnsequence.getObj(3)).getValue();
        this.timeStamp = ((AsnUnsignedInteger)asnsequence.getObj(4)).getValue();
        AsnObject asnobject = asnsequence.getObj(5);
        if (asnobject instanceof AsnSequence) {
            AsnSequence asnsequence1 = (AsnSequence)asnobject;
            int i = asnsequence1.size();
            this.varbinds = new Vector(i, i / 2);
            for (int j = 0; j < asnsequence1.size(); ++j) {
                AsnObject asnobject1 = asnsequence1.getObj(j);
                if (!(asnobject1 instanceof AsnSequence)) continue;
                AsnSequence asnsequence2 = (AsnSequence)asnobject1;
                AsnNameValuePair asnnamevaluepair = new AsnNameValuePair();
                AsnObject asnobject2 = (AsnObject)asnnamevaluepair.setData(asnsequence2);
                this.varbinds.addElement(asnnamevaluepair);
                this.setChanged();
            }
        }
        this.clearChanged();
        SnmpTrapPdu snmpTrapPdu = this;
        synchronized (snmpTrapPdu) {
            this.notify();
        }
    }

    public void setAgentAddr(String s) {
        this.agentAddr = s;
    }

    public void setEnterprise(String s) {
        this.enterprise = s;
    }

    public void setGenericTrap(long l) {
        this.genericTrap = l;
    }

    public void setSpecificTrap(int i) {
        this.specificTrap = i;
    }

    public void setTimeStamp(int i) {
        this.timeStamp = i;
    }

    public void setValue(AsnOID asnoid, AsnObject asnobject) {
        Enumeration enumeration = this.varbinds.elements();
        while (enumeration.hasMoreElements()) {
            AsnNameValuePair asnnamevaluepair = (AsnNameValuePair)enumeration.nextElement();
            if (!asnnamevaluepair.getName().same(asnoid)) continue;
            asnnamevaluepair.setValue(asnobject);
        }
    }

    public void setValue(String s, AsnObject asnobject) {
        this.setValue(new AsnOID(s), asnobject);
    }

    public String toString() {
        return this.getClass().getName() + "{" + "msg_type=" + AsnFactory.asnType2String(this.getMsgType()) + ", enterprise=" + this.enterprise + ", agentAddr=" + this.agentAddr + ", genericTrap=" + this.genericTrap + ", specificTrap=" + this.specificTrap + ", timeStamp=" + this.timeStamp + ", varbinds=" + this.varbinds + "}";
    }
}

