/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.tool;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jeus.ejb.util.CodeWriter;
import jeus.jms.server.mbean.JMSClientResourceMBean;
import jeus.jms.server.mbean.JMSConnectionResourceMBean;
import jeus.jms.server.mbean.JMSConsumerResourceMBean;
import jeus.jms.server.mbean.JMSDestinationStatsImpl;
import jeus.jms.server.mbean.JMSDurableSubscriberResourceMBean;
import jeus.jms.server.mbean.JMSEngineMoMBean;
import jeus.jms.server.mbean.JMSProducerResourceMBean;
import jeus.jms.server.mbean.JMSQueueConnectionFactoryResourceMBean;
import jeus.jms.server.mbean.JMSQueueDestinationResourceMBean;
import jeus.jms.server.mbean.JMSResourceMBean;
import jeus.jms.server.mbean.JMSSessionResourceMBean;
import jeus.jms.server.mbean.JMSTopicConnectionFactoryResourceMBean;
import jeus.jms.server.mbean.JMSTopicDestinationResourceMBean;
import jeus.jms.server.mbean.stats.JMSClientStatsImpl;
import jeus.jms.server.mbean.stats.JMSConnectionStatsImpl;
import jeus.jms.server.mbean.stats.JMSConsumerStatsImpl;
import jeus.jms.server.mbean.stats.JMSProducerStatsImpl;
import jeus.jms.server.mbean.stats.JMSSessionStatsImpl;
import jeus.jms.server.mbean.stats.JMSStatsImpl;
import jeus.management.j2ee.AppClientModuleMBean;
import jeus.management.j2ee.EJBModuleMBean;
import jeus.management.j2ee.EntityBeanMBean;
import jeus.management.j2ee.J2EEApplicationMBean;
import jeus.management.j2ee.J2EEDomainMBean;
import jeus.management.j2ee.J2EEServerMBean;
import jeus.management.j2ee.JCAConnectionFactoryMBean;
import jeus.management.j2ee.JCAManagedConnectionFactoryMBean;
import jeus.management.j2ee.JCAResourceMBean;
import jeus.management.j2ee.JDBCDataSourceMBean;
import jeus.management.j2ee.JDBCDriverMBean;
import jeus.management.j2ee.JDBCResourceMBean;
import jeus.management.j2ee.JEUSManagerMBean;
import jeus.management.j2ee.JNDIResourceMBean;
import jeus.management.j2ee.JTAResourceMBean;
import jeus.management.j2ee.JVMMBean;
import jeus.management.j2ee.JavaMailResourceMBean;
import jeus.management.j2ee.MessageDrivenBeanMBean;
import jeus.management.j2ee.ResourceAdapterMBean;
import jeus.management.j2ee.ResourceAdapterModuleMBean;
import jeus.management.j2ee.ServletMBean;
import jeus.management.j2ee.StatefulSessionBeanMBean;
import jeus.management.j2ee.StatelessSessionBeanMBean;
import jeus.management.j2ee.URLResourceMBean;
import jeus.management.j2ee.WebModuleMBean;
import jeus.management.j2ee.ejb.EJBEngineMoMBean;
import jeus.management.j2ee.security.PolicyMoMBean;
import jeus.management.j2ee.security.SecurityDomainMoMBean;
import jeus.management.j2ee.security.SecurityMoMBean;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.management.j2ee.servlet.ContextGroupMoMBean;
import jeus.management.j2ee.servlet.ServletStatsImpl;
import jeus.management.j2ee.servlet.ThreadPoolMoMBean;
import jeus.management.j2ee.servlet.ThreadPoolStatsImpl;
import jeus.management.j2ee.servlet.WebEngineMoMBean;
import jeus.management.j2ee.servlet.WebEngineStatsImpl;
import jeus.management.j2ee.servlet.WebListenerMoMBean;
import jeus.management.j2ee.servlet.WebModuleStatsImpl;
import jeus.management.j2ee.statistics.EntityBeanStatsImpl;
import jeus.management.j2ee.statistics.JDBCConnectionPoolStatsImpl;
import jeus.management.j2ee.statistics.JDBCStatsImpl;
import jeus.management.j2ee.statistics.JTAStatsImpl;
import jeus.management.j2ee.statistics.JVMStatsImpl;
import jeus.management.j2ee.statistics.MessageDrivenBeanStatsImpl;
import jeus.management.j2ee.statistics.StatefulSessionBeanStatsImpl;
import jeus.management.j2ee.statistics.StatelessSessionBeanStatsImpl;
import jeus.management.j2ee.statistics.URLStatsImpl;
import jeus.management.j2ee.thread.ThreadPoolMBean;
import jeus.management.j2ee.webserver.WebServerInfoMBean;
import jeus.management.j2ee.webserver.WebServerInfoStatsImpl;
import pt.ipb.agentapi.mibs.MibException;
import pt.ipb.agentapi.mibs.MibModule;
import pt.ipb.agentapi.mibs.MibNode;
import pt.ipb.agentapi.mibs.MibOps;

public class MbeanToMib {
    protected static final int CW_BUFFER = 4096;
    protected static final String fs = System.getProperty("file.separator");
    protected static final char fsc = fs.charAt(0);
    protected static String clsp = File.separator.equals("/") ? new String(":") : new String(";");
    private String mibFileName = null;
    private MibOps ops;
    private Hashtable mbeanOidTable = new Hashtable();
    private Hashtable attrOidTable = new Hashtable();
    private Hashtable mbeanNameTable = new Hashtable();
    private Hashtable attrNameTable = new Hashtable();
    private Hashtable descTable = new Hashtable();
    private int NOT_ASSIGNED_MBEAN_OID = 199;
    private int NOT_ASSIGNED_ATTR_OID = 999;
    private int NOT_ASSIGNED_STATS_ATTR_OID = 9999;
    private Hashtable mibTable = new Hashtable();
    private CodeWriter out = null;
    private OutputStream outputStream = null;

    public MbeanToMib(String fName) throws FileNotFoundException, MibException {
        this.mibFileName = fName;
        File mibFile = new File(this.mibFileName);
        this.outputStream = new BufferedOutputStream(new FileOutputStream(mibFile));
        this.out = new CodeWriter(this.outputStream);
    }

    private void generateMib(Hashtable statClasses) {
        try {
            Vector<String> header = new Vector<String>();
            this.mibTable.put("header", header);
            header.add("TMAX-JEUS-MIB DEFINITIONS ::= BEGIN");
            header.add("IMPORTS");
            header.add("");
            header.add("\tenterprises, Counter");
            header.add("\t\tFROM RFC1155-SMI");
            header.add("\tOBJECT-TYPE");
            header.add("\t\tFROM RFC-1212");
            header.add("\tDisplayString");
            header.add("\t\tFROM RFC1213-MIB");
            header.add("\tTRAP-TYPE");
            header.add("\t\tFROM RFC-1215;");
            header.add("tmax\tOBJECT IDENTIFIER  ::=  {  enterprises  14586  }");
            header.add("");
            header.add("jeus\tOBJECT IDENTIFIER  ::=  {  tmax  100  }");
            header.add("");
            header.add("----------------------------------------------------------");
            header.add("-- SNMP moniroting objects in each MBeans");
            header.add("----------------------------------------------------------");
            header.add("");
            Enumeration classes = statClasses.keys();
            while (classes.hasMoreElements()) {
                try {
                    String key = (String)classes.nextElement();
                    String mbeanName = key;
                    Class<?> mbeanC = Class.forName(mbeanName);
                    if (mbeanC == null) continue;
                    mbeanName = mbeanName.substring(mbeanName.lastIndexOf(".") + 1, mbeanName.lastIndexOf("MBean"));
                    mbeanName = mbeanName.substring(0, 1).toLowerCase() + mbeanName.substring(1);
                    Vector<String> mbeanHeader = new Vector<String>();
                    this.mibTable.put(mbeanName.toLowerCase(), mbeanHeader);
                    mbeanHeader.add("----------------");
                    mbeanHeader.add("-- " + mbeanName);
                    mbeanHeader.add("----------------");
                    mbeanHeader.add("");
                    mbeanHeader.add(mbeanName + " OBJECT IDENTIFIER");
                    String mbeanOID = (String)this.mbeanOidTable.get(mbeanName);
                    if (mbeanOID == null) {
                        mbeanOID = String.valueOf(this.NOT_ASSIGNED_MBEAN_OID++);
                        this.mbeanOidTable.put(mbeanName, mbeanOID);
                        this.mbeanNameTable.put(Integer.valueOf(mbeanOID), mbeanName);
                        this.attrNameTable.put(Integer.valueOf(mbeanOID), new Hashtable());
                    }
                    mbeanHeader.add("    ::=  { jeus  " + mbeanOID + " }");
                    mbeanHeader.add("");
                    Method[] methods = mbeanC.getMethods();
                    for (int j = 0; j < methods.length; ++j) {
                        String methodName = methods[j].getName();
                        String attributeName = methodName.substring(3);
                        String attributeNameLower = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                        attributeNameLower = mbeanName + attributeNameLower;
                        Class<?>[] paremeterClasses = methods[j].getParameterTypes();
                        Class<?> returnClass = methods[j].getReturnType();
                        if (mbeanName.equals("jMSDurableSubscriberResource")) {
                            boolean a = false;
                        }
                        if (attributeName.equals("ObjectName") || attributeName.equals("PermissionName") || attributeName.equals("J2EEType") || attributeName.equals("Troubles") || attributeName.equals("OwnTroubles") || attributeName.equals("parent") || attributeName.equals("Parent") || attributeName.equals("state") || attributeName.equals("startTime") || attributeName.equals("EventTypes") || attributeName.equals("NotificationInfo") || mbeanName.equals("jEUSManager") && attributeName.equals("deployedObjects") || mbeanName.equals("jEUSManager") && attributeName.equals("resources") || mbeanName.equals("threadPoolMo") && attributeName.equals("ThreadState_ALL_INFO") || (mbeanName.equals("jMSQueueDestinationResource") || mbeanName.equals("jMSTopicDestinationResource")) && attributeName.equals("MessageCount") || (mbeanName.equals("jMSQueueDestinationResource") || mbeanName.equals("jMSDurableSubscriberResource")) && attributeName.equals("MessageInfo") || attributeName.equals("stats") || !methodName.substring(0, 3).equals("get") && !methodName.substring(0, 3).equals("set") || (!methodName.substring(0, 3).equals("get") || methods[j].getParameterTypes().length != 0) && (!methodName.substring(0, 3).equals("set") || methods[j].getParameterTypes().length != 1)) continue;
                        if (returnClass.getName().indexOf("Stats") == -1 && returnClass.getName().indexOf("Statistic") == -1 && returnClass.getName().indexOf("DBConnectionPoolInfo") == -1) {
                            Vector<String> attrOut = new Vector<String>();
                            boolean isExistAttr = false;
                            Vector existAttrOut = (Vector)this.mibTable.get((mbeanName + ":" + attributeNameLower).toLowerCase());
                            System.out.println("[adol] " + (mbeanName + ":" + attributeNameLower).toLowerCase());
                            if (existAttrOut != null) {
                                isExistAttr = true;
                            }
                            this.mibTable.put((mbeanName + ":" + attributeNameLower).toLowerCase(), attrOut);
                            attrOut.add(attributeNameLower + "\tOBJECT-TYPE");
                            if (returnClass.isArray()) {
                                attrOut.add("    SYNTAX\tSEQUENCE OF DisplayString");
                            } else {
                                attrOut.add("    SYNTAX\tDisplayString");
                            }
                            if (isExistAttr) {
                                attrOut.add("    ACCESS\tread-write");
                            } else if (methodName.substring(0, 3).equals("get")) {
                                attrOut.add("    ACCESS\tread-only");
                            } else if (methodName.substring(0, 3).equals("set")) {
                                attrOut.add("    ACCESS\twrite-only");
                            }
                            attrOut.add("    STATUS\tmandatory");
                            String desc = (String)this.descTable.get((mbeanName + ":" + attributeNameLower).toLowerCase());
                            attrOut.add("    DESCRIPTION");
                            if (desc == null) {
                                attrOut.add("        \"\"");
                            } else {
                                attrOut.add("        " + desc);
                            }
                            String attrOID = (String)this.attrOidTable.get((mbeanName + ":" + attributeNameLower).toLowerCase());
                            if (attrOID == null) {
                                attrOID = String.valueOf(this.NOT_ASSIGNED_ATTR_OID++);
                                Hashtable temp = (Hashtable)this.attrNameTable.get(Integer.valueOf(mbeanOID));
                                temp.put(Integer.valueOf(attrOID), (mbeanName + ":" + attributeNameLower).toLowerCase());
                            }
                            attrOut.add("    ::=  {  " + mbeanName + " " + attrOID + "  }");
                            continue;
                        }
                        this.writeStatisticAttribute(this.out, mbeanName, returnClass.getName(), attributeNameLower, false);
                    }
                    String statClassName = (String)statClasses.get(key);
                    this.writeStatisticAttribute(this.out, mbeanName, statClassName, "", true);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void writeStatisticAttribute(CodeWriter out, String mbeanName, String statClassName, String attrPrefix, boolean isStatClass) throws IOException {
        Class<?> statsC = null;
        if (!attrPrefix.equals("")) {
            attrPrefix = attrPrefix + "-";
        }
        if (!attrPrefix.startsWith(mbeanName)) {
            attrPrefix = mbeanName + attrPrefix;
        }
        try {
            if (statClassName.indexOf("[L") >= 0) {
                statClassName = statClassName.substring(2, statClassName.lastIndexOf(";"));
            }
            if (!statClassName.equals("")) {
                statsC = Class.forName(statClassName);
            }
            if (statsC != null) {
                Method[] statMethods = statsC.getMethods();
                for (int j = 0; j < statMethods.length; ++j) {
                    String methodName = statMethods[j].getName();
                    String attributeName = methodName.substring(3);
                    String attributeNameLower = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                    Class<?>[] paremeterClasses = statMethods[j].getParameterTypes();
                    Class<?> returnClass = statMethods[j].getReturnType();
                    if (attributeName.equals("Statistic") || attributeName.equals("StatisticName") || attributeName.equals("StatisticNames") || attributeName.equals("Statistics") || attributeName.equals("Class") || attributeName.equals("Name") || attributeName.equals("Unit") || attributeName.equals("Description") || attributeName.equals("StartTime") || attributeName.equals("LastSampleTime") || attributeName.equals("ServiceTimeImpl") || mbeanName.equals("jDBCResource") && attributeName.equals("Connections") || mbeanName.equals("servlet") && attributeName.equals("SERVICE_TIME") || !methodName.substring(0, 3).equals("get") || statMethods[j].getParameterTypes().length != 0) continue;
                    if (returnClass.getName().indexOf("Stats") == -1 && returnClass.getName().indexOf("Statistic") == -1 && returnClass.getName().indexOf("DBConnectionPoolInfo") == -1) {
                        Vector<String> attrOut = new Vector<String>();
                        boolean isExistAttr = false;
                        Vector existAttrOut = (Vector)this.mibTable.get((mbeanName + ":" + attrPrefix + attributeNameLower).toLowerCase());
                        if (existAttrOut != null) {
                            isExistAttr = true;
                        }
                        this.mibTable.put((mbeanName + ":" + attrPrefix + attributeNameLower).toLowerCase(), attrOut);
                        System.out.println("attrPrefix[" + attrPrefix + "]");
                        attrOut.add(attrPrefix + attributeNameLower + "\tOBJECT-TYPE");
                        if (returnClass.isArray()) {
                            attrOut.add("    SYNTAX\tSEQUENCE OF DisplayString");
                        } else {
                            attrOut.add("    SYNTAX\tDisplayString");
                        }
                        if (isExistAttr) {
                            attrOut.add("    ACCESS\tread-write");
                        } else if (methodName.substring(0, 3).equals("get")) {
                            attrOut.add("    ACCESS\tread-only");
                        } else if (methodName.substring(0, 3).equals("set")) {
                            attrOut.add("    ACCESS\twrite-only");
                        }
                        attrOut.add("    STATUS\tmandatory");
                        String desc = (String)this.descTable.get((mbeanName + ":" + attrPrefix + attributeNameLower).toLowerCase());
                        attrOut.add("    DESCRIPTION");
                        if (desc == null) {
                            attrOut.add("        \"\"");
                        } else {
                            attrOut.add("        " + desc);
                        }
                        String attrOID = (String)this.attrOidTable.get((mbeanName + ":" + attrPrefix + attributeNameLower).toLowerCase());
                        if (attrOID == null) {
                            attrOID = isStatClass ? String.valueOf(this.NOT_ASSIGNED_STATS_ATTR_OID++) : String.valueOf(this.NOT_ASSIGNED_ATTR_OID++);
                            Hashtable temp = (Hashtable)this.attrNameTable.get(Integer.valueOf((String)this.mbeanOidTable.get(mbeanName)));
                            temp.put(Integer.valueOf(attrOID), (mbeanName + ":" + attrPrefix + attributeNameLower).toLowerCase());
                        }
                        attrOut.add("    ::=  {  " + mbeanName + " " + attrOID + "  }");
                        continue;
                    }
                    this.writeStatisticAttribute(out, mbeanName, returnClass.getName(), attrPrefix + attributeNameLower, isStatClass);
                }
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("    Statistics Class[" + statClassName + "] is not found!!");
        }
    }

    private void generate() {
        Hashtable<String, String> statClassName = new Hashtable<String, String>();
        statClassName.put(AppClientModuleMBean.class.getName(), "");
        statClassName.put(EJBModuleMBean.class.getName(), "");
        statClassName.put(EntityBeanMBean.class.getName(), EntityBeanStatsImpl.class.getName());
        statClassName.put(J2EEApplicationMBean.class.getName(), "");
        statClassName.put(J2EEDomainMBean.class.getName(), "");
        statClassName.put(J2EEServerMBean.class.getName(), "");
        statClassName.put(JavaMailResourceMBean.class.getName(), "");
        statClassName.put(JCAConnectionFactoryMBean.class.getName(), "");
        statClassName.put(JCAManagedConnectionFactoryMBean.class.getName(), "");
        statClassName.put(JCAResourceMBean.class.getName(), "");
        statClassName.put(JDBCDataSourceMBean.class.getName(), JDBCConnectionPoolStatsImpl.class.getName());
        statClassName.put(JDBCDriverMBean.class.getName(), "");
        statClassName.put(JDBCResourceMBean.class.getName(), JDBCStatsImpl.class.getName());
        statClassName.put(JEUSManagerMBean.class.getName(), "");
        statClassName.put(JMSResourceMBean.class.getName(), JMSStatsImpl.class.getName());
        statClassName.put(JMSConnectionResourceMBean.class.getName(), JMSConnectionStatsImpl.class.getName());
        statClassName.put(JMSConsumerResourceMBean.class.getName(), JMSConsumerStatsImpl.class.getName());
        statClassName.put(JMSProducerResourceMBean.class.getName(), JMSProducerStatsImpl.class.getName());
        statClassName.put(JMSSessionResourceMBean.class.getName(), JMSSessionStatsImpl.class.getName());
        statClassName.put(JNDIResourceMBean.class.getName(), "");
        statClassName.put(JTAResourceMBean.class.getName(), JTAStatsImpl.class.getName());
        statClassName.put(JVMMBean.class.getName(), JVMStatsImpl.class.getName());
        statClassName.put(MessageDrivenBeanMBean.class.getName(), MessageDrivenBeanStatsImpl.class.getName());
        statClassName.put(ResourceAdapterMBean.class.getName(), "");
        statClassName.put(ResourceAdapterModuleMBean.class.getName(), "");
        statClassName.put(ServletMBean.class.getName(), ServletStatsImpl.class.getName());
        statClassName.put(StatefulSessionBeanMBean.class.getName(), StatefulSessionBeanStatsImpl.class.getName());
        statClassName.put(StatelessSessionBeanMBean.class.getName(), StatelessSessionBeanStatsImpl.class.getName());
        statClassName.put(URLResourceMBean.class.getName(), URLStatsImpl.class.getName());
        statClassName.put(WebModuleMBean.class.getName(), WebModuleStatsImpl.class.getName());
        statClassName.put(EJBEngineMoMBean.class.getName(), "");
        statClassName.put(ContextGroupMoMBean.class.getName(), "");
        statClassName.put(ThreadPoolMoMBean.class.getName(), ThreadPoolStatsImpl.class.getName());
        statClassName.put(WebEngineMoMBean.class.getName(), WebEngineStatsImpl.class.getName());
        statClassName.put(WebListenerMoMBean.class.getName(), "");
        statClassName.put(JMSClientResourceMBean.class.getName(), JMSClientStatsImpl.class.getName());
        statClassName.put(JMSQueueConnectionFactoryResourceMBean.class.getName(), "");
        statClassName.put(JMSTopicConnectionFactoryResourceMBean.class.getName(), "");
        statClassName.put(JMSQueueDestinationResourceMBean.class.getName(), JMSDestinationStatsImpl.class.getName());
        statClassName.put(JMSTopicDestinationResourceMBean.class.getName(), JMSDestinationStatsImpl.class.getName());
        statClassName.put(JMSDurableSubscriberResourceMBean.class.getName(), "");
        statClassName.put(ThreadPoolMBean.class.getName(), "");
        statClassName.put(WebServerInfoMBean.class.getName(), WebServerInfoStatsImpl.class.getName());
        statClassName.put(PolicyMoMBean.class.getName(), "");
        statClassName.put(SecurityDomainMoMBean.class.getName(), "");
        statClassName.put(SecurityMoMBean.class.getName(), "");
        statClassName.put(SubjectMoMBean.class.getName(), "");
        statClassName.put(JMSEngineMoMBean.class.getName(), "");
        this.generateMib(statClassName);
    }

    public void loadMib(String fName) throws FileNotFoundException, MibException {
        this.ops = new MibOps();
        this.ops.loadMib(fName);
    }

    private void children(int level, MibNode node) {
        if (node != null) {
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                MibNode child = (MibNode)e.nextElement();
                this.children(level + 2, child);
            }
            MibNode parent = node.getParent();
            if (parent != null && parent.getOID().toString().equals(".1.3.6.1.4.1.14586.100")) {
                String mbeanClassName = node.getLabel();
                mbeanClassName = mbeanClassName.substring(0, 1).toUpperCase() + mbeanClassName.substring(1);
                String mbeanOID = node.getOID().toString();
                mbeanOID = mbeanOID.substring(mbeanOID.lastIndexOf(".") + 1);
                this.mbeanOidTable.put(node.getLabel(), mbeanOID);
                this.mbeanNameTable.put(Integer.valueOf(mbeanOID), node.getLabel());
                this.attrNameTable.put(Integer.valueOf(mbeanOID), new Hashtable());
                Enumeration e2 = node.children();
                while (e2.hasMoreElements()) {
                    MibNode child = (MibNode)e2.nextElement();
                    String attrOID = child.getOID().toString();
                    attrOID = attrOID.substring(attrOID.lastIndexOf(".") + 1);
                    this.attrOidTable.put((mbeanClassName + ":" + child.getLabel()).toLowerCase(), attrOID);
                    Hashtable temp = (Hashtable)this.attrNameTable.get(Integer.valueOf(mbeanOID));
                    temp.put(Integer.valueOf(attrOID), (mbeanClassName + ":" + child.getLabel()).toLowerCase());
                    String desc = child.getDescription();
                    this.descTable.put((mbeanClassName + ":" + child.getLabel()).toLowerCase(), desc);
                }
            }
        }
    }

    private void makeOIDTable() {
        Enumeration e = this.ops.modules();
        while (e.hasMoreElements()) {
            MibModule module = (MibModule)e.nextElement();
            MibNode root = module.getRoot();
            this.children(2, root);
        }
    }

    private void writeMib() throws IOException {
        int i = 0;
        Vector<String> sorted = new Vector<String>();
        ArrayList<Integer> mbeanlist = new ArrayList<Integer>();
        Enumeration mbeanEnum = this.mbeanNameTable.keys();
        while (mbeanEnum.hasMoreElements()) {
            Integer element = (Integer)mbeanEnum.nextElement();
            mbeanlist.add(element);
            String value = (String)this.mbeanNameTable.get(element);
            ++i;
        }
        Collections.sort(mbeanlist);
        for (i = 0; i < mbeanlist.size(); ++i) {
            String value = (String)this.mbeanNameTable.get(mbeanlist.get(i));
        }
        for (int p = 0; p < mbeanlist.size(); ++p) {
            i = 0;
            ArrayList<Integer> attrlist = new ArrayList<Integer>();
            Hashtable attrs = (Hashtable)this.attrNameTable.get(mbeanlist.get(p));
            Enumeration attrEnum = attrs.keys();
            while (attrEnum.hasMoreElements()) {
                Integer element = (Integer)attrEnum.nextElement();
                attrlist.add(element);
                String value = (String)attrs.get(element);
                ++i;
            }
            Collections.sort(attrlist);
            for (i = 0; i < attrlist.size(); ++i) {
                String value = (String)attrs.get(attrlist.get(i));
                sorted.add(value);
            }
        }
        Vector header = (Vector)this.mibTable.get("header");
        for (i = 0; i < header.size(); ++i) {
            this.out.write((String)header.get(i));
        }
        String prevMbeanName = "";
        Vector<String> generatedKey = new Vector<String>();
        for (i = 0; i < sorted.size(); ++i) {
            String key = (String)sorted.get(i);
            System.out.println("   " + key);
            String mbeanName = key.substring(0, key.indexOf(":"));
            try {
                if (!mbeanName.equals(prevMbeanName)) {
                    Vector mbeanHeader = (Vector)this.mibTable.get(mbeanName);
                    this.out.write("");
                    for (int p = 0; p < mbeanHeader.size(); ++p) {
                        this.out.write((String)mbeanHeader.get(p));
                    }
                    prevMbeanName = mbeanName;
                }
                boolean isGenerated = false;
                for (int z = 0; z < generatedKey.size(); ++z) {
                    if (!generatedKey.elementAt(z).equals(key)) continue;
                    isGenerated = true;
                }
                if (!isGenerated) {
                    Vector attrOut = (Vector)this.mibTable.get(key);
                    for (int q = 0; q < attrOut.size(); ++q) {
                        this.out.write((String)attrOut.get(q));
                    }
                }
            }
            catch (Throwable t) {
                System.out.println("WARNING: " + key + " is removed!!");
                t.printStackTrace();
            }
            generatedKey.add(key);
        }
        this.out.write("");
        this.out.write("END");
        this.outputStream.flush();
        this.outputStream.close();
    }

    public static void main(String[] args) {
        try {
            if (args.length == 2) {
                MbeanToMib mbeanToMib = new MbeanToMib(args[0]);
                mbeanToMib.loadMib(args[1]);
                mbeanToMib.makeOIDTable();
                mbeanToMib.generate();
                mbeanToMib.writeMib();
            } else {
                System.out.println("USAGE: java mbeanToMib <new mib filename> <old mib filename>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

