/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.snmp.tool;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import jeus.ejb.util.CodeWriter;
import pt.ipb.agentapi.mibs.MibException;
import pt.ipb.agentapi.mibs.MibModule;
import pt.ipb.agentapi.mibs.MibNode;
import pt.ipb.agentapi.mibs.MibOps;

public class MibToSnmpRegister {
    protected static final int CW_BUFFER = 4096;
    protected static final String fs = System.getProperty("file.separator");
    protected static final char fsc = fs.charAt(0);
    protected static String clsp;
    protected static String outputDir;
    protected static String outputFileName;
    protected static CodeWriter output;
    private MibOps ops = new MibOps();
    private String logLevel;

    public MibToSnmpRegister(String fName, String logLevel) throws FileNotFoundException, MibException {
        this.ops.loadMib(fName);
        this.logLevel = logLevel;
    }

    private void children(int level, MibNode node, CodeWriter out) {
        if (node == null || out == null) {
            return;
        }
        Enumeration e = node.children();
        while (e.hasMoreElements()) {
            MibNode child = (MibNode)e.nextElement();
            this.children(level + 2, child, out);
        }
        String temp = null;
        try {
            MibNode parent = node.getParent();
            if (parent != null && parent.getOID().toString().equals(".1.3.6.1.4.1.14586.100")) {
                String mbeanClassName = node.getLabel();
                mbeanClassName = mbeanClassName.substring(0, 1).toUpperCase() + mbeanClassName.substring(1);
                if (this.logLevel.toUpperCase().equals("JMX")) {
                    temp = "attrs = new Vector();";
                    System.out.println(temp);
                    output.write(temp);
                    temp = "attributes.put(\"" + mbeanClassName + "\", attrs);";
                    System.out.println(temp);
                    output.write(temp);
                    temp = null;
                }
                out.write("        // register a " + mbeanClassName + " mbean");
                Enumeration e2 = node.children();
                while (e2.hasMoreElements()) {
                    MibNode child = (MibNode)e2.nextElement();
                    if (this.logLevel.toUpperCase().equals("SNMP")) {
                        temp = "\"" + child.getOID().toString().substring(1) + "\",";
                    } else if (this.logLevel.toUpperCase().equals("DEFAULT")) {
                        temp = child.getOID().toString().substring(1) + " " + mbeanClassName + "." + child.getLabel();
                    } else if (this.logLevel.toUpperCase().equals("JMX")) {
                        temp = "attrs.add(\"" + child.getLabel() + "\");";
                    }
                    System.out.println(temp);
                    output.write(temp);
                    temp = null;
                    out.write("        snmpAgent.putOID(\"" + child.getOID().toString().substring(1) + "\", " + "\"" + mbeanClassName + "\"" + ", " + "\"" + MibToSnmpRegister.replaceStringOnce(child.getLabel(), node.getLabel(), "") + "\");");
                }
                out.write("");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static String replaceStringOnce(String in, String cha, String num) {
        int ptr = 0;
        int len = cha.length();
        if (in.indexOf(cha, ptr) < 0) {
            return in;
        }
        int loc = in.indexOf(cha, ptr);
        in = in.substring(0, loc) + num + in.substring(loc + len);
        return in;
    }

    private void generate() throws IOException {
        BufferedOutputStream outputStream = null;
        File snmpRegisterFile = new File(outputDir + "SnmpRegister.java");
        outputStream = new BufferedOutputStream(new FileOutputStream(snmpRegisterFile));
        CodeWriter out = new CodeWriter(outputStream);
        out.write("/* COPYRIGHT (c) 2005 by TMAX SOFT Inc. Korea");
        out.write("* All Rights Reserved.");
        out.write("*");
        out.write("* It's generated from TMAX-JEUS-MIB.mib file by MibToSnmpRegister.");
        out.write("*");
        out.write("* Contact : carryel@tmax.co.kr");
        out.write("* Made by : bongjae chang, Tmax Soft.co.");
        out.write("*/");
        out.write("");
        out.write("package jeus.management.snmp.adaptor;");
        out.write("");
        out.write("import jeus.management.snmp.agent.SnmpAgentImpl;");
        out.write("");
        out.write("public class SnmpRegister {");
        out.write("    private SnmpAgentImpl snmpAgent;");
        out.write("");
        out.write("    public SnmpRegister( SnmpAgentImpl snmpAgent ) {");
        out.write("        this.snmpAgent = snmpAgent;");
        out.write("    }");
        out.write("");
        out.write("    public void loadMibInfomation() {");
        out.write("        if ( snmpAgent == null )");
        out.write("            return;");
        out.write("");
        out.write("        // register all oid-method from mib file.");
        Enumeration e = this.ops.modules();
        while (e.hasMoreElements()) {
            MibModule module = (MibModule)e.nextElement();
            MibNode root = module.getRoot();
            this.children(2, root, out);
        }
        out.write("        return;");
        out.write("    }");
        out.write("");
        out.write("    public void unloadMibInformation() {");
        out.write("        if ( snmpAgent == null )");
        out.write("            return;");
        out.write("        snmpAgent.removeAllOID();");
        out.write("        return;");
        out.write("    }");
        out.write("}");
        ((OutputStream)outputStream).flush();
        ((OutputStream)outputStream).close();
    }

    public static void main(String[] args) {
        try {
            if (args == null || args.length < 1 || args.length > 2) {
                System.out.println("ex) MibToSnmpRegister <mibfile> <loglevel>");
                System.out.println("    <loglevel> : default | jmx | snmp");
                return;
            }
            String mibFileName = args[0];
            int index = mibFileName.lastIndexOf(fsc);
            if (index != -1) {
                outputDir = mibFileName.substring(0, index + 1);
                outputDir = outputDir + "register";
                outputDir = outputDir + fsc;
            }
            String logLevel = "default";
            if (args.length == 2) {
                logLevel = args[1];
            }
            File outputFile = new File(outputDir + outputFileName);
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
            output = new CodeWriter(outputStream);
            MibToSnmpRegister mibToSnmpRegister = new MibToSnmpRegister(mibFileName, logLevel);
            mibToSnmpRegister.generate();
            ((OutputStream)outputStream).flush();
            ((OutputStream)outputStream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        outputDir = "";
        outputFileName = "output.txt";
        output = null;
        clsp = File.separator.equals("/") ? new String(":") : new String(";");
    }
}

