/*
 * Decompiled with CFR 0.152.
 */
package jeus.net.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import jeus.jndi.jns.server.repository.ListenerProxy;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.impl.ConnectionManager;

public class ManagerConnectionManager
extends ConnectionManager {
    private Hashtable listenerTable = new Hashtable();

    public ManagerConnectionManager(SocketID socketID) {
        super(socketID);
    }

    public synchronized boolean remove(SocketStream ss) {
        if (super.remove(ss)) {
            this.removeListener(ss.getSocketID());
            return true;
        }
        return false;
    }

    private void removeListener(SocketID socketID) {
        Hashtable listeners = (Hashtable)this.listenerTable.remove(socketID);
        if (listeners != null) {
            Enumeration e = listeners.elements();
            while (e.hasMoreElements()) {
                ListenerProxy listener = (ListenerProxy)e.nextElement();
                listener.remove();
            }
        }
    }

    public synchronized void addListener(ListenerProxy listener) {
        SocketID socketID = listener.getSocketID();
        Hashtable<String, ListenerProxy> listeners = (Hashtable<String, ListenerProxy>)this.listenerTable.get(socketID);
        if (listeners == null) {
            listeners = new Hashtable<String, ListenerProxy>();
            this.listenerTable.put(socketID, listeners);
        }
        listeners.put(listener.getID(), listener);
    }

    public synchronized void removeListener(SocketID socketID, String ID) {
        Hashtable listeners = (Hashtable)this.listenerTable.get(socketID);
        if (listeners == null) {
            return;
        }
        ListenerProxy listener = (ListenerProxy)listeners.remove(ID);
        if (listener != null) {
            listener.remove();
        }
    }
}

