/*
 * Decompiled with CFR 0.152.
 */
package jeus.persistence.container;

import java.io.Serializable;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import jeus.container.ContainerExecutionContext;
import jeus.container.ExecutionModule;
import jeus.persistence.container.PersistenceUnit;
import jeus.persistence.container.PersistenceUnits;
import jeus.persistence.container.QueryWrapper;
import jeus.transaction.TxHelper;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JPA;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedEntityManager
implements EntityManager,
Serializable {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.persitence");
    protected String puUri;
    protected String unitName;
    protected PersistenceContextType type;
    protected Map properties;
    protected transient PersistenceUnit pu;
    protected transient boolean nonTxMode;
    protected transient EntityManager nonTxEntityManager;
    protected transient EntityManager extendedEntityManager;
    protected static final TransactionManager tm = TxHelper.getTransactionManager();

    protected ManagedEntityManager(PersistenceUnit pu, PersistenceContextType type, Map properties) {
        this.pu = pu;
        this.puUri = pu.getPersistenceUnits().getPersistenceUnitUri();
        this.unitName = pu.getUnitName();
        this.type = type;
        this.properties = properties;
    }

    protected PersistenceContextType getPersistenceContextType() {
        return this.type;
    }

    protected void checkTx() throws TransactionRequiredException {
        if (this.type == PersistenceContextType.TRANSACTION) {
            Transaction tx = null;
            try {
                tx = tm.getTransaction();
            }
            catch (SystemException ex) {
                throw new IllegalStateException(ex);
            }
            if (tx == null) {
                throw new TransactionRequiredException("There is no current transaction");
            }
        }
    }

    protected EntityManager getDelegate0() {
        Transaction tx;
        EntityManager pc = null;
        if (this.pu == null) {
            this.pu = PersistenceUnits.lookupPersistenceUnit(this.puUri, this.unitName);
            assert (this.pu != null);
        }
        try {
            tx = tm.getTransaction();
        }
        catch (SystemException ex) {
            throw new IllegalStateException(ex);
        }
        this.nonTxMode = false;
        if (this.type == PersistenceContextType.TRANSACTION) {
            if (tx != null) {
                pc = this.pu.getTxAssociatedPersistenceContext();
                if (pc == null) {
                    pc = this.pu.createEntityManager(this.properties);
                    this.pu.associatePersistenceContextWithTx(pc, this.type);
                }
            } else {
                if (this.nonTxEntityManager == null) {
                    this.nonTxEntityManager = this.pu.createEntityManager(this.properties);
                }
                pc = this.nonTxEntityManager;
                this.nonTxMode = true;
            }
        } else {
            if (this.extendedEntityManager == null) {
                ExecutionModule module = ContainerExecutionContext.getExecutionModule();
                if (module == null) {
                    throw new IllegalStateException("Extended Persistence Context is not supported in this context");
                }
                this.extendedEntityManager = module.getCurrentExtendedPersistenceContext(this.pu);
            }
            pc = this.extendedEntityManager;
        }
        return pc;
    }

    public void persist(Object entity) throws TransactionRequiredException {
        if (logger.isLoggable(JeusMessage_JPA._8_LEVEL)) {
            logger.log(JeusMessage_JPA._8_LEVEL, JeusMessage_JPA._8);
        }
        this.checkTx();
        this.getDelegate0().persist(entity);
    }

    public <T> T merge(T entity) throws TransactionRequiredException {
        if (logger.isLoggable(JeusMessage_JPA._9_LEVEL)) {
            logger.log(JeusMessage_JPA._9_LEVEL, JeusMessage_JPA._9);
        }
        this.checkTx();
        return (T)this.getDelegate0().merge(entity);
    }

    public void remove(Object entity) throws TransactionRequiredException {
        if (logger.isLoggable(JeusMessage_JPA._10_LEVEL)) {
            logger.log(JeusMessage_JPA._10_LEVEL, JeusMessage_JPA._10);
        }
        this.checkTx();
        this.getDelegate0().remove(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        if (logger.isLoggable(JeusMessage_JPA._11_LEVEL)) {
            logger.log(JeusMessage_JPA._11_LEVEL, JeusMessage_JPA._11);
        }
        try {
            Object object = this.getDelegate0().find(entityClass, primaryKey);
            return (T)object;
        }
        finally {
            if (this.nonTxMode) {
                this.nonTxEntityManager.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        if (logger.isLoggable(JeusMessage_JPA._12_LEVEL)) {
            logger.log(JeusMessage_JPA._12_LEVEL, JeusMessage_JPA._12);
        }
        try {
            Object object = this.getDelegate0().getReference(entityClass, primaryKey);
            return (T)object;
        }
        finally {
            if (this.nonTxMode) {
                this.nonTxEntityManager.clear();
            }
        }
    }

    public void flush() throws TransactionRequiredException, PersistenceException {
        if (logger.isLoggable(JeusMessage_JPA._13_LEVEL)) {
            logger.log(JeusMessage_JPA._13_LEVEL, JeusMessage_JPA._13);
        }
        this.checkTx();
        this.getDelegate0().flush();
    }

    public void refresh(Object entity) throws IllegalArgumentException, TransactionRequiredException, EntityNotFoundException {
        this.checkTx();
        this.getDelegate0().refresh(entity);
    }

    public boolean contains(Object entity) throws IllegalArgumentException {
        if (logger.isLoggable(JeusMessage_JPA._14_LEVEL)) {
            logger.log(JeusMessage_JPA._14_LEVEL, JeusMessage_JPA._14);
        }
        return this.getDelegate0().contains(entity);
    }

    public Query createQuery(String ejbqlString) {
        if (logger.isLoggable(JeusMessage_JPA._15_LEVEL)) {
            logger.log(JeusMessage_JPA._15_LEVEL, JeusMessage_JPA._15);
        }
        Query query = this.getDelegate0().createQuery(ejbqlString);
        if (this.nonTxMode) {
            query = new QueryWrapper(query, true, this.nonTxEntityManager);
        }
        return query;
    }

    public Query createNamedQuery(String name) {
        if (logger.isLoggable(JeusMessage_JPA._16_LEVEL)) {
            logger.log(JeusMessage_JPA._16_LEVEL, JeusMessage_JPA._16);
        }
        Query query = this.getDelegate0().createNamedQuery(name);
        if (this.nonTxMode) {
            query = new QueryWrapper(query, true, this.nonTxEntityManager);
        }
        return query;
    }

    public Query createNativeQuery(String sqlString) {
        if (logger.isLoggable(JeusMessage_JPA._17_LEVEL)) {
            logger.log(JeusMessage_JPA._17_LEVEL, JeusMessage_JPA._17);
        }
        Query query = this.getDelegate0().createNativeQuery(sqlString);
        if (this.nonTxMode) {
            query = new QueryWrapper(query, true, this.nonTxEntityManager);
        }
        return query;
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        if (logger.isLoggable(JeusMessage_JPA._17_LEVEL)) {
            logger.log(JeusMessage_JPA._17_LEVEL, JeusMessage_JPA._17);
        }
        Query query = this.getDelegate0().createNativeQuery(sqlString, resultClass);
        if (this.nonTxMode) {
            query = new QueryWrapper(query, true, this.nonTxEntityManager);
        }
        return query;
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        if (logger.isLoggable(JeusMessage_JPA._17_LEVEL)) {
            logger.log(JeusMessage_JPA._17_LEVEL, JeusMessage_JPA._17);
        }
        Query query = this.getDelegate0().createNativeQuery(sqlString, resultSetMapping);
        if (this.nonTxMode) {
            query = new QueryWrapper(query, true, this.nonTxEntityManager);
        }
        return query;
    }

    public void lock(Object entity, LockModeType lockMode) {
        if (logger.isLoggable(JeusMessage_JPA._18_LEVEL)) {
            logger.log(JeusMessage_JPA._18_LEVEL, JeusMessage_JPA._18);
        }
        this.getDelegate0().lock(entity, lockMode);
    }

    public void clear() {
        if (logger.isLoggable(JeusMessage_JPA._19_LEVEL)) {
            logger.log(JeusMessage_JPA._19_LEVEL, JeusMessage_JPA._19);
        }
        this.getDelegate0().clear();
    }

    public Object getDelegate() {
        return this.getDelegate0();
    }

    public FlushModeType getFlushMode() {
        if (logger.isLoggable(JeusMessage_JPA._20_LEVEL)) {
            logger.log(JeusMessage_JPA._20_LEVEL, JeusMessage_JPA._20);
        }
        return this.getDelegate0().getFlushMode();
    }

    public void setFlushMode(FlushModeType flushMode) {
        if (logger.isLoggable(JeusMessage_JPA._20_LEVEL)) {
            logger.log(JeusMessage_JPA._20_LEVEL, JeusMessage_JPA._20);
        }
        this.getDelegate0().setFlushMode(flushMode);
    }

    public void close() {
        throw new IllegalStateException("container-managed EntityManager does not support the operation");
    }

    public boolean isOpen() {
        return true;
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException("container-managed EntityManager does not support the operation");
    }

    public void joinTransaction() {
    }
}

