/*
 * Decompiled with CFR 0.152.
 */
package jeus.persistence.container;

import java.io.Serializable;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import jeus.persistence.container.PersistenceUnit;
import jeus.persistence.container.PersistenceUnits;
import jeus.util.logging.JeusLogger;

public class ManagedEntityManagerFactory
implements EntityManagerFactory,
Serializable {
    protected static final JeusLogger logger = PersistenceUnits.logger;
    protected String puUri;
    protected String unitName;
    protected transient EntityManagerFactory emf;

    ManagedEntityManagerFactory(PersistenceUnit pu) {
        this.puUri = pu.getPersistenceUnits().getPersistenceUnitUri();
        this.unitName = pu.getUnitName();
        this.emf = pu.getEntityManagerFactory();
    }

    public EntityManager createEntityManager() {
        return this.getDelegate().createEntityManager();
    }

    public EntityManager createEntityManager(Map map) {
        return this.getDelegate().createEntityManager(map);
    }

    public void close() {
        this.getDelegate().close();
    }

    public boolean isOpen() {
        return this.getDelegate().isOpen();
    }

    private EntityManagerFactory getDelegate() {
        if (this.emf == null) {
            PersistenceUnit pu = PersistenceUnits.lookupPersistenceUnit(this.puUri, this.unitName);
            assert (pu != null);
            this.emf = pu.getEntityManagerFactory();
        }
        return this.emf;
    }
}

