/*
 * Decompiled with CFR 0.152.
 */
package jeus.persistence.container;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.persistence.spi.PersistenceProvider;
import jeus.util.JeusRuntimeException;
import jeus.util.properties.JeusPersistenceProperties;

public class PersistenceProviders {
    public static final String PROVIDER_HIBERNATE = "org.hibernate.ejb.HibernatePersistence";
    public static final String PROVIDER_TOPLINK_ESSENTIALS = "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider";
    private static String defaultProvider;
    public static String DEFAULT_PERSISTENCE_PROPERTIES;
    protected static PersistenceProvider defaultPersistenceProvider;
    protected static Properties defaultPersistenceProperties;

    public static String getDefaultPersistenceProviderClassName() {
        if (defaultProvider == null && ((defaultProvider = JeusPersistenceProperties.DEFAULT_PROVIDER) == null || defaultProvider.trim().equals(""))) {
            defaultProvider = PROVIDER_TOPLINK_ESSENTIALS;
        }
        return defaultProvider;
    }

    public static synchronized PersistenceProvider getDefaultPersistenceProvider() throws JeusRuntimeException {
        if (defaultPersistenceProvider == null) {
            try {
                String className = PersistenceProviders.getDefaultPersistenceProviderClassName();
                Class<?> cls = Class.forName(className);
                if (!PersistenceProvider.class.isAssignableFrom(cls)) {
                    throw new Exception("class " + className + " is not PersistenceProvider class");
                }
                defaultPersistenceProvider = (PersistenceProvider)cls.newInstance();
            }
            catch (Exception ex) {
                throw new JeusRuntimeException("Could not create default persistence provider", (Throwable)ex);
            }
        }
        return defaultPersistenceProvider;
    }

    public static synchronized Properties getDefaultPersistenceProperties() {
        if (defaultPersistenceProperties == null) {
            Properties properties = new Properties();
            URL resource = PersistenceProviders.class.getClassLoader().getResource(DEFAULT_PERSISTENCE_PROPERTIES);
            if (resource != null) {
                try {
                    properties.load(resource.openStream());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            for (Object obj : properties.keySet()) {
                String key = (String)obj;
                String value = System.getProperty(key);
                if (value == null) continue;
                properties.setProperty(key, value);
            }
            defaultPersistenceProperties = properties;
        }
        return (Properties)defaultPersistenceProperties.clone();
    }

    public static PersistenceProvider createPersistenceProvider(ClassLoader loader, String className) throws Exception {
        if (className.equals(PersistenceProviders.getDefaultPersistenceProviderClassName())) {
            return PersistenceProviders.getDefaultPersistenceProvider();
        }
        Class<?> providerClass = loader.loadClass(className);
        if (!PersistenceProvider.class.isAssignableFrom(providerClass)) {
            throw new Exception(className + " is not PersistenceProvider class");
        }
        return (PersistenceProvider)providerClass.newInstance();
    }

    static {
        DEFAULT_PERSISTENCE_PROPERTIES = "jeus/persistence/container/persistence.properties";
    }
}

