/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.http;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.logging.Level;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeus.rmi.http.ServletClientException;
import jeus.rmi.http.ServletCommandHandler;
import jeus.rmi.http.ServletServerException;
import jeus.util.logging.JeusLogger;
import jeus.util.properties.JeusNetPropertyValues;

final class ServletForwardCommand
implements ServletCommandHandler {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.rmi");

    ServletForwardCommand() {
    }

    public String getName() {
        return "forward";
    }

    public void execute(String param, HttpServletRequest req, HttpServletResponse res) throws ServletClientException, ServletServerException {
        String line;
        DataInputStream socketIn;
        byte[] buffer;
        Socket socket;
        int port;
        if (!req.getMethod().equals("POST")) {
            throw new ServletClientException("can only forward POST requests");
        }
        try {
            port = Integer.parseInt(param);
        }
        catch (NumberFormatException e) {
            throw new ServletClientException("invalid port number: " + param);
        }
        if (port <= 0 || port > 65535) {
            throw new ServletClientException("invalid port: " + port);
        }
        if (port < 1024) {
            throw new ServletClientException("permission denied for port: " + port);
        }
        try {
            socket = new Socket(JeusNetPropertyValues.getLocalInetAddress(), port);
        }
        catch (IOException e) {
            throw new ServletServerException("could not connect to local port");
        }
        try {
            DataInputStream clientIn = new DataInputStream((InputStream)req.getInputStream());
            buffer = new byte[req.getContentLength()];
            clientIn.readFully(buffer);
        }
        catch (EOFException e) {
            throw new ServletClientException("unexpected EOF reading request body");
        }
        catch (IOException e) {
            throw new ServletClientException("error reading request body");
        }
        try {
            DataOutputStream socketOut = new DataOutputStream(socket.getOutputStream());
            socketOut.writeBytes("POST / HTTP/1.0\r\n");
            socketOut.writeBytes("Content-length: " + req.getContentLength() + "\r\n\r\n");
            socketOut.write(buffer);
            socketOut.flush();
        }
        catch (IOException e) {
            throw new ServletServerException("error writing to server");
        }
        try {
            socketIn = new DataInputStream(socket.getInputStream());
        }
        catch (IOException e) {
            throw new ServletServerException("error reading from server");
        }
        String key = "Content-length:".toLowerCase();
        boolean contentLengthFound = false;
        int responseContentLength = -1;
        do {
            try {
                line = socketIn.readLine();
            }
            catch (IOException e) {
                throw new ServletServerException("error reading from server");
            }
            if (line == null) {
                throw new ServletServerException("unexpected EOF reading server response");
            }
            if (!line.toLowerCase().startsWith(key)) continue;
            if (contentLengthFound) {
                // empty if block
            }
            responseContentLength = Integer.parseInt(line.substring(key.length()).trim());
            contentLengthFound = true;
        } while (line.length() != 0 && line.charAt(0) != '\r' && line.charAt(0) != '\n');
        if (!contentLengthFound || responseContentLength < 0) {
            throw new ServletServerException("missing or invalid content length in server response");
        }
        buffer = new byte[responseContentLength];
        try {
            socketIn.readFully(buffer);
        }
        catch (EOFException e) {
            throw new ServletServerException("unexpected EOF reading server response");
        }
        catch (IOException e) {
            throw new ServletServerException("error reading from server");
        }
        try {
            ServletOutputStream bodyOut = res.getOutputStream();
            res.setContentType("application/octet-stream");
            bodyOut.write(buffer);
            bodyOut.close();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new ServletServerException("error writing response");
        }
    }
}

