/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.runtime;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public abstract class Log {
    public static final Level BRIEF = Level.FINE;
    public static final Level VERBOSE = Level.FINER;
    private static final LogFactory logFactory = new LoggerLogFactory();

    public abstract boolean isLoggable(Level var1);

    public abstract void log(Level var1, String var2);

    public abstract void log(Level var1, String var2, Throwable var3);

    public abstract void setOutputStream(OutputStream var1);

    public abstract PrintStream getPrintStream();

    public static Log getLog(String loggerName, String oldLogName, int override) {
        Level level = override < 0 ? null : (override == 0 ? Level.OFF : (override > 0 && override <= 10 ? BRIEF : (override > 10 && override <= 20 ? VERBOSE : Level.FINEST)));
        return logFactory.createLog(loggerName, oldLogName, level);
    }

    public static Log getLog(String loggerName, String oldLogName, boolean override) {
        Level level = override ? VERBOSE : null;
        return logFactory.createLog(loggerName, oldLogName, level);
    }

    private static String[] getSource() {
        StackTraceElement[] trace = new Exception().getStackTrace();
        return new String[]{trace[3].getClassName(), trace[3].getMethodName()};
    }

    private class LoggerPrintStream
    extends PrintStream {
        private final Logger logger;
        private int last;
        private final ByteArrayOutputStream bufOut;

        private LoggerPrintStream(Logger logger) {
            super(new ByteArrayOutputStream());
            this.last = -1;
            this.bufOut = (ByteArrayOutputStream)this.out;
            this.logger = logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) {
            if (this.last == 13 && b == 10) {
                this.last = -1;
                return;
            }
            if (b == 10 || b == 13) {
                try {
                    String message = Thread.currentThread().getName() + ": " + this.bufOut.toString();
                    this.logger.logp(Level.INFO, "LogStream", "print", message);
                }
                finally {
                    this.bufOut.reset();
                }
            } else {
                super.write(b);
            }
            this.last = b;
        }

        public void write(byte[] b, int off, int len) {
            if (len < 0) {
                throw new ArrayIndexOutOfBoundsException(len);
            }
            for (int i = 0; i < len; ++i) {
                this.write(b[off + i]);
            }
        }

        public String toString() {
            return "RMI";
        }
    }

    private static class InternalStreamHandler
    extends StreamHandler {
        InternalStreamHandler(OutputStream out) {
            super(out, new SimpleFormatter());
        }

        public void publish(LogRecord record) {
            super.publish(record);
            this.flush();
        }

        public void close() {
            this.flush();
        }
    }

    private static class LoggerLog
    extends Log {
        private static final Handler alternateConsole = (Handler)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                InternalStreamHandler alternate = new InternalStreamHandler(System.err);
                alternate.setLevel(Level.ALL);
                return alternate;
            }
        });
        private InternalStreamHandler copyHandler = null;
        private final Logger logger;
        private LoggerPrintStream loggerSandwich;

        private LoggerLog(final Logger logger, final Level level) {
            this.logger = logger;
            if (level != null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        if (!logger.isLoggable(level)) {
                            logger.setLevel(level);
                        }
                        logger.addHandler(alternateConsole);
                        return null;
                    }
                });
            }
        }

        public boolean isLoggable(Level level) {
            return this.logger.isLoggable(level);
        }

        public void log(Level level, String message) {
            if (this.isLoggable(level)) {
                String[] source = Log.getSource();
                this.logger.logp(level, source[0], source[1], Thread.currentThread().getName() + ": " + message);
            }
        }

        public void log(Level level, String message, Throwable thrown) {
            if (this.isLoggable(level)) {
                String[] source = Log.getSource();
                this.logger.logp(level, source[0], source[1], Thread.currentThread().getName() + ": " + message, thrown);
            }
        }

        public synchronized void setOutputStream(OutputStream out) {
            if (out != null) {
                if (!this.logger.isLoggable(VERBOSE)) {
                    this.logger.setLevel(VERBOSE);
                }
                this.copyHandler = new InternalStreamHandler(out);
                this.copyHandler.setLevel(VERBOSE);
                this.logger.addHandler(this.copyHandler);
            } else {
                if (this.copyHandler != null) {
                    this.logger.removeHandler(this.copyHandler);
                }
                this.copyHandler = null;
            }
        }

        public synchronized PrintStream getPrintStream() {
            if (this.loggerSandwich == null) {
                this.loggerSandwich = new LoggerPrintStream(this.logger);
            }
            return this.loggerSandwich;
        }
    }

    private static class LoggerLogFactory
    implements LogFactory {
        LoggerLogFactory() {
        }

        public Log createLog(String loggerName, String oldLogName, Level level) {
            Logger logger = Logger.getLogger(loggerName);
            return new LoggerLog(logger, level);
        }
    }

    private static interface LogFactory {
        public Log createLog(String var1, String var2, Level var3);
    }
}

